/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.ResponseInfo;
import com.google.android.gms.ads.admanager.AppEventListener;
import com.google.android.gms.ads.internal.client.zza;
import com.google.android.gms.ads.internal.client.zzay;
import com.google.android.gms.ads.internal.client.zzdu;
import com.google.android.gms.ads.zzc;
import com.google.android.gms.ads.zzd;
import com.google.android.gms.ads.zze;
import com.google.android.gms.ads.zzf;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzbiu;
import com.google.android.gms.internal.ads.zzbjc;
import com.google.android.gms.internal.ads.zzbkq;
import com.google.android.gms.internal.ads.zzcge;
import com.google.android.gms.internal.ads.zzcgp;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;

public abstract class BaseAdView
extends ViewGroup {
    @NotOnlyInitialized
    protected final zzdu zza;

    @NonNull
    public AdListener getAdListener() {
        return this.zza.zza();
    }

    @Nullable
    public AdSize getAdSize() {
        return this.zza.zzb();
    }

    @Nullable
    public OnPaidEventListener getOnPaidEventListener() {
        return this.zza.zzc();
    }

    @Nullable
    public ResponseInfo getResponseInfo() {
        return this.zza.zzd();
    }

    @NonNull
    public String getAdUnitId() {
        return this.zza.zzj();
    }

    /*
     * WARNING - void declaration
     */
    protected BaseAdView(@NonNull Context context, int adViewType) {
        super((Context)zzdu2);
        void var2_2;
        zzdu zzdu2;
        this.zza = zzdu2 = new zzdu(this, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected BaseAdView(@NonNull Context context, @NonNull AttributeSet attrs, int adViewType) {
        super((Context)zzdu2, (AttributeSet)var2_2);
        void var3_3;
        void var2_2;
        zzdu zzdu2;
        this.zza = zzdu2 = new zzdu(this, (AttributeSet)var2_2, false, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected BaseAdView(@NonNull Context context, @NonNull AttributeSet attrs, boolean allowMultipleAdSizes) {
        super((Context)zzdu2, (AttributeSet)var2_2);
        void var3_3;
        void var2_2;
        zzdu zzdu2;
        this.zza = zzdu2 = new zzdu(this, (AttributeSet)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected BaseAdView(@NonNull Context context, @NonNull AttributeSet attrs, int defStyle, int adViewType) {
        super((Context)zzdu2, (AttributeSet)var2_2, (int)var3_3);
        void var4_4;
        void var3_3;
        void var2_2;
        zzdu zzdu2;
        this.zza = zzdu2 = new zzdu(this, (AttributeSet)var2_2, false, (int)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    protected BaseAdView(@NonNull Context context, @NonNull AttributeSet attrs, int defStyle, int adViewType, boolean allowMultipleAdSizes) {
        super((Context)zzdu2, (AttributeSet)var2_2, (int)var3_3);
        void var4_4;
        void var5_5;
        void var3_3;
        void var2_2;
        zzdu zzdu2;
        this.zza = zzdu2 = new zzdu(this, (AttributeSet)var2_2, (boolean)var5_5, (int)var4_4);
    }

    public void destroy() {
        zzbjc.zzc(this.getContext());
        if (((Boolean)zzbkq.zze.zze()).booleanValue()) {
            Object object = zzbjc.zziJ;
            if (((Boolean)zzay.zzc().zzb((zzbiu)object)).booleanValue()) {
                object = zzcge.zzb;
                zze zze2 = new zze(this);
                object.execute(zze2);
                return;
            }
        }
        this.zza.zzk();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(@NonNull AdRequest adRequest) {
        void var1_1;
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbjc.zzc(this.getContext());
        if (((Boolean)zzbkq.zzf.zze()).booleanValue()) {
            Object object = zzbjc.zziM;
            if (((Boolean)zzay.zzc().zzb((zzbiu)object)).booleanValue()) {
                object = zzcge.zzb;
                zzc zzc2 = new zzc(this, (AdRequest)var1_1);
                object.execute(zzc2);
                return;
            }
        }
        this.zza.zzm(var1_1.zza());
    }

    /*
     * WARNING - void declaration
     */
    protected void onLayout(boolean bl, int left, int top, int right, int bottom) {
        if ((this = this.getChildAt(0)) != null && this.getVisibility() != 8) {
            void var3_4;
            void var5_6;
            void var2_3;
            void var4_5;
            int n = this.getMeasuredWidth();
            int n2 = this.getMeasuredHeight();
            var2_3 = (var4_5 - var2_3 - n) / 2;
            var3_4 = (var5_6 - var3_4 - n2) / 2;
            this.layout((int)var2_3, (int)var3_4, (int)(var2_3 + n), (int)(var3_4 + n2));
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n;
        int n2;
        int n3;
        void var2_2;
        void var1_1;
        Object object = this.getChildAt(0);
        if (object != null && object.getVisibility() != 8) {
            this.measureChild((View)object, (int)var1_1, (int)var2_2);
            n3 = object.getMeasuredWidth();
            n2 = object.getMeasuredHeight();
            n = n3;
            n3 = n2;
        } else {
            try {
                object = this.getAdSize();
            }
            catch (NullPointerException nullPointerException) {
                zzcgp.zzh("Unable to retrieve ad size.", nullPointerException);
                object = null;
            }
            if (object != null) {
                Context context = this.getContext();
                n2 = ((AdSize)object).getWidthInPixels(context);
                n3 = ((AdSize)object).getHeightInPixels(context);
                n = n2;
            } else {
                n = 0;
                n3 = 0;
            }
        }
        n2 = this.getSuggestedMinimumWidth();
        n = Math.max(n, n2);
        n2 = this.getSuggestedMinimumHeight();
        n3 = Math.max(n3, n2);
        this.setMeasuredDimension(View.resolveSize((int)n, (int)var1_1), View.resolveSize((int)n3, (int)var2_2));
    }

    public void pause() {
        zzbjc.zzc(this.getContext());
        if (((Boolean)zzbkq.zzg.zze()).booleanValue()) {
            Object object = zzbjc.zziK;
            if (((Boolean)zzay.zzc().zzb((zzbiu)object)).booleanValue()) {
                object = zzcge.zzb;
                zzd zzd2 = new zzd(this);
                object.execute(zzd2);
                return;
            }
        }
        this.zza.zzn();
    }

    public void resume() {
        zzbjc.zzc(this.getContext());
        if (((Boolean)zzbkq.zzh.zze()).booleanValue()) {
            Object object = zzbjc.zziI;
            if (((Boolean)zzay.zzc().zzb((zzbiu)object)).booleanValue()) {
                object = zzcge.zzb;
                zzf zzf2 = new zzf(this);
                object.execute(zzf2);
                return;
            }
        }
        this.zza.zzp();
    }

    /*
     * WARNING - void declaration
     */
    public void setAdListener(@NonNull AdListener adListener) {
        void var1_1;
        this.zza.zzr((AdListener)var1_1);
        if (var1_1 == null) {
            this.zza.zzq(null);
            return;
        }
        if (var1_1 instanceof zza) {
            this.zza.zzq((zza)var1_1);
        }
        if (var1_1 instanceof AppEventListener) {
            this.zza.zzv((AppEventListener)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setAdSize(@NonNull AdSize adSize) {
        void var1_1;
        zzdu this_ = ((BaseAdView)((Object)this_)).zza;
        AdSize[] adSizeArray = new AdSize[]{var1_1};
        this_.zzs(adSizeArray);
    }

    /*
     * WARNING - void declaration
     */
    public void setAdUnitId(@NonNull String adUnitId) {
        void var1_1;
        this.zza.zzu((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setOnPaidEventListener(@Nullable OnPaidEventListener listener) {
        void var1_1;
        this.zza.zzx((OnPaidEventListener)var1_1);
    }

    public boolean isLoading() {
        return this.zza.zzA();
    }
}

