/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.internal.client.zzdq;
import com.google.android.gms.ads.internal.client.zzdr;
import com.google.android.gms.ads.mediation.MediationExtrasReceiver;
import com.google.android.gms.ads.mediation.customevent.CustomEvent;
import com.google.android.gms.ads.query.AdInfo;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzcgp;
import java.util.Date;
import java.util.List;
import java.util.Set;

@VisibleForTesting
public class AdRequest {
    public static final int ERROR_CODE_INTERNAL_ERROR = 0;
    public static final int ERROR_CODE_INVALID_REQUEST = 1;
    public static final int ERROR_CODE_NETWORK_ERROR = 2;
    public static final int ERROR_CODE_NO_FILL = 3;
    public static final int ERROR_CODE_APP_ID_MISSING = 8;
    public static final int ERROR_CODE_REQUEST_ID_MISMATCH = 10;
    public static final int ERROR_CODE_INVALID_AD_STRING = 11;
    public static final int ERROR_CODE_MEDIATION_NO_FILL = 9;
    public static final int GENDER_UNKNOWN = 0;
    public static final int GENDER_MALE = 1;
    public static final int GENDER_FEMALE = 2;
    public static final int MAX_CONTENT_URL_LENGTH = 512;
    @NonNull
    public static final String DEVICE_ID_EMULATOR = "B3EEABB8EE11C2BE770B684D95219ECB";
    protected final zzdr zza;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public <T extends CustomEvent> Bundle getCustomEventExtrasBundle(@NonNull Class<T> adapterClass) {
        void var1_1;
        return this.zza.zzd((Class)var1_1);
    }

    @NonNull
    public Bundle getCustomTargeting() {
        return this.zza.zze();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public <T extends MediationExtrasReceiver> Bundle getNetworkExtrasBundle(@NonNull Class<T> adapterClass) {
        void var1_1;
        return this.zza.zzf((Class)var1_1);
    }

    @NonNull
    public String getContentUrl() {
        return this.zza.zzl();
    }

    @NonNull
    public List<String> getNeighboringContentUrls() {
        return this.zza.zzp();
    }

    @NonNull
    public Set<String> getKeywords() {
        return this.zza.zzr();
    }

    protected AdRequest(@NonNull Builder builder) {
        zzdr zzdr2;
        this.zza = zzdr2 = new zzdr(builder.zza, null);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isTestDevice(@NonNull Context context) {
        void var1_1;
        return this.zza.zzt((Context)var1_1);
    }

    public zzdr zza() {
        return this.zza;
    }

    @VisibleForTesting
    public static class Builder {
        protected final zzdq zza;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addCustomEventExtrasBundle(@NonNull Class<? extends CustomEvent> adapterClass, @NonNull Bundle customEventExtras) {
            void var2_2;
            void var1_1;
            this.zza.zzr((Class)var1_1, (Bundle)var2_2);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addKeyword(@NonNull String keyword) {
            void var1_1;
            this.zza.zzt((String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addNetworkExtrasBundle(@NonNull Class<? extends MediationExtrasReceiver> adapterClass, @NonNull Bundle networkExtras) {
            void var2_2;
            void var1_1;
            this.zza.zzu((Class)var1_1, (Bundle)var2_2);
            if (var1_1.equals(AdMobAdapter.class) && var2_2.getBoolean("_emulatorLiveAds")) {
                this.zza.zzx(AdRequest.DEVICE_ID_EMULATOR);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        @KeepForSdk
        @NonNull
        public Builder setAdInfo(@NonNull AdInfo adInfo) {
            void var1_1;
            this.zza.zzy((AdInfo)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public Builder setAdString(@NonNull String adString) {
            void var1_1;
            this.zza.zzz((String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setContentUrl(@NonNull String contentUrl) {
            void var1_1;
            Preconditions.checkNotNull((Object)contentUrl, (Object)"Content URL must be non-null.");
            Preconditions.checkNotEmpty((String)var1_1, (Object)"Content URL must be non-empty.");
            boolean bl = var1_1.length() <= 512;
            Object[] objectArray = new Object[]{512, var1_1.length()};
            Preconditions.checkArgument((boolean)bl, (String)"Content URL must not exceed %d in length.  Provided length was %d.", (Object[])objectArray);
            this.zza.zzB((String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setHttpTimeoutMillis(int httpTimeoutMillis) {
            void var1_1;
            this.zza.zzD((int)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setNeighboringContentUrls(@NonNull List<String> neighboringContentUrls) {
            void var1_1;
            if (neighboringContentUrls == null) {
                zzcgp.zzj("neighboring content URLs list should not be null");
                return this;
            }
            this.zza.zzF((List)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setRequestAgent(@NonNull String requestAgent) {
            void var1_1;
            this.zza.zzH((String)var1_1);
            return this;
        }

        @NonNull
        public AdRequest build() {
            AdRequest adRequest = new AdRequest(this);
            return adRequest;
        }

        public Builder() {
            zzdq zzdq2;
            this.zza = zzdq2 = new zzdq();
            this.zza.zzw(AdRequest.DEVICE_ID_EMULATOR);
        }

        @Deprecated
        @NonNull
        public final Builder zza(@NonNull String string) {
            this.zza.zzw(string);
            return this;
        }

        @Deprecated
        @NonNull
        public final Builder zzb(@NonNull Date date) {
            this.zza.zzA(date);
            return this;
        }

        @Deprecated
        @NonNull
        public final Builder zzc(int n) {
            this.zza.zzC(n);
            return this;
        }

        @Deprecated
        @NonNull
        public final Builder zzd(boolean bl) {
            this.zza.zzE(bl);
            return this;
        }

        @Deprecated
        @NonNull
        public final Builder zze(boolean bl) {
            this.zza.zzI(bl);
            return this;
        }
    }
}

