/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.ads.formats.AdManagerAdViewOptions;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.formats.OnAdManagerAdViewLoadedListener;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.ads.internal.client.zzau;
import com.google.android.gms.ads.internal.client.zzaw;
import com.google.android.gms.ads.internal.client.zzay;
import com.google.android.gms.ads.internal.client.zzbl;
import com.google.android.gms.ads.internal.client.zzbo;
import com.google.android.gms.ads.internal.client.zzdr;
import com.google.android.gms.ads.internal.client.zzeo;
import com.google.android.gms.ads.internal.client.zzff;
import com.google.android.gms.ads.internal.client.zzg;
import com.google.android.gms.ads.internal.client.zzp;
import com.google.android.gms.ads.internal.client.zzq;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdOptions;
import com.google.android.gms.ads.nativead.NativeCustomFormatAd;
import com.google.android.gms.ads.zza;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzbiu;
import com.google.android.gms.internal.ads.zzbjc;
import com.google.android.gms.internal.ads.zzbkq;
import com.google.android.gms.internal.ads.zzbls;
import com.google.android.gms.internal.ads.zzboj;
import com.google.android.gms.internal.ads.zzbol;
import com.google.android.gms.internal.ads.zzbom;
import com.google.android.gms.internal.ads.zzbvh;
import com.google.android.gms.internal.ads.zzbyp;
import com.google.android.gms.internal.ads.zzbyr;
import com.google.android.gms.internal.ads.zzcge;
import com.google.android.gms.internal.ads.zzcgp;

public class AdLoader {
    private final zzp zza;
    private final Context zzb;
    private final zzbl zzc;

    /*
     * WARNING - void declaration
     */
    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(@NonNull AdRequest adRequest) {
        void var1_1;
        this.zzb(var1_1.zza());
    }

    /*
     * WARNING - void declaration
     */
    public void loadAd(@NonNull AdManagerAdRequest adManagerAdRequest) {
        void var1_1;
        this.zzb(var1_1.zza);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAds(@NonNull AdRequest adRequest, int maxNumberOfAds) {
        zzdr zzdr2 = adRequest.zza();
        try {
            void var2_3;
            this.zzc.zzh(this.zza.zza(this.zzb, zzdr2), (int)var2_3);
            return;
        }
        catch (RemoteException remoteException) {
            zzcgp.zzh("Failed to load ads.", remoteException);
            return;
        }
    }

    public boolean isLoading() {
        try {
            boolean bl = this.zzc.zzi();
            return bl;
        }
        catch (RemoteException remoteException) {
            zzcgp.zzk("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    AdLoader(Context context, zzbl zzbl2, zzp zzp2) {
        this.zzb = context;
        this.zzc = zzbl2;
        this.zza = zzp2;
    }

    final /* synthetic */ void zza(zzdr zzdr2) {
        try {
            this.zzc.zzg(this.zza.zza(this.zzb, zzdr2));
            return;
        }
        catch (RemoteException remoteException) {
            zzcgp.zzh("Failed to load ad.", remoteException);
            return;
        }
    }

    private final void zzb(zzdr zzdr2) {
        Object object;
        block5: {
            block4: {
                zzbjc.zzc(this.zzb);
                if (!((Boolean)zzbkq.zzc.zze()).booleanValue()) break block4;
                object = zzbjc.zziM;
                if (((Boolean)zzay.zzc().zzb((zzbiu)object)).booleanValue()) break block5;
            }
            try {
                this.zzc.zzg(this.zza.zza(this.zzb, zzdr2));
                return;
            }
            catch (RemoteException remoteException) {
                zzcgp.zzh("Failed to load ad.", remoteException);
                return;
            }
        }
        object = zzcge.zzb;
        zza zza2 = new zza(this, zzdr2);
        object.execute(zza2);
    }

    public static class Builder {
        private final Context zza;
        private final zzbo zzb;

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public Builder forAdManagerAdView(@NonNull OnAdManagerAdViewLoadedListener listener, AdSize ... adSizes) {
            zzbo zzbo2;
            if (adSizes == null || ((void)zzbo2).length <= 0) {
                Object object = new IllegalArgumentException("The supported ad sizes must contain at least one valid ad size.");
                throw object;
            }
            try {
                void var1_1;
                zzq zzq2 = new zzq(((Builder)object).zza, (AdSize[])zzbo2);
                zzbo2 = ((Builder)object).zzb;
                zzbol zzbol2 = new zzbol((OnAdManagerAdViewLoadedListener)var1_1);
                zzbo2.zzj(zzbol2, zzq2);
                return object;
            }
            catch (RemoteException remoteException) {
                zzcgp.zzk("Failed to add Google Ad Manager banner ad listener", remoteException);
                return object;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public Builder forCustomFormatAd(@NonNull String customFormatId, @NonNull NativeCustomFormatAd.OnCustomFormatAdLoadedListener adLoadedListener, @Nullable NativeCustomFormatAd.OnCustomClickListener customClickListener) {
            void var3_4;
            void var2_3;
            zzbyp zzbyp2 = new zzbyp((NativeCustomFormatAd.OnCustomFormatAdLoadedListener)var2_3, (NativeCustomFormatAd.OnCustomClickListener)var3_4);
            try {
                void var1_1;
                this.zzb.zzh((String)var1_1, zzbyp2.zzb(), zzbyp2.zza());
                return this;
            }
            catch (RemoteException remoteException) {
                zzcgp.zzk("Failed to add custom format ad listener", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Deprecated
        @NonNull
        public Builder forCustomTemplateAd(@NonNull String templateId, @NonNull NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener adLoadedListener, @Nullable NativeCustomTemplateAd.OnCustomClickListener customClickListener) {
            void var3_4;
            void var2_3;
            zzboj zzboj2 = new zzboj((NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener)var2_3, (NativeCustomTemplateAd.OnCustomClickListener)var3_4);
            try {
                void var1_1;
                this.zzb.zzh((String)var1_1, zzboj2.zze(), zzboj2.zzd());
                return this;
            }
            catch (RemoteException remoteException) {
                zzcgp.zzk("Failed to add custom template ad listener", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public Builder forNativeAd(@NonNull NativeAd.OnNativeAdLoadedListener listener) {
            try {
                void var1_1;
                zzbo zzbo2 = this.zzb;
                zzbyr zzbyr2 = new zzbyr((NativeAd.OnNativeAdLoadedListener)var1_1);
                zzbo2.zzk(zzbyr2);
                return this;
            }
            catch (RemoteException remoteException) {
                zzcgp.zzk("Failed to add google native ad listener", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Deprecated
        @NonNull
        public Builder forUnifiedNativeAd(@NonNull UnifiedNativeAd.OnUnifiedNativeAdLoadedListener listener) {
            try {
                void var1_1;
                zzbo zzbo2 = this.zzb;
                zzbom zzbom2 = new zzbom((UnifiedNativeAd.OnUnifiedNativeAdLoadedListener)var1_1);
                zzbo2.zzk(zzbom2);
                return this;
            }
            catch (RemoteException remoteException) {
                zzcgp.zzk("Failed to add google native ad listener", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public Builder withAdListener(@NonNull AdListener listener) {
            try {
                void var1_1;
                zzbo zzbo2 = this.zzb;
                zzg zzg2 = new zzg((AdListener)var1_1);
                zzbo2.zzl(zzg2);
                return this;
            }
            catch (RemoteException remoteException) {
                zzcgp.zzk("Failed to set AdListener.", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public Builder withAdManagerAdViewOptions(@NonNull AdManagerAdViewOptions options) {
            try {
                void var1_1;
                this.zzb.zzm((AdManagerAdViewOptions)var1_1);
                return this;
            }
            catch (RemoteException remoteException) {
                zzcgp.zzk("Failed to specify Ad Manager banner ad options", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Deprecated
        @NonNull
        public Builder withNativeAdOptions(@NonNull com.google.android.gms.ads.formats.NativeAdOptions options) {
            try {
                void var1_1;
                zzbo zzbo2 = this.zzb;
                zzbls zzbls2 = new zzbls((com.google.android.gms.ads.formats.NativeAdOptions)var1_1);
                zzbo2.zzo(zzbls2);
                return this;
            }
            catch (RemoteException remoteException) {
                zzcgp.zzk("Failed to specify native ad options", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NonNull
        public Builder withNativeAdOptions(@NonNull NativeAdOptions options) {
            try {
                void var2_10;
                void var1_1;
                zzbo zzbo2 = this.zzb;
                boolean bl = var1_1.shouldReturnUrlsForImageAssets();
                boolean bl2 = var1_1.shouldRequestMultipleImages();
                int n = var1_1.getAdChoicesPlacement();
                VideoOptions videoOptions = var1_1.getVideoOptions();
                if (videoOptions != null) {
                    zzff zzff2 = new zzff(var1_1.getVideoOptions());
                } else {
                    Object var2_11 = null;
                }
                zzbls zzbls2 = new zzbls(4, bl, -1, bl2, n, (zzff)var2_10, var1_1.zza(), var1_1.getMediaAspectRatio());
                zzbo2.zzo(zzbls2);
                return this;
            }
            catch (RemoteException remoteException) {
                zzcgp.zzk("Failed to specify native ad options", remoteException);
                return this;
            }
        }

        @NonNull
        public AdLoader build() {
            try {
                Context context = this.zza;
                zzbl zzbl2 = this.zzb.zze();
                AdLoader adLoader = new AdLoader(context, zzbl2, zzp.zza);
                return adLoader;
            }
            catch (RemoteException remoteException) {
                zzcgp.zzh("Failed to build AdLoader.", remoteException);
                zzeo zzeo2 = new zzeo();
                AdLoader adLoader = new AdLoader(this.zza, zzeo2.zzc(), zzp.zza);
                return adLoader;
            }
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull Context context, @NonNull String adUnitID) {
            void var2_2;
            zzbo zzbo2;
            Object object = Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
            object = (Context)object;
            zzau zzau2 = zzaw.zza();
            zzbvh zzbvh2 = new zzbvh();
            zzbo2 = zzau2.zzc((Context)zzbo2, (String)var2_2, zzbvh2);
            this.zza = object;
            this.zzb = zzbo2;
        }
    }
}

