/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzaky;
import com.google.android.gms.internal.zzkf;
import com.google.android.gms.internal.zzkg;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzko;
import com.google.android.gms.internal.zzkq;
import com.google.android.gms.internal.zzkr;
import com.google.android.gms.internal.zzks;
import com.google.android.gms.internal.zzkt;
import com.google.android.gms.internal.zzku;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzle;
import com.google.android.gms.internal.zzlt;
import com.google.android.gms.internal.zzmm;
import com.google.android.gms.internal.zzmu;
import com.google.android.gms.internal.zzmx;
import com.google.android.gms.internal.zzns;
import com.google.android.gms.internal.zzpe;
import com.google.android.gms.internal.zzwe;
import java.util.concurrent.atomic.AtomicBoolean;

@zzabh
@Hide
public final class zzmw {
    private final zzwe zzbjr = new zzwe();
    private final zzkn zzaln;
    private final AtomicBoolean zzbjs;
    private final VideoController zzbjt = new VideoController();
    private zzle zzbju = new zzmx(this);
    private zzkf zzbgt;
    private AdListener zzbgu;
    private AdSize[] zzbig;
    private AppEventListener zzamr;
    private Correlator zzbjv;
    private zzlt zzbjw;
    private OnCustomRenderedAdLoadedListener zzbjx;
    private VideoOptions zzamj;
    private String zzapp;
    private ViewGroup zzbjy;
    private int zzbjz;
    private boolean zzamp;

    public zzmw(ViewGroup viewGroup) {
        this(viewGroup, null, false, zzkn.zzbhz, 0);
    }

    public zzmw(ViewGroup viewGroup, int n) {
        this(viewGroup, null, false, zzkn.zzbhz, n);
    }

    public zzmw(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl) {
        this(viewGroup, attributeSet, bl, zzkn.zzbhz, 0);
    }

    public zzmw(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, int n) {
        this(viewGroup, attributeSet, false, zzkn.zzbhz, n);
    }

    private zzmw(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzkn zzkn2, zzlt zzlt2, int n) {
        this.zzbjy = viewGroup;
        this.zzaln = zzkn2;
        this.zzbjw = null;
        this.zzbjs = new AtomicBoolean(false);
        this.zzbjz = n;
        if (attributeSet != null) {
            Context context = viewGroup.getContext();
            try {
                zzkr zzkr2 = new zzkr(context, attributeSet);
                this.zzbig = zzkr2.zzi(bl);
                this.zzapp = zzkr2.getAdUnitId();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzlc.zzij().zza(viewGroup, new zzko(context, AdSize.BANNER), illegalArgumentException.getMessage(), illegalArgumentException.getMessage());
                return;
            }
            if (viewGroup.isInEditMode()) {
                boolean bl2;
                int n2 = this.zzbjz;
                AdSize adSize = this.zzbig[0];
                Context context2 = context;
                zzko zzko2 = new zzko(context2, adSize);
                new zzko(context2, adSize).zzbif = bl2 = zzmw.zzs(n2);
                zzlc.zzij().zza(viewGroup, zzko2, "Ads by Google");
            }
        }
    }

    private zzmw(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzkn zzkn2, int n) {
        this(viewGroup, attributeSet, bl, zzkn2, null, n);
    }

    public final void destroy() {
        try {
            if (this.zzbjw != null) {
                this.zzbjw.destroy();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to destroy AdView.", remoteException);
            return;
        }
    }

    public final AdListener getAdListener() {
        return this.zzbgu;
    }

    public final AdSize getAdSize() {
        try {
            zzko zzko2;
            if (this.zzbjw != null && (zzko2 = this.zzbjw.zzbq()) != null) {
                return zzko2.zzic();
            }
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to get the current AdSize.", remoteException);
        }
        if (this.zzbig != null) {
            return this.zzbig[0];
        }
        return null;
    }

    public final AdSize[] getAdSizes() {
        return this.zzbig;
    }

    public final String getAdUnitId() {
        if (this.zzapp == null && this.zzbjw != null) {
            try {
                this.zzapp = this.zzbjw.getAdUnitId();
            }
            catch (RemoteException remoteException) {
                zzaky.zzc("Failed to get ad unit id.", remoteException);
            }
        }
        return this.zzapp;
    }

    public final AppEventListener getAppEventListener() {
        return this.zzamr;
    }

    public final OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzbjx;
    }

    public final void zza(zzmu zzmu2) {
        try {
            if (this.zzbjw == null) {
                zzlt zzlt2;
                zzko zzko2;
                zzmw zzmw2 = this;
                if ((zzmw2.zzbig == null || zzmw2.zzapp == null) && zzmw2.zzbjw == null) {
                    throw new IllegalStateException("The ad size and ad unit ID must be set before loadAd is called.");
                }
                zzmw zzmw3 = zzmw2;
                Context context = zzmw3.zzbjy.getContext();
                Object object = zzko2 = zzmw.zza(context, zzmw3.zzbig, zzmw3.zzbjz);
                if ("search_v2".equals(object.zzbia)) {
                    String string = zzmw3.zzapp;
                    zzko zzko3 = zzko2;
                    Context context2 = context;
                    object = zzlc.zzik();
                    zzku zzku2 = new zzku((zzks)object, context2, zzko3, string);
                    Context context3 = context2;
                    zzlt2 = zzks.zza(context3, false, zzku2);
                } else {
                    zzwe zzwe2 = zzmw3.zzbjr;
                    String string = zzmw3.zzapp;
                    zzko zzko4 = zzko2;
                    Context context4 = context;
                    object = zzlc.zzik();
                    zzkt zzkt2 = new zzkt((zzks)object, context4, zzko4, string, zzwe2);
                    Context context5 = context4;
                    zzlt2 = zzks.zza(context5, false, zzkt2);
                }
                zzmw2.zzbjw = zzlt2;
                zzmw2.zzbjw.zza(new zzkh(zzmw2.zzbju));
                if (zzmw2.zzbgt != null) {
                    zzmw2.zzbjw.zza(new zzkg(zzmw2.zzbgt));
                }
                if (zzmw2.zzamr != null) {
                    zzmw2.zzbjw.zza(new zzkq(zzmw2.zzamr));
                }
                if (zzmw2.zzbjx != null) {
                    zzmw2.zzbjw.zza(new zzpe(zzmw2.zzbjx));
                }
                if (zzmw2.zzbjv != null) {
                    zzmw2.zzbjw.zza(zzmw2.zzbjv.zzbf());
                }
                if (zzmw2.zzamj != null) {
                    zzmw2.zzbjw.zza(new zzns(zzmw2.zzamj));
                }
                zzmw2.zzbjw.setManualImpressionsEnabled(zzmw2.zzamp);
                zzmw zzmw4 = zzmw2;
                try {
                    IObjectWrapper iObjectWrapper = zzmw4.zzbjw.zzbp();
                    if (iObjectWrapper != null) {
                        zzmw4.zzbjy.addView((View)zzn.zzy((IObjectWrapper)iObjectWrapper));
                    }
                }
                catch (RemoteException remoteException) {
                    zzaky.zzc("Failed to get an ad frame.", remoteException);
                }
            }
            if (this.zzbjw.zzb(zzkn.zza(this.zzbjy.getContext(), zzmu2))) {
                this.zzbjr.zzn(zzmu2.zziv());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to load ad.", remoteException);
            return;
        }
    }

    public final void pause() {
        try {
            if (this.zzbjw != null) {
                this.zzbjw.pause();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to call pause.", remoteException);
            return;
        }
    }

    public final void recordManualImpression() {
        if (this.zzbjs.getAndSet(true)) {
            return;
        }
        try {
            if (this.zzbjw != null) {
                this.zzbjw.zzbs();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to record impression.", remoteException);
            return;
        }
    }

    public final void resume() {
        try {
            if (this.zzbjw != null) {
                this.zzbjw.resume();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to call resume.", remoteException);
            return;
        }
    }

    public final void setAdListener(AdListener adListener) {
        this.zzbgu = adListener;
        this.zzbju.zza(adListener);
    }

    public final void zza(zzkf zzkf2) {
        try {
            this.zzbgt = zzkf2;
            if (this.zzbjw != null) {
                this.zzbjw.zza(zzkf2 != null ? new zzkg(zzkf2) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to set the AdClickListener.", remoteException);
            return;
        }
    }

    public final void setAdSizes(AdSize ... adSizeArray) {
        if (this.zzbig != null) {
            throw new IllegalStateException("The ad size can only be set once on AdView.");
        }
        this.zza(adSizeArray);
    }

    public final void zza(AdSize ... adSizeArray) {
        this.zzbig = adSizeArray;
        try {
            if (this.zzbjw != null) {
                this.zzbjw.zza(zzmw.zza(this.zzbjy.getContext(), this.zzbig, this.zzbjz));
            }
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to set the ad size.", remoteException);
        }
        this.zzbjy.requestLayout();
    }

    public final void setAdUnitId(String string) {
        if (this.zzapp != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on AdView.");
        }
        this.zzapp = string;
    }

    public final void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzamr = appEventListener;
            if (this.zzbjw != null) {
                this.zzbjw.zza(appEventListener != null ? new zzkq(appEventListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to set the AppEventListener.", remoteException);
            return;
        }
    }

    public final void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        this.zzbjx = onCustomRenderedAdLoadedListener;
        try {
            if (this.zzbjw != null) {
                this.zzbjw.zza(onCustomRenderedAdLoadedListener != null ? new zzpe(onCustomRenderedAdLoadedListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to set the onCustomRenderedAdLoadedListener.", remoteException);
            return;
        }
    }

    public final void setManualImpressionsEnabled(boolean bl) {
        this.zzamp = bl;
        try {
            if (this.zzbjw != null) {
                this.zzbjw.setManualImpressionsEnabled(this.zzamp);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to set manual impressions.", remoteException);
            return;
        }
    }

    public final void setCorrelator(Correlator correlator) {
        this.zzbjv = correlator;
        try {
            if (this.zzbjw != null) {
                this.zzbjw.zza(this.zzbjv == null ? null : this.zzbjv.zzbf());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to set correlator.", remoteException);
            return;
        }
    }

    public final String getMediationAdapterClassName() {
        try {
            if (this.zzbjw != null) {
                return this.zzbjw.zzco();
            }
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to get the mediation adapter class name.", remoteException);
        }
        return null;
    }

    public final boolean isLoading() {
        try {
            if (this.zzbjw != null) {
                return this.zzbjw.isLoading();
            }
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to check if ad is loading.", remoteException);
        }
        return false;
    }

    public final VideoController getVideoController() {
        return this.zzbjt;
    }

    public final zzmm zzbh() {
        if (this.zzbjw == null) {
            return null;
        }
        try {
            return this.zzbjw.getVideoController();
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to retrieve VideoController.", remoteException);
            return null;
        }
    }

    public final void setVideoOptions(VideoOptions videoOptions) {
        this.zzamj = videoOptions;
        try {
            if (this.zzbjw != null) {
                this.zzbjw.zza(videoOptions == null ? null : new zzns(videoOptions));
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to set video options.", remoteException);
            return;
        }
    }

    public final VideoOptions getVideoOptions() {
        return this.zzamj;
    }

    public final boolean zza(zzlt zzlt2) {
        IObjectWrapper iObjectWrapper;
        if (zzlt2 == null) {
            return false;
        }
        try {
            iObjectWrapper = zzlt2.zzbp();
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to get an ad frame.", remoteException);
            return false;
        }
        if (iObjectWrapper == null) {
            return false;
        }
        if (((View)zzn.zzy((IObjectWrapper)iObjectWrapper)).getParent() != null) {
            return false;
        }
        this.zzbjy.addView((View)zzn.zzy((IObjectWrapper)iObjectWrapper));
        this.zzbjw = zzlt2;
        return true;
    }

    private static zzko zza(Context context, AdSize[] adSizeArray, int n) {
        boolean bl;
        zzko zzko2 = new zzko(context, adSizeArray);
        new zzko(context, adSizeArray).zzbif = bl = zzmw.zzs(n);
        return zzko2;
    }

    private static boolean zzs(int n) {
        return n == 1;
    }

    static /* synthetic */ VideoController zza(zzmw zzmw2) {
        return zzmw2.zzbjt;
    }
}

