/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.formats;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.ads.formats.AdChoicesView;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzaky;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzqw;

public class NativeAdView
extends FrameLayout {
    private final FrameLayout zzamk;
    private final zzqw zzaml;

    public NativeAdView(Context context) {
        super(context);
        this.zzamk = this.zzb(context);
        this.zzaml = this.zzbj();
    }

    public NativeAdView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.zzamk = this.zzb(context);
        this.zzaml = this.zzbj();
    }

    public NativeAdView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.zzamk = this.zzb(context);
        this.zzaml = this.zzbj();
    }

    @TargetApi(value=21)
    public NativeAdView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.zzamk = this.zzb(context);
        this.zzaml = this.zzbj();
    }

    public void setAdChoicesView(AdChoicesView adChoicesView) {
        this.zza("1098", (View)adChoicesView);
    }

    public AdChoicesView getAdChoicesView() {
        View view = this.zzq("1098");
        if (view instanceof AdChoicesView) {
            return (AdChoicesView)view;
        }
        return null;
    }

    @Hide
    protected final void zza(String string, View view) {
        try {
            this.zzaml.zzb(string, zzn.zzz((Object)view));
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzb("Unable to call setAssetView on delegate", remoteException);
            return;
        }
    }

    @Hide
    protected final View zzq(String string) {
        try {
            IObjectWrapper iObjectWrapper = this.zzaml.zzal(string);
            if (iObjectWrapper != null) {
                return (View)zzn.zzy((IObjectWrapper)iObjectWrapper);
            }
        }
        catch (RemoteException remoteException) {
            zzaky.zzb("Unable to call getAssetView on delegate", remoteException);
        }
        return null;
    }

    public void setNativeAd(NativeAd nativeAd) {
        try {
            this.zzaml.zza((IObjectWrapper)nativeAd.zzbi());
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzb("Unable to call setNativeAd on delegate", remoteException);
            return;
        }
    }

    public void destroy() {
        try {
            this.zzaml.destroy();
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzb("Unable to destroy native ad view", remoteException);
            return;
        }
    }

    private final FrameLayout zzb(Context context) {
        Context context2 = context;
        FrameLayout frameLayout = new FrameLayout(context2);
        frameLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView((View)frameLayout);
        return frameLayout;
    }

    private final zzqw zzbj() {
        zzbq.checkNotNull((Object)this.zzamk, (Object)"createDelegate must be called after mOverlayFrame has been created");
        if (this.isInEditMode()) {
            return null;
        }
        return zzlc.zzik().zza(this.zzamk.getContext(), this, this.zzamk);
    }

    @Hide
    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        super.addView(view, n, layoutParams);
        super.bringChildToFront((View)this.zzamk);
    }

    @Hide
    public void removeView(View view) {
        if (this.zzamk == view) {
            return;
        }
        super.removeView(view);
    }

    @Hide
    public void removeAllViews() {
        super.removeAllViews();
        super.addView((View)this.zzamk);
    }

    @Hide
    public void bringChildToFront(View view) {
        super.bringChildToFront(view);
        if (this.zzamk != view) {
            super.bringChildToFront((View)this.zzamk);
        }
    }

    @Hide
    public void onVisibilityChanged(View view, int n) {
        super.onVisibilityChanged(view, n);
        if (this.zzaml != null) {
            try {
                this.zzaml.zzb(zzn.zzz((Object)view), n);
                return;
            }
            catch (RemoteException remoteException) {
                zzaky.zzb("Unable to call onVisibilityChanged on delegate", remoteException);
            }
        }
    }
}

