/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.doubleclick;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.ads.doubleclick.zza;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.NetworkExtras;
import com.google.android.gms.ads.mediation.customevent.CustomEvent;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzmu;
import com.google.android.gms.internal.zzmv;
import java.util.Date;
import java.util.List;
import java.util.Set;

public final class PublisherAdRequest {
    public static final int ERROR_CODE_INTERNAL_ERROR = 0;
    public static final int ERROR_CODE_INVALID_REQUEST = 1;
    public static final int ERROR_CODE_NETWORK_ERROR = 2;
    public static final int ERROR_CODE_NO_FILL = 3;
    public static final int GENDER_UNKNOWN = 0;
    public static final int GENDER_MALE = 1;
    public static final int GENDER_FEMALE = 2;
    public static final String DEVICE_ID_EMULATOR = "B3EEABB8EE11C2BE770B684D95219ECB";
    private final zzmu zzalq;

    private PublisherAdRequest(Builder builder) {
        this.zzalq = new zzmu(builder.zzalr);
    }

    public final Date getBirthday() {
        return this.zzalq.getBirthday();
    }

    public final String getContentUrl() {
        return this.zzalq.getContentUrl();
    }

    public final int getGender() {
        return this.zzalq.getGender();
    }

    public final Set<String> getKeywords() {
        return this.zzalq.getKeywords();
    }

    public final Location getLocation() {
        return this.zzalq.getLocation();
    }

    public final boolean getManualImpressionsEnabled() {
        return this.zzalq.getManualImpressionsEnabled();
    }

    @Deprecated
    public final <T extends NetworkExtras> T getNetworkExtras(Class<T> clazz) {
        return this.zzalq.getNetworkExtras(clazz);
    }

    public final <T extends MediationAdapter> Bundle getNetworkExtrasBundle(Class<T> clazz) {
        return this.zzalq.getNetworkExtrasBundle(clazz);
    }

    public final <T extends CustomEvent> Bundle getCustomEventExtrasBundle(Class<T> clazz) {
        return this.zzalq.getCustomEventExtrasBundle(clazz);
    }

    public final String getPublisherProvidedId() {
        return this.zzalq.getPublisherProvidedId();
    }

    public final boolean isTestDevice(Context context) {
        return this.zzalq.isTestDevice(context);
    }

    public final Bundle getCustomTargeting() {
        return this.zzalq.getCustomTargeting();
    }

    public static void updateCorrelator() {
    }

    @Hide
    public final zzmu zzbe() {
        return this.zzalq;
    }

    /* synthetic */ PublisherAdRequest(Builder builder, zza zza2) {
        this(builder);
    }

    public static final class Builder {
        private final zzmv zzalr = new zzmv();

        public Builder() {
        }

        public final Builder addKeyword(String string) {
            this.zzalr.zzad(string);
            return this;
        }

        public final Builder addNetworkExtras(NetworkExtras networkExtras) {
            this.zzalr.zza(networkExtras);
            return this;
        }

        public final Builder addNetworkExtrasBundle(Class<? extends MediationAdapter> clazz, Bundle bundle) {
            this.zzalr.zza(clazz, bundle);
            return this;
        }

        public final Builder addCustomEventExtrasBundle(Class<? extends CustomEvent> clazz, Bundle bundle) {
            this.zzalr.zzb(clazz, bundle);
            return this;
        }

        public final Builder addTestDevice(String string) {
            this.zzalr.zzae(string);
            return this;
        }

        public final PublisherAdRequest build() {
            return new PublisherAdRequest(this, null);
        }

        public final Builder setBirthday(Date date) {
            this.zzalr.zza(date);
            return this;
        }

        public final Builder setContentUrl(String string) {
            zzbq.checkNotNull((Object)string, (Object)"Content URL must be non-null.");
            zzbq.zzh((String)string, (Object)"Content URL must be non-empty.");
            zzbq.zzb((string.length() <= 512 ? 1 : 0) != 0, (String)"Content URL must not exceed %d in length.  Provided length was %d.", (Object[])new Object[]{512, string.length()});
            this.zzalr.zzag(string);
            return this;
        }

        public final Builder setGender(int n) {
            this.zzalr.zzr(n);
            return this;
        }

        public final Builder setLocation(Location location) {
            this.zzalr.zzb(location);
            return this;
        }

        @Deprecated
        public final Builder setManualImpressionsEnabled(boolean bl) {
            this.zzalr.setManualImpressionsEnabled(bl);
            return this;
        }

        public final Builder setPublisherProvidedId(String string) {
            this.zzalr.zzah(string);
            return this;
        }

        public final Builder setRequestAgent(String string) {
            this.zzalr.zzai(string);
            return this;
        }

        public final Builder tagForChildDirectedTreatment(boolean bl) {
            this.zzalr.zzj(bl);
            return this;
        }

        public final Builder addCustomTargeting(String string, String string2) {
            this.zzalr.zzd(string, string2);
            return this;
        }

        public final Builder addCustomTargeting(String string, List<String> list) {
            if (list != null) {
                this.zzalr.zzd(string, TextUtils.join((CharSequence)",", list));
            }
            return this;
        }

        public final Builder addCategoryExclusion(String string) {
            this.zzalr.zzaj(string);
            return this;
        }

        public final Builder setIsDesignedForFamilies(boolean bl) {
            this.zzalr.zzk(bl);
            return this;
        }
    }
}

