/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.support.annotation.RequiresPermission;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzaky;
import com.google.android.gms.internal.zzkf;
import com.google.android.gms.internal.zzmw;

class BaseAdView
extends ViewGroup {
    @Hide
    protected final zzmw zzalw;

    public BaseAdView(Context context, int n) {
        super(context);
        this.zzalw = new zzmw(this, n);
    }

    public BaseAdView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet);
        this.zzalw = new zzmw(this, attributeSet, false, n);
    }

    public BaseAdView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n);
        this.zzalw = new zzmw(this, attributeSet, false, n2);
    }

    public void destroy() {
        this.zzalw.destroy();
    }

    public AdListener getAdListener() {
        return this.zzalw.getAdListener();
    }

    public AdSize getAdSize() {
        return this.zzalw.getAdSize();
    }

    public String getAdUnitId() {
        return this.zzalw.getAdUnitId();
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(AdRequest adRequest) {
        this.zzalw.zza(adRequest.zzbe());
    }

    public void pause() {
        this.zzalw.pause();
    }

    public void resume() {
        this.zzalw.resume();
    }

    public boolean isLoading() {
        return this.zzalw.isLoading();
    }

    public void setAdListener(AdListener adListener) {
        this.zzalw.setAdListener(adListener);
        if (adListener == null) {
            this.zzalw.zza((zzkf)null);
            this.zzalw.setAppEventListener(null);
            return;
        }
        if (adListener instanceof zzkf) {
            this.zzalw.zza((zzkf)((Object)adListener));
        }
        if (adListener instanceof AppEventListener) {
            this.zzalw.setAppEventListener((AppEventListener)((Object)adListener));
        }
    }

    public void setAdSize(AdSize adSize) {
        this.zzalw.setAdSizes(adSize);
    }

    public void setAdUnitId(String string) {
        this.zzalw.setAdUnitId(string);
    }

    public String getMediationAdapterClassName() {
        return this.zzalw.getMediationAdapterClassName();
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            int n5 = view.getMeasuredWidth();
            int n6 = view.getMeasuredHeight();
            int n7 = (n3 - n - n5) / 2;
            int n8 = (n4 - n2 - n6) / 2;
            view.layout(n7, n8, n7 + n5, n8 + n6);
        }
    }

    protected void onMeasure(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            this.measureChild(view, n, n2);
            n3 = view.getMeasuredWidth();
            n4 = view.getMeasuredHeight();
        } else {
            AdSize adSize = null;
            try {
                adSize = this.getAdSize();
            }
            catch (NullPointerException nullPointerException) {
                zzaky.zzb("Unable to retrieve ad size.", nullPointerException);
            }
            if (adSize != null) {
                Context context = this.getContext();
                n3 = adSize.getWidthInPixels(context);
                n4 = adSize.getHeightInPixels(context);
            }
        }
        n3 = Math.max(n3, this.getSuggestedMinimumWidth());
        n4 = Math.max(n4, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(View.resolveSize((int)n3, (int)n), View.resolveSize((int)n4, (int)n2));
    }
}

