/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.doubleclick.PublisherAdRequest;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.formats.OnPublisherAdViewLoadedListener;
import com.google.android.gms.ads.formats.PublisherAdViewOptions;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzaky;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzko;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzll;
import com.google.android.gms.internal.zzlo;
import com.google.android.gms.internal.zzmu;
import com.google.android.gms.internal.zzqh;
import com.google.android.gms.internal.zzsq;
import com.google.android.gms.internal.zzsr;
import com.google.android.gms.internal.zzss;
import com.google.android.gms.internal.zzst;
import com.google.android.gms.internal.zzsu;
import com.google.android.gms.internal.zzsw;
import com.google.android.gms.internal.zzwe;

public class AdLoader {
    private final zzkn zzaln;
    private final Context mContext;
    private final zzll zzalo;

    AdLoader(Context context, zzll zzll2) {
        this(context, zzll2, zzkn.zzbhz);
    }

    private AdLoader(Context context, zzll zzll2, zzkn zzkn2) {
        this.mContext = context;
        this.zzalo = zzll2;
        this.zzaln = zzkn2;
    }

    private final void zza(zzmu zzmu2) {
        try {
            this.zzalo.zzd(zzkn.zza(this.mContext, zzmu2));
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzb("Failed to load ad.", remoteException);
            return;
        }
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(AdRequest adRequest) {
        this.zza(adRequest.zzbe());
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAds(AdRequest adRequest, int n) {
        zzmu zzmu2 = adRequest.zzbe();
        AdLoader adLoader = this;
        try {
            adLoader.zzalo.zza(zzkn.zza(adLoader.mContext, zzmu2), n);
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzb("Failed to load ads.", remoteException);
            return;
        }
    }

    public void loadAd(PublisherAdRequest publisherAdRequest) {
        this.zza(publisherAdRequest.zzbe());
    }

    @Deprecated
    public String getMediationAdapterClassName() {
        try {
            return this.zzalo.zzco();
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to get the mediation adapter class name.", remoteException);
            return null;
        }
    }

    public boolean isLoading() {
        try {
            return this.zzalo.isLoading();
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    public static class Builder {
        private final Context mContext;
        private final zzlo zzalp;

        public Builder(Context context, String string) {
            this((Context)zzbq.checkNotNull((Object)context, (Object)"context cannot be null"), zzlc.zzik().zzb(context, string, new zzwe()));
        }

        private Builder(Context context, zzlo zzlo2) {
            this.mContext = context;
            this.zzalp = zzlo2;
        }

        public Builder forContentAd(NativeContentAd.OnContentAdLoadedListener onContentAdLoadedListener) {
            try {
                this.zzalp.zza(new zzsr(onContentAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzaky.zzc("Failed to add content ad listener", remoteException);
            }
            return this;
        }

        public Builder forAppInstallAd(NativeAppInstallAd.OnAppInstallAdLoadedListener onAppInstallAdLoadedListener) {
            try {
                this.zzalp.zza(new zzsq(onAppInstallAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzaky.zzc("Failed to add app install ad listener", remoteException);
            }
            return this;
        }

        @Hide
        public final Builder zza(UnifiedNativeAd.zza zza2) {
            try {
                this.zzalp.zza(new zzsw(zza2));
            }
            catch (RemoteException remoteException) {
                zzaky.zzc("Failed to add google native ad listener", remoteException);
            }
            return this;
        }

        public Builder forCustomTemplateAd(String string, NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener onCustomTemplateAdLoadedListener, NativeCustomTemplateAd.OnCustomClickListener onCustomClickListener) {
            try {
                this.zzalp.zza(string, new zzst(onCustomTemplateAdLoadedListener), onCustomClickListener == null ? null : new zzss(onCustomClickListener));
            }
            catch (RemoteException remoteException) {
                zzaky.zzc("Failed to add custom template ad listener", remoteException);
            }
            return this;
        }

        public Builder forPublisherAdView(OnPublisherAdViewLoadedListener onPublisherAdViewLoadedListener, AdSize ... adSizeArray) {
            if (adSizeArray == null || adSizeArray.length <= 0) {
                throw new IllegalArgumentException("The supported ad sizes must contain at least one valid ad size.");
            }
            try {
                zzko zzko2 = new zzko(this.mContext, adSizeArray);
                this.zzalp.zza(new zzsu(onPublisherAdViewLoadedListener), zzko2);
            }
            catch (RemoteException remoteException) {
                zzaky.zzc("Failed to add publisher banner ad listener", remoteException);
            }
            return this;
        }

        public Builder withAdListener(AdListener adListener) {
            try {
                this.zzalp.zzb(new zzkh(adListener));
            }
            catch (RemoteException remoteException) {
                zzaky.zzc("Failed to set AdListener.", remoteException);
            }
            return this;
        }

        public Builder withNativeAdOptions(NativeAdOptions nativeAdOptions) {
            try {
                this.zzalp.zza(new zzqh(nativeAdOptions));
            }
            catch (RemoteException remoteException) {
                zzaky.zzc("Failed to specify native ad options", remoteException);
            }
            return this;
        }

        public Builder withPublisherAdViewOptions(PublisherAdViewOptions publisherAdViewOptions) {
            try {
                this.zzalp.zza(publisherAdViewOptions);
            }
            catch (RemoteException remoteException) {
                zzaky.zzc("Failed to specify DFP banner ad options", remoteException);
            }
            return this;
        }

        public Builder withCorrelator(@NonNull Correlator correlator) {
            zzbq.checkNotNull((Object)correlator);
            try {
                this.zzalp.zzb(correlator.zzbf());
            }
            catch (RemoteException remoteException) {
                zzaky.zzc("Failed to set correlator.", remoteException);
            }
            return this;
        }

        public AdLoader build() {
            try {
                return new AdLoader(this.mContext, this.zzalp.zzdi());
            }
            catch (RemoteException remoteException) {
                zzaky.zzb("Failed to build AdLoader.", remoteException);
                return null;
            }
        }
    }
}

