/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.oss.licenses.plugin;

import com.google.android.gms.oss.licenses.plugin.ArtifactInfo;
import com.google.android.gms.oss.licenses.plugin.DependencyUtil;
import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.util.XmlSlurper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.LoggerFactory;

public abstract class LicensesTask
extends DefaultTask
implements GroovyObject {
    private static final String UTF_8 = "UTF-8";
    private static final byte[] LINE_SEPARATOR;
    private static final int GRANULAR_BASE_VERSION = 14;
    private static final String GOOGLE_PLAY_SERVICES_GROUP = "com.google.android.gms";
    private static final String LICENSE_ARTIFACT_SUFFIX = "-license";
    private static final String FIREBASE_GROUP = "com.google.firebase";
    private static final String FAIL_READING_LICENSES_ERROR = "Failed to read license text.";
    private static final Object logger;
    protected int start;
    protected Set<String> googleServiceLicenses;
    protected Map<String, String> licensesMap;
    protected Map<String, String> licenseOffsets;
    protected static final String ABSENT_DEPENDENCY_KEY = "Debug License Info";
    protected static final String ABSENT_DEPENDENCY_TEXT = "Licenses are only provided in build variants (e.g. release) where the Android Gradle Plugin generates an app dependency list.";
    @OutputDirectory
    private File rawResourceDir;
    @OutputFile
    private File licenses;
    @OutputFile
    private File licensesMetadata;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public LicensesTask() {
        MetaClass metaClass;
        Map map;
        Map map2;
        int n;
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        this.start = n = 0;
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.googleServiceLicenses = (Set)ScriptBytecodeAdapter.castToType((Object)list, Set.class);
        this.licensesMap = map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.licenseOffsets = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @InputFile
    public abstract RegularFileProperty getDependenciesJson();

    @TaskAction
    public void action() {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[0].callCurrent((GroovyObject)this);
        } else {
            this.initOutputDir();
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[1].callCurrent((GroovyObject)this);
        } else {
            this.initLicenseFile();
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[2].callCurrent((GroovyObject)this);
        } else {
            this.initLicensesMetadata();
        }
        File dependenciesJsonFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].call(callSiteArray[4].callGetProperty(callSiteArray[5].callGroovyObjectGetProperty((Object)this))), File.class);
        Object artifactInfoSet = callSiteArray[6].callStatic(LicensesTask.class, (Object)dependenciesJsonFile);
        if (ScriptBytecodeAdapter.isCase((Object)callSiteArray[7].callGetProperty(DependencyUtil.class), (Object)artifactInfoSet)) {
            if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[8].call(artifactInfoSet), (Object)1)) {
                throw (Throwable)callSiteArray[9].callConstructor(IllegalStateException.class, (Object)"artifactInfoSet that contains EMPTY_ARTIFACT should not contain other artifacts.");
            }
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                callSiteArray[10].callCurrent((GroovyObject)this);
            } else {
                this.addDebugLicense();
            }
        } else {
            Object artifactInfo = null;
            Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].call(artifactInfoSet), Iterator.class);
            while (iterator.hasNext()) {
                artifactInfo = iterator.next();
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[12].callStatic(LicensesTask.class, callSiteArray[13].callGetProperty(artifactInfo)))) {
                    if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[14].call(callSiteArray[15].callGetProperty(artifactInfo), (Object)LICENSE_ARTIFACT_SUFFIX))) {
                        callSiteArray[16].callCurrent((GroovyObject)this, artifactInfo);
                    }
                    if (!(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[17].callStatic(LicensesTask.class, callSiteArray[18].callGetProperty(artifactInfo))) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[19].call(callSiteArray[20].callGetProperty(artifactInfo), (Object)LICENSE_ARTIFACT_SUFFIX)))) continue;
                    callSiteArray[21].callCurrent((GroovyObject)this, artifactInfo);
                    continue;
                }
                callSiteArray[22].callCurrent((GroovyObject)this, artifactInfo);
            }
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[23].callCurrent((GroovyObject)this);
        } else {
            this.writeMetadata();
        }
    }

    private static Set<ArtifactInfo> loadDependenciesJson(File jsonFile) {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        Object allDependencies = callSiteArray[24].call(callSiteArray[25].callConstructor(JsonSlurper.class), (Object)jsonFile);
        Object artifactInfoSet = callSiteArray[26].callConstructor(HashSet.class);
        Object entry = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[27].call(allDependencies), Iterator.class);
        while (iterator.hasNext()) {
            entry = iterator.next();
            ArtifactInfo artifactInfo = (ArtifactInfo)ScriptBytecodeAdapter.castToType((Object)callSiteArray[28].callStatic(LicensesTask.class, entry), ArtifactInfo.class);
            callSiteArray[29].call(artifactInfoSet, (Object)artifactInfo);
        }
        return (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[30].call(artifactInfoSet), Set.class);
    }

    private void addDebugLicense() {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        callSiteArray[31].callCurrent((GroovyObject)this, (Object)ABSENT_DEPENDENCY_KEY, callSiteArray[32].call((Object)ABSENT_DEPENDENCY_TEXT, (Object)UTF_8));
    }

    protected void initOutputDir() {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[33].call((Object)this.rawResourceDir))) {
            callSiteArray[34].call((Object)this.rawResourceDir);
        }
    }

    protected void initLicenseFile() {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)this.licenses, null)) {
            callSiteArray[35].call(logger, (Object)"License file is undefined");
        }
        public final class _initLicenseFile_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _initLicenseFile_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _initLicenseFile_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object w) {
                CallSite[] callSiteArray = _initLicenseFile_closure1.$getCallSiteArray();
                return callSiteArray[0].call(w, (Object)"");
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _initLicenseFile_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "leftShift";
                return new CallSiteArray(_initLicenseFile_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _initLicenseFile_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[36].call(callSiteArray[37].call((Object)this.licenses), (Object)new _initLicenseFile_closure1((Object)this, (Object)this));
    }

    protected void initLicensesMetadata() {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        public final class _initLicensesMetadata_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _initLicensesMetadata_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _initLicensesMetadata_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object w) {
                CallSite[] callSiteArray = _initLicensesMetadata_closure2.$getCallSiteArray();
                return callSiteArray[0].call(w, (Object)"");
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _initLicensesMetadata_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "leftShift";
                return new CallSiteArray(_initLicensesMetadata_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _initLicensesMetadata_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[38].call(callSiteArray[39].call((Object)this.licensesMetadata), (Object)new _initLicensesMetadata_closure2((Object)this, (Object)this));
    }

    protected static boolean isGoogleServices(String group) {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[40].call((Object)GOOGLE_PLAY_SERVICES_GROUP, (Object)group)) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[41].call((Object)FIREBASE_GROUP, (Object)group));
    }

    protected static boolean isGranularVersion(String version) {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        Object[] versions = (String[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[42].call((Object)version, (Object)"\\."), String[].class);
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[43].callGetProperty((Object)versions), (Object)0) && ScriptBytecodeAdapter.compareGreaterThanEqual((Object)callSiteArray[44].call(Integer.class, callSiteArray[45].call((Object)versions, (Object)0)), (Object)GRANULAR_BASE_VERSION);
        }
        return ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[46].callGetProperty((Object)versions), (Object)0) && ScriptBytecodeAdapter.compareGreaterThanEqual((Object)callSiteArray[47].call(Integer.class, BytecodeInterface8.objectArrayGet((Object[])versions, (int)0)), (Object)GRANULAR_BASE_VERSION);
    }

    protected void addGooglePlayServiceLicenses(ArtifactInfo artifactInfo) {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        File artifactFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[48].call(DependencyUtil.class, callSiteArray[49].callCurrent((GroovyObject)this), (Object)artifactInfo), File.class);
        if (ScriptBytecodeAdapter.compareEqual((Object)artifactFile, null)) {
            callSiteArray[50].call(logger, (Object)new GStringImpl(new Object[]{artifactInfo}, new String[]{"Unable to find Google Play Services Artifact for ", ""}));
            return;
        }
        callSiteArray[51].callCurrent((GroovyObject)this, (Object)artifactFile);
    }

    protected void addGooglePlayServiceLicenses(File artifactFile) {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        ZipFile licensesZip = (ZipFile)ScriptBytecodeAdapter.castToType((Object)callSiteArray[52].callConstructor(ZipFile.class, (Object)artifactFile), ZipFile.class);
        ZipEntry jsonFile = (ZipEntry)ScriptBytecodeAdapter.castToType((Object)callSiteArray[53].call((Object)licensesZip, (Object)"third_party_licenses.json"), ZipEntry.class);
        ZipEntry txtFile = (ZipEntry)ScriptBytecodeAdapter.castToType((Object)callSiteArray[54].call((Object)licensesZip, (Object)"third_party_licenses.txt"), ZipEntry.class);
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? !DefaultTypeTransformation.booleanUnbox((Object)jsonFile) || !DefaultTypeTransformation.booleanUnbox((Object)txtFile) : !DefaultTypeTransformation.booleanUnbox((Object)jsonFile) || !DefaultTypeTransformation.booleanUnbox((Object)txtFile)) {
            return;
        }
        Reference jsonSlurper = new Reference((Object)((JsonSlurper)ScriptBytecodeAdapter.castToType((Object)callSiteArray[55].callConstructor(JsonSlurper.class), JsonSlurper.class)));
        public final class _addGooglePlayServiceLicenses_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference jsonSlurper;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _addGooglePlayServiceLicenses_closure3(Object _outerInstance, Object _thisObject, Reference jsonSlurper) {
                Reference reference;
                CallSite[] callSiteArray = _addGooglePlayServiceLicenses_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.jsonSlurper = reference = jsonSlurper;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _addGooglePlayServiceLicenses_closure3.$getCallSiteArray();
                return callSiteArray[0].call(this.jsonSlurper.get(), it);
            }

            @Generated
            public JsonSlurper getJsonSlurper() {
                CallSite[] callSiteArray = _addGooglePlayServiceLicenses_closure3.$getCallSiteArray();
                return (JsonSlurper)ScriptBytecodeAdapter.castToType((Object)this.jsonSlurper.get(), JsonSlurper.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _addGooglePlayServiceLicenses_closure3.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addGooglePlayServiceLicenses_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "parse";
                return new CallSiteArray(_addGooglePlayServiceLicenses_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _addGooglePlayServiceLicenses_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object licensesObj = callSiteArray[56].call(callSiteArray[57].call((Object)licensesZip, (Object)jsonFile), (Object)new _addGooglePlayServiceLicenses_closure3((Object)this, (Object)this, jsonSlurper));
        if (ScriptBytecodeAdapter.compareEqual((Object)licensesObj, null)) {
            return;
        }
        Object entry = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[58].call(licensesObj), Iterator.class);
        while (iterator.hasNext()) {
            entry = iterator.next();
            Reference key = new Reference((Object)ShortTypeHandling.castToString((Object)callSiteArray[59].callGetProperty(entry)));
            Reference startValue = new Reference((Object)((Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[60].callGetProperty(callSiteArray[61].callGetProperty(entry)), Integer.class)));
            Reference lengthValue = new Reference((Object)((Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[62].callGetProperty(callSiteArray[63].callGetProperty(entry)), Integer.class)));
            if (!(!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[64].call(this.googleServiceLicenses, (Object)((String)key.get()))))) continue;
            public final class _addGooglePlayServiceLicenses_closure4
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference startValue;
                private /* synthetic */ Reference lengthValue;
                private /* synthetic */ Reference key;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _addGooglePlayServiceLicenses_closure4(Object _outerInstance, Object _thisObject, Reference startValue, Reference lengthValue, Reference key) {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    CallSite[] callSiteArray = _addGooglePlayServiceLicenses_closure4.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.startValue = reference3 = startValue;
                    this.lengthValue = reference2 = lengthValue;
                    this.key = reference = key;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _addGooglePlayServiceLicenses_closure4.$getCallSiteArray();
                    byte[] content = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callStatic(LicensesTask.class, it, this.startValue.get(), this.lengthValue.get()), byte[].class);
                    callSiteArray[1].call(callSiteArray[2].callGroovyObjectGetProperty((Object)this), this.key.get());
                    return callSiteArray[3].callCurrent((GroovyObject)this, this.key.get(), (Object)content);
                }

                @Generated
                public Integer getStartValue() {
                    CallSite[] callSiteArray = _addGooglePlayServiceLicenses_closure4.$getCallSiteArray();
                    return (Integer)ScriptBytecodeAdapter.castToType((Object)this.startValue.get(), Integer.class);
                }

                @Generated
                public Integer getLengthValue() {
                    CallSite[] callSiteArray = _addGooglePlayServiceLicenses_closure4.$getCallSiteArray();
                    return (Integer)ScriptBytecodeAdapter.castToType((Object)this.lengthValue.get(), Integer.class);
                }

                @Generated
                public String getKey() {
                    CallSite[] callSiteArray = _addGooglePlayServiceLicenses_closure4.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.key.get());
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _addGooglePlayServiceLicenses_closure4.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _addGooglePlayServiceLicenses_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "getBytesFromInputStream";
                    stringArray[1] = "add";
                    stringArray[2] = "googleServiceLicenses";
                    stringArray[3] = "appendDependency";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[4];
                    _addGooglePlayServiceLicenses_closure4.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_addGooglePlayServiceLicenses_closure4.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _addGooglePlayServiceLicenses_closure4.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[65].call(callSiteArray[66].call((Object)licensesZip, (Object)txtFile), (Object)new _addGooglePlayServiceLicenses_closure4((Object)this, (Object)this, startValue, lengthValue, key));
        }
    }

    /*
     * Unable to fully structure code
     */
    protected static byte[] getBytesFromInputStream(InputStream stream, long offset, int length) {
        var4_3 = LicensesTask.$getCallSiteArray();
        buffer = new byte[1024];
        textArray = (ByteArrayOutputStream)ScriptBytecodeAdapter.castToType((Object)var4_3[67].callConstructor(ByteArrayOutputStream.class), ByteArrayOutputStream.class);
        var4_3[68].call((Object)stream, (Object)offset);
        bytesRemaining = 0;
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || LicensesTask.__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            var8_7 = length > 0 != false ? Integer.valueOf(length) : var4_3[69].callGetProperty(Integer.class);
            bytesRemaining = DefaultTypeTransformation.intUnbox((Object)var8_7);
        } else {
            var9_8 = length > 0 != false ? Integer.valueOf(length) : var4_3[70].callGetProperty(Integer.class);
            bytesRemaining = DefaultTypeTransformation.intUnbox((Object)var9_8);
        }
        bytes = 0;
        while (true) {
            if (!(bytesRemaining > 0)) ** GOTO lbl-1000
            var11_10 = var4_3[71].call((Object)stream, (Object)buffer, (Object)0, var4_3[72].call(Math.class, (Object)bytesRemaining, var4_3[73].callGetProperty((Object)buffer)));
            bytes = DefaultTypeTransformation.intUnbox((Object)var11_10);
            if (ScriptBytecodeAdapter.compareNotEqual((Object)var11_10, (Object)-1)) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            if (!v0) break;
            var4_3[74].call((Object)textArray, (Object)buffer, (Object)0, (Object)bytes);
            bytesRemaining = DefaultTypeTransformation.intUnbox((Object)var4_3[75].call((Object)bytesRemaining, (Object)bytes));
        }
        var4_3[76].call((Object)stream);
        var12_11 = (byte[])ScriptBytecodeAdapter.castToType((Object)var4_3[77].call((Object)textArray), byte[].class);
        try {
            return var12_11;
        }
        catch (Exception e) {
            throw (Throwable)var4_3[78].callConstructor(RuntimeException.class, (Object)LicensesTask.FAIL_READING_LICENSES_ERROR, (Object)e);
        }
    }

    protected void addLicensesFromPom(ArtifactInfo artifactInfo) {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        Object pomFile = callSiteArray[79].call(DependencyUtil.class, callSiteArray[80].callCurrent((GroovyObject)this), (Object)artifactInfo);
        callSiteArray[81].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((File)ScriptBytecodeAdapter.castToType((Object)pomFile, File.class)), File.class), callSiteArray[82].callGroovyObjectGetProperty((Object)artifactInfo), callSiteArray[83].callGroovyObjectGetProperty((Object)artifactInfo));
    }

    protected void addLicensesFromPom(File pomFile, String group, String name) {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)pomFile, null) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[84].call((Object)pomFile))) {
                callSiteArray[85].call(logger, (Object)new GStringImpl(new Object[]{pomFile, group, name}, new String[]{"POM file ", " for ", ":", " does not exist."}));
                return;
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)pomFile, null) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[86].call((Object)pomFile))) {
            callSiteArray[87].call(logger, (Object)new GStringImpl(new Object[]{pomFile, group, name}, new String[]{"POM file ", " for ", ":", " does not exist."}));
            return;
        }
        Object rootNode = callSiteArray[88].call(callSiteArray[89].callConstructor(XmlSlurper.class), (Object)pomFile);
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[90].call(callSiteArray[91].callGetProperty(rootNode)), (Object)0)) {
            return;
        }
        Reference libraryName = new Reference((Object)ShortTypeHandling.castToString((Object)callSiteArray[92].callGetProperty(rootNode)));
        Reference licenseKey = new Reference((Object)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{group, name}, new String[]{"", ":", ""})));
        if (ScriptBytecodeAdapter.compareEqual((Object)((String)libraryName.get()), null) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[93].call((Object)((String)libraryName.get())))) {
            String string = (String)licenseKey.get();
            libraryName.set((Object)string);
        }
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[94].call(callSiteArray[95].callGetProperty(callSiteArray[96].callGetProperty(rootNode))), (Object)1)) {
            public final class _addLicensesFromPom_closure5
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference licenseKey;
                private /* synthetic */ Reference libraryName;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _addLicensesFromPom_closure5(Object _outerInstance, Object _thisObject, Reference licenseKey, Reference libraryName) {
                    Reference reference;
                    Reference reference2;
                    CallSite[] callSiteArray = _addLicensesFromPom_closure5.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.licenseKey = reference2 = licenseKey;
                    this.libraryName = reference = libraryName;
                }

                public Object doCall(Object license) {
                    CallSite[] callSiteArray = _addLicensesFromPom_closure5.$getCallSiteArray();
                    String licenseName = ShortTypeHandling.castToString((Object)callSiteArray[0].callGetProperty(license));
                    String licenseUrl = ShortTypeHandling.castToString((Object)callSiteArray[1].callGetProperty(license));
                    return callSiteArray[2].callCurrent((GroovyObject)this, callSiteArray[3].callConstructor(Dependency.class, (Object)new GStringImpl(new Object[]{this.licenseKey.get(), licenseName}, new String[]{"", " ", ""}), this.libraryName.get()), callSiteArray[4].call((Object)licenseUrl, callSiteArray[5].callGetProperty(LicensesTask.class)));
                }

                @Generated
                public String getLicenseKey() {
                    CallSite[] callSiteArray = _addLicensesFromPom_closure5.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.licenseKey.get());
                }

                @Generated
                public String getLibraryName() {
                    CallSite[] callSiteArray = _addLicensesFromPom_closure5.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.libraryName.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _addLicensesFromPom_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "name";
                    stringArray[1] = "url";
                    stringArray[2] = "appendDependency";
                    stringArray[3] = "<$constructor$>";
                    stringArray[4] = "getBytes";
                    stringArray[5] = "UTF_8";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[6];
                    _addLicensesFromPom_closure5.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_addLicensesFromPom_closure5.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _addLicensesFromPom_closure5.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[97].call(callSiteArray[98].callGetProperty(callSiteArray[99].callGetProperty(rootNode)), (Object)new _addLicensesFromPom_closure5((Object)this, (Object)this, licenseKey, libraryName));
        } else {
            String nodeUrl = ShortTypeHandling.castToString((Object)callSiteArray[100].callGetProperty(callSiteArray[101].callGetProperty(callSiteArray[102].callGetProperty(rootNode))));
            callSiteArray[103].callCurrent((GroovyObject)this, callSiteArray[104].callConstructor(Dependency.class, (Object)((String)licenseKey.get()), (Object)((String)libraryName.get())), callSiteArray[105].call((Object)nodeUrl, (Object)UTF_8));
        }
    }

    protected void appendDependency(String key, byte ... license) {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        callSiteArray[106].callCurrent((GroovyObject)this, callSiteArray[107].callConstructor(Dependency.class, (Object)key, (Object)key), (Object)license);
    }

    protected void appendDependency(Dependency dependency, byte ... license) {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        String licenseText = ShortTypeHandling.castToString((Object)callSiteArray[108].callConstructor(String.class, (Object)license, (Object)UTF_8));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[109].call(this.licensesMap, callSiteArray[110].callGroovyObjectGetProperty((Object)dependency)))) {
            return;
        }
        String offsets = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[111].call(this.licenseOffsets, (Object)licenseText))) {
            Object object = callSiteArray[112].call(this.licenseOffsets, (Object)licenseText);
            offsets = ShortTypeHandling.castToString((Object)object);
        } else {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{this.start, callSiteArray[113].callGetProperty((Object)license)}, new String[]{"", ":", ""});
            offsets = ShortTypeHandling.castToString((Object)gStringImpl);
            callSiteArray[114].call(this.licenseOffsets, (Object)licenseText, (Object)offsets);
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                callSiteArray[115].callCurrent((GroovyObject)this, (Object)license);
            } else {
                this.appendLicenseContent(license);
            }
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                callSiteArray[116].callCurrent((GroovyObject)this, (Object)LINE_SEPARATOR);
            } else {
                this.appendLicenseContent(LINE_SEPARATOR);
            }
        }
        callSiteArray[117].call(this.licensesMap, callSiteArray[118].callGroovyObjectGetProperty((Object)dependency), callSiteArray[119].call((Object)dependency, (Object)offsets));
    }

    protected void appendLicenseContent(byte ... content) {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        callSiteArray[120].call((Object)this.licenses, (Object)content);
        this.start = DefaultTypeTransformation.intUnbox((Object)callSiteArray[121].call((Object)this.start, callSiteArray[122].callGetProperty((Object)content)));
    }

    protected void writeMetadata() {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        Object entry = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[123].call(this.licensesMap), Iterator.class);
        while (iterator.hasNext()) {
            entry = iterator.next();
            callSiteArray[124].call((Object)this.licensesMetadata, callSiteArray[125].callGetProperty(entry), (Object)UTF_8);
            callSiteArray[126].call((Object)this.licensesMetadata, (Object)LINE_SEPARATOR);
        }
    }

    public static ArtifactInfo artifactInfoFromEntry(Object entry) {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        return (ArtifactInfo)ScriptBytecodeAdapter.castToType((Object)callSiteArray[127].callConstructor(ArtifactInfo.class, callSiteArray[128].callGetProperty(entry), callSiteArray[129].callGetProperty(entry), callSiteArray[130].callGetProperty(entry)), ArtifactInfo.class);
    }

    public /* synthetic */ Object this$dist$invoke$3(String name, Object args) {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(LicensesTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$3(String name, Object value) {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, LicensesTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$3(String name) {
        CallSite[] callSiteArray = LicensesTask.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(LicensesTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != LicensesTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    static {
        Object object;
        Object object2 = LicensesTask.$getCallSiteArray()[131].call(LicensesTask.$getCallSiteArray()[132].call(System.class, (Object)"line.separator"), (Object)UTF_8);
        LINE_SEPARATOR = (byte[])ScriptBytecodeAdapter.castToType((Object)object2, byte[].class);
        logger = object = LicensesTask.$getCallSiteArray()[133].call(LoggerFactory.class, LicensesTask.class);
    }

    @Generated
    public File getRawResourceDir() {
        return this.rawResourceDir;
    }

    @Generated
    public void setRawResourceDir(File file) {
        this.rawResourceDir = file;
    }

    @Generated
    public File getLicenses() {
        return this.licenses;
    }

    @Generated
    public void setLicenses(File file) {
        this.licenses = file;
    }

    @Generated
    public File getLicensesMetadata() {
        return this.licensesMetadata;
    }

    @Generated
    public void setLicensesMetadata(File file) {
        this.licensesMetadata = file;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "initOutputDir";
        stringArray[1] = "initLicenseFile";
        stringArray[2] = "initLicensesMetadata";
        stringArray[3] = "get";
        stringArray[4] = "asFile";
        stringArray[5] = "dependenciesJson";
        stringArray[6] = "loadDependenciesJson";
        stringArray[7] = "ABSENT_ARTIFACT";
        stringArray[8] = "size";
        stringArray[9] = "<$constructor$>";
        stringArray[10] = "addDebugLicense";
        stringArray[11] = "iterator";
        stringArray[12] = "isGoogleServices";
        stringArray[13] = "group";
        stringArray[14] = "endsWith";
        stringArray[15] = "name";
        stringArray[16] = "addLicensesFromPom";
        stringArray[17] = "isGranularVersion";
        stringArray[18] = "version";
        stringArray[19] = "endsWith";
        stringArray[20] = "name";
        stringArray[21] = "addGooglePlayServiceLicenses";
        stringArray[22] = "addLicensesFromPom";
        stringArray[23] = "writeMetadata";
        stringArray[24] = "parse";
        stringArray[25] = "<$constructor$>";
        stringArray[26] = "<$constructor$>";
        stringArray[27] = "iterator";
        stringArray[28] = "artifactInfoFromEntry";
        stringArray[29] = "add";
        stringArray[30] = "asImmutable";
        stringArray[31] = "appendDependency";
        stringArray[32] = "getBytes";
        stringArray[33] = "exists";
        stringArray[34] = "mkdirs";
        stringArray[35] = "error";
        stringArray[36] = "withWriter";
        stringArray[37] = "newWriter";
        stringArray[38] = "withWriter";
        stringArray[39] = "newWriter";
        stringArray[40] = "equalsIgnoreCase";
        stringArray[41] = "equalsIgnoreCase";
        stringArray[42] = "split";
        stringArray[43] = "length";
        stringArray[44] = "valueOf";
        stringArray[45] = "getAt";
        stringArray[46] = "length";
        stringArray[47] = "valueOf";
        stringArray[48] = "getLibraryFile";
        stringArray[49] = "getProject";
        stringArray[50] = "warn";
        stringArray[51] = "addGooglePlayServiceLicenses";
        stringArray[52] = "<$constructor$>";
        stringArray[53] = "getEntry";
        stringArray[54] = "getEntry";
        stringArray[55] = "<$constructor$>";
        stringArray[56] = "withCloseable";
        stringArray[57] = "getInputStream";
        stringArray[58] = "iterator";
        stringArray[59] = "key";
        stringArray[60] = "start";
        stringArray[61] = "value";
        stringArray[62] = "length";
        stringArray[63] = "value";
        stringArray[64] = "contains";
        stringArray[65] = "withCloseable";
        stringArray[66] = "getInputStream";
        stringArray[67] = "<$constructor$>";
        stringArray[68] = "skip";
        stringArray[69] = "MAX_VALUE";
        stringArray[70] = "MAX_VALUE";
        stringArray[71] = "read";
        stringArray[72] = "min";
        stringArray[73] = "length";
        stringArray[74] = "write";
        stringArray[75] = "minus";
        stringArray[76] = "close";
        stringArray[77] = "toByteArray";
        stringArray[78] = "<$constructor$>";
        stringArray[79] = "resolvePomFileArtifact";
        stringArray[80] = "getProject";
        stringArray[81] = "addLicensesFromPom";
        stringArray[82] = "group";
        stringArray[83] = "name";
        stringArray[84] = "exists";
        stringArray[85] = "error";
        stringArray[86] = "exists";
        stringArray[87] = "error";
        stringArray[88] = "parse";
        stringArray[89] = "<$constructor$>";
        stringArray[90] = "size";
        stringArray[91] = "licenses";
        stringArray[92] = "name";
        stringArray[93] = "isBlank";
        stringArray[94] = "size";
        stringArray[95] = "license";
        stringArray[96] = "licenses";
        stringArray[97] = "each";
        stringArray[98] = "license";
        stringArray[99] = "licenses";
        stringArray[100] = "url";
        stringArray[101] = "license";
        stringArray[102] = "licenses";
        stringArray[103] = "appendDependency";
        stringArray[104] = "<$constructor$>";
        stringArray[105] = "getBytes";
        stringArray[106] = "appendDependency";
        stringArray[107] = "<$constructor$>";
        stringArray[108] = "<$constructor$>";
        stringArray[109] = "containsKey";
        stringArray[110] = "key";
        stringArray[111] = "containsKey";
        stringArray[112] = "get";
        stringArray[113] = "length";
        stringArray[114] = "put";
        stringArray[115] = "appendLicenseContent";
        stringArray[116] = "appendLicenseContent";
        stringArray[117] = "put";
        stringArray[118] = "key";
        stringArray[119] = "buildLicensesMetadata";
        stringArray[120] = "append";
        stringArray[121] = "plus";
        stringArray[122] = "length";
        stringArray[123] = "iterator";
        stringArray[124] = "append";
        stringArray[125] = "value";
        stringArray[126] = "append";
        stringArray[127] = "<$constructor$>";
        stringArray[128] = "group";
        stringArray[129] = "name";
        stringArray[130] = "version";
        stringArray[131] = "getBytes";
        stringArray[132] = "getProperty";
        stringArray[133] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[134];
        LicensesTask.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(LicensesTask.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = LicensesTask.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public static class Dependency
    implements GroovyObject {
        private String key;
        private String name;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ SoftReference $callSiteArray;

        public Dependency(String key, String name) {
            MetaClass metaClass;
            CallSite[] callSiteArray = Dependency.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            String string = key;
            this.key = ShortTypeHandling.castToString((Object)string);
            String string2 = name;
            this.name = ShortTypeHandling.castToString((Object)string2);
        }

        public String buildLicensesMetadata(String offset) {
            CallSite[] callSiteArray = Dependency.$getCallSiteArray();
            return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{offset, this.name}, new String[]{"", " ", ""}));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = Dependency.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(Dependency.class, LicensesTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = Dependency.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(Dependency.class, LicensesTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = Dependency.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, LicensesTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = Dependency.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, LicensesTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = Dependency.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(Dependency.class, LicensesTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = Dependency.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(Dependency.class, LicensesTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != Dependency.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public void setKey(String string) {
            this.key = string;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setName(String string) {
            this.name = string;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(Dependency.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = Dependency.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

