/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.flexbox;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.v4.view.MarginLayoutParamsCompat;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.flexbox.FlexLine;
import com.google.android.flexbox.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class FlexboxLayout
extends ViewGroup {
    public static final int FLEX_DIRECTION_ROW = 0;
    public static final int FLEX_DIRECTION_ROW_REVERSE = 1;
    public static final int FLEX_DIRECTION_COLUMN = 2;
    public static final int FLEX_DIRECTION_COLUMN_REVERSE = 3;
    private int mFlexDirection;
    public static final int FLEX_WRAP_NOWRAP = 0;
    public static final int FLEX_WRAP_WRAP = 1;
    public static final int FLEX_WRAP_WRAP_REVERSE = 2;
    private int mFlexWrap;
    public static final int JUSTIFY_CONTENT_FLEX_START = 0;
    public static final int JUSTIFY_CONTENT_FLEX_END = 1;
    public static final int JUSTIFY_CONTENT_CENTER = 2;
    public static final int JUSTIFY_CONTENT_SPACE_BETWEEN = 3;
    public static final int JUSTIFY_CONTENT_SPACE_AROUND = 4;
    private int mJustifyContent;
    public static final int ALIGN_ITEMS_FLEX_START = 0;
    public static final int ALIGN_ITEMS_FLEX_END = 1;
    public static final int ALIGN_ITEMS_CENTER = 2;
    public static final int ALIGN_ITEMS_BASELINE = 3;
    public static final int ALIGN_ITEMS_STRETCH = 4;
    private int mAlignItems;
    public static final int ALIGN_CONTENT_FLEX_START = 0;
    public static final int ALIGN_CONTENT_FLEX_END = 1;
    public static final int ALIGN_CONTENT_CENTER = 2;
    public static final int ALIGN_CONTENT_SPACE_BETWEEN = 3;
    public static final int ALIGN_CONTENT_SPACE_AROUND = 4;
    public static final int ALIGN_CONTENT_STRETCH = 5;
    private int mAlignContent;
    public static final int SHOW_DIVIDER_NONE = 0;
    public static final int SHOW_DIVIDER_BEGINNING = 1;
    public static final int SHOW_DIVIDER_MIDDLE = 2;
    public static final int SHOW_DIVIDER_END = 4;
    private Drawable mDividerDrawableHorizontal;
    private Drawable mDividerDrawableVertical;
    private int mShowDividerHorizontal;
    private int mShowDividerVertical;
    private int mDividerHorizontalHeight;
    private int mDividerVerticalWidth;
    private int[] mReorderedIndices;
    private SparseIntArray mOrderCache;
    private List<FlexLine> mFlexLines = new ArrayList<FlexLine>();
    private boolean[] mChildrenFrozen;

    public FlexboxLayout(Context context) {
        this(context, null);
    }

    public FlexboxLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FlexboxLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        int dividerModeHorizontal;
        int dividerModeVertical;
        int dividerMode;
        Drawable drawableVertical;
        Drawable drawableHorizontal;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FlexboxLayout, defStyleAttr, 0);
        this.mFlexDirection = a.getInt(R.styleable.FlexboxLayout_flexDirection, 0);
        this.mFlexWrap = a.getInt(R.styleable.FlexboxLayout_flexWrap, 0);
        this.mJustifyContent = a.getInt(R.styleable.FlexboxLayout_justifyContent, 0);
        this.mAlignItems = a.getInt(R.styleable.FlexboxLayout_alignItems, 4);
        this.mAlignContent = a.getInt(R.styleable.FlexboxLayout_alignContent, 5);
        Drawable drawable = a.getDrawable(R.styleable.FlexboxLayout_dividerDrawable);
        if (drawable != null) {
            this.setDividerDrawableHorizontal(drawable);
            this.setDividerDrawableVertical(drawable);
        }
        if ((drawableHorizontal = a.getDrawable(R.styleable.FlexboxLayout_dividerDrawableHorizontal)) != null) {
            this.setDividerDrawableHorizontal(drawableHorizontal);
        }
        if ((drawableVertical = a.getDrawable(R.styleable.FlexboxLayout_dividerDrawableVertical)) != null) {
            this.setDividerDrawableVertical(drawableVertical);
        }
        if ((dividerMode = a.getInt(R.styleable.FlexboxLayout_showDivider, 0)) != 0) {
            this.mShowDividerVertical = dividerMode;
            this.mShowDividerHorizontal = dividerMode;
        }
        if ((dividerModeVertical = a.getInt(R.styleable.FlexboxLayout_showDividerVertical, 0)) != 0) {
            this.mShowDividerVertical = dividerModeVertical;
        }
        if ((dividerModeHorizontal = a.getInt(R.styleable.FlexboxLayout_showDividerHorizontal, 0)) != 0) {
            this.mShowDividerHorizontal = dividerModeHorizontal;
        }
        a.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.isOrderChangedFromLastMeasurement()) {
            this.mReorderedIndices = this.createReorderedIndices();
        }
        if (this.mChildrenFrozen == null || this.mChildrenFrozen.length < this.getChildCount()) {
            this.mChildrenFrozen = new boolean[this.getChildCount()];
        }
        switch (this.mFlexDirection) {
            case 0: 
            case 1: {
                this.measureHorizontal(widthMeasureSpec, heightMeasureSpec);
                break;
            }
            case 2: 
            case 3: {
                this.measureVertical(widthMeasureSpec, heightMeasureSpec);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid value for the flex direction is set: " + this.mFlexDirection);
            }
        }
        Arrays.fill(this.mChildrenFrozen, false);
    }

    public View getReorderedChildAt(int index) {
        if (index < 0 || index >= this.mReorderedIndices.length) {
            return null;
        }
        return this.getChildAt(this.mReorderedIndices[index]);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        this.mReorderedIndices = this.createReorderedIndices(child, index, params);
        super.addView(child, index, params);
    }

    private int[] createReorderedIndices(View viewBeforeAdded, int indexForViewBeforeAdded, ViewGroup.LayoutParams paramsForViewBeforeAdded) {
        int childCount = this.getChildCount();
        List<Order> orders = this.createOrders(childCount);
        Order orderForViewToBeAdded = new Order();
        orderForViewToBeAdded.order = viewBeforeAdded != null && paramsForViewBeforeAdded instanceof LayoutParams ? ((LayoutParams)paramsForViewBeforeAdded).order : 1;
        if (indexForViewBeforeAdded == -1 || indexForViewBeforeAdded == childCount) {
            orderForViewToBeAdded.index = childCount;
        } else if (indexForViewBeforeAdded < this.getChildCount()) {
            orderForViewToBeAdded.index = indexForViewBeforeAdded;
            for (int i = indexForViewBeforeAdded; i < childCount; ++i) {
                ++orders.get((int)i).index;
            }
        } else {
            orderForViewToBeAdded.index = childCount;
        }
        orders.add(orderForViewToBeAdded);
        return this.sortOrdersIntoReorderedIndices(childCount + 1, orders);
    }

    private int[] createReorderedIndices() {
        int childCount = this.getChildCount();
        List<Order> orders = this.createOrders(childCount);
        return this.sortOrdersIntoReorderedIndices(childCount, orders);
    }

    private int[] sortOrdersIntoReorderedIndices(int childCount, List<Order> orders) {
        Collections.sort(orders);
        if (this.mOrderCache == null) {
            this.mOrderCache = new SparseIntArray(childCount);
        }
        this.mOrderCache.clear();
        int[] reorderedIndices = new int[childCount];
        int i = 0;
        for (Order order : orders) {
            reorderedIndices[i] = order.index;
            this.mOrderCache.append(i, order.order);
            ++i;
        }
        return reorderedIndices;
    }

    @NonNull
    private List<Order> createOrders(int childCount) {
        ArrayList<Order> orders = new ArrayList<Order>(childCount);
        int i = 0;
        while (i < childCount) {
            View child = this.getChildAt(i);
            LayoutParams params = (LayoutParams)child.getLayoutParams();
            Order order = new Order();
            order.order = params.order;
            order.index = i++;
            orders.add(order);
        }
        return orders;
    }

    private boolean isOrderChangedFromLastMeasurement() {
        int childCount = this.getChildCount();
        if (this.mOrderCache == null) {
            this.mOrderCache = new SparseIntArray(childCount);
        }
        if (this.mOrderCache.size() != childCount) {
            return true;
        }
        for (int i = 0; i < childCount; ++i) {
            View view = this.getChildAt(i);
            if (view == null) continue;
            LayoutParams lp = (LayoutParams)view.getLayoutParams();
            if (lp.order == this.mOrderCache.get(i)) continue;
            return true;
        }
        return false;
    }

    private void measureHorizontal(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int childState = 0;
        this.mFlexLines.clear();
        int childCount = this.getChildCount();
        int paddingStart = ViewCompat.getPaddingStart((View)this);
        int paddingEnd = ViewCompat.getPaddingEnd((View)this);
        int largestHeightInRow = Integer.MIN_VALUE;
        FlexLine flexLine = new FlexLine();
        int indexInFlexLine = 0;
        flexLine.mMainSize = paddingStart + paddingEnd;
        for (int i = 0; i < childCount; ++i) {
            View child = this.getReorderedChildAt(i);
            if (child == null) {
                this.addFlexLineIfLastFlexItem(i, childCount, flexLine);
                continue;
            }
            if (child.getVisibility() == 8) {
                ++flexLine.mItemCount;
                this.addFlexLineIfLastFlexItem(i, childCount, flexLine);
                continue;
            }
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.alignSelf == 4) {
                flexLine.mIndicesAlignSelfStretch.add(i);
            }
            int childWidth = lp.width;
            if (lp.flexBasisPercent != -1.0f && widthMode == 0x40000000) {
                childWidth = Math.round((float)widthSize * lp.flexBasisPercent);
            }
            int childWidthMeasureSpec = FlexboxLayout.getChildMeasureSpec((int)widthMeasureSpec, (int)(this.getPaddingLeft() + this.getPaddingRight() + lp.leftMargin + lp.rightMargin), (int)childWidth);
            int childHeightMeasureSpec = FlexboxLayout.getChildMeasureSpec((int)heightMeasureSpec, (int)(this.getPaddingTop() + this.getPaddingBottom() + lp.topMargin + lp.bottomMargin), (int)lp.height);
            child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            this.checkSizeConstraints(child);
            childState = ViewCompat.combineMeasuredStates((int)childState, (int)ViewCompat.getMeasuredState((View)child));
            largestHeightInRow = Math.max(largestHeightInRow, child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
            if (this.isWrapRequired(widthMode, widthSize, flexLine.mMainSize, child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin, lp, i, indexInFlexLine)) {
                if (flexLine.mItemCount > 0) {
                    this.addFlexLine(flexLine);
                }
                flexLine = new FlexLine();
                flexLine.mItemCount = 1;
                flexLine.mMainSize = paddingStart + paddingEnd;
                largestHeightInRow = child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin;
                indexInFlexLine = 0;
            } else {
                ++flexLine.mItemCount;
                ++indexInFlexLine;
            }
            flexLine.mMainSize += child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin;
            flexLine.mTotalFlexGrow += lp.flexGrow;
            flexLine.mTotalFlexShrink += lp.flexShrink;
            flexLine.mCrossSize = Math.max(flexLine.mCrossSize, largestHeightInRow);
            if (this.hasDividerBeforeChildAtAlongMainAxis(i, indexInFlexLine)) {
                flexLine.mMainSize += this.mDividerVerticalWidth;
                flexLine.mDividerLengthInMainSize += this.mDividerVerticalWidth;
            }
            flexLine.mMaxBaseline = this.mFlexWrap != 2 ? Math.max(flexLine.mMaxBaseline, child.getBaseline() + lp.topMargin) : Math.max(flexLine.mMaxBaseline, child.getMeasuredHeight() - child.getBaseline() + lp.bottomMargin);
            this.addFlexLineIfLastFlexItem(i, childCount, flexLine);
        }
        this.determineMainSize(this.mFlexDirection, widthMeasureSpec, heightMeasureSpec);
        if (this.mAlignItems == 3) {
            int viewIndex = 0;
            for (FlexLine flexLine2 : this.mFlexLines) {
                int largestHeightInLine = Integer.MIN_VALUE;
                for (int i = viewIndex; i < viewIndex + flexLine2.mItemCount; ++i) {
                    View child = this.getReorderedChildAt(i);
                    LayoutParams lp = (LayoutParams)child.getLayoutParams();
                    if (this.mFlexWrap != 2) {
                        int marginTop = flexLine2.mMaxBaseline - child.getBaseline();
                        marginTop = Math.max(marginTop, lp.topMargin);
                        largestHeightInLine = Math.max(largestHeightInLine, child.getHeight() + marginTop + lp.bottomMargin);
                        continue;
                    }
                    int marginBottom = flexLine2.mMaxBaseline - child.getMeasuredHeight() + child.getBaseline();
                    marginBottom = Math.max(marginBottom, lp.bottomMargin);
                    largestHeightInLine = Math.max(largestHeightInLine, child.getHeight() + lp.topMargin + marginBottom);
                }
                flexLine2.mCrossSize = largestHeightInLine;
                viewIndex += flexLine2.mItemCount;
            }
        }
        this.determineCrossSize(this.mFlexDirection, widthMeasureSpec, heightMeasureSpec, this.getPaddingTop() + this.getPaddingBottom());
        this.stretchViews(this.mFlexDirection, this.mAlignItems);
        this.setMeasuredDimensionForFlex(this.mFlexDirection, widthMeasureSpec, heightMeasureSpec, childState);
    }

    private void measureVertical(int widthMeasureSpec, int heightMeasureSpec) {
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int childState = 0;
        this.mFlexLines.clear();
        int childCount = this.getChildCount();
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        int largestWidthInColumn = Integer.MIN_VALUE;
        FlexLine flexLine = new FlexLine();
        flexLine.mMainSize = paddingTop + paddingBottom;
        int indexInFlexLine = 0;
        for (int i = 0; i < childCount; ++i) {
            View child = this.getReorderedChildAt(i);
            if (child == null) {
                this.addFlexLineIfLastFlexItem(i, childCount, flexLine);
                continue;
            }
            if (child.getVisibility() == 8) {
                ++flexLine.mItemCount;
                this.addFlexLineIfLastFlexItem(i, childCount, flexLine);
                continue;
            }
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.alignSelf == 4) {
                flexLine.mIndicesAlignSelfStretch.add(i);
            }
            int childHeight = lp.height;
            if (lp.flexBasisPercent != -1.0f && heightMode == 0x40000000) {
                childHeight = Math.round((float)heightSize * lp.flexBasisPercent);
            }
            int childWidthMeasureSpec = FlexboxLayout.getChildMeasureSpec((int)widthMeasureSpec, (int)(this.getPaddingLeft() + this.getPaddingRight() + lp.leftMargin + lp.rightMargin), (int)lp.width);
            int childHeightMeasureSpec = FlexboxLayout.getChildMeasureSpec((int)heightMeasureSpec, (int)(this.getPaddingTop() + this.getPaddingBottom() + lp.topMargin + lp.bottomMargin), (int)childHeight);
            child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            this.checkSizeConstraints(child);
            childState = ViewCompat.combineMeasuredStates((int)childState, (int)ViewCompat.getMeasuredState((View)child));
            largestWidthInColumn = Math.max(largestWidthInColumn, child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin);
            if (this.isWrapRequired(heightMode, heightSize, flexLine.mMainSize, child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin, lp, i, indexInFlexLine)) {
                if (flexLine.mItemCount > 0) {
                    this.addFlexLine(flexLine);
                }
                flexLine = new FlexLine();
                flexLine.mItemCount = 1;
                flexLine.mMainSize = paddingTop + paddingBottom;
                largestWidthInColumn = child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin;
                indexInFlexLine = 0;
            } else {
                ++flexLine.mItemCount;
                ++indexInFlexLine;
            }
            flexLine.mMainSize += child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin;
            flexLine.mTotalFlexGrow += lp.flexGrow;
            flexLine.mTotalFlexShrink += lp.flexShrink;
            flexLine.mCrossSize = Math.max(flexLine.mCrossSize, largestWidthInColumn);
            if (this.hasDividerBeforeChildAtAlongMainAxis(i, indexInFlexLine)) {
                flexLine.mMainSize += this.mDividerHorizontalHeight;
            }
            this.addFlexLineIfLastFlexItem(i, childCount, flexLine);
        }
        this.determineMainSize(this.mFlexDirection, widthMeasureSpec, heightMeasureSpec);
        this.determineCrossSize(this.mFlexDirection, widthMeasureSpec, heightMeasureSpec, this.getPaddingLeft() + this.getPaddingRight());
        this.stretchViews(this.mFlexDirection, this.mAlignItems);
        this.setMeasuredDimensionForFlex(this.mFlexDirection, widthMeasureSpec, heightMeasureSpec, childState);
    }

    private void checkSizeConstraints(View view) {
        boolean needsMeasure = false;
        LayoutParams lp = (LayoutParams)view.getLayoutParams();
        int childWidth = view.getMeasuredWidth();
        int childHeight = view.getMeasuredHeight();
        if (view.getMeasuredWidth() < lp.minWidth) {
            needsMeasure = true;
            childWidth = lp.minWidth;
        } else if (view.getMeasuredWidth() > lp.maxWidth) {
            needsMeasure = true;
            childWidth = lp.maxWidth;
        }
        if (childHeight < lp.minHeight) {
            needsMeasure = true;
            childHeight = lp.minHeight;
        } else if (childHeight > lp.maxHeight) {
            needsMeasure = true;
            childHeight = lp.maxHeight;
        }
        if (needsMeasure) {
            view.measure(View.MeasureSpec.makeMeasureSpec((int)childWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)childHeight, (int)0x40000000));
        }
    }

    private void addFlexLineIfLastFlexItem(int childIndex, int childCount, FlexLine flexLine) {
        if (childIndex == childCount - 1 && flexLine.mItemCount != 0) {
            this.addFlexLine(flexLine);
        }
    }

    private void addFlexLine(FlexLine flexLine) {
        if (this.isMainAxisDirectionHorizontal(this.mFlexDirection)) {
            if ((this.mShowDividerVertical & 4) > 0) {
                flexLine.mMainSize += this.mDividerVerticalWidth;
                flexLine.mDividerLengthInMainSize += this.mDividerVerticalWidth;
            }
        } else if ((this.mShowDividerHorizontal & 4) > 0) {
            flexLine.mMainSize += this.mDividerHorizontalHeight;
            flexLine.mDividerLengthInMainSize += this.mDividerHorizontalHeight;
        }
        this.mFlexLines.add(flexLine);
    }

    private void determineMainSize(int flexDirection, int widthMeasureSpec, int heightMeasureSpec) {
        int paddingAlongMainAxis;
        int mainSize;
        switch (flexDirection) {
            case 0: 
            case 1: {
                int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
                int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
                mainSize = widthMode == 0x40000000 ? widthSize : this.getLargestMainSize();
                paddingAlongMainAxis = this.getPaddingLeft() + this.getPaddingRight();
                break;
            }
            case 2: 
            case 3: {
                int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
                int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
                mainSize = heightMode == 0x40000000 ? heightSize : this.getLargestMainSize();
                paddingAlongMainAxis = this.getPaddingTop() + this.getPaddingBottom();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid flex direction: " + flexDirection);
            }
        }
        int childIndex = 0;
        for (FlexLine flexLine : this.mFlexLines) {
            if (flexLine.mMainSize < mainSize) {
                childIndex = this.expandFlexItems(widthMeasureSpec, heightMeasureSpec, flexLine, flexDirection, mainSize, paddingAlongMainAxis, childIndex, false);
                continue;
            }
            childIndex = this.shrinkFlexItems(widthMeasureSpec, heightMeasureSpec, flexLine, flexDirection, mainSize, paddingAlongMainAxis, childIndex, false);
        }
    }

    private int expandFlexItems(int widthMeasureSpec, int heightMeasureSpec, FlexLine flexLine, int flexDirection, int maxMainSize, int paddingAlongMainAxis, int startIndex, boolean calledRecursively) {
        int childIndex = startIndex;
        if (flexLine.mTotalFlexGrow <= 0.0f || maxMainSize < flexLine.mMainSize) {
            return childIndex += flexLine.mItemCount;
        }
        int sizeBeforeExpand = flexLine.mMainSize;
        boolean needsReexpand = false;
        float unitSpace = (float)(maxMainSize - flexLine.mMainSize) / flexLine.mTotalFlexGrow;
        flexLine.mMainSize = paddingAlongMainAxis + flexLine.mDividerLengthInMainSize;
        if (!calledRecursively) {
            flexLine.mCrossSize = Integer.MIN_VALUE;
        }
        int largestCrossSize = 0;
        float accumulatedRoundError = 0.0f;
        for (int i = 0; i < flexLine.mItemCount; ++i) {
            View child = this.getReorderedChildAt(childIndex);
            if (child == null) continue;
            if (child.getVisibility() == 8) {
                ++childIndex;
                continue;
            }
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (this.isMainAxisDirectionHorizontal(flexDirection)) {
                if (!this.mChildrenFrozen[childIndex]) {
                    int newWidth;
                    float rawCalculatedWidth = (float)child.getMeasuredWidth() + unitSpace * lp.flexGrow;
                    if (i == flexLine.mItemCount - 1) {
                        rawCalculatedWidth += accumulatedRoundError;
                        accumulatedRoundError = 0.0f;
                    }
                    if ((newWidth = Math.round(rawCalculatedWidth)) > lp.maxWidth) {
                        needsReexpand = true;
                        newWidth = lp.maxWidth;
                        this.mChildrenFrozen[childIndex] = true;
                        flexLine.mTotalFlexGrow -= lp.flexGrow;
                    } else if ((double)(accumulatedRoundError += rawCalculatedWidth - (float)newWidth) > 1.0) {
                        ++newWidth;
                        accumulatedRoundError = (float)((double)accumulatedRoundError - 1.0);
                    } else if ((double)accumulatedRoundError < -1.0) {
                        --newWidth;
                        accumulatedRoundError = (float)((double)accumulatedRoundError + 1.0);
                    }
                    int childHeightMeasureSpec = this.getChildHeightMeasureSpec(heightMeasureSpec, lp);
                    child.measure(View.MeasureSpec.makeMeasureSpec((int)newWidth, (int)0x40000000), childHeightMeasureSpec);
                    largestCrossSize = Math.max(largestCrossSize, child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
                }
                flexLine.mMainSize += child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin;
            } else {
                if (!this.mChildrenFrozen[childIndex]) {
                    int newHeight;
                    float rawCalculatedHeight = (float)child.getMeasuredHeight() + unitSpace * lp.flexGrow;
                    if (i == flexLine.mItemCount - 1) {
                        rawCalculatedHeight += accumulatedRoundError;
                        accumulatedRoundError = 0.0f;
                    }
                    if ((newHeight = Math.round(rawCalculatedHeight)) > lp.maxHeight) {
                        needsReexpand = true;
                        newHeight = lp.maxHeight;
                        this.mChildrenFrozen[childIndex] = true;
                        flexLine.mTotalFlexGrow -= lp.flexGrow;
                    } else if ((double)(accumulatedRoundError += rawCalculatedHeight - (float)newHeight) > 1.0) {
                        ++newHeight;
                        accumulatedRoundError = (float)((double)accumulatedRoundError - 1.0);
                    } else if ((double)accumulatedRoundError < -1.0) {
                        --newHeight;
                        accumulatedRoundError = (float)((double)accumulatedRoundError + 1.0);
                    }
                    int childWidthMeasureSpec = this.getChildWidthMeasureSpec(widthMeasureSpec, lp);
                    child.measure(childWidthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)newHeight, (int)0x40000000));
                    largestCrossSize = Math.max(largestCrossSize, child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin);
                }
                flexLine.mMainSize += child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin;
            }
            flexLine.mCrossSize = Math.max(flexLine.mCrossSize, largestCrossSize);
            ++childIndex;
        }
        if (needsReexpand && sizeBeforeExpand != flexLine.mMainSize) {
            this.expandFlexItems(widthMeasureSpec, heightMeasureSpec, flexLine, flexDirection, maxMainSize, paddingAlongMainAxis, startIndex, true);
        }
        return childIndex;
    }

    private int shrinkFlexItems(int widthMeasureSpec, int heightMeasureSpec, FlexLine flexLine, int flexDirection, int maxMainSize, int paddingAlongMainAxis, int startIndex, boolean calledRecursively) {
        int childIndex = startIndex;
        int sizeBeforeShrink = flexLine.mMainSize;
        if (flexLine.mTotalFlexShrink <= 0.0f || maxMainSize > flexLine.mMainSize) {
            return childIndex += flexLine.mItemCount;
        }
        boolean needsReshrink = false;
        float unitShrink = (float)(flexLine.mMainSize - maxMainSize) / flexLine.mTotalFlexShrink;
        float accumulatedRoundError = 0.0f;
        flexLine.mMainSize = paddingAlongMainAxis + flexLine.mDividerLengthInMainSize;
        int largestCrossSize = 0;
        if (!calledRecursively) {
            flexLine.mCrossSize = Integer.MIN_VALUE;
        }
        for (int i = 0; i < flexLine.mItemCount; ++i) {
            View child = this.getReorderedChildAt(childIndex);
            if (child == null) continue;
            if (child.getVisibility() == 8) {
                ++childIndex;
                continue;
            }
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (this.isMainAxisDirectionHorizontal(flexDirection)) {
                if (!this.mChildrenFrozen[childIndex]) {
                    int newWidth;
                    float rawCalculatedWidth = (float)child.getMeasuredWidth() - unitShrink * lp.flexShrink;
                    if (i == flexLine.mItemCount - 1) {
                        rawCalculatedWidth += accumulatedRoundError;
                        accumulatedRoundError = 0.0f;
                    }
                    if ((newWidth = Math.round(rawCalculatedWidth)) < lp.minWidth) {
                        needsReshrink = true;
                        newWidth = lp.minWidth;
                        this.mChildrenFrozen[childIndex] = true;
                        flexLine.mTotalFlexShrink -= lp.flexShrink;
                    } else if ((double)(accumulatedRoundError += rawCalculatedWidth - (float)newWidth) > 1.0) {
                        ++newWidth;
                        accumulatedRoundError -= 1.0f;
                    } else if ((double)accumulatedRoundError < -1.0) {
                        --newWidth;
                        accumulatedRoundError += 1.0f;
                    }
                    int childHeightMeasureSpec = this.getChildHeightMeasureSpec(heightMeasureSpec, lp);
                    child.measure(View.MeasureSpec.makeMeasureSpec((int)newWidth, (int)0x40000000), childHeightMeasureSpec);
                    largestCrossSize = Math.max(largestCrossSize, child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
                }
                flexLine.mMainSize += child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin;
            } else {
                if (!this.mChildrenFrozen[childIndex]) {
                    int newHeight;
                    float rawCalculatedHeight = (float)child.getMeasuredHeight() - unitShrink * lp.flexShrink;
                    if (i == flexLine.mItemCount - 1) {
                        rawCalculatedHeight += accumulatedRoundError;
                        accumulatedRoundError = 0.0f;
                    }
                    if ((newHeight = Math.round(rawCalculatedHeight)) < lp.minHeight) {
                        needsReshrink = true;
                        newHeight = lp.minHeight;
                        this.mChildrenFrozen[childIndex] = true;
                        flexLine.mTotalFlexShrink -= lp.flexShrink;
                    } else if ((double)(accumulatedRoundError += rawCalculatedHeight - (float)newHeight) > 1.0) {
                        ++newHeight;
                        accumulatedRoundError -= 1.0f;
                    } else if ((double)accumulatedRoundError < -1.0) {
                        --newHeight;
                        accumulatedRoundError += 1.0f;
                    }
                    int childWidthMeasureSpec = this.getChildWidthMeasureSpec(widthMeasureSpec, lp);
                    child.measure(childWidthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)newHeight, (int)0x40000000));
                    largestCrossSize = Math.max(largestCrossSize, child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin);
                }
                flexLine.mMainSize += child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin;
            }
            flexLine.mCrossSize = Math.max(flexLine.mCrossSize, largestCrossSize);
            ++childIndex;
        }
        if (needsReshrink && sizeBeforeShrink != flexLine.mMainSize) {
            this.shrinkFlexItems(widthMeasureSpec, heightMeasureSpec, flexLine, flexDirection, maxMainSize, paddingAlongMainAxis, startIndex, true);
        }
        return childIndex;
    }

    private int getChildWidthMeasureSpec(int widthMeasureSpec, LayoutParams lp) {
        int childWidthMeasureSpec = FlexboxLayout.getChildMeasureSpec((int)widthMeasureSpec, (int)(this.getPaddingLeft() + this.getPaddingRight() + lp.leftMargin + lp.rightMargin), (int)lp.width);
        int childWidth = View.MeasureSpec.getSize((int)childWidthMeasureSpec);
        if (childWidth > lp.maxWidth) {
            childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)lp.maxWidth, (int)View.MeasureSpec.getMode((int)childWidthMeasureSpec));
        } else if (childWidth < lp.minWidth) {
            childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)lp.minWidth, (int)View.MeasureSpec.getMode((int)childWidthMeasureSpec));
        }
        return childWidthMeasureSpec;
    }

    private int getChildHeightMeasureSpec(int heightMeasureSpec, LayoutParams lp) {
        int childHeightMeasureSpec = FlexboxLayout.getChildMeasureSpec((int)heightMeasureSpec, (int)(this.getPaddingTop() + this.getPaddingBottom() + lp.topMargin + lp.bottomMargin), (int)lp.height);
        int childHeight = View.MeasureSpec.getSize((int)childHeightMeasureSpec);
        if (childHeight > lp.maxHeight) {
            childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)lp.maxHeight, (int)View.MeasureSpec.getMode((int)childHeightMeasureSpec));
        } else if (childHeight < lp.minHeight) {
            childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)lp.minHeight, (int)View.MeasureSpec.getMode((int)childHeightMeasureSpec));
        }
        return childHeightMeasureSpec;
    }

    private void determineCrossSize(int flexDirection, int widthMeasureSpec, int heightMeasureSpec, int paddingAlongCrossAxis) {
        int size;
        int mode;
        switch (flexDirection) {
            case 0: 
            case 1: {
                mode = View.MeasureSpec.getMode((int)heightMeasureSpec);
                size = View.MeasureSpec.getSize((int)heightMeasureSpec);
                break;
            }
            case 2: 
            case 3: {
                mode = View.MeasureSpec.getMode((int)widthMeasureSpec);
                size = View.MeasureSpec.getSize((int)widthMeasureSpec);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid flex direction: " + flexDirection);
            }
        }
        if (mode == 0x40000000) {
            int totalCrossSize = this.getSumOfCrossSize() + paddingAlongCrossAxis;
            if (this.mFlexLines.size() == 1) {
                this.mFlexLines.get((int)0).mCrossSize = size - paddingAlongCrossAxis;
            } else if (this.mFlexLines.size() >= 2 && totalCrossSize < size) {
                switch (this.mAlignContent) {
                    case 5: {
                        float freeSpaceUnit = (float)(size - totalCrossSize) / (float)this.mFlexLines.size();
                        float accumulatedError = 0.0f;
                        int flexLinesSize = this.mFlexLines.size();
                        for (int i = 0; i < flexLinesSize; ++i) {
                            int newCrossSize;
                            FlexLine flexLine = this.mFlexLines.get(i);
                            float newCrossSizeAsFloat = (float)flexLine.mCrossSize + freeSpaceUnit;
                            if (i == this.mFlexLines.size() - 1) {
                                newCrossSizeAsFloat += accumulatedError;
                                accumulatedError = 0.0f;
                            }
                            if ((accumulatedError += newCrossSizeAsFloat - (float)(newCrossSize = Math.round(newCrossSizeAsFloat))) > 1.0f) {
                                accumulatedError -= 1.0f;
                            } else if (accumulatedError < -1.0f) {
                                --newCrossSize;
                                accumulatedError += 1.0f;
                            }
                            flexLine.mCrossSize = ++newCrossSize;
                        }
                        break;
                    }
                    case 4: {
                        int spaceTopAndBottom = size - totalCrossSize;
                        int numberOfSpaces = this.mFlexLines.size() * 2;
                        ArrayList<FlexLine> newFlexLines = new ArrayList<FlexLine>();
                        FlexLine dummySpaceFlexLine = new FlexLine();
                        dummySpaceFlexLine.mCrossSize = spaceTopAndBottom /= numberOfSpaces;
                        for (FlexLine flexLine : this.mFlexLines) {
                            newFlexLines.add(dummySpaceFlexLine);
                            newFlexLines.add(flexLine);
                            newFlexLines.add(dummySpaceFlexLine);
                        }
                        this.mFlexLines = newFlexLines;
                        break;
                    }
                    case 3: {
                        float spaceBetweenFlexLine = size - totalCrossSize;
                        int numberOfSpaces = this.mFlexLines.size() - 1;
                        spaceBetweenFlexLine /= (float)numberOfSpaces;
                        float accumulatedError = 0.0f;
                        ArrayList<FlexLine> newFlexLines = new ArrayList<FlexLine>();
                        int flexLineSize = this.mFlexLines.size();
                        for (int i = 0; i < flexLineSize; ++i) {
                            FlexLine flexLine = this.mFlexLines.get(i);
                            newFlexLines.add(flexLine);
                            if (i == this.mFlexLines.size() - 1) continue;
                            FlexLine dummySpaceFlexLine = new FlexLine();
                            if (i == this.mFlexLines.size() - 2) {
                                dummySpaceFlexLine.mCrossSize = Math.round(spaceBetweenFlexLine + accumulatedError);
                                accumulatedError = 0.0f;
                            } else {
                                dummySpaceFlexLine.mCrossSize = Math.round(spaceBetweenFlexLine);
                            }
                            accumulatedError += spaceBetweenFlexLine - (float)dummySpaceFlexLine.mCrossSize;
                            if (accumulatedError > 1.0f) {
                                ++dummySpaceFlexLine.mCrossSize;
                                accumulatedError -= 1.0f;
                            } else if (accumulatedError < -1.0f) {
                                --dummySpaceFlexLine.mCrossSize;
                                accumulatedError += 1.0f;
                            }
                            newFlexLines.add(dummySpaceFlexLine);
                        }
                        this.mFlexLines = newFlexLines;
                        break;
                    }
                    case 2: {
                        int spaceAboveAndBottom = size - totalCrossSize;
                        ArrayList<FlexLine> newFlexLines = new ArrayList<FlexLine>();
                        FlexLine dummySpaceFlexLine = new FlexLine();
                        dummySpaceFlexLine.mCrossSize = spaceAboveAndBottom /= 2;
                        int flexLineSize = this.mFlexLines.size();
                        for (int i = 0; i < flexLineSize; ++i) {
                            if (i == 0) {
                                newFlexLines.add(dummySpaceFlexLine);
                            }
                            FlexLine flexLine = this.mFlexLines.get(i);
                            newFlexLines.add(flexLine);
                            if (i != this.mFlexLines.size() - 1) continue;
                            newFlexLines.add(dummySpaceFlexLine);
                        }
                        this.mFlexLines = newFlexLines;
                        break;
                    }
                    case 1: {
                        int spaceTop = size - totalCrossSize;
                        FlexLine dummySpaceFlexLine = new FlexLine();
                        dummySpaceFlexLine.mCrossSize = spaceTop;
                        this.mFlexLines.add(0, dummySpaceFlexLine);
                        break;
                    }
                }
            }
        }
    }

    private void stretchViews(int flexDirection, int alignItems) {
        if (alignItems == 4) {
            int viewIndex = 0;
            for (FlexLine flexLine : this.mFlexLines) {
                int i = 0;
                while (i < flexLine.mItemCount) {
                    View view = this.getReorderedChildAt(viewIndex);
                    LayoutParams lp = (LayoutParams)view.getLayoutParams();
                    if (lp.alignSelf == -1 || lp.alignSelf == 4) {
                        switch (flexDirection) {
                            case 0: 
                            case 1: {
                                this.stretchViewVertically(view, flexLine.mCrossSize);
                                break;
                            }
                            case 2: 
                            case 3: {
                                this.stretchViewHorizontally(view, flexLine.mCrossSize);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Invalid flex direction: " + flexDirection);
                            }
                        }
                    }
                    ++i;
                    ++viewIndex;
                }
            }
        } else {
            for (FlexLine flexLine : this.mFlexLines) {
                block11: for (Integer index : flexLine.mIndicesAlignSelfStretch) {
                    View view = this.getReorderedChildAt(index);
                    switch (flexDirection) {
                        case 0: 
                        case 1: {
                            this.stretchViewVertically(view, flexLine.mCrossSize);
                            continue block11;
                        }
                        case 2: 
                        case 3: {
                            this.stretchViewHorizontally(view, flexLine.mCrossSize);
                            continue block11;
                        }
                    }
                    throw new IllegalArgumentException("Invalid flex direction: " + flexDirection);
                }
            }
        }
    }

    private void stretchViewVertically(View view, int crossSize) {
        LayoutParams lp = (LayoutParams)view.getLayoutParams();
        int newHeight = crossSize - lp.topMargin - lp.bottomMargin;
        newHeight = Math.max(newHeight, 0);
        view.measure(View.MeasureSpec.makeMeasureSpec((int)view.getMeasuredWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)newHeight, (int)0x40000000));
    }

    private void stretchViewHorizontally(View view, int crossSize) {
        LayoutParams lp = (LayoutParams)view.getLayoutParams();
        int newWidth = crossSize - lp.leftMargin - lp.rightMargin;
        newWidth = Math.max(newWidth, 0);
        view.measure(View.MeasureSpec.makeMeasureSpec((int)newWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)view.getMeasuredHeight(), (int)0x40000000));
    }

    private void setMeasuredDimensionForFlex(int flexDirection, int widthMeasureSpec, int heightMeasureSpec, int childState) {
        int heightSizeAndState;
        int widthSizeAndState;
        int calculatedMaxWidth;
        int calculatedMaxHeight;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        switch (flexDirection) {
            case 0: 
            case 1: {
                calculatedMaxHeight = this.getSumOfCrossSize() + this.getPaddingTop() + this.getPaddingBottom();
                calculatedMaxWidth = this.getLargestMainSize();
                break;
            }
            case 2: 
            case 3: {
                calculatedMaxHeight = this.getLargestMainSize();
                calculatedMaxWidth = this.getSumOfCrossSize() + this.getPaddingLeft() + this.getPaddingRight();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid flex direction: " + flexDirection);
            }
        }
        switch (widthMode) {
            case 0x40000000: {
                if (widthSize < calculatedMaxWidth) {
                    childState = ViewCompat.combineMeasuredStates((int)childState, (int)0x1000000);
                }
                widthSizeAndState = ViewCompat.resolveSizeAndState((int)widthSize, (int)widthMeasureSpec, (int)childState);
                break;
            }
            case -2147483648: {
                if (widthSize < calculatedMaxWidth) {
                    childState = ViewCompat.combineMeasuredStates((int)childState, (int)0x1000000);
                } else {
                    widthSize = calculatedMaxWidth;
                }
                widthSizeAndState = ViewCompat.resolveSizeAndState((int)widthSize, (int)widthMeasureSpec, (int)childState);
                break;
            }
            case 0: {
                widthSizeAndState = ViewCompat.resolveSizeAndState((int)calculatedMaxWidth, (int)widthMeasureSpec, (int)childState);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown width mode is set: " + widthMode);
            }
        }
        switch (heightMode) {
            case 0x40000000: {
                if (heightSize < calculatedMaxHeight) {
                    childState = ViewCompat.combineMeasuredStates((int)childState, (int)256);
                }
                heightSizeAndState = ViewCompat.resolveSizeAndState((int)heightSize, (int)heightMeasureSpec, (int)childState);
                break;
            }
            case -2147483648: {
                if (heightSize < calculatedMaxHeight) {
                    childState = ViewCompat.combineMeasuredStates((int)childState, (int)256);
                } else {
                    heightSize = calculatedMaxHeight;
                }
                heightSizeAndState = ViewCompat.resolveSizeAndState((int)heightSize, (int)heightMeasureSpec, (int)childState);
                break;
            }
            case 0: {
                heightSizeAndState = ViewCompat.resolveSizeAndState((int)calculatedMaxHeight, (int)heightMeasureSpec, (int)childState);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown height mode is set: " + heightMode);
            }
        }
        this.setMeasuredDimension(widthSizeAndState, heightSizeAndState);
    }

    private boolean isWrapRequired(int mode, int maxSize, int currentLength, int childLength, LayoutParams lp, int childAbsoluteIndex, int childRelativeIndexInFlexLine) {
        if (this.mFlexWrap == 0) {
            return false;
        }
        if (lp.wrapBefore) {
            return true;
        }
        if (mode == 0) {
            return false;
        }
        if (this.isMainAxisDirectionHorizontal(this.mFlexDirection)) {
            if (this.hasDividerBeforeChildAtAlongMainAxis(childAbsoluteIndex, childRelativeIndexInFlexLine)) {
                childLength += this.mDividerVerticalWidth;
            }
            if ((this.mShowDividerVertical & 4) > 0) {
                childLength += this.mDividerVerticalWidth;
            }
        } else {
            if (this.hasDividerBeforeChildAtAlongMainAxis(childAbsoluteIndex, childRelativeIndexInFlexLine)) {
                childLength += this.mDividerHorizontalHeight;
            }
            if ((this.mShowDividerHorizontal & 4) > 0) {
                childLength += this.mDividerHorizontalHeight;
            }
        }
        return maxSize < currentLength + childLength;
    }

    private int getLargestMainSize() {
        int largestSize = Integer.MIN_VALUE;
        for (FlexLine flexLine : this.mFlexLines) {
            largestSize = Math.max(largestSize, flexLine.mMainSize);
        }
        return largestSize;
    }

    private int getSumOfCrossSize() {
        int sum = 0;
        int size = this.mFlexLines.size();
        for (int i = 0; i < size; ++i) {
            FlexLine flexLine = this.mFlexLines.get(i);
            if (this.hasDividerBeforeFlexLine(i)) {
                sum = this.isMainAxisDirectionHorizontal(this.mFlexDirection) ? (sum += this.mDividerHorizontalHeight) : (sum += this.mDividerVerticalWidth);
            }
            if (this.hasEndDividerAfterFlexLine(i)) {
                sum = this.isMainAxisDirectionHorizontal(this.mFlexDirection) ? (sum += this.mDividerHorizontalHeight) : (sum += this.mDividerVerticalWidth);
            }
            sum += flexLine.mCrossSize;
        }
        return sum;
    }

    private boolean isMainAxisDirectionHorizontal(int flexDirection) {
        return flexDirection == 0 || flexDirection == 1;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int layoutDirection = ViewCompat.getLayoutDirection((View)this);
        switch (this.mFlexDirection) {
            case 0: {
                boolean isRtl = layoutDirection == 1;
                this.layoutHorizontal(isRtl, left, top, right, bottom);
                break;
            }
            case 1: {
                boolean isRtl = layoutDirection != 1;
                this.layoutHorizontal(isRtl, left, top, right, bottom);
                break;
            }
            case 2: {
                boolean isRtl;
                boolean bl = isRtl = layoutDirection == 1;
                if (this.mFlexWrap == 2) {
                    isRtl = !isRtl;
                }
                this.layoutVertical(isRtl, false, left, top, right, bottom);
                break;
            }
            case 3: {
                boolean isRtl;
                boolean bl = isRtl = layoutDirection == 1;
                if (this.mFlexWrap == 2) {
                    isRtl = !isRtl;
                }
                this.layoutVertical(isRtl, true, left, top, right, bottom);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid flex direction is set: " + this.mFlexDirection);
            }
        }
    }

    private void layoutHorizontal(boolean isRtl, int left, int top, int right, int bottom) {
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int currentViewIndex = 0;
        int height = bottom - top;
        int width = right - left;
        int childBottom = height - this.getPaddingBottom();
        int childTop = this.getPaddingTop();
        int size = this.mFlexLines.size();
        for (int i = 0; i < size; ++i) {
            float childRight;
            float childLeft;
            FlexLine flexLine = this.mFlexLines.get(i);
            if (this.hasDividerBeforeFlexLine(i)) {
                childBottom -= this.mDividerHorizontalHeight;
                childTop += this.mDividerHorizontalHeight;
            }
            float spaceBetweenItem = 0.0f;
            switch (this.mJustifyContent) {
                case 0: {
                    childLeft = paddingLeft;
                    childRight = width - paddingRight;
                    break;
                }
                case 1: {
                    childLeft = width - flexLine.mMainSize + paddingRight;
                    childRight = flexLine.mMainSize - paddingLeft;
                    break;
                }
                case 2: {
                    childLeft = (float)paddingLeft + (float)(width - flexLine.mMainSize) / 2.0f;
                    childRight = (float)(width - paddingRight) - (float)(width - flexLine.mMainSize) / 2.0f;
                    break;
                }
                case 4: {
                    if (flexLine.mItemCount != 0) {
                        spaceBetweenItem = (float)(width - flexLine.mMainSize) / (float)flexLine.mItemCount;
                    }
                    childLeft = (float)paddingLeft + spaceBetweenItem / 2.0f;
                    childRight = (float)(width - paddingRight) - spaceBetweenItem / 2.0f;
                    break;
                }
                case 3: {
                    childLeft = paddingLeft;
                    float denominator = flexLine.mItemCount != 1 ? (float)(flexLine.mItemCount - 1) : 1.0f;
                    spaceBetweenItem = (float)(width - flexLine.mMainSize) / denominator;
                    childRight = width - paddingRight;
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid justifyContent is set: " + this.mJustifyContent);
                }
            }
            spaceBetweenItem = Math.max(spaceBetweenItem, 0.0f);
            for (int j = 0; j < flexLine.mItemCount; ++j) {
                View child = this.getReorderedChildAt(currentViewIndex);
                if (child == null) continue;
                if (child.getVisibility() == 8) {
                    ++currentViewIndex;
                    continue;
                }
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                childLeft += (float)lp.leftMargin;
                childRight -= (float)lp.rightMargin;
                if (this.hasDividerBeforeChildAtAlongMainAxis(currentViewIndex, j)) {
                    childLeft += (float)this.mDividerVerticalWidth;
                    childRight -= (float)this.mDividerVerticalWidth;
                }
                if (this.mFlexWrap == 2) {
                    if (isRtl) {
                        this.layoutSingleChildHorizontal(child, flexLine, this.mFlexWrap, this.mAlignItems, Math.round(childRight) - child.getMeasuredWidth(), childBottom - child.getMeasuredHeight(), Math.round(childRight), childBottom);
                    } else {
                        this.layoutSingleChildHorizontal(child, flexLine, this.mFlexWrap, this.mAlignItems, Math.round(childLeft), childBottom - child.getMeasuredHeight(), Math.round(childLeft) + child.getMeasuredWidth(), childBottom);
                    }
                } else if (isRtl) {
                    this.layoutSingleChildHorizontal(child, flexLine, this.mFlexWrap, this.mAlignItems, Math.round(childRight) - child.getMeasuredWidth(), childTop, Math.round(childRight), childTop + child.getMeasuredHeight());
                } else {
                    this.layoutSingleChildHorizontal(child, flexLine, this.mFlexWrap, this.mAlignItems, Math.round(childLeft), childTop, Math.round(childLeft) + child.getMeasuredWidth(), childTop + child.getMeasuredHeight());
                }
                childLeft += (float)child.getMeasuredWidth() + spaceBetweenItem + (float)lp.rightMargin;
                childRight -= (float)child.getMeasuredWidth() + spaceBetweenItem + (float)lp.leftMargin;
                ++currentViewIndex;
                flexLine.mLeft = Math.min(flexLine.mLeft, child.getLeft() - lp.leftMargin);
                flexLine.mTop = Math.min(flexLine.mTop, child.getTop() - lp.topMargin);
                flexLine.mRight = Math.max(flexLine.mRight, child.getRight() + lp.rightMargin);
                flexLine.mBottom = Math.max(flexLine.mBottom, child.getBottom() + lp.bottomMargin);
            }
            childTop += flexLine.mCrossSize;
            childBottom -= flexLine.mCrossSize;
        }
    }

    private void layoutSingleChildHorizontal(View view, FlexLine flexLine, int flexWrap, int alignItems, int left, int top, int right, int bottom) {
        LayoutParams lp = (LayoutParams)view.getLayoutParams();
        if (lp.alignSelf != -1) {
            alignItems = lp.alignSelf;
        }
        int crossSize = flexLine.mCrossSize;
        switch (alignItems) {
            case 0: 
            case 4: {
                if (flexWrap != 2) {
                    view.layout(left, top + lp.topMargin, right, bottom + lp.topMargin);
                    break;
                }
                view.layout(left, top - lp.bottomMargin, right, bottom - lp.bottomMargin);
                break;
            }
            case 3: {
                if (flexWrap != 2) {
                    int marginTop = flexLine.mMaxBaseline - view.getBaseline();
                    marginTop = Math.max(marginTop, lp.topMargin);
                    view.layout(left, top + marginTop, right, bottom + marginTop);
                    break;
                }
                int marginBottom = flexLine.mMaxBaseline - view.getMeasuredHeight() + view.getBaseline();
                marginBottom = Math.max(marginBottom, lp.bottomMargin);
                view.layout(left, top - marginBottom, right, bottom - marginBottom);
                break;
            }
            case 1: {
                if (flexWrap != 2) {
                    view.layout(left, top + crossSize - view.getMeasuredHeight() - lp.bottomMargin, right, top + crossSize - lp.bottomMargin);
                    break;
                }
                view.layout(left, top - crossSize + view.getMeasuredHeight() + lp.topMargin, right, bottom - crossSize + view.getMeasuredHeight() + lp.topMargin);
                break;
            }
            case 2: {
                int topFromCrossAxis = (crossSize - view.getMeasuredHeight() + lp.topMargin - lp.bottomMargin) / 2;
                if (flexWrap != 2) {
                    view.layout(left, top + topFromCrossAxis, right, top + topFromCrossAxis + view.getMeasuredHeight());
                    break;
                }
                view.layout(left, top - topFromCrossAxis, right, top - topFromCrossAxis + view.getMeasuredHeight());
            }
        }
    }

    private void layoutVertical(boolean isRtl, boolean fromBottomToTop, int left, int top, int right, int bottom) {
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        int paddingRight = this.getPaddingRight();
        int childLeft = this.getPaddingLeft();
        int currentViewIndex = 0;
        int width = right - left;
        int height = bottom - top;
        int childRight = width - paddingRight;
        int size = this.mFlexLines.size();
        for (int i = 0; i < size; ++i) {
            float childBottom;
            float childTop;
            FlexLine flexLine = this.mFlexLines.get(i);
            if (this.hasDividerBeforeFlexLine(i)) {
                childLeft += this.mDividerVerticalWidth;
                childRight -= this.mDividerVerticalWidth;
            }
            float spaceBetweenItem = 0.0f;
            switch (this.mJustifyContent) {
                case 0: {
                    childTop = paddingTop;
                    childBottom = height - paddingBottom;
                    break;
                }
                case 1: {
                    childTop = height - flexLine.mMainSize + paddingBottom;
                    childBottom = flexLine.mMainSize - paddingTop;
                    break;
                }
                case 2: {
                    childTop = (float)paddingTop + (float)(height - flexLine.mMainSize) / 2.0f;
                    childBottom = (float)(height - paddingBottom) - (float)(height - flexLine.mMainSize) / 2.0f;
                    break;
                }
                case 4: {
                    if (flexLine.mItemCount != 0) {
                        spaceBetweenItem = (float)(height - flexLine.mMainSize) / (float)flexLine.mItemCount;
                    }
                    childTop = (float)paddingTop + spaceBetweenItem / 2.0f;
                    childBottom = (float)(height - paddingBottom) - spaceBetweenItem / 2.0f;
                    break;
                }
                case 3: {
                    childTop = paddingTop;
                    float denominator = flexLine.mItemCount != 1 ? (float)(flexLine.mItemCount - 1) : 1.0f;
                    spaceBetweenItem = (float)(height - flexLine.mMainSize) / denominator;
                    childBottom = height - paddingBottom;
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid justifyContent is set: " + this.mJustifyContent);
                }
            }
            spaceBetweenItem = Math.max(spaceBetweenItem, 0.0f);
            for (int j = 0; j < flexLine.mItemCount; ++j) {
                View child = this.getReorderedChildAt(currentViewIndex);
                if (child == null) continue;
                if (child.getVisibility() == 8) {
                    ++currentViewIndex;
                    continue;
                }
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                childTop += (float)lp.topMargin;
                childBottom -= (float)lp.bottomMargin;
                if (this.hasDividerBeforeChildAtAlongMainAxis(currentViewIndex, j)) {
                    childTop += (float)this.mDividerHorizontalHeight;
                    childBottom -= (float)this.mDividerHorizontalHeight;
                }
                if (isRtl) {
                    if (fromBottomToTop) {
                        this.layoutSingleChildVertical(child, flexLine, true, this.mAlignItems, childRight - child.getMeasuredWidth(), Math.round(childBottom) - child.getMeasuredHeight(), childRight, Math.round(childBottom));
                    } else {
                        this.layoutSingleChildVertical(child, flexLine, true, this.mAlignItems, childRight - child.getMeasuredWidth(), Math.round(childTop), childRight, Math.round(childTop) + child.getMeasuredHeight());
                    }
                } else if (fromBottomToTop) {
                    this.layoutSingleChildVertical(child, flexLine, false, this.mAlignItems, childLeft, Math.round(childBottom) - child.getMeasuredHeight(), childLeft + child.getMeasuredWidth(), Math.round(childBottom));
                } else {
                    this.layoutSingleChildVertical(child, flexLine, false, this.mAlignItems, childLeft, Math.round(childTop), childLeft + child.getMeasuredWidth(), Math.round(childTop) + child.getMeasuredHeight());
                }
                childTop += (float)child.getMeasuredHeight() + spaceBetweenItem + (float)lp.bottomMargin;
                childBottom -= (float)child.getMeasuredHeight() + spaceBetweenItem + (float)lp.topMargin;
                ++currentViewIndex;
                flexLine.mLeft = Math.min(flexLine.mLeft, child.getLeft() - lp.leftMargin);
                flexLine.mTop = Math.min(flexLine.mTop, child.getTop() - lp.topMargin);
                flexLine.mRight = Math.max(flexLine.mRight, child.getRight() + lp.rightMargin);
                flexLine.mBottom = Math.max(flexLine.mBottom, child.getBottom() + lp.bottomMargin);
            }
            childLeft += flexLine.mCrossSize;
            childRight -= flexLine.mCrossSize;
        }
    }

    private void layoutSingleChildVertical(View view, FlexLine flexLine, boolean isRtl, int alignItems, int left, int top, int right, int bottom) {
        LayoutParams lp = (LayoutParams)view.getLayoutParams();
        if (lp.alignSelf != -1) {
            alignItems = lp.alignSelf;
        }
        int crossSize = flexLine.mCrossSize;
        switch (alignItems) {
            case 0: 
            case 3: 
            case 4: {
                if (!isRtl) {
                    view.layout(left + lp.leftMargin, top, right + lp.leftMargin, bottom);
                    break;
                }
                view.layout(left - lp.rightMargin, top, right - lp.rightMargin, bottom);
                break;
            }
            case 1: {
                if (!isRtl) {
                    view.layout(left + crossSize - view.getMeasuredWidth() - lp.rightMargin, top, right + crossSize - view.getMeasuredWidth() - lp.rightMargin, bottom);
                    break;
                }
                view.layout(left - crossSize + view.getMeasuredWidth() + lp.leftMargin, top, right - crossSize + view.getMeasuredWidth() + lp.leftMargin, bottom);
                break;
            }
            case 2: {
                int leftFromCrossAxis = (crossSize - view.getMeasuredWidth() + MarginLayoutParamsCompat.getMarginStart((ViewGroup.MarginLayoutParams)lp) - MarginLayoutParamsCompat.getMarginEnd((ViewGroup.MarginLayoutParams)lp)) / 2;
                if (!isRtl) {
                    view.layout(left + leftFromCrossAxis, top, right + leftFromCrossAxis, bottom);
                    break;
                }
                view.layout(left - leftFromCrossAxis, top, right - leftFromCrossAxis, bottom);
            }
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.mDividerDrawableVertical == null && this.mDividerDrawableHorizontal == null) {
            return;
        }
        if (this.mShowDividerHorizontal == 0 && this.mShowDividerVertical == 0) {
            return;
        }
        int layoutDirection = ViewCompat.getLayoutDirection((View)this);
        boolean fromBottomToTop = false;
        switch (this.mFlexDirection) {
            case 0: {
                boolean isRtl;
                boolean bl = isRtl = layoutDirection == 1;
                if (this.mFlexWrap == 2) {
                    fromBottomToTop = true;
                }
                this.drawDividersHorizontal(canvas, isRtl, fromBottomToTop);
                break;
            }
            case 1: {
                boolean isRtl;
                boolean bl = isRtl = layoutDirection != 1;
                if (this.mFlexWrap == 2) {
                    fromBottomToTop = true;
                }
                this.drawDividersHorizontal(canvas, isRtl, fromBottomToTop);
                break;
            }
            case 2: {
                boolean isRtl;
                boolean bl = isRtl = layoutDirection == 1;
                if (this.mFlexWrap == 2) {
                    isRtl = !isRtl;
                }
                fromBottomToTop = false;
                this.drawDividersVertical(canvas, isRtl, fromBottomToTop);
                break;
            }
            case 3: {
                boolean isRtl;
                boolean bl = isRtl = layoutDirection == 1;
                if (this.mFlexWrap == 2) {
                    isRtl = !isRtl;
                }
                fromBottomToTop = true;
                this.drawDividersVertical(canvas, isRtl, fromBottomToTop);
            }
        }
    }

    private void drawDividersHorizontal(Canvas canvas, boolean isRtl, boolean fromBottomToTop) {
        int currentViewIndex = 0;
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int horizontalDividerLength = Math.max(0, this.getWidth() - paddingRight - paddingLeft);
        int size = this.mFlexLines.size();
        for (int i = 0; i < size; ++i) {
            int horizontalDividerTop;
            FlexLine flexLine = this.mFlexLines.get(i);
            for (int j = 0; j < flexLine.mItemCount; ++j) {
                int dividerLeft;
                View view = this.getReorderedChildAt(currentViewIndex);
                LayoutParams lp = (LayoutParams)view.getLayoutParams();
                if (this.hasDividerBeforeChildAtAlongMainAxis(currentViewIndex, j)) {
                    dividerLeft = isRtl ? view.getRight() + lp.rightMargin : view.getLeft() - lp.leftMargin - this.mDividerVerticalWidth;
                    this.drawVerticalDivider(canvas, dividerLeft, flexLine.mTop, flexLine.mCrossSize);
                }
                if (j == flexLine.mItemCount - 1 && (this.mShowDividerVertical & 4) > 0) {
                    dividerLeft = isRtl ? view.getLeft() - lp.leftMargin - this.mDividerVerticalWidth : view.getRight() + lp.rightMargin;
                    this.drawVerticalDivider(canvas, dividerLeft, flexLine.mTop, flexLine.mCrossSize);
                }
                ++currentViewIndex;
            }
            if (this.hasDividerBeforeFlexLine(i)) {
                horizontalDividerTop = fromBottomToTop ? flexLine.mBottom : flexLine.mTop - this.mDividerHorizontalHeight;
                this.drawHorizontalDivider(canvas, paddingLeft, horizontalDividerTop, horizontalDividerLength);
            }
            if (!this.hasEndDividerAfterFlexLine(i) || (this.mShowDividerHorizontal & 4) <= 0) continue;
            horizontalDividerTop = fromBottomToTop ? flexLine.mTop - this.mDividerHorizontalHeight : flexLine.mBottom;
            this.drawHorizontalDivider(canvas, paddingLeft, horizontalDividerTop, horizontalDividerLength);
        }
    }

    private void drawDividersVertical(Canvas canvas, boolean isRtl, boolean fromBottomToTop) {
        int currentViewIndex = 0;
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        int verticalDividerLength = Math.max(0, this.getHeight() - paddingBottom - paddingTop);
        int size = this.mFlexLines.size();
        for (int i = 0; i < size; ++i) {
            int verticalDividerLeft;
            FlexLine flexLine = this.mFlexLines.get(i);
            for (int j = 0; j < flexLine.mItemCount; ++j) {
                int dividerTop;
                View view = this.getReorderedChildAt(currentViewIndex);
                LayoutParams lp = (LayoutParams)view.getLayoutParams();
                if (this.hasDividerBeforeChildAtAlongMainAxis(currentViewIndex, j)) {
                    dividerTop = fromBottomToTop ? view.getBottom() + lp.bottomMargin : view.getTop() - lp.topMargin - this.mDividerHorizontalHeight;
                    this.drawHorizontalDivider(canvas, flexLine.mLeft, dividerTop, flexLine.mCrossSize);
                }
                if (j == flexLine.mItemCount - 1 && (this.mShowDividerHorizontal & 4) > 0) {
                    dividerTop = fromBottomToTop ? view.getTop() - lp.topMargin - this.mDividerHorizontalHeight : view.getBottom() + lp.bottomMargin;
                    this.drawHorizontalDivider(canvas, flexLine.mLeft, dividerTop, flexLine.mCrossSize);
                }
                ++currentViewIndex;
            }
            if (this.hasDividerBeforeFlexLine(i)) {
                verticalDividerLeft = isRtl ? flexLine.mRight : flexLine.mLeft - this.mDividerVerticalWidth;
                this.drawVerticalDivider(canvas, verticalDividerLeft, paddingTop, verticalDividerLength);
            }
            if (!this.hasEndDividerAfterFlexLine(i) || (this.mShowDividerVertical & 4) <= 0) continue;
            verticalDividerLeft = isRtl ? flexLine.mLeft - this.mDividerVerticalWidth : flexLine.mRight;
            this.drawVerticalDivider(canvas, verticalDividerLeft, paddingTop, verticalDividerLength);
        }
    }

    private void drawVerticalDivider(Canvas canvas, int left, int top, int length) {
        if (this.mDividerDrawableVertical == null) {
            return;
        }
        this.mDividerDrawableVertical.setBounds(left, top, left + this.mDividerVerticalWidth, top + length);
        this.mDividerDrawableVertical.draw(canvas);
    }

    private void drawHorizontalDivider(Canvas canvas, int left, int top, int length) {
        if (this.mDividerDrawableHorizontal == null) {
            return;
        }
        this.mDividerDrawableHorizontal.setBounds(left, top, left + length, top + this.mDividerHorizontalHeight);
        this.mDividerDrawableHorizontal.draw(canvas);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    public int getFlexDirection() {
        return this.mFlexDirection;
    }

    public void setFlexDirection(int flexDirection) {
        if (this.mFlexDirection != flexDirection) {
            this.mFlexDirection = flexDirection;
            this.requestLayout();
        }
    }

    public int getFlexWrap() {
        return this.mFlexWrap;
    }

    public void setFlexWrap(int flexWrap) {
        if (this.mFlexWrap != flexWrap) {
            this.mFlexWrap = flexWrap;
            this.requestLayout();
        }
    }

    public int getJustifyContent() {
        return this.mJustifyContent;
    }

    public void setJustifyContent(int justifyContent) {
        if (this.mJustifyContent != justifyContent) {
            this.mJustifyContent = justifyContent;
            this.requestLayout();
        }
    }

    public int getAlignItems() {
        return this.mAlignItems;
    }

    public void setAlignItems(int alignItems) {
        if (this.mAlignItems != alignItems) {
            this.mAlignItems = alignItems;
            this.requestLayout();
        }
    }

    public int getAlignContent() {
        return this.mAlignContent;
    }

    public void setAlignContent(int alignContent) {
        if (this.mAlignContent != alignContent) {
            this.mAlignContent = alignContent;
            this.requestLayout();
        }
    }

    public List<FlexLine> getFlexLines() {
        ArrayList<FlexLine> result = new ArrayList<FlexLine>(this.mFlexLines.size());
        for (FlexLine flexLine : this.mFlexLines) {
            if (flexLine.getItemCount() == 0) continue;
            result.add(flexLine);
        }
        return result;
    }

    public Drawable getDividerDrawableHorizontal() {
        return this.mDividerDrawableHorizontal;
    }

    public Drawable getDividerDrawableVertical() {
        return this.mDividerDrawableVertical;
    }

    public void setDividerDrawable(Drawable divider) {
        this.setDividerDrawableHorizontal(divider);
        this.setDividerDrawableVertical(divider);
    }

    public void setDividerDrawableHorizontal(Drawable divider) {
        if (divider == this.mDividerDrawableHorizontal) {
            return;
        }
        this.mDividerDrawableHorizontal = divider;
        this.mDividerHorizontalHeight = divider != null ? divider.getIntrinsicHeight() : 0;
        this.setWillNotDrawFlag();
        this.requestLayout();
    }

    public void setDividerDrawableVertical(Drawable divider) {
        if (divider == this.mDividerDrawableVertical) {
            return;
        }
        this.mDividerDrawableVertical = divider;
        this.mDividerVerticalWidth = divider != null ? divider.getIntrinsicWidth() : 0;
        this.setWillNotDrawFlag();
        this.requestLayout();
    }

    public int getShowDividerVertical() {
        return this.mShowDividerVertical;
    }

    public int getShowDividerHorizontal() {
        return this.mShowDividerHorizontal;
    }

    public void setShowDivider(int dividerMode) {
        this.setShowDividerVertical(dividerMode);
        this.setShowDividerHorizontal(dividerMode);
    }

    public void setShowDividerVertical(int dividerMode) {
        if (dividerMode != this.mShowDividerVertical) {
            this.mShowDividerVertical = dividerMode;
            this.requestLayout();
        }
    }

    public void setShowDividerHorizontal(int dividerMode) {
        if (dividerMode != this.mShowDividerHorizontal) {
            this.mShowDividerHorizontal = dividerMode;
            this.requestLayout();
        }
    }

    private void setWillNotDrawFlag() {
        if (this.mDividerDrawableHorizontal == null && this.mDividerDrawableVertical == null) {
            this.setWillNotDraw(true);
        } else {
            this.setWillNotDraw(false);
        }
    }

    private boolean hasDividerBeforeChildAtAlongMainAxis(int childAbsoluteIndex, int childRelativeIndexInFlexLine) {
        if (this.allViewsAreGoneBefore(childAbsoluteIndex, childRelativeIndexInFlexLine)) {
            if (this.isMainAxisDirectionHorizontal(this.mFlexDirection)) {
                return (this.mShowDividerVertical & 1) != 0;
            }
            return (this.mShowDividerHorizontal & 1) != 0;
        }
        if (this.isMainAxisDirectionHorizontal(this.mFlexDirection)) {
            return (this.mShowDividerVertical & 2) != 0;
        }
        return (this.mShowDividerHorizontal & 2) != 0;
    }

    private boolean allViewsAreGoneBefore(int childAbsoluteIndex, int childRelativeIndexInFlexLine) {
        for (int i = 1; i <= childRelativeIndexInFlexLine; ++i) {
            View view = this.getReorderedChildAt(childAbsoluteIndex - i);
            if (view == null || view.getVisibility() == 8) continue;
            return false;
        }
        return true;
    }

    private boolean hasDividerBeforeFlexLine(int flexLineIndex) {
        if (flexLineIndex < 0 || flexLineIndex >= this.mFlexLines.size()) {
            return false;
        }
        if (this.allFlexLinesAreDummyBefore(flexLineIndex)) {
            if (this.isMainAxisDirectionHorizontal(this.mFlexDirection)) {
                return (this.mShowDividerHorizontal & 1) != 0;
            }
            return (this.mShowDividerVertical & 1) != 0;
        }
        if (this.isMainAxisDirectionHorizontal(this.mFlexDirection)) {
            return (this.mShowDividerHorizontal & 2) != 0;
        }
        return (this.mShowDividerVertical & 2) != 0;
    }

    private boolean allFlexLinesAreDummyBefore(int flexLineIndex) {
        for (int i = 0; i < flexLineIndex; ++i) {
            if (this.mFlexLines.get((int)i).mItemCount <= 0) continue;
            return false;
        }
        return true;
    }

    private boolean hasEndDividerAfterFlexLine(int flexLineIndex) {
        if (flexLineIndex < 0 || flexLineIndex >= this.mFlexLines.size()) {
            return false;
        }
        for (int i = flexLineIndex + 1; i < this.mFlexLines.size(); ++i) {
            if (this.mFlexLines.get((int)i).mItemCount <= 0) continue;
            return false;
        }
        if (this.isMainAxisDirectionHorizontal(this.mFlexDirection)) {
            return (this.mShowDividerHorizontal & 4) != 0;
        }
        return (this.mShowDividerVertical & 4) != 0;
    }

    private static class Order
    implements Comparable<Order> {
        int index;
        int order;

        private Order() {
        }

        @Override
        public int compareTo(@NonNull Order another) {
            if (this.order != another.order) {
                return this.order - another.order;
            }
            return this.index - another.index;
        }

        public String toString() {
            return "Order{order=" + this.order + ", index=" + this.index + '}';
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        private static final int ORDER_DEFAULT = 1;
        private static final float FLEX_GROW_DEFAULT = 0.0f;
        private static final float FLEX_SHRINK_DEFAULT = 1.0f;
        public static final float FLEX_BASIS_PERCENT_DEFAULT = -1.0f;
        public static final int ALIGN_SELF_AUTO = -1;
        public static final int ALIGN_SELF_FLEX_START = 0;
        public static final int ALIGN_SELF_FLEX_END = 1;
        public static final int ALIGN_SELF_CENTER = 2;
        public static final int ALIGN_SELF_BASELINE = 3;
        public static final int ALIGN_SELF_STRETCH = 4;
        private static final int MAX_SIZE = 0xFFFFFF;
        public int order = 1;
        public float flexGrow = 0.0f;
        public float flexShrink = 1.0f;
        public int alignSelf = -1;
        public float flexBasisPercent = -1.0f;
        public int minWidth;
        public int minHeight;
        public int maxWidth = 0xFFFFFF;
        public int maxHeight = 0xFFFFFF;
        public boolean wrapBefore;

        public LayoutParams(Context context, AttributeSet attrs) {
            super(context, attrs);
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FlexboxLayout_Layout);
            this.order = a.getInt(R.styleable.FlexboxLayout_Layout_layout_order, 1);
            this.flexGrow = a.getFloat(R.styleable.FlexboxLayout_Layout_layout_flexGrow, 0.0f);
            this.flexShrink = a.getFloat(R.styleable.FlexboxLayout_Layout_layout_flexShrink, 1.0f);
            this.alignSelf = a.getInt(R.styleable.FlexboxLayout_Layout_layout_alignSelf, -1);
            this.flexBasisPercent = a.getFraction(R.styleable.FlexboxLayout_Layout_layout_flexBasisPercent, 1, 1, -1.0f);
            this.minWidth = a.getDimensionPixelSize(R.styleable.FlexboxLayout_Layout_layout_minWidth, 0);
            this.minHeight = a.getDimensionPixelSize(R.styleable.FlexboxLayout_Layout_layout_minHeight, 0);
            this.maxWidth = a.getDimensionPixelSize(R.styleable.FlexboxLayout_Layout_layout_maxWidth, 0xFFFFFF);
            this.maxHeight = a.getDimensionPixelSize(R.styleable.FlexboxLayout_Layout_layout_maxHeight, 0xFFFFFF);
            this.wrapBefore = a.getBoolean(R.styleable.FlexboxLayout_Layout_layout_wrapBefore, false);
            a.recycle();
        }

        public LayoutParams(LayoutParams source) {
            super((ViewGroup.MarginLayoutParams)source);
            this.order = source.order;
            this.flexGrow = source.flexGrow;
            this.flexShrink = source.flexShrink;
            this.alignSelf = source.alignSelf;
            this.flexBasisPercent = source.flexBasisPercent;
            this.minWidth = source.minWidth;
            this.minHeight = source.minHeight;
            this.maxWidth = source.maxWidth;
            this.maxHeight = source.maxHeight;
            this.wrapBefore = source.wrapBefore;
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(int width, int height) {
            super(new ViewGroup.LayoutParams(width, height));
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DividerMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AlignContent {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AlignItems {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface JustifyContent {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FlexWrap {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FlexDirection {
    }
}

