/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament.gltfio;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import com.google.android.filament.Engine;
import com.google.android.filament.Material;
import com.google.android.filament.MaterialInstance;
import com.google.android.filament.VertexBuffer;
import com.google.android.filament.gltfio.MaterialProvider;

public class UbershaderLoader
implements MaterialProvider {
    private static final VertexBuffer.VertexAttribute[] sVertexAttributesValues = VertexBuffer.VertexAttribute.values();
    private long mNativeObject;

    public UbershaderLoader(Engine engine) {
        long nativeEngine = engine.getNativeObject();
        this.mNativeObject = UbershaderLoader.nCreateUbershaderLoader(nativeEngine);
    }

    @Override
    public void destroy() {
        UbershaderLoader.nDestroyUbershaderLoader(this.mNativeObject);
        this.mNativeObject = 0L;
    }

    @Override
    @Nullable
    public MaterialInstance createMaterialInstance(MaterialProvider.MaterialKey config, @NonNull @Size(min=8L) int[] uvmap, @Nullable String label, @Nullable String extras) {
        long nativeMaterialInstance = UbershaderLoader.nCreateMaterialInstance(this.mNativeObject, config, uvmap, label);
        return nativeMaterialInstance == 0L ? null : new MaterialInstance(null, nativeMaterialInstance);
    }

    @Override
    @NonNull
    public Material[] getMaterials() {
        int count = UbershaderLoader.nGetMaterialCount(this.mNativeObject);
        Material[] result = new Material[count];
        long[] natives = new long[count];
        UbershaderLoader.nGetMaterials(this.mNativeObject, natives);
        for (int i = 0; i < count; ++i) {
            result[i] = new Material(natives[i]);
        }
        return result;
    }

    @Override
    public boolean needsDummyData(int attrib) {
        VertexBuffer.VertexAttribute vattrib = sVertexAttributesValues[attrib];
        switch (vattrib) {
            case UV0: 
            case UV1: 
            case COLOR: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void destroyMaterials() {
        UbershaderLoader.nDestroyMaterials(this.mNativeObject);
    }

    public long getNativeObject() {
        return this.mNativeObject;
    }

    private static native long nCreateUbershaderLoader(long var0);

    private static native void nDestroyUbershaderLoader(long var0);

    private static native void nDestroyMaterials(long var0);

    private static native long nCreateMaterialInstance(long var0, MaterialProvider.MaterialKey var2, int[] var3, String var4);

    private static native int nGetMaterialCount(long var0);

    private static native void nGetMaterials(long var0, long[] var2);
}

