/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament.textured;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.google.android.filament.Engine;
import com.google.android.filament.Texture;
import com.google.android.filament.android.TextureHelper;
import com.google.android.filament.textured.TextureType;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t\u001a\u0010\u0010\b\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"SKIP_BITMAP_COPY", "", "format", "Lcom/google/android/filament/Texture$Format;", "bitmap", "Landroid/graphics/Bitmap;", "internalFormat", "Lcom/google/android/filament/Texture$InternalFormat;", "type", "Lcom/google/android/filament/textured/TextureType;", "loadTexture", "Lcom/google/android/filament/Texture;", "engine", "Lcom/google/android/filament/Engine;", "resources", "Landroid/content/res/Resources;", "resourceId", "", "Lcom/google/android/filament/Texture$Type;", "filament-utils-android_release"})
public final class TextureLoaderKt {
    public static final boolean SKIP_BITMAP_COPY = true;

    @NotNull
    public static final Texture loadTexture(@NotNull Engine engine, @NotNull Resources resources, int resourceId, @NotNull TextureType type) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inPremultiplied = type == TextureType.COLOR;
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)resources, (int)resourceId, (BitmapFactory.Options)options);
        Texture texture = new Texture.Builder().width(bitmap.getWidth()).height(bitmap.getHeight()).sampler(Texture.Sampler.SAMPLER_2D).format(TextureLoaderKt.internalFormat(type)).levels(255).build(engine);
        Intrinsics.checkNotNullExpressionValue((Object)texture, (String)"Builder()\n            .w\u2026           .build(engine)");
        Texture texture2 = texture;
        TextureHelper.setBitmap((Engine)engine, (Texture)texture2, (int)0, (Bitmap)bitmap);
        texture2.generateMipmaps(engine);
        return texture2;
    }

    private static final Texture.InternalFormat internalFormat(TextureType type) {
        Texture.InternalFormat internalFormat;
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                internalFormat = Texture.InternalFormat.SRGB8_A8;
                break;
            }
            case 2: {
                internalFormat = Texture.InternalFormat.RGBA8;
                break;
            }
            case 3: {
                internalFormat = Texture.InternalFormat.RGBA8;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return internalFormat;
    }

    private static final Texture.Format format(Bitmap bitmap) {
        Texture.Format format;
        switch (bitmap.getConfig().name()) {
            case "ALPHA_8": {
                format = Texture.Format.ALPHA;
                break;
            }
            case "RGB_565": {
                format = Texture.Format.RGB;
                break;
            }
            case "ARGB_8888": {
                format = Texture.Format.RGBA;
                break;
            }
            case "RGBA_F16": {
                format = Texture.Format.RGBA;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown bitmap configuration");
            }
        }
        return format;
    }

    private static final Texture.Type type(Bitmap bitmap) {
        Texture.Type type;
        switch (bitmap.getConfig().name()) {
            case "ALPHA_8": {
                type = Texture.Type.USHORT;
                break;
            }
            case "RGB_565": {
                type = Texture.Type.USHORT_565;
                break;
            }
            case "ARGB_8888": {
                type = Texture.Type.UBYTE;
                break;
            }
            case "RGBA_F16": {
                type = Texture.Type.HALF;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported bitmap configuration");
            }
        }
        return type;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TextureType.values().length];
            nArray[TextureType.COLOR.ordinal()] = 1;
            nArray[TextureType.NORMAL.ordinal()] = 2;
            nArray[TextureType.DATA.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

