/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament.android;

import android.content.Context;
import android.hardware.display.DisplayManager;
import android.os.Build;
import android.os.Handler;
import android.view.Display;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.filament.Renderer;

public class DisplayHelper {
    private Handler mHandler = null;
    private DisplayManager mDisplayManager;
    private Display mDisplay;
    private Renderer mRenderer;
    private DisplayManager.DisplayListener mListener;

    public DisplayHelper(@NonNull Context context) {
        this.mDisplayManager = (DisplayManager)context.getSystemService("display");
    }

    public DisplayHelper(@NonNull Context context, @NonNull Handler handler) {
        this(context);
        this.mHandler = handler;
    }

    protected void finalize() throws Throwable {
        try {
            this.detach();
        }
        finally {
            super.finalize();
        }
    }

    public void attach(@NonNull Renderer renderer, final @NonNull Display display) {
        if (renderer == this.mRenderer && display == this.mDisplay) {
            return;
        }
        this.mRenderer = renderer;
        this.mDisplay = display;
        this.mListener = new DisplayManager.DisplayListener(){

            public void onDisplayAdded(int displayId) {
            }

            public void onDisplayRemoved(int displayId) {
            }

            public void onDisplayChanged(int displayId) {
                if (displayId == display.getDisplayId()) {
                    DisplayHelper.this.updateDisplayInfo();
                }
            }
        };
        this.mDisplayManager.registerDisplayListener(this.mListener, this.mHandler);
        if (this.mHandler != null) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    DisplayHelper.this.updateDisplayInfo();
                }
            });
        } else {
            this.updateDisplayInfo();
        }
    }

    public void detach() {
        if (this.mListener != null) {
            this.mDisplayManager.unregisterDisplayListener(this.mListener);
            this.mListener = null;
            this.mDisplay = null;
            this.mRenderer = null;
        }
    }

    private void updateDisplayInfo() {
        this.mRenderer.setDisplayInfo(DisplayHelper.getDisplayInfo(this.mDisplay, this.mRenderer.getDisplayInfo()));
    }

    public Display getDisplay() {
        return this.mDisplay;
    }

    @NonNull
    public static Renderer.DisplayInfo getDisplayInfo(@NonNull Display display, @Nullable Renderer.DisplayInfo info) {
        if (info == null) {
            info = new Renderer.DisplayInfo();
        }
        info.refreshRate = DisplayHelper.getRefreshRate(display);
        info.presentationDeadlineNanos = DisplayHelper.getPresentationDeadlineNanos(display);
        info.vsyncOffsetNanos = DisplayHelper.getAppVsyncOffsetNanos(display);
        return info;
    }

    public static long getAppVsyncOffsetNanos(@NonNull Display display) {
        if (Build.VERSION.SDK_INT >= 29) {
            return display.getAppVsyncOffsetNanos();
        }
        return 0L;
    }

    public static long getPresentationDeadlineNanos(@NonNull Display display) {
        if (Build.VERSION.SDK_INT >= 29) {
            return display.getPresentationDeadlineNanos();
        }
        return 11600000L;
    }

    public static float getRefreshRate(@NonNull Display display) {
        return display.getRefreshRate();
    }

    public static long getRefreshPeriodNanos(@NonNull Display display) {
        return (long)(1.0E9 / (double)display.getRefreshRate());
    }
}

