/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import java.nio.Buffer;

public class SurfaceOrientation {
    private long mNativeObject;

    private SurfaceOrientation(long nativeSurfaceOrientation) {
        this.mNativeObject = nativeSurfaceOrientation;
    }

    public long getNativeObject() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Calling method on destroyed SurfaceOrientation");
        }
        return this.mNativeObject;
    }

    @IntRange(from=0L)
    public int getVertexCount() {
        return SurfaceOrientation.nGetVertexCount(this.mNativeObject);
    }

    @NonNull
    public void getQuatsAsFloat(@NonNull Buffer buffer) {
        SurfaceOrientation.nGetQuatsAsFloat(this.mNativeObject, buffer, buffer.remaining());
    }

    @NonNull
    public void getQuatsAsHalf(@NonNull Buffer buffer) {
        SurfaceOrientation.nGetQuatsAsHalf(this.mNativeObject, buffer, buffer.remaining());
    }

    @NonNull
    public void getQuatsAsShort(@NonNull Buffer buffer) {
        SurfaceOrientation.nGetQuatsAsShort(this.mNativeObject, buffer, buffer.remaining());
    }

    public void destroy() {
        SurfaceOrientation.nDestroy(this.mNativeObject);
        this.mNativeObject = 0L;
    }

    private static native long nCreateBuilder();

    private static native void nDestroyBuilder(long var0);

    private static native void nBuilderVertexCount(long var0, int var2);

    private static native void nBuilderNormals(long var0, Buffer var2, int var3, int var4);

    private static native void nBuilderTangents(long var0, Buffer var2, int var3, int var4);

    private static native void nBuilderUVs(long var0, Buffer var2, int var3, int var4);

    private static native void nBuilderPositions(long var0, Buffer var2, int var3, int var4);

    private static native void nBuilderTriangleCount(long var0, int var2);

    private static native void nBuilderTriangles16(long var0, Buffer var2, int var3);

    private static native void nBuilderTriangles32(long var0, Buffer var2, int var3);

    private static native long nBuilderBuild(long var0);

    private static native int nGetVertexCount(long var0);

    private static native void nGetQuatsAsFloat(long var0, Buffer var2, int var3);

    private static native void nGetQuatsAsHalf(long var0, Buffer var2, int var3);

    private static native void nGetQuatsAsShort(long var0, Buffer var2, int var3);

    private static native void nDestroy(long var0);

    public static class Builder {
        private int mVertexCount;
        private int mTriangleCount;
        private Buffer mNormals;
        private int mNormalsStride;
        private Buffer mTangents;
        private int mTangentsStride;
        private Buffer mTexCoords;
        private int mTexCoordsStride;
        private Buffer mPositions;
        private int mPositionsStride;
        private Buffer mTrianglesUint16;
        private Buffer mTrianglesUint32;

        @NonNull
        public Builder vertexCount(@IntRange(from=1L) int vertexCount) {
            this.mVertexCount = vertexCount;
            return this;
        }

        @NonNull
        public Builder normals(@NonNull Buffer buffer) {
            this.mNormals = buffer;
            this.mNormalsStride = 0;
            return this;
        }

        @NonNull
        public Builder tangents(@NonNull Buffer buffer) {
            this.mTangents = buffer;
            this.mTangentsStride = 0;
            return this;
        }

        @NonNull
        public Builder uvs(@NonNull Buffer buffer) {
            this.mTexCoords = buffer;
            this.mTexCoordsStride = 0;
            return this;
        }

        @NonNull
        public Builder positions(@NonNull Buffer buffer) {
            this.mPositions = buffer;
            this.mPositionsStride = 0;
            return this;
        }

        @NonNull
        public Builder triangleCount(int triangleCount) {
            this.mTriangleCount = triangleCount;
            return this;
        }

        @NonNull
        public Builder triangles_uint16(@NonNull Buffer buffer) {
            this.mTrianglesUint16 = buffer;
            return this;
        }

        @NonNull
        public Builder triangles_uint32(@NonNull Buffer buffer) {
            this.mTrianglesUint32 = buffer;
            return this;
        }

        @NonNull
        public SurfaceOrientation build() {
            long builder = SurfaceOrientation.nCreateBuilder();
            SurfaceOrientation.nBuilderVertexCount(builder, this.mVertexCount);
            SurfaceOrientation.nBuilderTriangleCount(builder, this.mTriangleCount);
            if (this.mNormals != null) {
                SurfaceOrientation.nBuilderNormals(builder, this.mNormals, this.mNormals.remaining(), this.mNormalsStride);
            }
            if (this.mTangents != null) {
                SurfaceOrientation.nBuilderTangents(builder, this.mTangents, this.mTangents.remaining(), this.mTangentsStride);
            }
            if (this.mTexCoords != null) {
                SurfaceOrientation.nBuilderUVs(builder, this.mTexCoords, this.mTexCoords.remaining(), this.mTexCoordsStride);
            }
            if (this.mPositions != null) {
                SurfaceOrientation.nBuilderPositions(builder, this.mPositions, this.mPositions.remaining(), this.mPositionsStride);
            }
            if (this.mTrianglesUint16 != null) {
                SurfaceOrientation.nBuilderTriangles16(builder, this.mTrianglesUint16, this.mTrianglesUint16.remaining());
            }
            if (this.mTrianglesUint32 != null) {
                SurfaceOrientation.nBuilderTriangles32(builder, this.mTrianglesUint32, this.mTrianglesUint32.remaining());
            }
            long nativeSurfaceOrientation = SurfaceOrientation.nBuilderBuild(builder);
            SurfaceOrientation.nDestroyBuilder(builder);
            if (nativeSurfaceOrientation == 0L) {
                throw new IllegalStateException("Could not create SurfaceOrientation");
            }
            return new SurfaceOrientation(nativeSurfaceOrientation);
        }
    }
}

