/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament.android;

import android.graphics.SurfaceTexture;
import android.os.Build;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class UiHelper {
    private static final String LOG_TAG = "UiHelper";
    private static final boolean LOGGING = false;
    private int mDesiredWidth;
    private int mDesiredHeight;
    private Object mNativeWindow;
    private RendererCallback mRenderCallback;
    private boolean mHasSwapChain;
    private RenderSurface mRenderSurface;
    private boolean mOpaque = true;
    private boolean mOverlay = false;

    public UiHelper() {
        this(ContextErrorPolicy.CHECK);
    }

    public UiHelper(ContextErrorPolicy policy) {
    }

    public void setRenderCallback(@Nullable RendererCallback renderCallback) {
        this.mRenderCallback = renderCallback;
    }

    @Nullable
    public RendererCallback getRenderCallback() {
        return this.mRenderCallback;
    }

    public void detach() {
        this.destroySwapChain();
        this.mNativeWindow = null;
        this.mRenderSurface = null;
    }

    public boolean isReadyToRender() {
        return this.mHasSwapChain;
    }

    public void setDesiredSize(int width, int height) {
        this.mDesiredWidth = width;
        this.mDesiredHeight = height;
        if (this.mRenderSurface != null) {
            this.mRenderSurface.resize(width, height);
        }
    }

    public int getDesiredWidth() {
        return this.mDesiredWidth;
    }

    public int getDesiredHeight() {
        return this.mDesiredHeight;
    }

    public boolean isOpaque() {
        return this.mOpaque;
    }

    public void setOpaque(boolean opaque) {
        this.mOpaque = opaque;
    }

    public boolean isMediaOverlay() {
        return this.mOverlay;
    }

    public void setMediaOverlay(boolean overlay) {
        this.mOverlay = overlay;
    }

    public long getSwapChainFlags() {
        return this.isOpaque() ? 0L : 1L;
    }

    public void attachTo(@NonNull SurfaceView view) {
        if (this.attach(view)) {
            Surface surface;
            boolean translucent;
            boolean bl = translucent = !this.isOpaque();
            if (this.isMediaOverlay()) {
                view.setZOrderMediaOverlay(translucent);
            } else {
                view.setZOrderOnTop(translucent);
            }
            int format = this.isOpaque() ? -1 : -3;
            view.getHolder().setFormat(format);
            this.mRenderSurface = new SurfaceViewHandler(view);
            SurfaceHolder.Callback callback = new SurfaceHolder.Callback(){

                public void surfaceCreated(SurfaceHolder holder) {
                    UiHelper.this.createSwapChain(holder.getSurface());
                }

                public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                    UiHelper.this.mRenderCallback.onResized(width, height);
                }

                public void surfaceDestroyed(SurfaceHolder holder) {
                    UiHelper.this.destroySwapChain();
                }
            };
            SurfaceHolder holder = view.getHolder();
            holder.addCallback(callback);
            if (this.mDesiredWidth > 0 && this.mDesiredHeight > 0) {
                holder.setFixedSize(this.mDesiredWidth, this.mDesiredHeight);
            }
            if ((surface = holder.getSurface()) != null && surface.isValid()) {
                callback.surfaceCreated(holder);
                callback.surfaceChanged(holder, format, holder.getSurfaceFrame().width(), holder.getSurfaceFrame().height());
            }
        }
    }

    public void attachTo(@NonNull TextureView view) {
        if (this.attach(view)) {
            view.setOpaque(this.isOpaque());
            this.mRenderSurface = new TextureViewHandler(view);
            TextureView.SurfaceTextureListener listener = new TextureView.SurfaceTextureListener(){

                public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
                    if (Build.VERSION.SDK_INT >= 15 && UiHelper.this.mDesiredWidth > 0 && UiHelper.this.mDesiredHeight > 0) {
                        surfaceTexture.setDefaultBufferSize(UiHelper.this.mDesiredWidth, UiHelper.this.mDesiredHeight);
                    }
                    Surface surface = new Surface(surfaceTexture);
                    TextureViewHandler textureViewHandler = (TextureViewHandler)UiHelper.this.mRenderSurface;
                    textureViewHandler.setSurface(surface);
                    UiHelper.this.createSwapChain(surface);
                    UiHelper.this.mRenderCallback.onResized(width, height);
                }

                public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
                    if (UiHelper.this.mDesiredWidth > 0 && UiHelper.this.mDesiredHeight > 0) {
                        surfaceTexture.setDefaultBufferSize(UiHelper.this.mDesiredWidth, UiHelper.this.mDesiredHeight);
                        UiHelper.this.mRenderCallback.onResized(UiHelper.this.mDesiredWidth, UiHelper.this.mDesiredHeight);
                    } else {
                        UiHelper.this.mRenderCallback.onResized(width, height);
                    }
                }

                public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
                    UiHelper.this.destroySwapChain();
                    return true;
                }

                public void onSurfaceTextureUpdated(SurfaceTexture surface) {
                }
            };
            view.setSurfaceTextureListener(listener);
            if (view.isAvailable()) {
                SurfaceTexture surfaceTexture = view.getSurfaceTexture();
                listener.onSurfaceTextureAvailable(surfaceTexture, this.mDesiredWidth, this.mDesiredHeight);
            }
        }
    }

    public void attachTo(final @NonNull SurfaceHolder holder) {
        if (this.attach(holder)) {
            Surface surface;
            int format = this.isOpaque() ? -1 : -3;
            holder.setFormat(format);
            this.mRenderSurface = new SurfaceHolderHandler(holder);
            SurfaceHolder.Callback callback = new SurfaceHolder.Callback(){

                public void surfaceCreated(SurfaceHolder surfaceHolder) {
                    UiHelper.this.createSwapChain(holder.getSurface());
                }

                public void surfaceChanged(SurfaceHolder holder2, int format, int width, int height) {
                    UiHelper.this.mRenderCallback.onResized(width, height);
                }

                public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
                    UiHelper.this.destroySwapChain();
                }
            };
            holder.addCallback(callback);
            if (this.mDesiredWidth > 0 && this.mDesiredHeight > 0) {
                holder.setFixedSize(this.mDesiredWidth, this.mDesiredHeight);
            }
            if ((surface = holder.getSurface()) != null && surface.isValid()) {
                callback.surfaceCreated(holder);
                callback.surfaceChanged(holder, format, holder.getSurfaceFrame().width(), holder.getSurfaceFrame().height());
            }
        }
    }

    private boolean attach(@NonNull Object nativeWindow) {
        if (this.mNativeWindow != null) {
            if (this.mNativeWindow == nativeWindow) {
                return false;
            }
            this.destroySwapChain();
        }
        this.mNativeWindow = nativeWindow;
        return true;
    }

    private void createSwapChain(@NonNull Surface surface) {
        this.mRenderCallback.onNativeWindowChanged(surface);
        this.mHasSwapChain = true;
    }

    private void destroySwapChain() {
        if (this.mRenderSurface != null) {
            this.mRenderSurface.detach();
        }
        this.mRenderCallback.onDetachedFromSurface();
        this.mHasSwapChain = false;
    }

    private class TextureViewHandler
    implements RenderSurface {
        private TextureView mTextureView;
        private Surface mSurface;

        TextureViewHandler(TextureView surface) {
            this.mTextureView = surface;
        }

        @Override
        public void resize(int width, int height) {
            if (Build.VERSION.SDK_INT >= 15) {
                this.mTextureView.getSurfaceTexture().setDefaultBufferSize(width, height);
            }
            UiHelper.this.mRenderCallback.onResized(width, height);
        }

        @Override
        public void detach() {
            this.setSurface(null);
        }

        void setSurface(Surface surface) {
            if (surface == null && this.mSurface != null) {
                this.mSurface.release();
            }
            this.mSurface = surface;
        }
    }

    private static class SurfaceHolderHandler
    implements RenderSurface {
        private SurfaceHolder mSurfaceHolder;

        SurfaceHolderHandler(SurfaceHolder surface) {
            this.mSurfaceHolder = surface;
        }

        @Override
        public void resize(int width, int height) {
            this.mSurfaceHolder.setFixedSize(width, height);
        }

        @Override
        public void detach() {
        }
    }

    private static class SurfaceViewHandler
    implements RenderSurface {
        private SurfaceView mSurfaceView;

        SurfaceViewHandler(SurfaceView surface) {
            this.mSurfaceView = surface;
        }

        @Override
        public void resize(int width, int height) {
            this.mSurfaceView.getHolder().setFixedSize(width, height);
        }

        @Override
        public void detach() {
        }
    }

    private static interface RenderSurface {
        public void resize(int var1, int var2);

        public void detach();
    }

    public static interface RendererCallback {
        public void onNativeWindowChanged(Surface var1);

        public void onDetachedFromSurface();

        public void onResized(int var1, int var2);
    }

    public static enum ContextErrorPolicy {
        CHECK,
        DONT_CHECK;

    }
}

