/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import com.google.android.filament.Engine;
import com.google.android.filament.Stream;
import com.google.android.filament.proguard.UsedByReflection;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;

public class Texture {
    private static final Sampler[] sSamplerValues = Sampler.values();
    private static final InternalFormat[] sInternalFormatValues = InternalFormat.values();
    private long mNativeObject;
    public static final int BASE_LEVEL = 0;

    public Texture(long nativeTexture) {
        this.mNativeObject = nativeTexture;
    }

    public static boolean isTextureFormatSupported(@NonNull Engine engine, @NonNull InternalFormat format) {
        return Texture.nIsTextureFormatSupported(engine.getNativeObject(), format.ordinal());
    }

    public static boolean isTextureSwizzleSupported(@NonNull Engine engine) {
        return Texture.nIsTextureSwizzleSupported(engine.getNativeObject());
    }

    public int getWidth(@IntRange(from=0L) int level) {
        return Texture.nGetWidth(this.getNativeObject(), level);
    }

    public int getHeight(@IntRange(from=0L) int level) {
        return Texture.nGetHeight(this.getNativeObject(), level);
    }

    public int getDepth(@IntRange(from=0L) int level) {
        return Texture.nGetDepth(this.getNativeObject(), level);
    }

    public int getLevels() {
        return Texture.nGetLevels(this.getNativeObject());
    }

    @NonNull
    public Sampler getTarget() {
        return sSamplerValues[Texture.nGetTarget(this.getNativeObject())];
    }

    @NonNull
    public InternalFormat getFormat() {
        return sInternalFormatValues[Texture.nGetInternalFormat(this.getNativeObject())];
    }

    public void setImage(@NonNull Engine engine, @IntRange(from=0L) int level, @NonNull PixelBufferDescriptor buffer) {
        this.setImage(engine, level, 0, 0, this.getWidth(level), this.getHeight(level), buffer);
    }

    public void setImage(@NonNull Engine engine, @IntRange(from=0L) int level, @IntRange(from=0L) int xoffset, @IntRange(from=0L) int yoffset, @IntRange(from=0L) int width, @IntRange(from=0L) int height, @NonNull PixelBufferDescriptor buffer) {
        int result = buffer.type == Type.COMPRESSED ? Texture.nSetImageCompressed(this.getNativeObject(), engine.getNativeObject(), level, xoffset, yoffset, width, height, buffer.storage, buffer.storage.remaining(), buffer.left, buffer.top, buffer.type.ordinal(), buffer.alignment, buffer.compressedSizeInBytes, buffer.compressedFormat.ordinal(), buffer.handler, buffer.callback) : Texture.nSetImage(this.getNativeObject(), engine.getNativeObject(), level, xoffset, yoffset, width, height, buffer.storage, buffer.storage.remaining(), buffer.left, buffer.top, buffer.type.ordinal(), buffer.alignment, buffer.stride, buffer.format.ordinal(), buffer.handler, buffer.callback);
        if (result < 0) {
            throw new BufferOverflowException();
        }
    }

    public void setImage(@NonNull Engine engine, @IntRange(from=0L) int level, @IntRange(from=0L) int xoffset, @IntRange(from=0L) int yoffset, @IntRange(from=0L) int zoffset, @IntRange(from=0L) int width, @IntRange(from=0L) int height, @IntRange(from=0L) int depth, @NonNull PixelBufferDescriptor buffer) {
        int result = buffer.type == Type.COMPRESSED ? Texture.nSetImage3DCompressed(this.getNativeObject(), engine.getNativeObject(), level, xoffset, yoffset, zoffset, width, height, depth, buffer.storage, buffer.storage.remaining(), buffer.left, buffer.top, buffer.type.ordinal(), buffer.alignment, buffer.compressedSizeInBytes, buffer.compressedFormat.ordinal(), buffer.handler, buffer.callback) : Texture.nSetImage3D(this.getNativeObject(), engine.getNativeObject(), level, xoffset, yoffset, zoffset, width, height, depth, buffer.storage, buffer.storage.remaining(), buffer.left, buffer.top, buffer.type.ordinal(), buffer.alignment, buffer.stride, buffer.format.ordinal(), buffer.handler, buffer.callback);
        if (result < 0) {
            throw new BufferOverflowException();
        }
    }

    public void setImage(@NonNull Engine engine, @IntRange(from=0L) int level, @NonNull PixelBufferDescriptor buffer, @NonNull @Size(min=6L) int[] faceOffsetsInBytes) {
        int result = buffer.type == Type.COMPRESSED ? Texture.nSetImageCubemapCompressed(this.getNativeObject(), engine.getNativeObject(), level, buffer.storage, buffer.storage.remaining(), buffer.left, buffer.top, buffer.type.ordinal(), buffer.alignment, buffer.compressedSizeInBytes, buffer.compressedFormat.ordinal(), faceOffsetsInBytes, buffer.handler, buffer.callback) : Texture.nSetImageCubemap(this.getNativeObject(), engine.getNativeObject(), level, buffer.storage, buffer.storage.remaining(), buffer.left, buffer.top, buffer.type.ordinal(), buffer.alignment, buffer.stride, buffer.format.ordinal(), faceOffsetsInBytes, buffer.handler, buffer.callback);
        if (result < 0) {
            throw new BufferOverflowException();
        }
    }

    public void setExternalImage(@NonNull Engine engine, long eglImage) {
        Texture.nSetExternalImage(this.getNativeObject(), engine.getNativeObject(), eglImage);
    }

    public void setExternalStream(@NonNull Engine engine, @NonNull Stream stream) {
        long streamNativeObject;
        long nativeObject = this.getNativeObject();
        if (!Texture.nIsStreamValidForTexture(nativeObject, streamNativeObject = stream.getNativeObject())) {
            throw new IllegalStateException("Invalid texture sampler: When used with a stream, a texture must use a SAMPLER_EXTERNAL");
        }
        Texture.nSetExternalStream(nativeObject, engine.getNativeObject(), streamNativeObject);
    }

    public void generateMipmaps(@NonNull Engine engine) {
        Texture.nGenerateMipmaps(this.getNativeObject(), engine.getNativeObject());
    }

    public void generatePrefilterMipmap(@NonNull Engine engine, @NonNull PixelBufferDescriptor buffer, @NonNull @Size(min=6L) int[] faceOffsetsInBytes, PrefilterOptions options) {
        int result;
        int width = this.getWidth(0);
        int height = this.getHeight(0);
        int sampleCount = 8;
        boolean mirror = true;
        if (options != null) {
            sampleCount = options.sampleCount;
            mirror = options.mirror;
        }
        if ((result = Texture.nGeneratePrefilterMipmap(this.getNativeObject(), engine.getNativeObject(), width, height, buffer.storage, buffer.storage.remaining(), buffer.left, buffer.top, buffer.type.ordinal(), buffer.alignment, buffer.stride, buffer.format.ordinal(), faceOffsetsInBytes, buffer.handler, buffer.callback, sampleCount, mirror)) < 0) {
            throw new BufferOverflowException();
        }
    }

    @UsedByReflection(value="TextureHelper.java")
    public long getNativeObject() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Calling method on destroyed Texture");
        }
        return this.mNativeObject;
    }

    void clearNativeObject() {
        this.mNativeObject = 0L;
    }

    private static native boolean nIsTextureFormatSupported(long var0, int var2);

    private static native boolean nIsTextureSwizzleSupported(long var0);

    private static native long nCreateBuilder();

    private static native void nDestroyBuilder(long var0);

    private static native void nBuilderWidth(long var0, int var2);

    private static native void nBuilderHeight(long var0, int var2);

    private static native void nBuilderDepth(long var0, int var2);

    private static native void nBuilderLevels(long var0, int var2);

    private static native void nBuilderSampler(long var0, int var2);

    private static native void nBuilderFormat(long var0, int var2);

    private static native void nBuilderUsage(long var0, int var2);

    private static native void nBuilderSwizzle(long var0, int var2, int var3, int var4, int var5);

    private static native void nBuilderImportTexture(long var0, long var2);

    private static native long nBuilderBuild(long var0, long var2);

    private static native int nGetWidth(long var0, int var2);

    private static native int nGetHeight(long var0, int var2);

    private static native int nGetDepth(long var0, int var2);

    private static native int nGetLevels(long var0);

    private static native int nGetTarget(long var0);

    private static native int nGetInternalFormat(long var0);

    private static native int nSetImage(long var0, long var2, int var4, int var5, int var6, int var7, int var8, Buffer var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, Object var17, Runnable var18);

    private static native int nSetImageCompressed(long var0, long var2, int var4, int var5, int var6, int var7, int var8, Buffer var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, Object var17, Runnable var18);

    private static native int nSetImage3D(long var0, long var2, int var4, int var5, int var6, int var7, int var8, int var9, int var10, Buffer var11, int var12, int var13, int var14, int var15, int var16, int var17, int var18, Object var19, Runnable var20);

    private static native int nSetImage3DCompressed(long var0, long var2, int var4, int var5, int var6, int var7, int var8, int var9, int var10, Buffer var11, int var12, int var13, int var14, int var15, int var16, int var17, int var18, Object var19, Runnable var20);

    private static native int nSetImageCubemap(long var0, long var2, int var4, Buffer var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int[] var13, Object var14, Runnable var15);

    private static native int nSetImageCubemapCompressed(long var0, long var2, int var4, Buffer var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int[] var13, Object var14, Runnable var15);

    private static native void nSetExternalImage(long var0, long var2, long var4);

    private static native void nSetExternalStream(long var0, long var2, long var4);

    private static native void nGenerateMipmaps(long var0, long var2);

    private static native boolean nIsStreamValidForTexture(long var0, long var2);

    private static native int nGeneratePrefilterMipmap(long var0, long var2, int var4, int var5, Buffer var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int[] var14, Object var15, Runnable var16, int var17, boolean var18);

    static /* synthetic */ long access$000() {
        return Texture.nCreateBuilder();
    }

    public static class Usage {
        public static final int COLOR_ATTACHMENT = 1;
        public static final int DEPTH_ATTACHMENT = 2;
        public static final int STENCIL_ATTACHMENT = 4;
        public static final int UPLOADABLE = 8;
        public static final int SAMPLEABLE = 16;
        public static final int SUBPASS_INPUT = 32;
        public static final int DEFAULT = 24;
    }

    public static class Builder {
        private final BuilderFinalizer mFinalizer;
        private final long mNativeBuilder = Texture.access$000();

        public Builder() {
            this.mFinalizer = new BuilderFinalizer(this.mNativeBuilder);
        }

        @NonNull
        public Builder width(@IntRange(from=1L) int width) {
            Texture.nBuilderWidth(this.mNativeBuilder, width);
            return this;
        }

        @NonNull
        public Builder height(@IntRange(from=1L) int height) {
            Texture.nBuilderHeight(this.mNativeBuilder, height);
            return this;
        }

        @NonNull
        public Builder depth(@IntRange(from=1L) int depth) {
            Texture.nBuilderDepth(this.mNativeBuilder, depth);
            return this;
        }

        @NonNull
        public Builder levels(@IntRange(from=1L) int levels) {
            Texture.nBuilderLevels(this.mNativeBuilder, levels);
            return this;
        }

        @NonNull
        public Builder sampler(@NonNull Sampler target) {
            Texture.nBuilderSampler(this.mNativeBuilder, target.ordinal());
            return this;
        }

        @NonNull
        public Builder format(@NonNull InternalFormat format) {
            Texture.nBuilderFormat(this.mNativeBuilder, format.ordinal());
            return this;
        }

        @NonNull
        public Builder usage(int flags) {
            Texture.nBuilderUsage(this.mNativeBuilder, flags);
            return this;
        }

        @NonNull
        public Builder swizzle(@NonNull Swizzle r, @NonNull Swizzle g, @NonNull Swizzle b, @NonNull Swizzle a) {
            Texture.nBuilderSwizzle(this.mNativeBuilder, r.ordinal(), g.ordinal(), b.ordinal(), a.ordinal());
            return this;
        }

        @NonNull
        public Builder importTexture(long id) {
            Texture.nBuilderImportTexture(this.mNativeBuilder, id);
            return this;
        }

        @NonNull
        public Texture build(@NonNull Engine engine) {
            long nativeTexture = Texture.nBuilderBuild(this.mNativeBuilder, engine.getNativeObject());
            if (nativeTexture == 0L) {
                throw new IllegalStateException("Couldn't create Texture");
            }
            return new Texture(nativeTexture);
        }

        private static class BuilderFinalizer {
            private final long mNativeObject;

            BuilderFinalizer(long nativeObject) {
                this.mNativeObject = nativeObject;
            }

            public void finalize() {
                try {
                    super.finalize();
                }
                catch (Throwable throwable) {
                }
                finally {
                    Texture.nDestroyBuilder(this.mNativeObject);
                }
            }
        }
    }

    public static class PrefilterOptions {
        public int sampleCount = 8;
        public boolean mirror = true;
    }

    public static class PixelBufferDescriptor {
        public Buffer storage;
        public Type type;
        public int alignment = 1;
        public int left = 0;
        public int top = 0;
        public int stride = 0;
        public Format format;
        public int compressedSizeInBytes;
        public CompressedFormat compressedFormat;
        @Nullable
        public Object handler;
        @Nullable
        public Runnable callback;

        public PixelBufferDescriptor(@NonNull Buffer storage, @NonNull Format format, @NonNull Type type, @IntRange(from=1L, to=8L) int alignment, @IntRange(from=0L) int left, @IntRange(from=0L) int top, @IntRange(from=0L) int stride, @Nullable Object handler, @Nullable Runnable callback) {
            this.storage = storage;
            this.left = left;
            this.top = top;
            this.type = type;
            this.alignment = alignment;
            this.stride = stride;
            this.format = format;
            this.handler = handler;
            this.callback = callback;
        }

        public PixelBufferDescriptor(@NonNull Buffer storage, @NonNull Format format, @NonNull Type type) {
            this(storage, format, type, 1, 0, 0, 0, null, null);
        }

        public PixelBufferDescriptor(@NonNull Buffer storage, @NonNull Format format, @NonNull Type type, @IntRange(from=1L, to=8L) int alignment) {
            this(storage, format, type, alignment, 0, 0, 0, null, null);
        }

        public PixelBufferDescriptor(@NonNull Buffer storage, @NonNull Format format, @NonNull Type type, @IntRange(from=1L, to=8L) int alignment, @IntRange(from=0L) int left, @IntRange(from=0L) int top) {
            this(storage, format, type, alignment, left, top, 0, null, null);
        }

        public PixelBufferDescriptor(@NonNull ByteBuffer storage, @NonNull CompressedFormat format, @IntRange(from=0L) int compressedSizeInBytes) {
            this.storage = storage;
            this.type = Type.COMPRESSED;
            this.alignment = 1;
            this.compressedFormat = format;
            this.compressedSizeInBytes = compressedSizeInBytes;
        }

        public void setCallback(@Nullable Object handler, @Nullable Runnable callback) {
            this.handler = handler;
            this.callback = callback;
        }

        static int computeDataSize(@NonNull Format format, @NonNull Type type, int stride, int height, @IntRange(from=1L, to=8L) int alignment) {
            if (type == Type.COMPRESSED) {
                return 0;
            }
            int n = 0;
            switch (format) {
                case R: 
                case R_INTEGER: 
                case DEPTH_COMPONENT: 
                case ALPHA: {
                    n = 1;
                    break;
                }
                case RG: 
                case RG_INTEGER: 
                case DEPTH_STENCIL: 
                case STENCIL_INDEX: {
                    n = 2;
                    break;
                }
                case RGB: 
                case RGB_INTEGER: {
                    n = 3;
                    break;
                }
                case RGBA: 
                case RGBA_INTEGER: {
                    n = 4;
                    break;
                }
                default: {
                    throw new IllegalStateException("unsupported format enum");
                }
            }
            int bpp = n;
            switch (type) {
                case UBYTE: 
                case BYTE: 
                case COMPRESSED: {
                    break;
                }
                case USHORT: 
                case SHORT: 
                case HALF: {
                    bpp *= 2;
                    break;
                }
                case UINT: 
                case INT: 
                case FLOAT: {
                    bpp *= 4;
                    break;
                }
                case UINT_10F_11F_11F_REV: {
                    bpp = 4;
                    break;
                }
                case USHORT_565: {
                    bpp = 2;
                }
            }
            int bpr = bpp * stride;
            int bprAligned = bpr + (alignment - 1) & -alignment;
            return bprAligned * height;
        }
    }

    public static enum Swizzle {
        SUBSTITUTE_ZERO,
        SUBSTITUTE_ONE,
        CHANNEL_0,
        CHANNEL_1,
        CHANNEL_2,
        CHANNEL_3;

    }

    public static enum Type {
        UBYTE,
        BYTE,
        USHORT,
        SHORT,
        UINT,
        INT,
        HALF,
        FLOAT,
        COMPRESSED,
        UINT_10F_11F_11F_REV,
        USHORT_565;

    }

    public static enum Format {
        R,
        R_INTEGER,
        RG,
        RG_INTEGER,
        RGB,
        RGB_INTEGER,
        RGBA,
        RGBA_INTEGER,
        UNUSED,
        DEPTH_COMPONENT,
        DEPTH_STENCIL,
        STENCIL_INDEX,
        ALPHA;

    }

    public static enum CubemapFace {
        POSITIVE_X,
        NEGATIVE_X,
        POSITIVE_Y,
        NEGATIVE_Y,
        POSITIVE_Z,
        NEGATIVE_Z;

    }

    public static enum CompressedFormat {
        EAC_R11,
        EAC_R11_SIGNED,
        EAC_RG11,
        EAC_RG11_SIGNED,
        ETC2_RGB8,
        ETC2_SRGB8,
        ETC2_RGB8_A1,
        ETC2_SRGB8_A1,
        ETC2_EAC_RGBA8,
        ETC2_EAC_SRGBA8,
        DXT1_RGB,
        DXT1_RGBA,
        DXT3_RGBA,
        DXT5_RGBA,
        DXT1_SRGB,
        DXT1_SRGBA,
        DXT3_SRGBA,
        DXT5_SRGBA,
        RGBA_ASTC_4x4,
        RGBA_ASTC_5x4,
        RGBA_ASTC_5x5,
        RGBA_ASTC_6x5,
        RGBA_ASTC_6x6,
        RGBA_ASTC_8x5,
        RGBA_ASTC_8x6,
        RGBA_ASTC_8x8,
        RGBA_ASTC_10x5,
        RGBA_ASTC_10x6,
        RGBA_ASTC_10x8,
        RGBA_ASTC_10x10,
        RGBA_ASTC_12x10,
        RGBA_ASTC_12x12,
        SRGB8_ALPHA8_ASTC_4x4,
        SRGB8_ALPHA8_ASTC_5x4,
        SRGB8_ALPHA8_ASTC_5x5,
        SRGB8_ALPHA8_ASTC_6x5,
        SRGB8_ALPHA8_ASTC_6x6,
        SRGB8_ALPHA8_ASTC_8x5,
        SRGB8_ALPHA8_ASTC_8x6,
        SRGB8_ALPHA8_ASTC_8x8,
        SRGB8_ALPHA8_ASTC_10x5,
        SRGB8_ALPHA8_ASTC_10x6,
        SRGB8_ALPHA8_ASTC_10x8,
        SRGB8_ALPHA8_ASTC_10x10,
        SRGB8_ALPHA8_ASTC_12x10,
        SRGB8_ALPHA8_ASTC_12x12;

    }

    public static enum InternalFormat {
        R8,
        R8_SNORM,
        R8UI,
        R8I,
        STENCIL8,
        R16F,
        R16UI,
        R16I,
        RG8,
        RG8_SNORM,
        RG8UI,
        RG8I,
        RGB565,
        RGB9_E5,
        RGB5_A1,
        RGBA4,
        DEPTH16,
        RGB8,
        SRGB8,
        RGB8_SNORM,
        RGB8UI,
        RGB8I,
        DEPTH24,
        R32F,
        R32UI,
        R32I,
        RG16F,
        RG16UI,
        RG16I,
        R11F_G11F_B10F,
        RGBA8,
        SRGB8_A8,
        RGBA8_SNORM,
        UNUSED,
        RGB10_A2,
        RGBA8UI,
        RGBA8I,
        DEPTH32F,
        DEPTH24_STENCIL8,
        DEPTH32F_STENCIL8,
        RGB16F,
        RGB16UI,
        RGB16I,
        RG32F,
        RG32UI,
        RG32I,
        RGBA16F,
        RGBA16UI,
        RGBA16I,
        RGB32F,
        RGB32UI,
        RGB32I,
        RGBA32F,
        RGBA32UI,
        RGBA32I,
        EAC_R11,
        EAC_R11_SIGNED,
        EAC_RG11,
        EAC_RG11_SIGNED,
        ETC2_RGB8,
        ETC2_SRGB8,
        ETC2_RGB8_A1,
        ETC2_SRGB8_A1,
        ETC2_EAC_RGBA8,
        ETC2_EAC_SRGBA8,
        DXT1_RGB,
        DXT1_RGBA,
        DXT3_RGBA,
        DXT5_RGBA,
        DXT1_SRGB,
        DXT1_SRGBA,
        DXT3_SRGBA,
        DXT5_SRGBA,
        RGBA_ASTC_4x4,
        RGBA_ASTC_5x4,
        RGBA_ASTC_5x5,
        RGBA_ASTC_6x5,
        RGBA_ASTC_6x6,
        RGBA_ASTC_8x5,
        RGBA_ASTC_8x6,
        RGBA_ASTC_8x8,
        RGBA_ASTC_10x5,
        RGBA_ASTC_10x6,
        RGBA_ASTC_10x8,
        RGBA_ASTC_10x10,
        RGBA_ASTC_12x10,
        RGBA_ASTC_12x12,
        SRGB8_ALPHA8_ASTC_4x4,
        SRGB8_ALPHA8_ASTC_5x4,
        SRGB8_ALPHA8_ASTC_5x5,
        SRGB8_ALPHA8_ASTC_6x5,
        SRGB8_ALPHA8_ASTC_6x6,
        SRGB8_ALPHA8_ASTC_8x5,
        SRGB8_ALPHA8_ASTC_8x6,
        SRGB8_ALPHA8_ASTC_8x8,
        SRGB8_ALPHA8_ASTC_10x5,
        SRGB8_ALPHA8_ASTC_10x6,
        SRGB8_ALPHA8_ASTC_10x8,
        SRGB8_ALPHA8_ASTC_10x10,
        SRGB8_ALPHA8_ASTC_12x10,
        SRGB8_ALPHA8_ASTC_12x12;

    }

    public static enum Sampler {
        SAMPLER_2D,
        SAMPLER_2D_ARRAY,
        SAMPLER_CUBEMAP,
        SAMPLER_EXTERNAL,
        SAMPLER_3D;

    }
}

