/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament;

import androidx.annotation.NonNull;
import androidx.annotation.Size;
import com.google.android.filament.Asserts;
import com.google.android.filament.Engine;
import com.google.android.filament.ToneMapper;

public class ColorGrading {
    long mNativeObject;

    public ColorGrading(long colorGrading) {
        this.mNativeObject = colorGrading;
    }

    public long getNativeObject() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Calling method on destroyed ColorGrading");
        }
        return this.mNativeObject;
    }

    void clearNativeObject() {
        this.mNativeObject = 0L;
    }

    private static native long nCreateBuilder();

    private static native void nDestroyBuilder(long var0);

    private static native void nBuilderQuality(long var0, int var2);

    private static native void nBuilderToneMapper(long var0, long var2);

    private static native void nBuilderToneMapping(long var0, int var2);

    private static native void nBuilderLuminanceScaling(long var0, boolean var2);

    private static native void nBuilderGamutMapping(long var0, boolean var2);

    private static native void nBuilderExposure(long var0, float var2);

    private static native void nBuilderNightAdaptation(long var0, float var2);

    private static native void nBuilderWhiteBalance(long var0, float var2, float var3);

    private static native void nBuilderChannelMixer(long var0, float[] var2, float[] var3, float[] var4);

    private static native void nBuilderShadowsMidtonesHighlights(long var0, float[] var2, float[] var3, float[] var4, float[] var5);

    private static native void nBuilderSlopeOffsetPower(long var0, float[] var2, float[] var3, float[] var4);

    private static native void nBuilderContrast(long var0, float var2);

    private static native void nBuilderVibrance(long var0, float var2);

    private static native void nBuilderSaturation(long var0, float var2);

    private static native void nBuilderCurves(long var0, float[] var2, float[] var3, float[] var4);

    private static native long nBuilderBuild(long var0, long var2);

    static /* synthetic */ long access$000() {
        return ColorGrading.nCreateBuilder();
    }

    public static class Builder {
        private final BuilderFinalizer mFinalizer;
        private final long mNativeBuilder = ColorGrading.access$000();

        public Builder() {
            this.mFinalizer = new BuilderFinalizer(this.mNativeBuilder);
        }

        public Builder quality(QualityLevel qualityLevel) {
            ColorGrading.nBuilderQuality(this.mNativeBuilder, qualityLevel.ordinal());
            return this;
        }

        public Builder toneMapper(ToneMapper toneMapper) {
            ColorGrading.nBuilderToneMapper(this.mNativeBuilder, toneMapper.getNativeObject());
            return this;
        }

        public Builder toneMapping(ToneMapping toneMapping) {
            ColorGrading.nBuilderToneMapping(this.mNativeBuilder, toneMapping.ordinal());
            return this;
        }

        public Builder luminanceScaling(boolean luminanceScaling) {
            ColorGrading.nBuilderLuminanceScaling(this.mNativeBuilder, luminanceScaling);
            return this;
        }

        public Builder gamutMapping(boolean gamutMapping) {
            ColorGrading.nBuilderGamutMapping(this.mNativeBuilder, gamutMapping);
            return this;
        }

        public Builder exposure(float exposure) {
            ColorGrading.nBuilderExposure(this.mNativeBuilder, exposure);
            return this;
        }

        public Builder nightAdaptation(float adaptation) {
            ColorGrading.nBuilderNightAdaptation(this.mNativeBuilder, adaptation);
            return this;
        }

        public Builder whiteBalance(float temperature, float tint) {
            ColorGrading.nBuilderWhiteBalance(this.mNativeBuilder, temperature, tint);
            return this;
        }

        public Builder channelMixer(@NonNull @Size(min=3L) float[] outRed, @NonNull @Size(min=3L) float[] outGreen, @NonNull @Size(min=3L) float[] outBlue) {
            Asserts.assertFloat3In(outRed);
            Asserts.assertFloat3In(outGreen);
            Asserts.assertFloat3In(outBlue);
            ColorGrading.nBuilderChannelMixer(this.mNativeBuilder, outRed, outGreen, outBlue);
            return this;
        }

        public Builder shadowsMidtonesHighlights(@NonNull @Size(min=4L) float[] shadows, @NonNull @Size(min=4L) float[] midtones, @NonNull @Size(min=4L) float[] highlights, @NonNull @Size(min=4L) float[] ranges) {
            Asserts.assertFloat4In(shadows);
            Asserts.assertFloat4In(midtones);
            Asserts.assertFloat4In(highlights);
            Asserts.assertFloat4In(ranges);
            ColorGrading.nBuilderShadowsMidtonesHighlights(this.mNativeBuilder, shadows, midtones, highlights, ranges);
            return this;
        }

        public Builder slopeOffsetPower(@NonNull @Size(min=3L) float[] slope, @NonNull @Size(min=3L) float[] offset, @NonNull @Size(min=3L) float[] power) {
            Asserts.assertFloat3In(slope);
            Asserts.assertFloat3In(offset);
            Asserts.assertFloat3In(power);
            ColorGrading.nBuilderSlopeOffsetPower(this.mNativeBuilder, slope, offset, power);
            return this;
        }

        public Builder contrast(float contrast) {
            ColorGrading.nBuilderContrast(this.mNativeBuilder, contrast);
            return this;
        }

        public Builder vibrance(float vibrance) {
            ColorGrading.nBuilderVibrance(this.mNativeBuilder, vibrance);
            return this;
        }

        public Builder saturation(float saturation) {
            ColorGrading.nBuilderSaturation(this.mNativeBuilder, saturation);
            return this;
        }

        public Builder curves(@NonNull @Size(min=3L) float[] shadowGamma, @NonNull @Size(min=3L) float[] midPoint, @NonNull @Size(min=3L) float[] highlightScale) {
            Asserts.assertFloat3In(shadowGamma);
            Asserts.assertFloat3In(midPoint);
            Asserts.assertFloat3In(highlightScale);
            ColorGrading.nBuilderCurves(this.mNativeBuilder, shadowGamma, midPoint, highlightScale);
            return this;
        }

        @NonNull
        public ColorGrading build(@NonNull Engine engine) {
            long nativeColorGrading = ColorGrading.nBuilderBuild(this.mNativeBuilder, engine.getNativeObject());
            if (nativeColorGrading == 0L) {
                throw new IllegalStateException("Couldn't create ColorGrading");
            }
            return new ColorGrading(nativeColorGrading);
        }

        private static class BuilderFinalizer {
            private final long mNativeObject;

            BuilderFinalizer(long nativeObject) {
                this.mNativeObject = nativeObject;
            }

            public void finalize() {
                try {
                    super.finalize();
                }
                catch (Throwable throwable) {
                }
                finally {
                    ColorGrading.nDestroyBuilder(this.mNativeObject);
                }
            }
        }
    }

    public static enum ToneMapping {
        LINEAR,
        ACES_LEGACY,
        ACES,
        FILMIC,
        DISPLAY_RANGE;

    }

    public static enum QualityLevel {
        LOW,
        MEDIUM,
        HIGH,
        ULTRA;

    }
}

