/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ext.okhttp;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.ExoPlayerLibraryInfo;
import com.google.android.exoplayer2.upstream.BaseDataSource;
import com.google.android.exoplayer2.upstream.DataSourceException;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.HttpDataSource;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import com.google.common.base.Predicate;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.CacheControl;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkHttpDataSource
extends BaseDataSource
implements HttpDataSource {
    private static final byte[] SKIP_BUFFER;
    private final Call.Factory callFactory;
    private final HttpDataSource.RequestProperties requestProperties;
    @Nullable
    private final String userAgent;
    @Nullable
    private final CacheControl cacheControl;
    @Nullable
    private final HttpDataSource.RequestProperties defaultRequestProperties;
    @Nullable
    private Predicate<String> contentTypePredicate;
    @Nullable
    private DataSpec dataSpec;
    @Nullable
    private Response response;
    @Nullable
    private InputStream responseByteStream;
    private boolean opened;
    private long bytesToSkip;
    private long bytesToRead;
    private long bytesSkipped;
    private long bytesRead;

    @Deprecated
    public OkHttpDataSource(Call.Factory callFactory) {
        this(callFactory, null);
    }

    @Deprecated
    public OkHttpDataSource(Call.Factory callFactory, @Nullable String userAgent) {
        this(callFactory, userAgent, null, null);
    }

    @Deprecated
    public OkHttpDataSource(Call.Factory callFactory, @Nullable String userAgent, @Nullable CacheControl cacheControl, @Nullable HttpDataSource.RequestProperties defaultRequestProperties) {
        this(callFactory, userAgent, cacheControl, defaultRequestProperties, null);
    }

    private OkHttpDataSource(Call.Factory callFactory, @Nullable String userAgent, @Nullable CacheControl cacheControl, @Nullable HttpDataSource.RequestProperties defaultRequestProperties, @Nullable Predicate<String> contentTypePredicate) {
        super(true);
        this.callFactory = (Call.Factory)Assertions.checkNotNull((Object)callFactory);
        this.userAgent = userAgent;
        this.cacheControl = cacheControl;
        this.defaultRequestProperties = defaultRequestProperties;
        this.contentTypePredicate = contentTypePredicate;
        this.requestProperties = new HttpDataSource.RequestProperties();
    }

    @Deprecated
    public void setContentTypePredicate(@Nullable Predicate<String> contentTypePredicate) {
        this.contentTypePredicate = contentTypePredicate;
    }

    @Nullable
    public Uri getUri() {
        return this.response == null ? null : Uri.parse((String)this.response.request().url().toString());
    }

    public int getResponseCode() {
        return this.response == null ? -1 : this.response.code();
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.response == null ? Collections.emptyMap() : this.response.headers().toMultimap();
    }

    public void setRequestProperty(String name, String value) {
        Assertions.checkNotNull((Object)name);
        Assertions.checkNotNull((Object)value);
        this.requestProperties.set(name, value);
    }

    public void clearRequestProperty(String name) {
        Assertions.checkNotNull((Object)name);
        this.requestProperties.remove(name);
    }

    public void clearAllRequestProperties() {
        this.requestProperties.clear();
    }

    public long open(DataSpec dataSpec) throws HttpDataSource.HttpDataSourceException {
        long contentLength;
        String contentType;
        ResponseBody responseBody;
        Response response;
        this.dataSpec = dataSpec;
        this.bytesRead = 0L;
        this.bytesSkipped = 0L;
        this.transferInitializing(dataSpec);
        Request request = this.makeRequest(dataSpec);
        try {
            response = this.response = this.callFactory.newCall(request).execute();
            responseBody = (ResponseBody)Assertions.checkNotNull((Object)response.body());
            this.responseByteStream = responseBody.byteStream();
        }
        catch (IOException e) {
            String message = e.getMessage();
            if (message != null && Util.toLowerInvariant((String)message).matches("cleartext communication.*not permitted.*")) {
                throw new HttpDataSource.CleartextNotPermittedException(e, dataSpec);
            }
            throw new HttpDataSource.HttpDataSourceException("Unable to connect", e, dataSpec, 1);
        }
        int responseCode = response.code();
        if (!response.isSuccessful()) {
            byte[] errorResponseBody;
            try {
                errorResponseBody = Util.toByteArray((InputStream)((InputStream)Assertions.checkNotNull((Object)this.responseByteStream)));
            }
            catch (IOException e) {
                errorResponseBody = Util.EMPTY_BYTE_ARRAY;
            }
            Map headers = response.headers().toMultimap();
            this.closeConnectionQuietly();
            HttpDataSource.InvalidResponseCodeException exception = new HttpDataSource.InvalidResponseCodeException(responseCode, response.message(), headers, dataSpec, errorResponseBody);
            if (responseCode == 416) {
                exception.initCause((Throwable)new DataSourceException(0));
            }
            throw exception;
        }
        MediaType mediaType = responseBody.contentType();
        String string = contentType = mediaType != null ? mediaType.toString() : "";
        if (this.contentTypePredicate != null && !this.contentTypePredicate.apply((Object)contentType)) {
            this.closeConnectionQuietly();
            throw new HttpDataSource.InvalidContentTypeException(contentType, dataSpec);
        }
        long l = this.bytesToSkip = responseCode == 200 && dataSpec.position != 0L ? dataSpec.position : 0L;
        this.bytesToRead = dataSpec.length != -1L ? dataSpec.length : ((contentLength = responseBody.contentLength()) != -1L ? contentLength - this.bytesToSkip : -1L);
        this.opened = true;
        this.transferStarted(dataSpec);
        return this.bytesToRead;
    }

    public int read(byte[] buffer, int offset, int readLength) throws HttpDataSource.HttpDataSourceException {
        try {
            this.skipInternal();
            return this.readInternal(buffer, offset, readLength);
        }
        catch (IOException e) {
            throw new HttpDataSource.HttpDataSourceException(e, (DataSpec)Assertions.checkNotNull((Object)this.dataSpec), 2);
        }
    }

    public void close() throws HttpDataSource.HttpDataSourceException {
        if (this.opened) {
            this.opened = false;
            this.transferEnded();
            this.closeConnectionQuietly();
        }
    }

    protected final long bytesSkipped() {
        return this.bytesSkipped;
    }

    protected final long bytesRead() {
        return this.bytesRead;
    }

    protected final long bytesRemaining() {
        return this.bytesToRead == -1L ? this.bytesToRead : this.bytesToRead - this.bytesRead;
    }

    private Request makeRequest(DataSpec dataSpec) throws HttpDataSource.HttpDataSourceException {
        long position = dataSpec.position;
        long length = dataSpec.length;
        HttpUrl url = HttpUrl.parse((String)dataSpec.uri.toString());
        if (url == null) {
            throw new HttpDataSource.HttpDataSourceException("Malformed URL", dataSpec, 1);
        }
        Request.Builder builder = new Request.Builder().url(url);
        if (this.cacheControl != null) {
            builder.cacheControl(this.cacheControl);
        }
        HashMap headers = new HashMap();
        if (this.defaultRequestProperties != null) {
            headers.putAll(this.defaultRequestProperties.getSnapshot());
        }
        headers.putAll(this.requestProperties.getSnapshot());
        headers.putAll(dataSpec.httpRequestHeaders);
        for (Map.Entry header : headers.entrySet()) {
            builder.header((String)header.getKey(), (String)header.getValue());
        }
        if (position != 0L || length != -1L) {
            String rangeRequest = "bytes=" + position + "-";
            if (length != -1L) {
                rangeRequest = rangeRequest + (position + length - 1L);
            }
            builder.addHeader("Range", rangeRequest);
        }
        if (this.userAgent != null) {
            builder.addHeader("User-Agent", this.userAgent);
        }
        if (!dataSpec.isFlagSet(1)) {
            builder.addHeader("Accept-Encoding", "identity");
        }
        RequestBody requestBody = null;
        if (dataSpec.httpBody != null) {
            requestBody = RequestBody.create(null, (byte[])dataSpec.httpBody);
        } else if (dataSpec.httpMethod == 2) {
            requestBody = RequestBody.create(null, (byte[])Util.EMPTY_BYTE_ARRAY);
        }
        builder.method(dataSpec.getHttpMethodString(), requestBody);
        return builder.build();
    }

    private void skipInternal() throws IOException {
        if (this.bytesSkipped == this.bytesToSkip) {
            return;
        }
        while (this.bytesSkipped != this.bytesToSkip) {
            int readLength = (int)Math.min(this.bytesToSkip - this.bytesSkipped, (long)SKIP_BUFFER.length);
            int read = ((InputStream)Util.castNonNull((Object)this.responseByteStream)).read(SKIP_BUFFER, 0, readLength);
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedIOException();
            }
            if (read == -1) {
                throw new EOFException();
            }
            this.bytesSkipped += (long)read;
            this.bytesTransferred(read);
        }
    }

    private int readInternal(byte[] buffer, int offset, int readLength) throws IOException {
        int read;
        if (readLength == 0) {
            return 0;
        }
        if (this.bytesToRead != -1L) {
            long bytesRemaining = this.bytesToRead - this.bytesRead;
            if (bytesRemaining == 0L) {
                return -1;
            }
            readLength = (int)Math.min((long)readLength, bytesRemaining);
        }
        if ((read = ((InputStream)Util.castNonNull((Object)this.responseByteStream)).read(buffer, offset, readLength)) == -1) {
            if (this.bytesToRead != -1L) {
                throw new EOFException();
            }
            return -1;
        }
        this.bytesRead += (long)read;
        this.bytesTransferred(read);
        return read;
    }

    private void closeConnectionQuietly() {
        if (this.response != null) {
            ((ResponseBody)Assertions.checkNotNull((Object)this.response.body())).close();
            this.response = null;
        }
        this.responseByteStream = null;
    }

    static {
        ExoPlayerLibraryInfo.registerModule((String)"goog.exo.okhttp");
        SKIP_BUFFER = new byte[4096];
    }

    public static final class Factory
    implements HttpDataSource.Factory {
        private final HttpDataSource.RequestProperties defaultRequestProperties;
        private final Call.Factory callFactory;
        @Nullable
        private String userAgent;
        @Nullable
        private TransferListener transferListener;
        @Nullable
        private CacheControl cacheControl;
        @Nullable
        private Predicate<String> contentTypePredicate;

        public Factory(Call.Factory callFactory) {
            this.callFactory = callFactory;
            this.defaultRequestProperties = new HttpDataSource.RequestProperties();
        }

        @Deprecated
        public final HttpDataSource.RequestProperties getDefaultRequestProperties() {
            return this.defaultRequestProperties;
        }

        public final Factory setDefaultRequestProperties(Map<String, String> defaultRequestProperties) {
            this.defaultRequestProperties.clearAndSet(defaultRequestProperties);
            return this;
        }

        public Factory setUserAgent(@Nullable String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Factory setCacheControl(@Nullable CacheControl cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        public Factory setContentTypePredicate(@Nullable Predicate<String> contentTypePredicate) {
            this.contentTypePredicate = contentTypePredicate;
            return this;
        }

        public Factory setTransferListener(@Nullable TransferListener transferListener) {
            this.transferListener = transferListener;
            return this;
        }

        public OkHttpDataSource createDataSource() {
            OkHttpDataSource dataSource = new OkHttpDataSource(this.callFactory, this.userAgent, this.cacheControl, this.defaultRequestProperties, this.contentTypePredicate);
            if (this.transferListener != null) {
                dataSource.addTransferListener(this.transferListener);
            }
            return dataSource;
        }
    }
}

