/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ext.okhttp;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.ExoPlayerLibraryInfo;
import com.google.android.exoplayer2.ext.okhttp.OkHttpDataSource;
import com.google.android.exoplayer2.upstream.HttpDataSource;
import com.google.android.exoplayer2.upstream.TransferListener;
import okhttp3.CacheControl;
import okhttp3.Call;

public final class OkHttpDataSourceFactory
extends HttpDataSource.BaseFactory {
    private final Call.Factory callFactory;
    @Nullable
    private final String userAgent;
    @Nullable
    private final TransferListener listener;
    @Nullable
    private final CacheControl cacheControl;

    public OkHttpDataSourceFactory(Call.Factory callFactory) {
        this(callFactory, ExoPlayerLibraryInfo.DEFAULT_USER_AGENT, null, null);
    }

    public OkHttpDataSourceFactory(Call.Factory callFactory, @Nullable String userAgent) {
        this(callFactory, userAgent, null, null);
    }

    public OkHttpDataSourceFactory(Call.Factory callFactory, @Nullable String userAgent, @Nullable CacheControl cacheControl) {
        this(callFactory, userAgent, null, cacheControl);
    }

    public OkHttpDataSourceFactory(Call.Factory callFactory, @Nullable String userAgent, @Nullable TransferListener listener) {
        this(callFactory, userAgent, listener, null);
    }

    public OkHttpDataSourceFactory(Call.Factory callFactory, @Nullable String userAgent, @Nullable TransferListener listener, @Nullable CacheControl cacheControl) {
        this.callFactory = callFactory;
        this.userAgent = userAgent;
        this.listener = listener;
        this.cacheControl = cacheControl;
    }

    protected OkHttpDataSource createDataSourceInternal(HttpDataSource.RequestProperties defaultRequestProperties) {
        OkHttpDataSource dataSource = new OkHttpDataSource(this.callFactory, this.userAgent, this.cacheControl, defaultRequestProperties);
        if (this.listener != null) {
            dataSource.addTransferListener(this.listener);
        }
        return dataSource;
    }
}

