/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ext.mediasession;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.media.session.PlaybackStateCompat;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.ControlDispatcher;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.ext.mediasession.MediaSessionConnector;
import com.google.android.exoplayer2.ext.mediasession.R;
import com.google.android.exoplayer2.util.RepeatModeUtil;

public final class RepeatModeActionProvider
implements MediaSessionConnector.CustomActionProvider {
    public static final int DEFAULT_REPEAT_TOGGLE_MODES = 3;
    private static final String ACTION_REPEAT_MODE = "ACTION_EXO_REPEAT_MODE";
    private final int repeatToggleModes;
    private final CharSequence repeatAllDescription;
    private final CharSequence repeatOneDescription;
    private final CharSequence repeatOffDescription;

    public RepeatModeActionProvider(Context context) {
        this(context, 3);
    }

    public RepeatModeActionProvider(Context context, int repeatToggleModes) {
        this.repeatToggleModes = repeatToggleModes;
        this.repeatAllDescription = context.getString(R.string.exo_media_action_repeat_all_description);
        this.repeatOneDescription = context.getString(R.string.exo_media_action_repeat_one_description);
        this.repeatOffDescription = context.getString(R.string.exo_media_action_repeat_off_description);
    }

    @Override
    public void onCustomAction(Player player, ControlDispatcher controlDispatcher, String action, @Nullable Bundle extras) {
        int proposedMode;
        int mode = player.getRepeatMode();
        if (mode != (proposedMode = RepeatModeUtil.getNextRepeatMode((int)mode, (int)this.repeatToggleModes))) {
            controlDispatcher.dispatchSetRepeatMode(player, proposedMode);
        }
    }

    @Override
    public PlaybackStateCompat.CustomAction getCustomAction(Player player) {
        int iconResourceId;
        CharSequence actionLabel;
        switch (player.getRepeatMode()) {
            case 1: {
                actionLabel = this.repeatOneDescription;
                iconResourceId = R.drawable.exo_media_action_repeat_one;
                break;
            }
            case 2: {
                actionLabel = this.repeatAllDescription;
                iconResourceId = R.drawable.exo_media_action_repeat_all;
                break;
            }
            default: {
                actionLabel = this.repeatOffDescription;
                iconResourceId = R.drawable.exo_media_action_repeat_off;
            }
        }
        PlaybackStateCompat.CustomAction.Builder repeatBuilder = new PlaybackStateCompat.CustomAction.Builder(ACTION_REPEAT_MODE, actionLabel, iconResourceId);
        return repeatBuilder.build();
    }
}

