/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ext.ima;

import android.content.Context;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.google.ads.interactivemedia.v3.api.AdDisplayContainer;
import com.google.ads.interactivemedia.v3.api.AdError;
import com.google.ads.interactivemedia.v3.api.AdErrorEvent;
import com.google.ads.interactivemedia.v3.api.AdEvent;
import com.google.ads.interactivemedia.v3.api.AdsLoader;
import com.google.ads.interactivemedia.v3.api.AdsRenderingSettings;
import com.google.ads.interactivemedia.v3.api.AdsRequest;
import com.google.ads.interactivemedia.v3.api.CompanionAdSlot;
import com.google.ads.interactivemedia.v3.api.FriendlyObstruction;
import com.google.ads.interactivemedia.v3.api.FriendlyObstructionPurpose;
import com.google.ads.interactivemedia.v3.api.ImaSdkSettings;
import com.google.ads.interactivemedia.v3.api.UiElement;
import com.google.ads.interactivemedia.v3.api.player.VideoAdPlayer;
import com.google.ads.interactivemedia.v3.api.player.VideoProgressUpdate;
import com.google.android.exoplayer2.upstream.DataSchemeDataSource;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;

final class ImaUtil {
    public static final int TIMEOUT_UNSET = -1;
    public static final int BITRATE_UNSET = -1;

    public static FriendlyObstructionPurpose getFriendlyObstructionPurpose(int purpose) {
        switch (purpose) {
            case 0: {
                return FriendlyObstructionPurpose.VIDEO_CONTROLS;
            }
            case 1: {
                return FriendlyObstructionPurpose.CLOSE_AD;
            }
            case 3: {
                return FriendlyObstructionPurpose.NOT_VISIBLE;
            }
        }
        return FriendlyObstructionPurpose.OTHER;
    }

    public static long[] getAdGroupTimesUsForCuePoints(List<Float> cuePoints) {
        if (cuePoints.isEmpty()) {
            return new long[]{0L};
        }
        int count = cuePoints.size();
        long[] adGroupTimesUs = new long[count];
        int adGroupIndex = 0;
        for (int i = 0; i < count; ++i) {
            double cuePoint = cuePoints.get(i).floatValue();
            if (cuePoint == -1.0) {
                adGroupTimesUs[count - 1] = Long.MIN_VALUE;
                continue;
            }
            adGroupTimesUs[adGroupIndex++] = Math.round(1000000.0 * cuePoint);
        }
        Arrays.sort(adGroupTimesUs, 0, adGroupIndex);
        return adGroupTimesUs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AdsRequest getAdsRequestForAdTagDataSpec(ImaFactory imaFactory, DataSpec adTagDataSpec) throws IOException {
        AdsRequest request = imaFactory.createAdsRequest();
        if ("data".equals(adTagDataSpec.uri.getScheme())) {
            try (DataSchemeDataSource dataSchemeDataSource = new DataSchemeDataSource();){
                dataSchemeDataSource.open(adTagDataSpec);
                request.setAdsResponse(Util.fromUtf8Bytes((byte[])Util.readToEnd((DataSource)dataSchemeDataSource)));
            }
        } else {
            request.setAdTagUrl(adTagDataSpec.uri.toString());
        }
        return request;
    }

    public static boolean isAdGroupLoadError(AdError adError) {
        return adError.getErrorCode() == AdError.AdErrorCode.VAST_LINEAR_ASSET_MISMATCH || adError.getErrorCode() == AdError.AdErrorCode.UNKNOWN_ERROR;
    }

    public static Looper getImaLooper() {
        return Looper.getMainLooper();
    }

    public static String getStringForVideoProgressUpdate(VideoProgressUpdate videoProgressUpdate) {
        if (VideoProgressUpdate.VIDEO_TIME_NOT_READY.equals((Object)videoProgressUpdate)) {
            return "not ready";
        }
        return Util.formatInvariant((String)"%d ms of %d ms", (Object[])new Object[]{videoProgressUpdate.getCurrentTimeMs(), videoProgressUpdate.getDurationMs()});
    }

    private ImaUtil() {
    }

    public static final class Configuration {
        public final long adPreloadTimeoutMs;
        public final int vastLoadTimeoutMs;
        public final int mediaLoadTimeoutMs;
        public final boolean focusSkipButtonWhenAvailable;
        public final boolean playAdBeforeStartPosition;
        public final int mediaBitrate;
        @Nullable
        public final Boolean enableContinuousPlayback;
        @Nullable
        public final List<String> adMediaMimeTypes;
        @Nullable
        public final Set<UiElement> adUiElements;
        @Nullable
        public final Collection<CompanionAdSlot> companionAdSlots;
        @Nullable
        public final AdErrorEvent.AdErrorListener applicationAdErrorListener;
        @Nullable
        public final AdEvent.AdEventListener applicationAdEventListener;
        @Nullable
        public final VideoAdPlayer.VideoAdPlayerCallback applicationVideoAdPlayerCallback;
        @Nullable
        public final ImaSdkSettings imaSdkSettings;
        public final boolean debugModeEnabled;

        public Configuration(long adPreloadTimeoutMs, int vastLoadTimeoutMs, int mediaLoadTimeoutMs, boolean focusSkipButtonWhenAvailable, boolean playAdBeforeStartPosition, int mediaBitrate, @Nullable Boolean enableContinuousPlayback, @Nullable List<String> adMediaMimeTypes, @Nullable Set<UiElement> adUiElements, @Nullable Collection<CompanionAdSlot> companionAdSlots, @Nullable AdErrorEvent.AdErrorListener applicationAdErrorListener, @Nullable AdEvent.AdEventListener applicationAdEventListener, @Nullable VideoAdPlayer.VideoAdPlayerCallback applicationVideoAdPlayerCallback, @Nullable ImaSdkSettings imaSdkSettings, boolean debugModeEnabled) {
            this.adPreloadTimeoutMs = adPreloadTimeoutMs;
            this.vastLoadTimeoutMs = vastLoadTimeoutMs;
            this.mediaLoadTimeoutMs = mediaLoadTimeoutMs;
            this.focusSkipButtonWhenAvailable = focusSkipButtonWhenAvailable;
            this.playAdBeforeStartPosition = playAdBeforeStartPosition;
            this.mediaBitrate = mediaBitrate;
            this.enableContinuousPlayback = enableContinuousPlayback;
            this.adMediaMimeTypes = adMediaMimeTypes;
            this.adUiElements = adUiElements;
            this.companionAdSlots = companionAdSlots;
            this.applicationAdErrorListener = applicationAdErrorListener;
            this.applicationAdEventListener = applicationAdEventListener;
            this.applicationVideoAdPlayerCallback = applicationVideoAdPlayerCallback;
            this.imaSdkSettings = imaSdkSettings;
            this.debugModeEnabled = debugModeEnabled;
        }
    }

    public static interface ImaFactory {
        public ImaSdkSettings createImaSdkSettings();

        public AdsRenderingSettings createAdsRenderingSettings();

        public AdDisplayContainer createAdDisplayContainer(ViewGroup var1, VideoAdPlayer var2);

        public AdDisplayContainer createAudioAdDisplayContainer(Context var1, VideoAdPlayer var2);

        public FriendlyObstruction createFriendlyObstruction(View var1, FriendlyObstructionPurpose var2, @Nullable String var3);

        public AdsRequest createAdsRequest();

        public AdsLoader createAdsLoader(Context var1, ImaSdkSettings var2, AdDisplayContainer var3);
    }
}

