/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ext.ima;

import android.content.Context;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.ads.interactivemedia.v3.api.AdDisplayContainer;
import com.google.ads.interactivemedia.v3.api.AdErrorEvent;
import com.google.ads.interactivemedia.v3.api.AdEvent;
import com.google.ads.interactivemedia.v3.api.AdsRenderingSettings;
import com.google.ads.interactivemedia.v3.api.AdsRequest;
import com.google.ads.interactivemedia.v3.api.CompanionAdSlot;
import com.google.ads.interactivemedia.v3.api.FriendlyObstruction;
import com.google.ads.interactivemedia.v3.api.FriendlyObstructionPurpose;
import com.google.ads.interactivemedia.v3.api.ImaSdkFactory;
import com.google.ads.interactivemedia.v3.api.ImaSdkSettings;
import com.google.ads.interactivemedia.v3.api.UiElement;
import com.google.ads.interactivemedia.v3.api.player.VideoAdPlayer;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.ExoPlayerLibraryInfo;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.ext.ima.AdTagLoader;
import com.google.android.exoplayer2.ext.ima.ImaUtil;
import com.google.android.exoplayer2.source.ads.AdsLoader;
import com.google.android.exoplayer2.source.ads.AdsMediaSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public final class ImaAdsLoader
implements Player.EventListener,
AdsLoader {
    private final ImaUtil.Configuration configuration;
    private final Context context;
    private final ImaUtil.ImaFactory imaFactory;
    private final HashMap<Object, AdTagLoader> adTagLoaderByAdsId;
    private final HashMap<AdsMediaSource, AdTagLoader> adTagLoaderByAdsMediaSource;
    private final Timeline.Period period;
    private final Timeline.Window window;
    private boolean wasSetPlayerCalled;
    @Nullable
    private Player nextPlayer;
    private List<String> supportedMimeTypes;
    @Nullable
    private Player player;
    @Nullable
    private AdTagLoader currentAdTagLoader;

    private ImaAdsLoader(Context context, ImaUtil.Configuration configuration, ImaUtil.ImaFactory imaFactory) {
        this.context = context.getApplicationContext();
        this.configuration = configuration;
        this.imaFactory = imaFactory;
        this.supportedMimeTypes = ImmutableList.of();
        this.adTagLoaderByAdsId = new HashMap();
        this.adTagLoaderByAdsMediaSource = new HashMap();
        this.period = new Timeline.Period();
        this.window = new Timeline.Window();
    }

    @Nullable
    public com.google.ads.interactivemedia.v3.api.AdsLoader getAdsLoader() {
        return this.currentAdTagLoader != null ? this.currentAdTagLoader.getAdsLoader() : null;
    }

    @Nullable
    public AdDisplayContainer getAdDisplayContainer() {
        return this.currentAdTagLoader != null ? this.currentAdTagLoader.getAdDisplayContainer() : null;
    }

    public void requestAds(DataSpec adTagDataSpec, Object adsId, @Nullable ViewGroup adViewGroup) {
        if (!this.adTagLoaderByAdsId.containsKey(adsId)) {
            AdTagLoader adTagLoader = new AdTagLoader(this.context, this.configuration, this.imaFactory, this.supportedMimeTypes, adTagDataSpec, adsId, adViewGroup);
            this.adTagLoaderByAdsId.put(adsId, adTagLoader);
        }
    }

    public void skipAd() {
        if (this.currentAdTagLoader != null) {
            this.currentAdTagLoader.skipAd();
        }
    }

    public void focusSkipButton() {
        if (this.currentAdTagLoader != null) {
            this.currentAdTagLoader.focusSkipButton();
        }
    }

    public void setPlayer(@Nullable Player player) {
        Assertions.checkState((Looper.myLooper() == ImaUtil.getImaLooper() ? 1 : 0) != 0);
        Assertions.checkState((player == null || player.getApplicationLooper() == ImaUtil.getImaLooper() ? 1 : 0) != 0);
        this.nextPlayer = player;
        this.wasSetPlayerCalled = true;
    }

    public void setSupportedContentTypes(int ... contentTypes) {
        ArrayList<String> supportedMimeTypes = new ArrayList<String>();
        for (int contentType : contentTypes) {
            if (contentType == 0) {
                supportedMimeTypes.add("application/dash+xml");
                continue;
            }
            if (contentType == 2) {
                supportedMimeTypes.add("application/x-mpegURL");
                continue;
            }
            if (contentType != 3) continue;
            supportedMimeTypes.addAll(Arrays.asList("video/mp4", "video/webm", "video/3gpp", "audio/mp4", "audio/mpeg"));
        }
        this.supportedMimeTypes = Collections.unmodifiableList(supportedMimeTypes);
    }

    public void start(AdsMediaSource adsMediaSource, DataSpec adTagDataSpec, Object adsId, AdsLoader.AdViewProvider adViewProvider, AdsLoader.EventListener eventListener) {
        AdTagLoader adTagLoader;
        Assertions.checkState((boolean)this.wasSetPlayerCalled, (Object)"Set player using adsLoader.setPlayer before preparing the player.");
        if (this.adTagLoaderByAdsMediaSource.isEmpty()) {
            this.player = this.nextPlayer;
            Player player = this.player;
            if (player == null) {
                return;
            }
            player.addListener((Player.EventListener)this);
        }
        if ((adTagLoader = this.adTagLoaderByAdsId.get(adsId)) == null) {
            this.requestAds(adTagDataSpec, adsId, adViewProvider.getAdViewGroup());
            adTagLoader = this.adTagLoaderByAdsId.get(adsId);
        }
        this.adTagLoaderByAdsMediaSource.put(adsMediaSource, (AdTagLoader)Assertions.checkNotNull((Object)adTagLoader));
        adTagLoader.addListenerWithAdView(eventListener, adViewProvider);
        this.maybeUpdateCurrentAdTagLoader();
    }

    public void stop(AdsMediaSource adsMediaSource, AdsLoader.EventListener eventListener) {
        AdTagLoader removedAdTagLoader = this.adTagLoaderByAdsMediaSource.remove(adsMediaSource);
        this.maybeUpdateCurrentAdTagLoader();
        if (removedAdTagLoader != null) {
            removedAdTagLoader.removeListener(eventListener);
        }
        if (this.player != null && this.adTagLoaderByAdsMediaSource.isEmpty()) {
            this.player.removeListener((Player.EventListener)this);
            this.player = null;
        }
    }

    public void release() {
        if (this.player != null) {
            this.player.removeListener((Player.EventListener)this);
            this.player = null;
            this.maybeUpdateCurrentAdTagLoader();
        }
        this.nextPlayer = null;
        for (AdTagLoader adTagLoader : this.adTagLoaderByAdsMediaSource.values()) {
            adTagLoader.release();
        }
        this.adTagLoaderByAdsMediaSource.clear();
        for (AdTagLoader adTagLoader : this.adTagLoaderByAdsId.values()) {
            adTagLoader.release();
        }
        this.adTagLoaderByAdsId.clear();
    }

    public void handlePrepareComplete(AdsMediaSource adsMediaSource, int adGroupIndex, int adIndexInAdGroup) {
        if (this.player == null) {
            return;
        }
        ((AdTagLoader)Assertions.checkNotNull((Object)this.adTagLoaderByAdsMediaSource.get(adsMediaSource))).handlePrepareComplete(adGroupIndex, adIndexInAdGroup);
    }

    public void handlePrepareError(AdsMediaSource adsMediaSource, int adGroupIndex, int adIndexInAdGroup, IOException exception) {
        if (this.player == null) {
            return;
        }
        ((AdTagLoader)Assertions.checkNotNull((Object)this.adTagLoaderByAdsMediaSource.get(adsMediaSource))).handlePrepareError(adGroupIndex, adIndexInAdGroup, exception);
    }

    public void onTimelineChanged(Timeline timeline, int reason) {
        if (timeline.isEmpty()) {
            return;
        }
        this.maybeUpdateCurrentAdTagLoader();
        this.maybePreloadNextPeriodAds();
    }

    public void onPositionDiscontinuity(int reason) {
        this.maybeUpdateCurrentAdTagLoader();
        this.maybePreloadNextPeriodAds();
    }

    public void onShuffleModeEnabledChanged(boolean shuffleModeEnabled) {
        this.maybePreloadNextPeriodAds();
    }

    public void onRepeatModeChanged(int repeatMode) {
        this.maybePreloadNextPeriodAds();
    }

    private void maybeUpdateCurrentAdTagLoader() {
        AdTagLoader oldAdTagLoader = this.currentAdTagLoader;
        AdTagLoader newAdTagLoader = this.getCurrentAdTagLoader();
        if (!Util.areEqual((Object)oldAdTagLoader, (Object)newAdTagLoader)) {
            if (oldAdTagLoader != null) {
                oldAdTagLoader.deactivate();
            }
            this.currentAdTagLoader = newAdTagLoader;
            if (newAdTagLoader != null) {
                newAdTagLoader.activate((Player)Assertions.checkNotNull((Object)this.player));
            }
        }
    }

    @Nullable
    private AdTagLoader getCurrentAdTagLoader() {
        Player player = this.player;
        if (player == null) {
            return null;
        }
        Timeline timeline = player.getCurrentTimeline();
        if (timeline.isEmpty()) {
            return null;
        }
        int periodIndex = player.getCurrentPeriodIndex();
        Object adsId = timeline.getPeriod(periodIndex, this.period).getAdsId();
        if (adsId == null) {
            return null;
        }
        AdTagLoader adTagLoader = this.adTagLoaderByAdsId.get(adsId);
        if (adTagLoader == null || !this.adTagLoaderByAdsMediaSource.containsValue(adTagLoader)) {
            return null;
        }
        return adTagLoader;
    }

    private void maybePreloadNextPeriodAds() {
        Player player = this.player;
        if (player == null) {
            return;
        }
        Timeline timeline = player.getCurrentTimeline();
        if (timeline.isEmpty()) {
            return;
        }
        int nextPeriodIndex = timeline.getNextPeriodIndex(player.getCurrentPeriodIndex(), this.period, this.window, player.getRepeatMode(), player.getShuffleModeEnabled());
        if (nextPeriodIndex == -1) {
            return;
        }
        timeline.getPeriod(nextPeriodIndex, this.period);
        Object nextAdsId = this.period.getAdsId();
        if (nextAdsId == null) {
            return;
        }
        AdTagLoader nextAdTagLoader = this.adTagLoaderByAdsId.get(nextAdsId);
        if (nextAdTagLoader == null || nextAdTagLoader == this.currentAdTagLoader) {
            return;
        }
        long periodPositionUs = (Long)timeline.getPeriodPosition((Timeline.Window)this.window, (Timeline.Period)this.period, (int)this.period.windowIndex, (long)-9223372036854775807L).second;
        nextAdTagLoader.maybePreloadAds(C.usToMs((long)periodPositionUs), C.usToMs((long)this.period.durationUs));
    }

    static {
        ExoPlayerLibraryInfo.registerModule((String)"goog.exo.ima");
    }

    private static final class DefaultImaFactory
    implements ImaUtil.ImaFactory {
        private DefaultImaFactory() {
        }

        @Override
        public ImaSdkSettings createImaSdkSettings() {
            ImaSdkSettings settings = ImaSdkFactory.getInstance().createImaSdkSettings();
            settings.setLanguage(Util.getSystemLanguageCodes()[0]);
            return settings;
        }

        @Override
        public AdsRenderingSettings createAdsRenderingSettings() {
            return ImaSdkFactory.getInstance().createAdsRenderingSettings();
        }

        @Override
        public AdDisplayContainer createAdDisplayContainer(ViewGroup container, VideoAdPlayer player) {
            return ImaSdkFactory.createAdDisplayContainer((ViewGroup)container, (VideoAdPlayer)player);
        }

        @Override
        public AdDisplayContainer createAudioAdDisplayContainer(Context context, VideoAdPlayer player) {
            return ImaSdkFactory.createAudioAdDisplayContainer((Context)context, (VideoAdPlayer)player);
        }

        @Override
        public FriendlyObstruction createFriendlyObstruction(View view, FriendlyObstructionPurpose friendlyObstructionPurpose, @Nullable String reasonDetail) {
            return ImaSdkFactory.getInstance().createFriendlyObstruction(view, friendlyObstructionPurpose, reasonDetail);
        }

        @Override
        public AdsRequest createAdsRequest() {
            return ImaSdkFactory.getInstance().createAdsRequest();
        }

        @Override
        public com.google.ads.interactivemedia.v3.api.AdsLoader createAdsLoader(Context context, ImaSdkSettings imaSdkSettings, AdDisplayContainer adDisplayContainer) {
            return ImaSdkFactory.getInstance().createAdsLoader(context, imaSdkSettings, adDisplayContainer);
        }
    }

    public static final class Builder {
        public static final long DEFAULT_AD_PRELOAD_TIMEOUT_MS = 10000L;
        private final Context context;
        @Nullable
        private ImaSdkSettings imaSdkSettings;
        @Nullable
        private AdErrorEvent.AdErrorListener adErrorListener;
        @Nullable
        private AdEvent.AdEventListener adEventListener;
        @Nullable
        private VideoAdPlayer.VideoAdPlayerCallback videoAdPlayerCallback;
        @Nullable
        private List<String> adMediaMimeTypes;
        @Nullable
        private Set<UiElement> adUiElements;
        @Nullable
        private Collection<CompanionAdSlot> companionAdSlots;
        @Nullable
        private Boolean enableContinuousPlayback;
        private long adPreloadTimeoutMs;
        private int vastLoadTimeoutMs;
        private int mediaLoadTimeoutMs;
        private int mediaBitrate;
        private boolean focusSkipButtonWhenAvailable;
        private boolean playAdBeforeStartPosition;
        private boolean debugModeEnabled;
        private ImaUtil.ImaFactory imaFactory;

        public Builder(Context context) {
            this.context = ((Context)Assertions.checkNotNull((Object)context)).getApplicationContext();
            this.adPreloadTimeoutMs = 10000L;
            this.vastLoadTimeoutMs = -1;
            this.mediaLoadTimeoutMs = -1;
            this.mediaBitrate = -1;
            this.focusSkipButtonWhenAvailable = true;
            this.playAdBeforeStartPosition = true;
            this.imaFactory = new DefaultImaFactory();
        }

        public Builder setImaSdkSettings(ImaSdkSettings imaSdkSettings) {
            this.imaSdkSettings = (ImaSdkSettings)Assertions.checkNotNull((Object)imaSdkSettings);
            return this;
        }

        public Builder setAdErrorListener(AdErrorEvent.AdErrorListener adErrorListener) {
            this.adErrorListener = (AdErrorEvent.AdErrorListener)Assertions.checkNotNull((Object)adErrorListener);
            return this;
        }

        public Builder setAdEventListener(AdEvent.AdEventListener adEventListener) {
            this.adEventListener = (AdEvent.AdEventListener)Assertions.checkNotNull((Object)adEventListener);
            return this;
        }

        public Builder setVideoAdPlayerCallback(VideoAdPlayer.VideoAdPlayerCallback videoAdPlayerCallback) {
            this.videoAdPlayerCallback = (VideoAdPlayer.VideoAdPlayerCallback)Assertions.checkNotNull((Object)videoAdPlayerCallback);
            return this;
        }

        public Builder setAdUiElements(Set<UiElement> adUiElements) {
            this.adUiElements = ImmutableSet.copyOf((Collection)((Collection)Assertions.checkNotNull(adUiElements)));
            return this;
        }

        public Builder setCompanionAdSlots(Collection<CompanionAdSlot> companionAdSlots) {
            this.companionAdSlots = ImmutableList.copyOf((Collection)((Collection)Assertions.checkNotNull(companionAdSlots)));
            return this;
        }

        public Builder setAdMediaMimeTypes(List<String> adMediaMimeTypes) {
            this.adMediaMimeTypes = ImmutableList.copyOf((Collection)((Collection)Assertions.checkNotNull(adMediaMimeTypes)));
            return this;
        }

        public Builder setEnableContinuousPlayback(boolean enableContinuousPlayback) {
            this.enableContinuousPlayback = enableContinuousPlayback;
            return this;
        }

        public Builder setAdPreloadTimeoutMs(long adPreloadTimeoutMs) {
            Assertions.checkArgument((adPreloadTimeoutMs == -9223372036854775807L || adPreloadTimeoutMs > 0L ? 1 : 0) != 0);
            this.adPreloadTimeoutMs = adPreloadTimeoutMs;
            return this;
        }

        public Builder setVastLoadTimeoutMs(int vastLoadTimeoutMs) {
            Assertions.checkArgument((vastLoadTimeoutMs > 0 ? 1 : 0) != 0);
            this.vastLoadTimeoutMs = vastLoadTimeoutMs;
            return this;
        }

        public Builder setMediaLoadTimeoutMs(int mediaLoadTimeoutMs) {
            Assertions.checkArgument((mediaLoadTimeoutMs > 0 ? 1 : 0) != 0);
            this.mediaLoadTimeoutMs = mediaLoadTimeoutMs;
            return this;
        }

        public Builder setMaxMediaBitrate(int bitrate) {
            Assertions.checkArgument((bitrate > 0 ? 1 : 0) != 0);
            this.mediaBitrate = bitrate;
            return this;
        }

        public Builder setFocusSkipButtonWhenAvailable(boolean focusSkipButtonWhenAvailable) {
            this.focusSkipButtonWhenAvailable = focusSkipButtonWhenAvailable;
            return this;
        }

        public Builder setPlayAdBeforeStartPosition(boolean playAdBeforeStartPosition) {
            this.playAdBeforeStartPosition = playAdBeforeStartPosition;
            return this;
        }

        public Builder setDebugModeEnabled(boolean debugModeEnabled) {
            this.debugModeEnabled = debugModeEnabled;
            return this;
        }

        @VisibleForTesting
        Builder setImaFactory(ImaUtil.ImaFactory imaFactory) {
            this.imaFactory = (ImaUtil.ImaFactory)Assertions.checkNotNull((Object)imaFactory);
            return this;
        }

        public ImaAdsLoader build() {
            return new ImaAdsLoader(this.context, new ImaUtil.Configuration(this.adPreloadTimeoutMs, this.vastLoadTimeoutMs, this.mediaLoadTimeoutMs, this.focusSkipButtonWhenAvailable, this.playAdBeforeStartPosition, this.mediaBitrate, this.enableContinuousPlayback, this.adMediaMimeTypes, this.adUiElements, this.companionAdSlots, this.adErrorListener, this.adEventListener, this.videoAdPlayerCallback, this.imaSdkSettings, this.debugModeEnabled), this.imaFactory);
        }
    }
}

