/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ext.ima;

import com.google.android.exoplayer2.source.ads.AdPlaybackState;
import java.util.Arrays;
import java.util.List;

final class AdPlaybackStateFactory {
    private AdPlaybackStateFactory() {
    }

    public static AdPlaybackState fromCuePoints(List<Float> cuePoints) {
        if (cuePoints.isEmpty()) {
            return new AdPlaybackState(new long[]{0L});
        }
        int count = cuePoints.size();
        long[] adGroupTimesUs = new long[count];
        int adGroupIndex = 0;
        for (int i = 0; i < count; ++i) {
            double cuePoint = cuePoints.get(i).floatValue();
            if (cuePoint == -1.0) {
                adGroupTimesUs[count - 1] = Long.MIN_VALUE;
                continue;
            }
            adGroupTimesUs[adGroupIndex++] = Math.round(1000000.0 * cuePoint);
        }
        Arrays.sort(adGroupTimesUs, 0, adGroupIndex);
        return new AdPlaybackState(adGroupTimesUs);
    }
}

