/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ext.cronet;

import android.content.Context;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.chromium.net.CronetEngine;
import org.chromium.net.CronetProvider;

@Deprecated
public final class CronetUtil {
    private static final String TAG = "CronetUtil";

    @Nullable
    public static CronetEngine buildCronetEngine(Context context) {
        return CronetUtil.buildCronetEngine(context, null, false);
    }

    @Nullable
    public static CronetEngine buildCronetEngine(Context context, @Nullable String userAgent, boolean preferGooglePlayServices) {
        ArrayList cronetProviders = new ArrayList(CronetProvider.getAllProviders((Context)context));
        for (int i = cronetProviders.size() - 1; i >= 0; --i) {
            if (((CronetProvider)cronetProviders.get(i)).isEnabled() && !"Fallback-Cronet-Provider".equals(((CronetProvider)cronetProviders.get(i)).getName())) continue;
            cronetProviders.remove(i);
        }
        CronetProviderComparator providerComparator = new CronetProviderComparator(preferGooglePlayServices);
        Collections.sort(cronetProviders, providerComparator);
        for (int i = 0; i < cronetProviders.size(); ++i) {
            String providerName = ((CronetProvider)cronetProviders.get(i)).getName();
            try {
                CronetEngine.Builder cronetEngineBuilder = ((CronetProvider)cronetProviders.get(i)).createBuilder();
                if (userAgent != null) {
                    cronetEngineBuilder.setUserAgent(userAgent);
                }
                CronetEngine cronetEngine = cronetEngineBuilder.build();
                Log.d((String)TAG, (String)("CronetEngine built using " + providerName));
                return cronetEngine;
            }
            catch (SecurityException e) {
                Log.w((String)TAG, (String)"Failed to build CronetEngine. Please check that the process has android.permission.ACCESS_NETWORK_STATE.");
                continue;
            }
            catch (UnsatisfiedLinkError e) {
                Log.w((String)TAG, (String)"Failed to link Cronet binaries. Please check that native Cronet binaries arebundled into your app.");
            }
        }
        Log.w((String)TAG, (String)"CronetEngine could not be built.");
        return null;
    }

    private CronetUtil() {
    }

    private static class CronetProviderComparator
    implements Comparator<CronetProvider> {
        private static final String GOOGLE_PLAY_SERVICES_PROVIDER_NAME = "Google-Play-Services-Cronet-Provider";
        private final boolean preferGooglePlayServices;

        public CronetProviderComparator(boolean preferGooglePlayServices) {
            this.preferGooglePlayServices = preferGooglePlayServices;
        }

        @Override
        public int compare(CronetProvider providerLeft, CronetProvider providerRight) {
            int providerComparison = this.getPriority(providerLeft) - this.getPriority(providerRight);
            if (providerComparison != 0) {
                return providerComparison;
            }
            return -CronetProviderComparator.compareVersionStrings(providerLeft.getVersion(), providerRight.getVersion());
        }

        private int getPriority(CronetProvider provider) {
            String providerName = provider.getName();
            if ("App-Packaged-Cronet-Provider".equals(providerName)) {
                return 1;
            }
            if (GOOGLE_PLAY_SERVICES_PROVIDER_NAME.equals(providerName)) {
                return this.preferGooglePlayServices ? 0 : 2;
            }
            return 3;
        }

        private static int compareVersionStrings(@Nullable String versionLeft, @Nullable String versionRight) {
            if (versionLeft == null || versionRight == null) {
                return 0;
            }
            String[] versionStringsLeft = Util.split((String)versionLeft, (String)"\\.");
            String[] versionStringsRight = Util.split((String)versionRight, (String)"\\.");
            int minLength = Math.min(versionStringsLeft.length, versionStringsRight.length);
            for (int i = 0; i < minLength; ++i) {
                if (versionStringsLeft[i].equals(versionStringsRight[i])) continue;
                try {
                    int versionIntLeft = Integer.parseInt(versionStringsLeft[i]);
                    int versionIntRight = Integer.parseInt(versionStringsRight[i]);
                    return versionIntLeft - versionIntRight;
                }
                catch (NumberFormatException e) {
                    return 0;
                }
            }
            return 0;
        }
    }
}

