/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ext.cast;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.MediaMetadata;
import com.google.android.exoplayer2.ext.cast.MediaItemConverter;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public final class DefaultMediaItemConverter
implements MediaItemConverter {
    private static final String KEY_MEDIA_ITEM = "mediaItem";
    private static final String KEY_PLAYER_CONFIG = "exoPlayerConfig";
    private static final String KEY_URI = "uri";
    private static final String KEY_TITLE = "title";
    private static final String KEY_MIME_TYPE = "mimeType";
    private static final String KEY_DRM_CONFIGURATION = "drmConfiguration";
    private static final String KEY_UUID = "uuid";
    private static final String KEY_LICENSE_URI = "licenseUri";
    private static final String KEY_REQUEST_HEADERS = "requestHeaders";

    @Override
    public MediaItem toMediaItem(MediaQueueItem item) {
        MediaInfo mediaInfo = item.getMedia();
        Assertions.checkNotNull((Object)mediaInfo);
        return DefaultMediaItemConverter.getMediaItem((JSONObject)Assertions.checkNotNull((Object)mediaInfo.getCustomData()));
    }

    @Override
    public MediaQueueItem toMediaQueueItem(MediaItem item) {
        Assertions.checkNotNull((Object)item.playbackProperties);
        if (item.playbackProperties.mimeType == null) {
            throw new IllegalArgumentException("The item must specify its mimeType");
        }
        com.google.android.gms.cast.MediaMetadata metadata = new com.google.android.gms.cast.MediaMetadata(1);
        if (item.mediaMetadata.title != null) {
            metadata.putString("com.google.android.gms.cast.metadata.TITLE", item.mediaMetadata.title);
        }
        MediaInfo mediaInfo = new MediaInfo.Builder(item.playbackProperties.uri.toString()).setStreamType(1).setContentType(item.playbackProperties.mimeType).setMetadata(metadata).setCustomData(DefaultMediaItemConverter.getCustomData(item)).build();
        return new MediaQueueItem.Builder(mediaInfo).build();
    }

    private static MediaItem getMediaItem(JSONObject customData) {
        try {
            JSONObject mediaItemJson = customData.getJSONObject(KEY_MEDIA_ITEM);
            MediaItem.Builder builder = new MediaItem.Builder();
            builder.setUri(Uri.parse((String)mediaItemJson.getString(KEY_URI)));
            if (mediaItemJson.has(KEY_TITLE)) {
                MediaMetadata mediaMetadata = new MediaMetadata.Builder().setTitle(mediaItemJson.getString(KEY_TITLE)).build();
                builder.setMediaMetadata(mediaMetadata);
            }
            if (mediaItemJson.has(KEY_MIME_TYPE)) {
                builder.setMimeType(mediaItemJson.getString(KEY_MIME_TYPE));
            }
            if (mediaItemJson.has(KEY_DRM_CONFIGURATION)) {
                DefaultMediaItemConverter.populateDrmConfiguration(mediaItemJson.getJSONObject(KEY_DRM_CONFIGURATION), builder);
            }
            return builder.build();
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private static void populateDrmConfiguration(JSONObject json, MediaItem.Builder builder) throws JSONException {
        builder.setDrmUuid(UUID.fromString(json.getString(KEY_UUID)));
        builder.setDrmLicenseUri(json.getString(KEY_LICENSE_URI));
        JSONObject requestHeadersJson = json.getJSONObject(KEY_REQUEST_HEADERS);
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        Iterator iterator = requestHeadersJson.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            requestHeaders.put(key, requestHeadersJson.getString(key));
        }
        builder.setDrmLicenseRequestHeaders(requestHeaders);
    }

    private static JSONObject getCustomData(MediaItem mediaItem) {
        JSONObject json = new JSONObject();
        try {
            json.put(KEY_MEDIA_ITEM, (Object)DefaultMediaItemConverter.getMediaItemJson(mediaItem));
            JSONObject playerConfigJson = DefaultMediaItemConverter.getPlayerConfigJson(mediaItem);
            if (playerConfigJson != null) {
                json.put(KEY_PLAYER_CONFIG, (Object)playerConfigJson);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return json;
    }

    private static JSONObject getMediaItemJson(MediaItem mediaItem) throws JSONException {
        Assertions.checkNotNull((Object)mediaItem.playbackProperties);
        JSONObject json = new JSONObject();
        json.put(KEY_TITLE, (Object)mediaItem.mediaMetadata.title);
        json.put(KEY_URI, (Object)mediaItem.playbackProperties.uri.toString());
        json.put(KEY_MIME_TYPE, (Object)mediaItem.playbackProperties.mimeType);
        if (mediaItem.playbackProperties.drmConfiguration != null) {
            json.put(KEY_DRM_CONFIGURATION, (Object)DefaultMediaItemConverter.getDrmConfigurationJson(mediaItem.playbackProperties.drmConfiguration));
        }
        return json;
    }

    private static JSONObject getDrmConfigurationJson(MediaItem.DrmConfiguration drmConfiguration) throws JSONException {
        JSONObject json = new JSONObject();
        json.put(KEY_UUID, (Object)drmConfiguration.uuid);
        json.put(KEY_LICENSE_URI, (Object)drmConfiguration.licenseUri);
        json.put(KEY_REQUEST_HEADERS, (Object)new JSONObject(drmConfiguration.requestHeaders));
        return json;
    }

    @Nullable
    private static JSONObject getPlayerConfigJson(MediaItem mediaItem) throws JSONException {
        String drmScheme;
        if (mediaItem.playbackProperties == null || mediaItem.playbackProperties.drmConfiguration == null) {
            return null;
        }
        MediaItem.DrmConfiguration drmConfiguration = mediaItem.playbackProperties.drmConfiguration;
        if (C.WIDEVINE_UUID.equals(drmConfiguration.uuid)) {
            drmScheme = "widevine";
        } else if (C.PLAYREADY_UUID.equals(drmConfiguration.uuid)) {
            drmScheme = "playready";
        } else {
            return null;
        }
        JSONObject exoPlayerConfigJson = new JSONObject();
        exoPlayerConfigJson.put("withCredentials", false);
        exoPlayerConfigJson.put("protectionSystem", (Object)drmScheme);
        if (drmConfiguration.licenseUri != null) {
            exoPlayerConfigJson.put("licenseUrl", (Object)drmConfiguration.licenseUri);
        }
        if (!drmConfiguration.requestHeaders.isEmpty()) {
            exoPlayerConfigJson.put("headers", (Object)new JSONObject(drmConfiguration.requestHeaders));
        }
        return exoPlayerConfigJson;
    }
}

