/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ext.cast;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.Format;
import com.google.android.gms.cast.CastStatusCodes;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaTrack;

final class CastUtils {
    private static final long LIVE_STREAM_DURATION = -1000L;

    public static long getStreamDurationUs(@Nullable MediaInfo mediaInfo) {
        if (mediaInfo == null) {
            return -9223372036854775807L;
        }
        long durationMs = mediaInfo.getStreamDuration();
        return durationMs != -1L && durationMs != -1000L ? C.msToUs((long)durationMs) : -9223372036854775807L;
    }

    public static String getLogString(int statusCode) {
        switch (statusCode) {
            case 2004: {
                return "A requested application could not be found.";
            }
            case 2005: {
                return "A requested application is not currently running.";
            }
            case 2000: {
                return "Authentication failure.";
            }
            case 2002: {
                return "An in-progress request has been canceled, most likely because another action has preempted it.";
            }
            case 2200: {
                return "The Cast Remote Display service could not be created.";
            }
            case 2201: {
                return "The Cast Remote Display service was disconnected.";
            }
            case 2100: {
                return "The in-progress request failed.";
            }
            case 8: {
                return "An internal error has occurred.";
            }
            case 14: {
                return "A blocking call was interrupted while waiting and did not run to completion.";
            }
            case 2001: {
                return "An invalid request was made.";
            }
            case 2007: {
                return "A message could not be sent because there is not enough room in the send buffer at this time.";
            }
            case 2006: {
                return "A message could not be sent because it is too large.";
            }
            case 7: {
                return "Network I/O error.";
            }
            case 2003: {
                return "The request was disallowed and could not be completed.";
            }
            case 2103: {
                return "The request's progress is no longer being tracked because another request of the same type has been made before the first request completed.";
            }
            case 0: {
                return "Success.";
            }
            case 15: {
                return "An operation has timed out.";
            }
            case 13: {
                return "An unknown, unexpected error has occurred.";
            }
        }
        return CastStatusCodes.getStatusCodeString((int)statusCode);
    }

    public static Format mediaTrackToFormat(MediaTrack mediaTrack) {
        return new Format.Builder().setId(mediaTrack.getContentId()).setContainerMimeType(mediaTrack.getContentType()).setLanguage(mediaTrack.getLanguage()).build();
    }

    private CastUtils() {
    }
}

