/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ext.cast;

import android.util.SparseArray;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.ext.cast.CastTimeline;
import com.google.android.exoplayer2.ext.cast.CastUtils;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import java.util.HashSet;

final class CastTimelineTracker {
    private final SparseArray<CastTimeline.ItemData> itemIdToData = new SparseArray();

    public CastTimeline getCastTimeline(RemoteMediaClient remoteMediaClient) {
        MediaStatus mediaStatus;
        int[] itemIds = remoteMediaClient.getMediaQueue().getItemIds();
        if (itemIds.length > 0) {
            this.removeUnusedItemDataEntries(itemIds);
        }
        if ((mediaStatus = remoteMediaClient.getMediaStatus()) == null) {
            return CastTimeline.EMPTY_CAST_TIMELINE;
        }
        int currentItemId = mediaStatus.getCurrentItemId();
        this.updateItemData(currentItemId, mediaStatus.getMediaInfo(), -9223372036854775807L);
        for (MediaQueueItem item : mediaStatus.getQueueItems()) {
            long defaultPositionUs = (long)(item.getStartTime() * 1000000.0);
            this.updateItemData(item.getItemId(), item.getMedia(), defaultPositionUs);
        }
        return new CastTimeline(itemIds, this.itemIdToData);
    }

    private void updateItemData(int itemId, @Nullable MediaInfo mediaInfo, long defaultPositionUs) {
        boolean isLive;
        CastTimeline.ItemData previousData = (CastTimeline.ItemData)this.itemIdToData.get(itemId, (Object)CastTimeline.ItemData.EMPTY);
        long durationUs = CastUtils.getStreamDurationUs(mediaInfo);
        if (durationUs == -9223372036854775807L) {
            durationUs = previousData.durationUs;
        }
        boolean bl = mediaInfo == null ? previousData.isLive : (isLive = mediaInfo.getStreamType() == 2);
        if (defaultPositionUs == -9223372036854775807L) {
            defaultPositionUs = previousData.defaultPositionUs;
        }
        this.itemIdToData.put(itemId, (Object)previousData.copyWithNewValues(durationUs, defaultPositionUs, isLive));
    }

    private void removeUnusedItemDataEntries(int[] itemIds) {
        HashSet<Integer> scratchItemIds = new HashSet<Integer>(itemIds.length * 2);
        for (int id : itemIds) {
            scratchItemIds.add(id);
        }
        int index = 0;
        while (index < this.itemIdToData.size()) {
            if (!scratchItemIds.contains(this.itemIdToData.keyAt(index))) {
                this.itemIdToData.removeAt(index);
                continue;
            }
            ++index;
        }
    }
}

