/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ext.cast;

import android.net.Uri;
import android.util.SparseArray;
import android.util.SparseIntArray;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.Timeline;
import java.util.Arrays;

final class CastTimeline
extends Timeline {
    public static final CastTimeline EMPTY_CAST_TIMELINE = new CastTimeline(new int[0], (SparseArray<ItemData>)new SparseArray());
    private final SparseIntArray idsToIndex;
    private final int[] ids;
    private final long[] durationsUs;
    private final long[] defaultPositionsUs;
    private final boolean[] isLive;

    public CastTimeline(int[] itemIds, SparseArray<ItemData> itemIdToData) {
        int itemCount = itemIds.length;
        this.idsToIndex = new SparseIntArray(itemCount);
        this.ids = Arrays.copyOf(itemIds, itemCount);
        this.durationsUs = new long[itemCount];
        this.defaultPositionsUs = new long[itemCount];
        this.isLive = new boolean[itemCount];
        for (int i = 0; i < this.ids.length; ++i) {
            int id = this.ids[i];
            this.idsToIndex.put(id, i);
            ItemData data = (ItemData)itemIdToData.get(id, (Object)ItemData.EMPTY);
            this.durationsUs[i] = data.durationUs;
            this.defaultPositionsUs[i] = data.defaultPositionUs == -9223372036854775807L ? 0L : data.defaultPositionUs;
            this.isLive[i] = data.isLive;
        }
    }

    public int getWindowCount() {
        return this.ids.length;
    }

    public Timeline.Window getWindow(int windowIndex, Timeline.Window window, long defaultPositionProjectionUs) {
        long durationUs = this.durationsUs[windowIndex];
        boolean isDynamic = durationUs == -9223372036854775807L;
        MediaItem mediaItem = new MediaItem.Builder().setUri(Uri.EMPTY).setTag((Object)this.ids[windowIndex]).build();
        return window.set((Object)this.ids[windowIndex], mediaItem, null, -9223372036854775807L, -9223372036854775807L, -9223372036854775807L, !isDynamic, isDynamic, this.isLive[windowIndex] ? mediaItem.liveConfiguration : null, this.defaultPositionsUs[windowIndex], durationUs, windowIndex, windowIndex, 0L);
    }

    public int getPeriodCount() {
        return this.ids.length;
    }

    public Timeline.Period getPeriod(int periodIndex, Timeline.Period period, boolean setIds) {
        int id = this.ids[periodIndex];
        return period.set((Object)id, (Object)id, periodIndex, this.durationsUs[periodIndex], 0L);
    }

    public int getIndexOfPeriod(Object uid) {
        return uid instanceof Integer ? this.idsToIndex.get(((Integer)uid).intValue(), -1) : -1;
    }

    public Integer getUidOfPeriod(int periodIndex) {
        return this.ids[periodIndex];
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CastTimeline)) {
            return false;
        }
        CastTimeline that = (CastTimeline)((Object)other);
        return Arrays.equals(this.ids, that.ids) && Arrays.equals(this.durationsUs, that.durationsUs) && Arrays.equals(this.defaultPositionsUs, that.defaultPositionsUs) && Arrays.equals(this.isLive, that.isLive);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.ids);
        result = 31 * result + Arrays.hashCode(this.durationsUs);
        result = 31 * result + Arrays.hashCode(this.defaultPositionsUs);
        result = 31 * result + Arrays.hashCode(this.isLive);
        return result;
    }

    public static final class ItemData {
        public static final ItemData EMPTY = new ItemData();
        public final long durationUs;
        public final long defaultPositionUs;
        public final boolean isLive;

        private ItemData() {
            this(-9223372036854775807L, -9223372036854775807L, false);
        }

        public ItemData(long durationUs, long defaultPositionUs, boolean isLive) {
            this.durationUs = durationUs;
            this.defaultPositionUs = defaultPositionUs;
            this.isLive = isLive;
        }

        public ItemData copyWithNewValues(long durationUs, long defaultPositionUs, boolean isLive) {
            if (durationUs == this.durationUs && defaultPositionUs == this.defaultPositionUs && isLive == this.isLive) {
                return this;
            }
            return new ItemData(durationUs, defaultPositionUs, isLive);
        }
    }
}

