/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ext.cast;

import android.os.Looper;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.BasePlayer;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayerLibraryInfo;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.ext.cast.CastTimeline;
import com.google.android.exoplayer2.ext.cast.CastTimelineTracker;
import com.google.android.exoplayer2.ext.cast.CastTrackSelection;
import com.google.android.exoplayer2.ext.cast.CastUtils;
import com.google.android.exoplayer2.ext.cast.DefaultMediaItemConverter;
import com.google.android.exoplayer2.ext.cast.MediaItemConverter;
import com.google.android.exoplayer2.ext.cast.SessionAvailabilityListener;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.util.ListenerSet;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.MediaTrack;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.ResultCallback;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class CastPlayer
extends BasePlayer {
    private static final String TAG = "CastPlayer";
    private static final int RENDERER_COUNT = 3;
    private static final int RENDERER_INDEX_VIDEO = 0;
    private static final int RENDERER_INDEX_AUDIO = 1;
    private static final int RENDERER_INDEX_TEXT = 2;
    private static final long PROGRESS_REPORT_PERIOD_MS = 1000L;
    private static final TrackSelectionArray EMPTY_TRACK_SELECTION_ARRAY;
    private static final long[] EMPTY_TRACK_ID_ARRAY;
    private final CastContext castContext;
    private final MediaItemConverter mediaItemConverter;
    private final CastTimelineTracker timelineTracker;
    private final Timeline.Period period;
    private final StatusListener statusListener;
    private final SeekResultCallback seekResultCallback;
    private final ListenerSet<Player.EventListener, Player.Events> listeners;
    @Nullable
    private SessionAvailabilityListener sessionAvailabilityListener;
    private final StateHolder<Boolean> playWhenReady;
    private final StateHolder<Integer> repeatMode;
    @Nullable
    private RemoteMediaClient remoteMediaClient;
    private CastTimeline currentTimeline;
    private TrackGroupArray currentTrackGroups;
    private TrackSelectionArray currentTrackSelection;
    private int playbackState;
    private int currentWindowIndex;
    private long lastReportedPositionMs;
    private int pendingSeekCount;
    private int pendingSeekWindowIndex;
    private long pendingSeekPositionMs;

    public CastPlayer(CastContext castContext) {
        this(castContext, new DefaultMediaItemConverter());
    }

    public CastPlayer(CastContext castContext, MediaItemConverter mediaItemConverter) {
        this.castContext = castContext;
        this.mediaItemConverter = mediaItemConverter;
        this.timelineTracker = new CastTimelineTracker();
        this.period = new Timeline.Period();
        this.statusListener = new StatusListener();
        this.seekResultCallback = new SeekResultCallback();
        this.listeners = new ListenerSet(Looper.getMainLooper(), Clock.DEFAULT, Player.Events::new, (listener, eventFlags) -> listener.onEvents((Player)this, eventFlags));
        this.playWhenReady = new StateHolder<Boolean>(false);
        this.repeatMode = new StateHolder<Integer>(0);
        this.playbackState = 1;
        this.currentTimeline = CastTimeline.EMPTY_CAST_TIMELINE;
        this.currentTrackGroups = TrackGroupArray.EMPTY;
        this.currentTrackSelection = EMPTY_TRACK_SELECTION_ARRAY;
        this.pendingSeekWindowIndex = -1;
        this.pendingSeekPositionMs = -9223372036854775807L;
        SessionManager sessionManager = castContext.getSessionManager();
        sessionManager.addSessionManagerListener((SessionManagerListener)this.statusListener, CastSession.class);
        CastSession session = sessionManager.getCurrentCastSession();
        this.setRemoteMediaClient(session != null ? session.getRemoteMediaClient() : null);
        this.updateInternalStateAndNotifyIfChanged();
    }

    @Deprecated
    @Nullable
    public PendingResult<RemoteMediaClient.MediaChannelResult> loadItem(MediaQueueItem item, long positionMs) {
        return this.setMediaItemsInternal(new MediaQueueItem[]{item}, 0, positionMs, (Integer)this.repeatMode.value);
    }

    @Deprecated
    @Nullable
    public PendingResult<RemoteMediaClient.MediaChannelResult> loadItems(MediaQueueItem[] items, int startIndex, long positionMs, int repeatMode) {
        return this.setMediaItemsInternal(items, startIndex, positionMs, repeatMode);
    }

    @Deprecated
    @Nullable
    public PendingResult<RemoteMediaClient.MediaChannelResult> addItems(MediaQueueItem ... items) {
        return this.addMediaItemsInternal(items, 0);
    }

    @Deprecated
    @Nullable
    public PendingResult<RemoteMediaClient.MediaChannelResult> addItems(int periodId, MediaQueueItem ... items) {
        if (periodId == 0 || this.currentTimeline.getIndexOfPeriod(periodId) != -1) {
            return this.addMediaItemsInternal(items, periodId);
        }
        return null;
    }

    @Deprecated
    @Nullable
    public PendingResult<RemoteMediaClient.MediaChannelResult> removeItem(int periodId) {
        if (this.currentTimeline.getIndexOfPeriod(periodId) != -1) {
            return this.removeMediaItemsInternal(new int[]{periodId});
        }
        return null;
    }

    @Deprecated
    @Nullable
    public PendingResult<RemoteMediaClient.MediaChannelResult> moveItem(int periodId, int newIndex) {
        Assertions.checkArgument((newIndex >= 0 && newIndex < this.currentTimeline.getWindowCount() ? 1 : 0) != 0);
        int fromIndex = this.currentTimeline.getIndexOfPeriod(periodId);
        if (fromIndex != -1 && fromIndex != newIndex) {
            return this.moveMediaItemsInternal(new int[]{periodId}, fromIndex, newIndex);
        }
        return null;
    }

    @Nullable
    public MediaQueueItem getItem(int periodId) {
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && this.currentTimeline.getIndexOfPeriod(periodId) != -1 ? mediaStatus.getItemById(periodId) : null;
    }

    public boolean isCastSessionAvailable() {
        return this.remoteMediaClient != null;
    }

    public void setSessionAvailabilityListener(@Nullable SessionAvailabilityListener listener) {
        this.sessionAvailabilityListener = listener;
    }

    @Nullable
    public Player.AudioComponent getAudioComponent() {
        return null;
    }

    @Nullable
    public Player.VideoComponent getVideoComponent() {
        return null;
    }

    @Nullable
    public Player.TextComponent getTextComponent() {
        return null;
    }

    @Nullable
    public Player.MetadataComponent getMetadataComponent() {
        return null;
    }

    @Nullable
    public Player.DeviceComponent getDeviceComponent() {
        return null;
    }

    public Looper getApplicationLooper() {
        return Looper.getMainLooper();
    }

    public void addListener(Player.EventListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(Player.EventListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void setMediaItems(List<MediaItem> mediaItems, boolean resetPosition) {
        int windowIndex = resetPosition ? 0 : this.getCurrentWindowIndex();
        long startPositionMs = resetPosition ? -9223372036854775807L : this.getContentPosition();
        this.setMediaItems(mediaItems, windowIndex, startPositionMs);
    }

    public void setMediaItems(List<MediaItem> mediaItems, int startWindowIndex, long startPositionMs) {
        this.setMediaItemsInternal(this.toMediaQueueItems(mediaItems), startWindowIndex, startPositionMs, (Integer)this.repeatMode.value);
    }

    public void addMediaItems(List<MediaItem> mediaItems) {
        this.addMediaItemsInternal(this.toMediaQueueItems(mediaItems), 0);
    }

    public void addMediaItems(int index, List<MediaItem> mediaItems) {
        Assertions.checkArgument((index >= 0 ? 1 : 0) != 0);
        int uid = 0;
        if (index < this.currentTimeline.getWindowCount()) {
            uid = (Integer)this.currentTimeline.getWindow((int)index, (Timeline.Window)this.window).uid;
        }
        this.addMediaItemsInternal(this.toMediaQueueItems(mediaItems), uid);
    }

    public void moveMediaItems(int fromIndex, int toIndex, int newIndex) {
        Assertions.checkArgument((fromIndex >= 0 && fromIndex <= toIndex && toIndex <= this.currentTimeline.getWindowCount() && newIndex >= 0 && newIndex < this.currentTimeline.getWindowCount() ? 1 : 0) != 0);
        newIndex = Math.min(newIndex, this.currentTimeline.getWindowCount() - (toIndex - fromIndex));
        if (fromIndex == toIndex || fromIndex == newIndex) {
            return;
        }
        int[] uids = new int[toIndex - fromIndex];
        for (int i = 0; i < uids.length; ++i) {
            uids[i] = (Integer)this.currentTimeline.getWindow((int)(i + fromIndex), (Timeline.Window)this.window).uid;
        }
        this.moveMediaItemsInternal(uids, fromIndex, newIndex);
    }

    public void removeMediaItems(int fromIndex, int toIndex) {
        Assertions.checkArgument((fromIndex >= 0 && toIndex >= fromIndex && toIndex <= this.currentTimeline.getWindowCount() ? 1 : 0) != 0);
        if (fromIndex == toIndex) {
            return;
        }
        int[] uids = new int[toIndex - fromIndex];
        for (int i = 0; i < uids.length; ++i) {
            uids[i] = (Integer)this.currentTimeline.getWindow((int)(i + fromIndex), (Timeline.Window)this.window).uid;
        }
        this.removeMediaItemsInternal(uids);
    }

    public void clearMediaItems() {
        this.removeMediaItems(0, this.currentTimeline.getWindowCount());
    }

    public void prepare() {
    }

    public int getPlaybackState() {
        return this.playbackState;
    }

    public int getPlaybackSuppressionReason() {
        return 0;
    }

    @Deprecated
    @Nullable
    public ExoPlaybackException getPlaybackError() {
        return this.getPlayerError();
    }

    @Nullable
    public ExoPlaybackException getPlayerError() {
        return null;
    }

    public void setPlayWhenReady(boolean playWhenReady) {
        if (this.remoteMediaClient == null) {
            return;
        }
        this.setPlayerStateAndNotifyIfChanged(playWhenReady, 1, this.playbackState);
        this.listeners.flushEvents();
        PendingResult pendingResult = playWhenReady ? this.remoteMediaClient.play() : this.remoteMediaClient.pause();
        this.playWhenReady.pendingResultCallback = new ResultCallback<RemoteMediaClient.MediaChannelResult>(){

            public void onResult(RemoteMediaClient.MediaChannelResult mediaChannelResult) {
                if (CastPlayer.this.remoteMediaClient != null) {
                    CastPlayer.this.updatePlayerStateAndNotifyIfChanged(this);
                    CastPlayer.this.listeners.flushEvents();
                }
            }
        };
        pendingResult.setResultCallback(this.playWhenReady.pendingResultCallback);
    }

    public boolean getPlayWhenReady() {
        return (Boolean)this.playWhenReady.value;
    }

    public void seekTo(int windowIndex, long positionMs) {
        MediaStatus mediaStatus = this.getMediaStatus();
        long l = positionMs = positionMs != -9223372036854775807L ? positionMs : 0L;
        if (mediaStatus != null) {
            if (this.getCurrentWindowIndex() != windowIndex) {
                this.remoteMediaClient.queueJumpToItem(((Integer)this.currentTimeline.getPeriod((int)windowIndex, (Timeline.Period)this.period).uid).intValue(), positionMs, null).setResultCallback((ResultCallback)this.seekResultCallback);
            } else {
                this.remoteMediaClient.seek(positionMs).setResultCallback((ResultCallback)this.seekResultCallback);
            }
            ++this.pendingSeekCount;
            this.pendingSeekWindowIndex = windowIndex;
            this.pendingSeekPositionMs = positionMs;
            this.listeners.queueEvent(12, listener -> listener.onPositionDiscontinuity(1));
        } else if (this.pendingSeekCount == 0) {
            this.listeners.queueEvent(-1, Player.EventListener::onSeekProcessed);
        }
        this.listeners.flushEvents();
    }

    public void setPlaybackParameters(@Nullable PlaybackParameters playbackParameters) {
    }

    public PlaybackParameters getPlaybackParameters() {
        return PlaybackParameters.DEFAULT;
    }

    public void stop(boolean reset) {
        this.playbackState = 1;
        if (this.remoteMediaClient != null) {
            this.remoteMediaClient.stop();
        }
    }

    public void release() {
        SessionManager sessionManager = this.castContext.getSessionManager();
        sessionManager.removeSessionManagerListener((SessionManagerListener)this.statusListener, CastSession.class);
        sessionManager.endCurrentSession(false);
    }

    public int getRendererCount() {
        return 3;
    }

    public int getRendererType(int index) {
        switch (index) {
            case 0: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public void setRepeatMode(int repeatMode) {
        if (this.remoteMediaClient == null) {
            return;
        }
        this.setRepeatModeAndNotifyIfChanged(repeatMode);
        this.listeners.flushEvents();
        PendingResult pendingResult = this.remoteMediaClient.queueSetRepeatMode(CastPlayer.getCastRepeatMode(repeatMode), null);
        this.repeatMode.pendingResultCallback = new ResultCallback<RemoteMediaClient.MediaChannelResult>(){

            public void onResult(RemoteMediaClient.MediaChannelResult mediaChannelResult) {
                if (CastPlayer.this.remoteMediaClient != null) {
                    CastPlayer.this.updateRepeatModeAndNotifyIfChanged(this);
                    CastPlayer.this.listeners.flushEvents();
                }
            }
        };
        pendingResult.setResultCallback(this.repeatMode.pendingResultCallback);
    }

    public int getRepeatMode() {
        return (Integer)this.repeatMode.value;
    }

    public void setShuffleModeEnabled(boolean shuffleModeEnabled) {
    }

    public boolean getShuffleModeEnabled() {
        return false;
    }

    public TrackSelectionArray getCurrentTrackSelections() {
        return this.currentTrackSelection;
    }

    public TrackGroupArray getCurrentTrackGroups() {
        return this.currentTrackGroups;
    }

    public List<Metadata> getCurrentStaticMetadata() {
        return Collections.emptyList();
    }

    public Timeline getCurrentTimeline() {
        return this.currentTimeline;
    }

    public int getCurrentPeriodIndex() {
        return this.getCurrentWindowIndex();
    }

    public int getCurrentWindowIndex() {
        return this.pendingSeekWindowIndex != -1 ? this.pendingSeekWindowIndex : this.currentWindowIndex;
    }

    public long getDuration() {
        return this.getContentDuration();
    }

    public long getCurrentPosition() {
        return this.pendingSeekPositionMs != -9223372036854775807L ? this.pendingSeekPositionMs : (this.remoteMediaClient != null ? this.remoteMediaClient.getApproximateStreamPosition() : this.lastReportedPositionMs);
    }

    public long getBufferedPosition() {
        return this.getCurrentPosition();
    }

    public long getTotalBufferedDuration() {
        long bufferedPosition = this.getBufferedPosition();
        long currentPosition = this.getCurrentPosition();
        return bufferedPosition == -9223372036854775807L || currentPosition == -9223372036854775807L ? 0L : bufferedPosition - currentPosition;
    }

    public boolean isPlayingAd() {
        return false;
    }

    public int getCurrentAdGroupIndex() {
        return -1;
    }

    public int getCurrentAdIndexInAdGroup() {
        return -1;
    }

    public boolean isLoading() {
        return false;
    }

    public long getContentPosition() {
        return this.getCurrentPosition();
    }

    public long getContentBufferedPosition() {
        return this.getBufferedPosition();
    }

    private void updateInternalStateAndNotifyIfChanged() {
        boolean isPlaying;
        if (this.remoteMediaClient == null) {
            return;
        }
        boolean wasPlaying = this.playbackState == 3 && (Boolean)this.playWhenReady.value != false;
        this.updatePlayerStateAndNotifyIfChanged(null);
        boolean bl = isPlaying = this.playbackState == 3 && (Boolean)this.playWhenReady.value != false;
        if (wasPlaying != isPlaying) {
            this.listeners.queueEvent(8, listener -> listener.onIsPlayingChanged(isPlaying));
        }
        this.updateRepeatModeAndNotifyIfChanged(null);
        this.updateTimelineAndNotifyIfChanged();
        int currentWindowIndex = -1;
        MediaQueueItem currentItem = this.remoteMediaClient.getCurrentItem();
        if (currentItem != null) {
            currentWindowIndex = this.currentTimeline.getIndexOfPeriod(currentItem.getItemId());
        }
        if (currentWindowIndex == -1) {
            currentWindowIndex = 0;
        }
        if (this.currentWindowIndex != currentWindowIndex && this.pendingSeekCount == 0) {
            this.currentWindowIndex = currentWindowIndex;
            this.listeners.queueEvent(12, listener -> listener.onPositionDiscontinuity(0));
        }
        if (this.updateTracksAndSelectionsAndNotifyIfChanged()) {
            this.listeners.queueEvent(2, listener -> listener.onTracksChanged(this.currentTrackGroups, this.currentTrackSelection));
        }
        this.listeners.flushEvents();
    }

    @RequiresNonNull(value={"remoteMediaClient"})
    private void updatePlayerStateAndNotifyIfChanged(@Nullable ResultCallback<?> resultCallback) {
        boolean newPlayWhenReadyValue = (Boolean)this.playWhenReady.value;
        if (this.playWhenReady.acceptsUpdate(resultCallback)) {
            newPlayWhenReadyValue = !this.remoteMediaClient.isPaused();
            this.playWhenReady.clearPendingResultCallback();
        }
        int playWhenReadyChangeReason = newPlayWhenReadyValue != (Boolean)this.playWhenReady.value ? 4 : 1;
        this.setPlayerStateAndNotifyIfChanged(newPlayWhenReadyValue, playWhenReadyChangeReason, CastPlayer.fetchPlaybackState(this.remoteMediaClient));
    }

    @RequiresNonNull(value={"remoteMediaClient"})
    private void updateRepeatModeAndNotifyIfChanged(@Nullable ResultCallback<?> resultCallback) {
        if (this.repeatMode.acceptsUpdate(resultCallback)) {
            this.setRepeatModeAndNotifyIfChanged(CastPlayer.fetchRepeatMode(this.remoteMediaClient));
            this.repeatMode.clearPendingResultCallback();
        }
    }

    private void updateTimelineAndNotifyIfChanged() {
        if (this.updateTimeline()) {
            this.listeners.queueEvent(0, listener -> listener.onTimelineChanged((Timeline)this.currentTimeline, 1));
        }
    }

    private boolean updateTimeline() {
        CastTimeline oldTimeline = this.currentTimeline;
        MediaStatus status = this.getMediaStatus();
        this.currentTimeline = status != null ? this.timelineTracker.getCastTimeline(this.remoteMediaClient) : CastTimeline.EMPTY_CAST_TIMELINE;
        return !oldTimeline.equals((Object)this.currentTimeline);
    }

    private boolean updateTracksAndSelectionsAndNotifyIfChanged() {
        List castMediaTracks;
        if (this.remoteMediaClient == null) {
            return false;
        }
        MediaStatus mediaStatus = this.getMediaStatus();
        MediaInfo mediaInfo = mediaStatus != null ? mediaStatus.getMediaInfo() : null;
        List list = castMediaTracks = mediaInfo != null ? mediaInfo.getMediaTracks() : null;
        if (castMediaTracks == null || castMediaTracks.isEmpty()) {
            boolean hasChanged = !this.currentTrackGroups.isEmpty();
            this.currentTrackGroups = TrackGroupArray.EMPTY;
            this.currentTrackSelection = EMPTY_TRACK_SELECTION_ARRAY;
            return hasChanged;
        }
        long[] activeTrackIds = mediaStatus.getActiveTrackIds();
        if (activeTrackIds == null) {
            activeTrackIds = EMPTY_TRACK_ID_ARRAY;
        }
        TrackGroup[] trackGroups = new TrackGroup[castMediaTracks.size()];
        TrackSelection[] trackSelections = new TrackSelection[3];
        for (int i = 0; i < castMediaTracks.size(); ++i) {
            MediaTrack mediaTrack = (MediaTrack)castMediaTracks.get(i);
            trackGroups[i] = new TrackGroup(new Format[]{CastUtils.mediaTrackToFormat(mediaTrack)});
            long id = mediaTrack.getId();
            int trackType = MimeTypes.getTrackType((String)mediaTrack.getContentType());
            int rendererIndex = CastPlayer.getRendererIndexForTrackType(trackType);
            if (!CastPlayer.isTrackActive(id, activeTrackIds) || rendererIndex == -1 || trackSelections[rendererIndex] != null) continue;
            trackSelections[rendererIndex] = new CastTrackSelection(trackGroups[i]);
        }
        TrackGroupArray newTrackGroups = new TrackGroupArray(trackGroups);
        TrackSelectionArray newTrackSelections = new TrackSelectionArray(trackSelections);
        if (!newTrackGroups.equals((Object)this.currentTrackGroups) || !newTrackSelections.equals((Object)this.currentTrackSelection)) {
            this.currentTrackSelection = new TrackSelectionArray(trackSelections);
            this.currentTrackGroups = new TrackGroupArray(trackGroups);
            return true;
        }
        return false;
    }

    @Nullable
    private PendingResult<RemoteMediaClient.MediaChannelResult> setMediaItemsInternal(MediaQueueItem[] mediaQueueItems, int startWindowIndex, long startPositionMs, int repeatMode) {
        if (this.remoteMediaClient == null || mediaQueueItems.length == 0) {
            return null;
        }
        long l = startPositionMs = startPositionMs == -9223372036854775807L ? 0L : startPositionMs;
        if (startWindowIndex == -1) {
            startWindowIndex = this.getCurrentWindowIndex();
            startPositionMs = this.getCurrentPosition();
        }
        return this.remoteMediaClient.queueLoad(mediaQueueItems, Math.min(startWindowIndex, mediaQueueItems.length - 1), CastPlayer.getCastRepeatMode(repeatMode), startPositionMs, null);
    }

    @Nullable
    private PendingResult<RemoteMediaClient.MediaChannelResult> addMediaItemsInternal(MediaQueueItem[] items, int uid) {
        if (this.remoteMediaClient == null || this.getMediaStatus() == null) {
            return null;
        }
        return this.remoteMediaClient.queueInsertItems(items, uid, null);
    }

    @Nullable
    private PendingResult<RemoteMediaClient.MediaChannelResult> moveMediaItemsInternal(int[] uids, int fromIndex, int newIndex) {
        if (this.remoteMediaClient == null || this.getMediaStatus() == null) {
            return null;
        }
        int insertBeforeIndex = fromIndex < newIndex ? newIndex + uids.length : newIndex;
        int insertBeforeItemId = 0;
        if (insertBeforeIndex < this.currentTimeline.getWindowCount()) {
            insertBeforeItemId = (Integer)this.currentTimeline.getWindow((int)insertBeforeIndex, (Timeline.Window)this.window).uid;
        }
        return this.remoteMediaClient.queueReorderItems(uids, insertBeforeItemId, null);
    }

    @Nullable
    private PendingResult<RemoteMediaClient.MediaChannelResult> removeMediaItemsInternal(int[] uids) {
        if (this.remoteMediaClient == null || this.getMediaStatus() == null) {
            return null;
        }
        return this.remoteMediaClient.queueRemoveItems(uids, null);
    }

    private void setRepeatModeAndNotifyIfChanged(int repeatMode) {
        if ((Integer)this.repeatMode.value != repeatMode) {
            this.repeatMode.value = repeatMode;
            this.listeners.queueEvent(9, listener -> listener.onRepeatModeChanged(repeatMode));
        }
    }

    private void setPlayerStateAndNotifyIfChanged(boolean playWhenReady, int playWhenReadyChangeReason, int playbackState) {
        boolean playbackStateChanged;
        boolean playWhenReadyChanged = (Boolean)this.playWhenReady.value != playWhenReady;
        boolean bl = playbackStateChanged = this.playbackState != playbackState;
        if (playWhenReadyChanged || playbackStateChanged) {
            this.playbackState = playbackState;
            this.playWhenReady.value = playWhenReady;
            this.listeners.queueEvent(-1, listener -> listener.onPlayerStateChanged(playWhenReady, playbackState));
            if (playbackStateChanged) {
                this.listeners.queueEvent(5, listener -> listener.onPlaybackStateChanged(playbackState));
            }
            if (playWhenReadyChanged) {
                this.listeners.queueEvent(6, listener -> listener.onPlayWhenReadyChanged(playWhenReady, playWhenReadyChangeReason));
            }
        }
    }

    private void setRemoteMediaClient(@Nullable RemoteMediaClient remoteMediaClient) {
        if (this.remoteMediaClient == remoteMediaClient) {
            return;
        }
        if (this.remoteMediaClient != null) {
            this.remoteMediaClient.unregisterCallback((RemoteMediaClient.Callback)this.statusListener);
            this.remoteMediaClient.removeProgressListener((RemoteMediaClient.ProgressListener)this.statusListener);
        }
        this.remoteMediaClient = remoteMediaClient;
        if (remoteMediaClient != null) {
            if (this.sessionAvailabilityListener != null) {
                this.sessionAvailabilityListener.onCastSessionAvailable();
            }
            remoteMediaClient.registerCallback((RemoteMediaClient.Callback)this.statusListener);
            remoteMediaClient.addProgressListener((RemoteMediaClient.ProgressListener)this.statusListener, 1000L);
            this.updateInternalStateAndNotifyIfChanged();
        } else {
            this.updateTimelineAndNotifyIfChanged();
            if (this.sessionAvailabilityListener != null) {
                this.sessionAvailabilityListener.onCastSessionUnavailable();
            }
        }
    }

    @Nullable
    private MediaStatus getMediaStatus() {
        return this.remoteMediaClient != null ? this.remoteMediaClient.getMediaStatus() : null;
    }

    private static int fetchPlaybackState(RemoteMediaClient remoteMediaClient) {
        int receiverAppStatus = remoteMediaClient.getPlayerState();
        switch (receiverAppStatus) {
            case 4: {
                return 2;
            }
            case 2: 
            case 3: {
                return 3;
            }
        }
        return 1;
    }

    private static int fetchRepeatMode(RemoteMediaClient remoteMediaClient) {
        MediaStatus mediaStatus = remoteMediaClient.getMediaStatus();
        if (mediaStatus == null) {
            return 0;
        }
        int castRepeatMode = mediaStatus.getQueueRepeatMode();
        switch (castRepeatMode) {
            case 2: {
                return 1;
            }
            case 1: 
            case 3: {
                return 2;
            }
            case 0: {
                return 0;
            }
        }
        throw new IllegalStateException();
    }

    private static boolean isTrackActive(long id, long[] activeTrackIds) {
        for (long activeTrackId : activeTrackIds) {
            if (activeTrackId != id) continue;
            return true;
        }
        return false;
    }

    private static int getRendererIndexForTrackType(int trackType) {
        return trackType == 2 ? 0 : (trackType == 1 ? 1 : (trackType == 3 ? 2 : -1));
    }

    private static int getCastRepeatMode(int repeatMode) {
        switch (repeatMode) {
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 0: {
                return 0;
            }
        }
        throw new IllegalArgumentException();
    }

    private MediaQueueItem[] toMediaQueueItems(List<MediaItem> mediaItems) {
        MediaQueueItem[] mediaQueueItems = new MediaQueueItem[mediaItems.size()];
        for (int i = 0; i < mediaItems.size(); ++i) {
            mediaQueueItems[i] = this.mediaItemConverter.toMediaQueueItem(mediaItems.get(i));
        }
        return mediaQueueItems;
    }

    static {
        ExoPlayerLibraryInfo.registerModule((String)"goog.exo.cast");
        EMPTY_TRACK_SELECTION_ARRAY = new TrackSelectionArray(new TrackSelection[]{null, null, null});
        EMPTY_TRACK_ID_ARRAY = new long[0];
    }

    private static final class StateHolder<T> {
        public T value;
        @Nullable
        public ResultCallback<RemoteMediaClient.MediaChannelResult> pendingResultCallback;

        public StateHolder(T initialValue) {
            this.value = initialValue;
        }

        public void clearPendingResultCallback() {
            this.pendingResultCallback = null;
        }

        public boolean acceptsUpdate(@Nullable ResultCallback<?> resultCallback) {
            return this.pendingResultCallback == resultCallback;
        }
    }

    private final class SeekResultCallback
    implements ResultCallback<RemoteMediaClient.MediaChannelResult> {
        private SeekResultCallback() {
        }

        public void onResult(RemoteMediaClient.MediaChannelResult result) {
            int statusCode = result.getStatus().getStatusCode();
            if (statusCode != 0 && statusCode != 2103) {
                String string = CastUtils.getLogString(statusCode);
                Log.e((String)CastPlayer.TAG, (String)new StringBuilder(37 + String.valueOf(string).length()).append("Seek failed. Error code ").append(statusCode).append(": ").append(string).toString());
            }
            if (--CastPlayer.this.pendingSeekCount == 0) {
                CastPlayer.this.pendingSeekWindowIndex = -1;
                CastPlayer.this.pendingSeekPositionMs = -9223372036854775807L;
                CastPlayer.this.listeners.sendEvent(-1, Player.EventListener::onSeekProcessed);
            }
        }
    }

    private final class StatusListener
    extends RemoteMediaClient.Callback
    implements SessionManagerListener<CastSession>,
    RemoteMediaClient.ProgressListener {
        private StatusListener() {
        }

        public void onProgressUpdated(long progressMs, long unusedDurationMs) {
            CastPlayer.this.lastReportedPositionMs = progressMs;
        }

        public void onStatusUpdated() {
            CastPlayer.this.updateInternalStateAndNotifyIfChanged();
        }

        public void onMetadataUpdated() {
        }

        public void onQueueStatusUpdated() {
            CastPlayer.this.updateTimelineAndNotifyIfChanged();
        }

        public void onPreloadStatusUpdated() {
        }

        public void onSendingRemoteMediaRequest() {
        }

        public void onAdBreakStatusUpdated() {
        }

        public void onSessionStarted(CastSession castSession, String s) {
            CastPlayer.this.setRemoteMediaClient(castSession.getRemoteMediaClient());
        }

        public void onSessionResumed(CastSession castSession, boolean b) {
            CastPlayer.this.setRemoteMediaClient(castSession.getRemoteMediaClient());
        }

        public void onSessionEnded(CastSession castSession, int i) {
            CastPlayer.this.setRemoteMediaClient(null);
        }

        public void onSessionSuspended(CastSession castSession, int i) {
            CastPlayer.this.setRemoteMediaClient(null);
        }

        public void onSessionResumeFailed(CastSession castSession, int statusCode) {
            String string = CastUtils.getLogString(statusCode);
            Log.e((String)CastPlayer.TAG, (String)new StringBuilder(47 + String.valueOf(string).length()).append("Session resume failed. Error code ").append(statusCode).append(": ").append(string).toString());
        }

        public void onSessionStarting(CastSession castSession) {
        }

        public void onSessionStartFailed(CastSession castSession, int statusCode) {
            String string = CastUtils.getLogString(statusCode);
            Log.e((String)CastPlayer.TAG, (String)new StringBuilder(46 + String.valueOf(string).length()).append("Session start failed. Error code ").append(statusCode).append(": ").append(string).toString());
        }

        public void onSessionEnding(CastSession castSession) {
        }

        public void onSessionResuming(CastSession castSession, String s) {
        }
    }
}

