/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.accessibility.CaptioningManager;
import com.google.android.exoplayer2.text.CaptionStyleCompat;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.TextRenderer;
import com.google.android.exoplayer2.ui.SubtitlePainter;
import com.google.android.exoplayer2.util.Util;
import java.util.ArrayList;
import java.util.List;

public final class SubtitleView
extends View
implements TextRenderer.Output {
    public static final float DEFAULT_TEXT_SIZE_FRACTION = 0.0533f;
    public static final float DEFAULT_BOTTOM_PADDING_FRACTION = 0.08f;
    private static final int FRACTIONAL = 0;
    private static final int FRACTIONAL_IGNORE_PADDING = 1;
    private static final int ABSOLUTE = 2;
    private final List<SubtitlePainter> painters = new ArrayList<SubtitlePainter>();
    private List<Cue> cues;
    private int textSizeType = 0;
    private float textSize = 0.0533f;
    private boolean applyEmbeddedStyles = true;
    private boolean applyEmbeddedFontSizes = true;
    private CaptionStyleCompat style = CaptionStyleCompat.DEFAULT;
    private float bottomPaddingFraction = 0.08f;

    public SubtitleView(Context context) {
        this(context, null);
    }

    public SubtitleView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void onCues(List<Cue> cues) {
        this.setCues(cues);
    }

    public void setCues(List<Cue> cues) {
        int cueCount;
        if (this.cues == cues) {
            return;
        }
        this.cues = cues;
        int n = cueCount = cues == null ? 0 : cues.size();
        while (this.painters.size() < cueCount) {
            this.painters.add(new SubtitlePainter(this.getContext()));
        }
        this.invalidate();
    }

    public void setFixedTextSize(int unit, float size) {
        Context context = this.getContext();
        Resources resources = context == null ? Resources.getSystem() : context.getResources();
        this.setTextSize(2, TypedValue.applyDimension((int)unit, (float)size, (DisplayMetrics)resources.getDisplayMetrics()));
    }

    public void setUserDefaultTextSize() {
        float fontScale = Util.SDK_INT >= 19 && !this.isInEditMode() ? this.getUserCaptionFontScaleV19() : 1.0f;
        this.setFractionalTextSize(0.0533f * fontScale);
    }

    public void setFractionalTextSize(float fractionOfHeight) {
        this.setFractionalTextSize(fractionOfHeight, false);
    }

    public void setFractionalTextSize(float fractionOfHeight, boolean ignorePadding) {
        this.setTextSize(ignorePadding ? 1 : 0, fractionOfHeight);
    }

    private void setTextSize(int textSizeType, float textSize) {
        if (this.textSizeType == textSizeType && this.textSize == textSize) {
            return;
        }
        this.textSizeType = textSizeType;
        this.textSize = textSize;
        this.invalidate();
    }

    public void setApplyEmbeddedStyles(boolean applyEmbeddedStyles) {
        if (this.applyEmbeddedStyles == applyEmbeddedStyles && this.applyEmbeddedFontSizes == applyEmbeddedStyles) {
            return;
        }
        this.applyEmbeddedStyles = applyEmbeddedStyles;
        this.applyEmbeddedFontSizes = applyEmbeddedStyles;
        this.invalidate();
    }

    public void setApplyEmbeddedFontSizes(boolean applyEmbeddedFontSizes) {
        if (this.applyEmbeddedFontSizes == applyEmbeddedFontSizes) {
            return;
        }
        this.applyEmbeddedFontSizes = applyEmbeddedFontSizes;
        this.invalidate();
    }

    public void setUserDefaultStyle() {
        this.setStyle(Util.SDK_INT >= 19 && !this.isInEditMode() ? this.getUserCaptionStyleV19() : CaptionStyleCompat.DEFAULT);
    }

    public void setStyle(CaptionStyleCompat style) {
        if (this.style == style) {
            return;
        }
        this.style = style;
        this.invalidate();
    }

    public void setBottomPaddingFraction(float bottomPaddingFraction) {
        if (this.bottomPaddingFraction == bottomPaddingFraction) {
            return;
        }
        this.bottomPaddingFraction = bottomPaddingFraction;
        this.invalidate();
    }

    public void dispatchDraw(Canvas canvas) {
        float textSizePx;
        int cueCount = this.cues == null ? 0 : this.cues.size();
        int rawTop = this.getTop();
        int rawBottom = this.getBottom();
        int left = this.getLeft() + this.getPaddingLeft();
        int top = rawTop + this.getPaddingTop();
        int right = this.getRight() + this.getPaddingRight();
        int bottom = rawBottom - this.getPaddingBottom();
        if (bottom <= top || right <= left) {
            return;
        }
        float f = this.textSizeType == 2 ? this.textSize : (textSizePx = this.textSize * (float)(this.textSizeType == 0 ? bottom - top : rawBottom - rawTop));
        if (textSizePx <= 0.0f) {
            return;
        }
        for (int i = 0; i < cueCount; ++i) {
            this.painters.get(i).draw(this.cues.get(i), this.applyEmbeddedStyles, this.applyEmbeddedFontSizes, this.style, textSizePx, this.bottomPaddingFraction, canvas, left, top, right, bottom);
        }
    }

    @TargetApi(value=19)
    private float getUserCaptionFontScaleV19() {
        CaptioningManager captioningManager = (CaptioningManager)this.getContext().getSystemService("captioning");
        return captioningManager.getFontScale();
    }

    @TargetApi(value=19)
    private CaptionStyleCompat getUserCaptionStyleV19() {
        CaptioningManager captioningManager = (CaptioningManager)this.getContext().getSystemService("captioning");
        return CaptionStyleCompat.createFromCaptionStyle((CaptioningManager.CaptionStyle)captioningManager.getUserStyle());
    }
}

