/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.ui.R;
import com.google.android.exoplayer2.ui.TimeBar;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.util.Arrays;
import java.util.Formatter;
import java.util.Locale;

public class PlaybackControlView
extends FrameLayout {
    public static final ControlDispatcher DEFAULT_CONTROL_DISPATCHER = new ControlDispatcher(){

        @Override
        public boolean dispatchSetPlayWhenReady(ExoPlayer player, boolean playWhenReady) {
            player.setPlayWhenReady(playWhenReady);
            return true;
        }

        @Override
        public boolean dispatchSeekTo(ExoPlayer player, int windowIndex, long positionMs) {
            player.seekTo(windowIndex, positionMs);
            return true;
        }
    };
    public static final int DEFAULT_FAST_FORWARD_MS = 15000;
    public static final int DEFAULT_REWIND_MS = 5000;
    public static final int DEFAULT_SHOW_TIMEOUT_MS = 5000;
    public static final int MAX_WINDOWS_FOR_MULTI_WINDOW_TIME_BAR = 100;
    private static final long MAX_POSITION_FOR_SEEK_TO_PREVIOUS = 3000L;
    private final ComponentListener componentListener;
    private final View previousButton;
    private final View nextButton;
    private final View playButton;
    private final View pauseButton;
    private final View fastForwardButton;
    private final View rewindButton;
    private final TextView durationView;
    private final TextView positionView;
    private final TimeBar timeBar;
    private final StringBuilder formatBuilder;
    private final Formatter formatter;
    private final Timeline.Period period;
    private final Timeline.Window window;
    private ExoPlayer player;
    private ControlDispatcher controlDispatcher;
    private VisibilityListener visibilityListener;
    private boolean isAttachedToWindow;
    private boolean showMultiWindowTimeBar;
    private boolean multiWindowTimeBar;
    private boolean scrubbing;
    private int rewindMs;
    private int fastForwardMs;
    private int showTimeoutMs;
    private long hideAtMs;
    private long[] adBreakTimesMs;
    private final Runnable updateProgressAction = new Runnable(){

        @Override
        public void run() {
            PlaybackControlView.this.updateProgress();
        }
    };
    private final Runnable hideAction = new Runnable(){

        @Override
        public void run() {
            PlaybackControlView.this.hide();
        }
    };

    public PlaybackControlView(Context context) {
        this(context, null);
    }

    public PlaybackControlView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlaybackControlView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        int controllerLayoutId = R.layout.exo_playback_control_view;
        this.rewindMs = 5000;
        this.fastForwardMs = 15000;
        this.showTimeoutMs = 5000;
        if (attrs != null) {
            TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.PlaybackControlView, 0, 0);
            try {
                this.rewindMs = a.getInt(R.styleable.PlaybackControlView_rewind_increment, this.rewindMs);
                this.fastForwardMs = a.getInt(R.styleable.PlaybackControlView_fastforward_increment, this.fastForwardMs);
                this.showTimeoutMs = a.getInt(R.styleable.PlaybackControlView_show_timeout, this.showTimeoutMs);
                controllerLayoutId = a.getResourceId(R.styleable.PlaybackControlView_controller_layout_id, controllerLayoutId);
            }
            finally {
                a.recycle();
            }
        }
        this.period = new Timeline.Period();
        this.window = new Timeline.Window();
        this.formatBuilder = new StringBuilder();
        this.formatter = new Formatter(this.formatBuilder, Locale.getDefault());
        this.adBreakTimesMs = new long[0];
        this.componentListener = new ComponentListener();
        this.controlDispatcher = DEFAULT_CONTROL_DISPATCHER;
        LayoutInflater.from((Context)context).inflate(controllerLayoutId, (ViewGroup)this);
        this.setDescendantFocusability(262144);
        this.durationView = (TextView)this.findViewById(R.id.exo_duration);
        this.positionView = (TextView)this.findViewById(R.id.exo_position);
        this.timeBar = (TimeBar)this.findViewById(R.id.exo_progress);
        if (this.timeBar != null) {
            this.timeBar.setListener(this.componentListener);
        }
        this.playButton = this.findViewById(R.id.exo_play);
        if (this.playButton != null) {
            this.playButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.pauseButton = this.findViewById(R.id.exo_pause);
        if (this.pauseButton != null) {
            this.pauseButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.previousButton = this.findViewById(R.id.exo_prev);
        if (this.previousButton != null) {
            this.previousButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.nextButton = this.findViewById(R.id.exo_next);
        if (this.nextButton != null) {
            this.nextButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.rewindButton = this.findViewById(R.id.exo_rew);
        if (this.rewindButton != null) {
            this.rewindButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.fastForwardButton = this.findViewById(R.id.exo_ffwd);
        if (this.fastForwardButton != null) {
            this.fastForwardButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
    }

    public ExoPlayer getPlayer() {
        return this.player;
    }

    public void setPlayer(ExoPlayer player) {
        if (this.player == player) {
            return;
        }
        if (this.player != null) {
            this.player.removeListener((ExoPlayer.EventListener)this.componentListener);
        }
        this.player = player;
        if (player != null) {
            player.addListener((ExoPlayer.EventListener)this.componentListener);
        }
        this.updateAll();
    }

    public void setShowMultiWindowTimeBar(boolean showMultiWindowTimeBar) {
        this.showMultiWindowTimeBar = showMultiWindowTimeBar;
        this.updateTimeBarMode();
    }

    public void setVisibilityListener(VisibilityListener listener) {
        this.visibilityListener = listener;
    }

    public void setControlDispatcher(ControlDispatcher controlDispatcher) {
        this.controlDispatcher = controlDispatcher == null ? DEFAULT_CONTROL_DISPATCHER : controlDispatcher;
    }

    public void setRewindIncrementMs(int rewindMs) {
        this.rewindMs = rewindMs;
        this.updateNavigation();
    }

    public void setFastForwardIncrementMs(int fastForwardMs) {
        this.fastForwardMs = fastForwardMs;
        this.updateNavigation();
    }

    public int getShowTimeoutMs() {
        return this.showTimeoutMs;
    }

    public void setShowTimeoutMs(int showTimeoutMs) {
        this.showTimeoutMs = showTimeoutMs;
    }

    public void show() {
        if (!this.isVisible()) {
            this.setVisibility(0);
            if (this.visibilityListener != null) {
                this.visibilityListener.onVisibilityChange(this.getVisibility());
            }
            this.updateAll();
            this.requestPlayPauseFocus();
        }
        this.hideAfterTimeout();
    }

    public void hide() {
        if (this.isVisible()) {
            this.setVisibility(8);
            if (this.visibilityListener != null) {
                this.visibilityListener.onVisibilityChange(this.getVisibility());
            }
            this.removeCallbacks(this.updateProgressAction);
            this.removeCallbacks(this.hideAction);
            this.hideAtMs = -9223372036854775807L;
        }
    }

    public boolean isVisible() {
        return this.getVisibility() == 0;
    }

    private void hideAfterTimeout() {
        this.removeCallbacks(this.hideAction);
        if (this.showTimeoutMs > 0) {
            this.hideAtMs = SystemClock.uptimeMillis() + (long)this.showTimeoutMs;
            if (this.isAttachedToWindow) {
                this.postDelayed(this.hideAction, this.showTimeoutMs);
            }
        } else {
            this.hideAtMs = -9223372036854775807L;
        }
    }

    private void updateAll() {
        this.updatePlayPauseButton();
        this.updateNavigation();
        this.updateProgress();
    }

    private void updatePlayPauseButton() {
        boolean playing;
        if (!this.isVisible() || !this.isAttachedToWindow) {
            return;
        }
        boolean requestPlayPauseFocus = false;
        boolean bl = playing = this.player != null && this.player.getPlayWhenReady();
        if (this.playButton != null) {
            requestPlayPauseFocus |= playing && this.playButton.isFocused();
            this.playButton.setVisibility(playing ? 8 : 0);
        }
        if (this.pauseButton != null) {
            requestPlayPauseFocus |= !playing && this.pauseButton.isFocused();
            this.pauseButton.setVisibility(!playing ? 8 : 0);
        }
        if (requestPlayPauseFocus) {
            this.requestPlayPauseFocus();
        }
    }

    private void updateNavigation() {
        if (!this.isVisible() || !this.isAttachedToWindow) {
            return;
        }
        Timeline timeline = this.player != null ? this.player.getCurrentTimeline() : null;
        boolean haveNonEmptyTimeline = timeline != null && !timeline.isEmpty();
        boolean isSeekable = false;
        boolean enablePrevious = false;
        boolean enableNext = false;
        if (haveNonEmptyTimeline) {
            int windowIndex = this.player.getCurrentWindowIndex();
            timeline.getWindow(windowIndex, this.window);
            isSeekable = this.window.isSeekable;
            enablePrevious = windowIndex > 0 || isSeekable || !this.window.isDynamic;
            boolean bl = enableNext = windowIndex < timeline.getWindowCount() - 1 || this.window.isDynamic;
            if (timeline.getPeriod((int)this.player.getCurrentPeriodIndex(), (Timeline.Period)this.period).isAd) {
                this.hide();
            }
        }
        this.setButtonEnabled(enablePrevious, this.previousButton);
        this.setButtonEnabled(enableNext, this.nextButton);
        this.setButtonEnabled(this.fastForwardMs > 0 && isSeekable, this.fastForwardButton);
        this.setButtonEnabled(this.rewindMs > 0 && isSeekable, this.rewindButton);
        if (this.timeBar != null) {
            this.timeBar.setEnabled(isSeekable);
        }
    }

    private void updateTimeBarMode() {
        if (this.player == null) {
            return;
        }
        this.multiWindowTimeBar = this.showMultiWindowTimeBar && PlaybackControlView.canShowMultiWindowTimeBar(this.player.getCurrentTimeline(), this.period);
    }

    private void updateProgress() {
        int playbackState;
        if (!this.isVisible() || !this.isAttachedToWindow) {
            return;
        }
        long position = 0L;
        long bufferedPosition = 0L;
        long duration = 0L;
        if (this.player != null) {
            if (this.multiWindowTimeBar) {
                Timeline timeline = this.player.getCurrentTimeline();
                int windowCount = timeline.getWindowCount();
                int periodIndex = this.player.getCurrentPeriodIndex();
                long positionUs = 0L;
                long bufferedPositionUs = 0L;
                long durationUs = 0L;
                boolean isInAdBreak = false;
                boolean isPlayingAd = false;
                int adBreakCount = 0;
                for (int i = 0; i < windowCount; ++i) {
                    timeline.getWindow(i, this.window);
                    for (int j = this.window.firstPeriodIndex; j <= this.window.lastPeriodIndex; ++j) {
                        if (timeline.getPeriod((int)j, (Timeline.Period)this.period).isAd) {
                            isPlayingAd |= j == periodIndex;
                            if (isInAdBreak) continue;
                            isInAdBreak = true;
                            if (adBreakCount == this.adBreakTimesMs.length) {
                                this.adBreakTimesMs = Arrays.copyOf(this.adBreakTimesMs, this.adBreakTimesMs.length == 0 ? 1 : this.adBreakTimesMs.length * 2);
                            }
                            this.adBreakTimesMs[adBreakCount++] = C.usToMs((long)durationUs);
                            continue;
                        }
                        isInAdBreak = false;
                        long periodDurationUs = this.period.getDurationUs();
                        Assertions.checkState((periodDurationUs != -9223372036854775807L ? 1 : 0) != 0);
                        long periodDurationInWindowUs = periodDurationUs;
                        if (j == this.window.firstPeriodIndex) {
                            periodDurationInWindowUs -= this.window.positionInFirstPeriodUs;
                        }
                        if (i < periodIndex) {
                            positionUs += periodDurationInWindowUs;
                            bufferedPositionUs += periodDurationInWindowUs;
                        }
                        durationUs += periodDurationInWindowUs;
                    }
                }
                position = C.usToMs((long)positionUs);
                bufferedPosition = C.usToMs((long)bufferedPositionUs);
                duration = C.usToMs((long)durationUs);
                if (!isPlayingAd) {
                    position += this.player.getCurrentPosition();
                    bufferedPosition += this.player.getBufferedPosition();
                }
                if (this.timeBar != null) {
                    this.timeBar.setAdBreakTimesMs(this.adBreakTimesMs, adBreakCount);
                }
            } else {
                position = this.player.getCurrentPosition();
                bufferedPosition = this.player.getBufferedPosition();
                duration = this.player.getDuration();
            }
        }
        if (this.durationView != null) {
            this.durationView.setText((CharSequence)Util.getStringForTime((StringBuilder)this.formatBuilder, (Formatter)this.formatter, (long)duration));
        }
        if (this.positionView != null && !this.scrubbing) {
            this.positionView.setText((CharSequence)Util.getStringForTime((StringBuilder)this.formatBuilder, (Formatter)this.formatter, (long)position));
        }
        if (this.timeBar != null) {
            this.timeBar.setPosition(position);
            this.timeBar.setBufferedPosition(bufferedPosition);
            this.timeBar.setDuration(duration);
        }
        this.removeCallbacks(this.updateProgressAction);
        int n = playbackState = this.player == null ? 1 : this.player.getPlaybackState();
        if (playbackState != 1 && playbackState != 4) {
            long delayMs;
            if (this.player.getPlayWhenReady() && playbackState == 3) {
                delayMs = 1000L - position % 1000L;
                if (delayMs < 200L) {
                    delayMs += 1000L;
                }
            } else {
                delayMs = 1000L;
            }
            this.postDelayed(this.updateProgressAction, delayMs);
        }
    }

    private void requestPlayPauseFocus() {
        boolean playing;
        boolean bl = playing = this.player != null && this.player.getPlayWhenReady();
        if (!playing && this.playButton != null) {
            this.playButton.requestFocus();
        } else if (playing && this.pauseButton != null) {
            this.pauseButton.requestFocus();
        }
    }

    private void setButtonEnabled(boolean enabled, View view) {
        if (view == null) {
            return;
        }
        view.setEnabled(enabled);
        if (Util.SDK_INT >= 11) {
            this.setViewAlphaV11(view, enabled ? 1.0f : 0.3f);
            view.setVisibility(0);
        } else {
            view.setVisibility(enabled ? 0 : 4);
        }
    }

    @TargetApi(value=11)
    private void setViewAlphaV11(View view, float alpha) {
        view.setAlpha(alpha);
    }

    private void previous() {
        Timeline timeline = this.player.getCurrentTimeline();
        if (timeline.isEmpty()) {
            return;
        }
        int windowIndex = this.player.getCurrentWindowIndex();
        timeline.getWindow(windowIndex, this.window);
        if (windowIndex > 0 && (this.player.getCurrentPosition() <= 3000L || this.window.isDynamic && !this.window.isSeekable)) {
            this.seekTo(windowIndex - 1, -9223372036854775807L);
        } else {
            this.seekTo(0L);
        }
    }

    private void next() {
        Timeline timeline = this.player.getCurrentTimeline();
        if (timeline.isEmpty()) {
            return;
        }
        int windowIndex = this.player.getCurrentWindowIndex();
        if (windowIndex < timeline.getWindowCount() - 1) {
            this.seekTo(windowIndex + 1, -9223372036854775807L);
        } else if (timeline.getWindow((int)windowIndex, (Timeline.Window)this.window, (boolean)false).isDynamic) {
            this.seekTo(windowIndex, -9223372036854775807L);
        }
    }

    private void rewind() {
        if (this.rewindMs <= 0) {
            return;
        }
        this.seekTo(Math.max(this.player.getCurrentPosition() - (long)this.rewindMs, 0L));
    }

    private void fastForward() {
        if (this.fastForwardMs <= 0) {
            return;
        }
        this.seekTo(Math.min(this.player.getCurrentPosition() + (long)this.fastForwardMs, this.player.getDuration()));
    }

    private void seekTo(long positionMs) {
        this.seekTo(this.player.getCurrentWindowIndex(), positionMs);
    }

    private void seekTo(int windowIndex, long positionMs) {
        boolean dispatched = this.controlDispatcher.dispatchSeekTo(this.player, windowIndex, positionMs);
        if (!dispatched) {
            this.updateProgress();
        }
    }

    private void seekToTimebarPosition(long timebarPositionMs) {
        if (this.multiWindowTimeBar) {
            Timeline timeline = this.player.getCurrentTimeline();
            int windowCount = timeline.getWindowCount();
            long remainingMs = timebarPositionMs;
            for (int i = 0; i < windowCount; ++i) {
                timeline.getWindow(i, this.window);
                for (int j = this.window.firstPeriodIndex; j <= this.window.lastPeriodIndex; ++j) {
                    if (timeline.getPeriod((int)j, (Timeline.Period)this.period).isAd) continue;
                    long periodDurationMs = this.period.getDurationMs();
                    if (periodDurationMs == -9223372036854775807L) {
                        throw new IllegalStateException();
                    }
                    if (j == this.window.firstPeriodIndex) {
                        periodDurationMs -= this.window.getPositionInFirstPeriodMs();
                    }
                    if (i == windowCount - 1 && j == this.window.lastPeriodIndex && remainingMs >= periodDurationMs) {
                        this.seekTo(i, this.window.getDurationMs());
                        return;
                    }
                    if (remainingMs < periodDurationMs) {
                        this.seekTo(i, this.period.getPositionInWindowMs() + remainingMs);
                        return;
                    }
                    remainingMs -= periodDurationMs;
                }
            }
        } else {
            this.seekTo(timebarPositionMs);
        }
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.isAttachedToWindow = true;
        if (this.hideAtMs != -9223372036854775807L) {
            long delayMs = this.hideAtMs - SystemClock.uptimeMillis();
            if (delayMs <= 0L) {
                this.hide();
            } else {
                this.postDelayed(this.hideAction, delayMs);
            }
        }
        this.updateAll();
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.isAttachedToWindow = false;
        this.removeCallbacks(this.updateProgressAction);
        this.removeCallbacks(this.hideAction);
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        boolean handled;
        boolean bl = handled = this.dispatchMediaKeyEvent(event) || super.dispatchKeyEvent(event);
        if (handled) {
            this.show();
        }
        return handled;
    }

    public boolean dispatchMediaKeyEvent(KeyEvent event) {
        int keyCode = event.getKeyCode();
        if (this.player == null || !PlaybackControlView.isHandledMediaKey(keyCode)) {
            return false;
        }
        if (event.getAction() == 0) {
            switch (keyCode) {
                case 90: {
                    this.fastForward();
                    break;
                }
                case 89: {
                    this.rewind();
                    break;
                }
                case 85: {
                    this.controlDispatcher.dispatchSetPlayWhenReady(this.player, !this.player.getPlayWhenReady());
                    break;
                }
                case 126: {
                    this.controlDispatcher.dispatchSetPlayWhenReady(this.player, true);
                    break;
                }
                case 127: {
                    this.controlDispatcher.dispatchSetPlayWhenReady(this.player, false);
                    break;
                }
                case 87: {
                    this.next();
                    break;
                }
                case 88: {
                    this.previous();
                    break;
                }
            }
        }
        this.show();
        return true;
    }

    @SuppressLint(value={"InlinedApi"})
    private static boolean isHandledMediaKey(int keyCode) {
        return keyCode == 90 || keyCode == 89 || keyCode == 85 || keyCode == 126 || keyCode == 127 || keyCode == 87 || keyCode == 88;
    }

    private static boolean canShowMultiWindowTimeBar(Timeline timeline, Timeline.Period period) {
        if (timeline.getWindowCount() > 100) {
            return false;
        }
        int periodCount = timeline.getPeriodCount();
        for (int i = 0; i < periodCount; ++i) {
            timeline.getPeriod(i, period);
            if (period.isAd || period.durationUs != -9223372036854775807L) continue;
            return false;
        }
        return true;
    }

    private final class ComponentListener
    implements ExoPlayer.EventListener,
    TimeBar.OnScrubListener,
    View.OnClickListener {
        private ComponentListener() {
        }

        @Override
        public void onScrubStart(TimeBar timeBar) {
            PlaybackControlView.this.removeCallbacks(PlaybackControlView.this.hideAction);
            PlaybackControlView.this.scrubbing = true;
        }

        @Override
        public void onScrubMove(TimeBar timeBar, long position) {
            if (PlaybackControlView.this.positionView != null) {
                PlaybackControlView.this.positionView.setText((CharSequence)Util.getStringForTime((StringBuilder)PlaybackControlView.this.formatBuilder, (Formatter)PlaybackControlView.this.formatter, (long)position));
            }
        }

        @Override
        public void onScrubStop(TimeBar timeBar, long position, boolean canceled) {
            PlaybackControlView.this.scrubbing = false;
            if (!canceled && PlaybackControlView.this.player != null) {
                PlaybackControlView.this.seekToTimebarPosition(position);
            }
            PlaybackControlView.this.hideAfterTimeout();
        }

        public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
            PlaybackControlView.this.updatePlayPauseButton();
            PlaybackControlView.this.updateProgress();
        }

        public void onPositionDiscontinuity() {
            PlaybackControlView.this.updateNavigation();
            PlaybackControlView.this.updateProgress();
        }

        public void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
        }

        public void onTimelineChanged(Timeline timeline, Object manifest) {
            PlaybackControlView.this.updateNavigation();
            PlaybackControlView.this.updateTimeBarMode();
            PlaybackControlView.this.updateProgress();
        }

        public void onLoadingChanged(boolean isLoading) {
        }

        public void onTracksChanged(TrackGroupArray tracks, TrackSelectionArray selections) {
        }

        public void onPlayerError(ExoPlaybackException error) {
        }

        public void onClick(View view) {
            if (PlaybackControlView.this.player != null) {
                if (PlaybackControlView.this.nextButton == view) {
                    PlaybackControlView.this.next();
                } else if (PlaybackControlView.this.previousButton == view) {
                    PlaybackControlView.this.previous();
                } else if (PlaybackControlView.this.fastForwardButton == view) {
                    PlaybackControlView.this.fastForward();
                } else if (PlaybackControlView.this.rewindButton == view) {
                    PlaybackControlView.this.rewind();
                } else if (PlaybackControlView.this.playButton == view) {
                    PlaybackControlView.this.controlDispatcher.dispatchSetPlayWhenReady(PlaybackControlView.this.player, true);
                } else if (PlaybackControlView.this.pauseButton == view) {
                    PlaybackControlView.this.controlDispatcher.dispatchSetPlayWhenReady(PlaybackControlView.this.player, false);
                }
            }
            PlaybackControlView.this.hideAfterTimeout();
        }
    }

    public static interface ControlDispatcher {
        public boolean dispatchSetPlayWhenReady(ExoPlayer var1, boolean var2);

        public boolean dispatchSeekTo(ExoPlayer var1, int var2, long var3);
    }

    public static interface VisibilityListener {
        public void onVisibilityChange(int var1);
    }
}

