/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import com.google.android.exoplayer2.ui.R;
import com.google.android.exoplayer2.ui.TimeBar;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.util.Formatter;
import java.util.Locale;

public class DefaultTimeBar
extends View
implements TimeBar {
    private static final int FINE_SCRUB_Y_THRESHOLD = -50;
    private static final int FINE_SCRUB_RATIO = 3;
    private static final long STOP_SCRUBBING_TIMEOUT_MS = 1000L;
    private static final int DEFAULT_INCREMENT_COUNT = 20;
    private static final int DEFAULT_BAR_HEIGHT = 4;
    private static final int DEFAULT_TOUCH_TARGET_HEIGHT = 26;
    private static final int DEFAULT_PLAYED_COLOR = 0x33FFFFFF;
    private static final int DEFAULT_BUFFERED_COLOR = -855638017;
    private static final int DEFAULT_AD_MARKER_COLOR = -1291845888;
    private static final int DEFAULT_AD_MARKER_WIDTH = 4;
    private static final int DEFAULT_SCRUBBER_ENABLED_SIZE = 12;
    private static final int DEFAULT_SCRUBBER_DISABLED_SIZE = 0;
    private static final int DEFAULT_SCRUBBER_DRAGGED_SIZE = 16;
    private static final int OPAQUE_COLOR = -16777216;
    private final Rect seekBounds = new Rect();
    private final Rect progressBar = new Rect();
    private final Rect bufferedBar = new Rect();
    private final Rect scrubberBar = new Rect();
    private final Paint progressPaint = new Paint();
    private final Paint bufferedPaint = new Paint();
    private final Paint scrubberPaint = new Paint();
    private final Paint adMarkerPaint = new Paint();
    private final int barHeight;
    private final int touchTargetHeight;
    private final int adMarkerWidth;
    private final int scrubberEnabledSize;
    private final int scrubberDisabledSize;
    private final int scrubberDraggedSize;
    private final int scrubberPadding;
    private final int fineScrubYThreshold;
    private final StringBuilder formatBuilder;
    private final Formatter formatter;
    private final Runnable stopScrubbingRunnable;
    private int scrubberSize;
    private TimeBar.OnScrubListener listener;
    private int keyCountIncrement;
    private long keyTimeIncrement;
    private int lastCoarseScrubXPosition;
    private int[] locationOnScreen;
    private Point touchPosition;
    private boolean scrubbing;
    private long scrubPosition;
    private long duration;
    private long position;
    private long bufferedPosition;
    private int adBreakCount;
    private long[] adBreakTimesMs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultTimeBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        Resources res = context.getResources();
        DisplayMetrics displayMetrics = res.getDisplayMetrics();
        this.fineScrubYThreshold = DefaultTimeBar.dpToPx(displayMetrics, -50);
        int defaultBarHeight = DefaultTimeBar.dpToPx(displayMetrics, 4);
        int defaultTouchTargetHeight = DefaultTimeBar.dpToPx(displayMetrics, 26);
        int defaultAdMarkerWidth = DefaultTimeBar.dpToPx(displayMetrics, 4);
        int defaultScrubberEnabledSize = DefaultTimeBar.dpToPx(displayMetrics, 12);
        int defaultScrubberDisabledSize = DefaultTimeBar.dpToPx(displayMetrics, 0);
        int defaultScrubberDraggedSize = DefaultTimeBar.dpToPx(displayMetrics, 16);
        if (attrs != null) {
            TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.DefaultTimeBar, 0, 0);
            try {
                this.barHeight = a.getDimensionPixelSize(R.styleable.DefaultTimeBar_bar_height, defaultBarHeight);
                this.touchTargetHeight = a.getDimensionPixelSize(R.styleable.DefaultTimeBar_touch_target_height, defaultTouchTargetHeight);
                this.adMarkerWidth = a.getDimensionPixelSize(R.styleable.DefaultTimeBar_ad_marker_width, defaultAdMarkerWidth);
                this.scrubberEnabledSize = a.getDimensionPixelSize(R.styleable.DefaultTimeBar_scrubber_enabled_size, defaultScrubberEnabledSize);
                this.scrubberDisabledSize = a.getDimensionPixelSize(R.styleable.DefaultTimeBar_scrubber_disabled_size, defaultScrubberDisabledSize);
                this.scrubberDraggedSize = a.getDimensionPixelSize(R.styleable.DefaultTimeBar_scrubber_dragged_size, defaultScrubberDraggedSize);
                int playedColor = a.getInt(R.styleable.DefaultTimeBar_played_color, 0x33FFFFFF);
                int bufferedColor = a.getInt(R.styleable.DefaultTimeBar_buffered_color, -855638017);
                int adMarkerColor = a.getInt(R.styleable.DefaultTimeBar_ad_marker_color, -1291845888);
                this.progressPaint.setColor(playedColor);
                this.scrubberPaint.setColor(0xFF000000 | playedColor);
                this.bufferedPaint.setColor(bufferedColor);
                this.adMarkerPaint.setColor(adMarkerColor);
            }
            finally {
                a.recycle();
            }
        } else {
            this.barHeight = defaultBarHeight;
            this.touchTargetHeight = defaultTouchTargetHeight;
            this.adMarkerWidth = defaultAdMarkerWidth;
            this.scrubberEnabledSize = defaultScrubberEnabledSize;
            this.scrubberDisabledSize = defaultScrubberDisabledSize;
            this.scrubberDraggedSize = defaultScrubberDraggedSize;
            this.scrubberPaint.setColor(-1);
            this.progressPaint.setColor(0x33FFFFFF);
            this.bufferedPaint.setColor(-855638017);
            this.adMarkerPaint.setColor(-1291845888);
        }
        this.formatBuilder = new StringBuilder();
        this.formatter = new Formatter(this.formatBuilder, Locale.getDefault());
        this.stopScrubbingRunnable = new Runnable(){

            @Override
            public void run() {
                DefaultTimeBar.this.stopScrubbing(false);
            }
        };
        this.scrubberSize = this.scrubberEnabledSize;
        this.scrubberPadding = (Math.max(this.scrubberDisabledSize, Math.max(this.scrubberEnabledSize, this.scrubberDraggedSize)) + 1) / 2;
        this.duration = -9223372036854775807L;
        this.keyTimeIncrement = -9223372036854775807L;
        this.keyCountIncrement = 20;
        this.setFocusable(true);
        if (Util.SDK_INT >= 16) {
            this.maybeSetImportantForAccessibilityV16();
        }
    }

    @Override
    public void setListener(TimeBar.OnScrubListener listener) {
        this.listener = listener;
    }

    @Override
    public void setKeyTimeIncrement(long time) {
        Assertions.checkArgument((time > 0L ? 1 : 0) != 0);
        this.keyCountIncrement = -1;
        this.keyTimeIncrement = time;
    }

    @Override
    public void setKeyCountIncrement(int count) {
        Assertions.checkArgument((count > 0 ? 1 : 0) != 0);
        this.keyCountIncrement = count;
        this.keyTimeIncrement = -9223372036854775807L;
    }

    @Override
    public void setPosition(long position) {
        this.position = position;
        this.setContentDescription(this.getProgressText());
    }

    @Override
    public void setBufferedPosition(long bufferedPosition) {
        this.bufferedPosition = bufferedPosition;
    }

    @Override
    public void setDuration(long duration) {
        this.duration = duration;
        if (this.scrubbing && duration == -9223372036854775807L) {
            this.stopScrubbing(true);
        } else {
            this.updateScrubberState();
        }
    }

    @Override
    public void setAdBreakTimesMs(@Nullable long[] adBreakTimesMs, int adBreakCount) {
        Assertions.checkArgument((adBreakCount == 0 || adBreakTimesMs != null ? 1 : 0) != 0);
        this.adBreakCount = adBreakCount;
        this.adBreakTimesMs = adBreakTimesMs;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateScrubberState();
        if (this.scrubbing && !enabled) {
            this.stopScrubbing(true);
        }
    }

    public void onDraw(Canvas canvas) {
        canvas.save();
        this.drawTimeBar(canvas);
        this.drawPlayhead(canvas);
        canvas.restore();
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled() || this.duration <= 0L) {
            return false;
        }
        Point touchPosition = this.resolveRelativeTouchPosition(event);
        int x = touchPosition.x;
        int y = touchPosition.y;
        switch (event.getAction()) {
            case 0: {
                if (!this.isInSeekBar(x, y)) break;
                this.startScrubbing();
                this.positionScrubber(x);
                this.scrubPosition = this.getScrubberPosition();
                this.update();
                this.invalidate();
                return true;
            }
            case 2: {
                if (!this.scrubbing) break;
                if (y < this.fineScrubYThreshold) {
                    int relativeX = x - this.lastCoarseScrubXPosition;
                    this.positionScrubber(this.lastCoarseScrubXPosition + relativeX / 3);
                } else {
                    this.lastCoarseScrubXPosition = x;
                    this.positionScrubber(x);
                }
                this.scrubPosition = this.getScrubberPosition();
                if (this.listener != null) {
                    this.listener.onScrubMove(this, this.scrubPosition);
                }
                this.update();
                this.invalidate();
                return true;
            }
            case 1: 
            case 3: {
                if (!this.scrubbing) break;
                this.stopScrubbing(event.getAction() == 3);
                return true;
            }
        }
        return false;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.isEnabled()) {
            long positionIncrement = this.getPositionIncrement();
            switch (keyCode) {
                case 21: {
                    positionIncrement = -positionIncrement;
                }
                case 22: {
                    if (!this.scrubIncrementally(positionIncrement)) break;
                    this.removeCallbacks(this.stopScrubbingRunnable);
                    this.postDelayed(this.stopScrubbingRunnable, 1000L);
                    return true;
                }
                case 23: 
                case 66: {
                    if (!this.scrubbing) break;
                    this.removeCallbacks(this.stopScrubbingRunnable);
                    this.stopScrubbingRunnable.run();
                    return true;
                }
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int measureWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int measureHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.setMeasuredDimension(measureWidth, measureHeight);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int width = right - left;
        int height = bottom - top;
        int barY = height - this.touchTargetHeight;
        int seekLeft = this.getPaddingLeft();
        int seekRight = width - this.getPaddingRight();
        int progressY = barY + (this.touchTargetHeight - this.barHeight) / 2;
        this.seekBounds.set(seekLeft, barY, seekRight, barY + this.touchTargetHeight);
        this.progressBar.set(this.seekBounds.left + this.scrubberPadding, progressY, this.seekBounds.right - this.scrubberPadding, progressY + this.barHeight);
        this.update();
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        super.onSizeChanged(width, height, oldWidth, oldHeight);
    }

    @TargetApi(value=14)
    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        if (event.getEventType() == 4) {
            event.getText().add(this.getProgressText());
        }
        event.setClassName((CharSequence)DefaultTimeBar.class.getName());
    }

    @TargetApi(value=21)
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName((CharSequence)DefaultTimeBar.class.getCanonicalName());
        info.setContentDescription((CharSequence)this.getProgressText());
        if (this.duration <= 0L) {
            return;
        }
        if (Util.SDK_INT >= 21) {
            info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_FORWARD);
            info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_BACKWARD);
        } else if (Util.SDK_INT >= 16) {
            info.addAction(4096);
            info.addAction(8192);
        }
    }

    @TargetApi(value=16)
    public boolean performAccessibilityAction(int action, Bundle args) {
        if (super.performAccessibilityAction(action, args)) {
            return true;
        }
        if (this.duration <= 0L) {
            return false;
        }
        if (action == 8192) {
            if (this.scrubIncrementally(-this.getPositionIncrement())) {
                this.stopScrubbing(false);
            }
        } else if (action == 4096) {
            if (this.scrubIncrementally(this.getPositionIncrement())) {
                this.stopScrubbing(false);
            }
        } else {
            return false;
        }
        this.sendAccessibilityEvent(4);
        return true;
    }

    @TargetApi(value=16)
    private void maybeSetImportantForAccessibilityV16() {
        if (this.getImportantForAccessibility() == 0) {
            this.setImportantForAccessibility(1);
        }
    }

    private void startScrubbing() {
        this.scrubbing = true;
        this.updateScrubberState();
        ViewParent parent = this.getParent();
        if (parent != null) {
            parent.requestDisallowInterceptTouchEvent(true);
        }
        if (this.listener != null) {
            this.listener.onScrubStart(this);
        }
    }

    private void stopScrubbing(boolean canceled) {
        this.scrubbing = false;
        ViewParent parent = this.getParent();
        if (parent != null) {
            parent.requestDisallowInterceptTouchEvent(false);
        }
        this.updateScrubberState();
        this.invalidate();
        if (this.listener != null) {
            this.listener.onScrubStop(this, this.getScrubberPosition(), canceled);
        }
    }

    private void updateScrubberState() {
        this.scrubberSize = this.scrubbing ? this.scrubberDraggedSize : (this.isEnabled() && this.duration >= 0L ? this.scrubberEnabledSize : this.scrubberDisabledSize);
    }

    private void update() {
        long newScrubberTime;
        this.bufferedBar.set(this.progressBar);
        this.scrubberBar.set(this.progressBar);
        long l = newScrubberTime = this.scrubbing ? this.scrubPosition : this.position;
        if (this.duration > 0L) {
            int bufferedPixelWidth = (int)((long)this.progressBar.width() * this.bufferedPosition / this.duration);
            this.bufferedBar.right = this.progressBar.left + bufferedPixelWidth;
            int scrubberPixelPosition = (int)((long)this.progressBar.width() * newScrubberTime / this.duration);
            this.scrubberBar.right = this.progressBar.left + scrubberPixelPosition;
        } else {
            this.bufferedBar.right = this.progressBar.left;
            this.scrubberBar.right = this.progressBar.left;
        }
        this.invalidate(this.seekBounds);
    }

    private void positionScrubber(float xPosition) {
        this.scrubberBar.right = Util.constrainValue((int)((int)xPosition), (int)this.progressBar.left, (int)this.progressBar.right);
    }

    private Point resolveRelativeTouchPosition(MotionEvent motionEvent) {
        if (this.locationOnScreen == null) {
            this.locationOnScreen = new int[2];
            this.touchPosition = new Point();
        }
        this.getLocationOnScreen(this.locationOnScreen);
        this.touchPosition.set((int)motionEvent.getRawX() - this.locationOnScreen[0], (int)motionEvent.getRawY() - this.locationOnScreen[1]);
        return this.touchPosition;
    }

    private long getScrubberPosition() {
        if (this.progressBar.width() <= 0 || this.duration == -9223372036854775807L) {
            return 0L;
        }
        return (long)this.scrubberBar.width() * this.duration / (long)this.progressBar.width();
    }

    private boolean isInSeekBar(float x, float y) {
        return this.seekBounds.contains((int)x, (int)y);
    }

    private void drawTimeBar(Canvas canvas) {
        int progressBarHeight = this.progressBar.height();
        int barTop = this.progressBar.centerY() - progressBarHeight / 2;
        int barBottom = barTop + progressBarHeight;
        if (this.duration <= 0L) {
            canvas.drawRect((float)this.progressBar.left, (float)barTop, (float)this.progressBar.right, (float)barBottom, this.progressPaint);
            return;
        }
        int bufferedLeft = this.bufferedBar.left;
        int bufferedRight = this.bufferedBar.right;
        int progressLeft = Math.max(Math.max(this.progressBar.left, bufferedRight), this.scrubberBar.right);
        if (progressLeft < this.progressBar.right) {
            canvas.drawRect((float)progressLeft, (float)barTop, (float)this.progressBar.right, (float)barBottom, this.progressPaint);
        }
        if (bufferedRight > (bufferedLeft = Math.max(bufferedLeft, this.scrubberBar.right))) {
            canvas.drawRect((float)bufferedLeft, (float)barTop, (float)bufferedRight, (float)barBottom, this.bufferedPaint);
        }
        if (this.scrubberBar.width() > 0) {
            canvas.drawRect((float)this.scrubberBar.left, (float)barTop, (float)this.scrubberBar.right, (float)barBottom, this.scrubberPaint);
        }
        int adMarkerOffset = this.adMarkerWidth / 2;
        for (int i = 0; i < this.adBreakCount; ++i) {
            long adBreakTimeMs = Util.constrainValue((long)this.adBreakTimesMs[i], (long)0L, (long)this.duration);
            int markerPositionOffset = (int)((long)this.progressBar.width() * adBreakTimeMs / this.duration) - adMarkerOffset;
            int markerLeft = this.progressBar.left + Math.min(this.progressBar.width() - this.adMarkerWidth, Math.max(0, markerPositionOffset));
            canvas.drawRect((float)markerLeft, (float)barTop, (float)(markerLeft + this.adMarkerWidth), (float)barBottom, this.adMarkerPaint);
        }
    }

    private void drawPlayhead(Canvas canvas) {
        if (this.duration <= 0L) {
            return;
        }
        int playheadRadius = this.scrubberSize / 2;
        int playheadCenter = Util.constrainValue((int)this.scrubberBar.right, (int)this.scrubberBar.left, (int)this.progressBar.right);
        canvas.drawCircle((float)playheadCenter, (float)this.scrubberBar.centerY(), (float)playheadRadius, this.scrubberPaint);
    }

    private String getProgressText() {
        return Util.getStringForTime((StringBuilder)this.formatBuilder, (Formatter)this.formatter, (long)this.position);
    }

    private long getPositionIncrement() {
        return this.keyTimeIncrement == -9223372036854775807L ? (this.duration == -9223372036854775807L ? 0L : this.duration / (long)this.keyCountIncrement) : this.keyTimeIncrement;
    }

    private boolean scrubIncrementally(long positionChange) {
        if (this.duration <= 0L) {
            return false;
        }
        long scrubberPosition = this.getScrubberPosition();
        this.scrubPosition = Util.constrainValue((long)(scrubberPosition + positionChange), (long)0L, (long)this.duration);
        if (this.scrubPosition == scrubberPosition) {
            return false;
        }
        if (!this.scrubbing) {
            this.startScrubbing();
        }
        if (this.listener != null) {
            this.listener.onScrubMove(this, this.scrubPosition);
        }
        this.update();
        return true;
    }

    private static int dpToPx(DisplayMetrics displayMetrics, int dps) {
        return (int)((float)dps * displayMetrics.density + 0.5f);
    }
}

