/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.annotation.SuppressLint;
import android.os.Looper;
import android.widget.TextView;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.decoder.DecoderCounters;
import com.google.android.exoplayer2.util.Assertions;
import java.util.Locale;

public class DebugTextViewHelper
implements Player.EventListener,
Runnable {
    private static final int REFRESH_INTERVAL_MS = 1000;
    private final SimpleExoPlayer player;
    private final TextView textView;
    private boolean started;

    public DebugTextViewHelper(SimpleExoPlayer player, TextView textView) {
        Assertions.checkArgument((player.getApplicationLooper() == Looper.getMainLooper() ? 1 : 0) != 0);
        this.player = player;
        this.textView = textView;
    }

    public final void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.player.addListener((Player.EventListener)this);
        this.updateAndPost();
    }

    public final void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        this.player.removeListener((Player.EventListener)this);
        this.textView.removeCallbacks((Runnable)this);
    }

    public final void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
        this.updateAndPost();
    }

    public final void onPositionDiscontinuity(int reason) {
        this.updateAndPost();
    }

    @Override
    public final void run() {
        this.updateAndPost();
    }

    @SuppressLint(value={"SetTextI18n"})
    protected final void updateAndPost() {
        this.textView.setText((CharSequence)this.getDebugString());
        this.textView.removeCallbacks((Runnable)this);
        this.textView.postDelayed((Runnable)this, 1000L);
    }

    protected String getDebugString() {
        return this.getPlayerStateString() + this.getVideoString() + this.getAudioString();
    }

    protected String getPlayerStateString() {
        String playbackStateString;
        switch (this.player.getPlaybackState()) {
            case 2: {
                playbackStateString = "buffering";
                break;
            }
            case 4: {
                playbackStateString = "ended";
                break;
            }
            case 1: {
                playbackStateString = "idle";
                break;
            }
            case 3: {
                playbackStateString = "ready";
                break;
            }
            default: {
                playbackStateString = "unknown";
            }
        }
        return String.format("playWhenReady:%s playbackState:%s window:%s", this.player.getPlayWhenReady(), playbackStateString, this.player.getCurrentWindowIndex());
    }

    protected String getVideoString() {
        Format format = this.player.getVideoFormat();
        DecoderCounters decoderCounters = this.player.getVideoDecoderCounters();
        if (format == null || decoderCounters == null) {
            return "";
        }
        return "\n" + format.sampleMimeType + "(id:" + format.id + " r:" + format.width + "x" + format.height + DebugTextViewHelper.getPixelAspectRatioString(format.pixelWidthHeightRatio) + DebugTextViewHelper.getDecoderCountersBufferCountString(decoderCounters) + ")";
    }

    protected String getAudioString() {
        Format format = this.player.getAudioFormat();
        DecoderCounters decoderCounters = this.player.getAudioDecoderCounters();
        if (format == null || decoderCounters == null) {
            return "";
        }
        return "\n" + format.sampleMimeType + "(id:" + format.id + " hz:" + format.sampleRate + " ch:" + format.channelCount + DebugTextViewHelper.getDecoderCountersBufferCountString(decoderCounters) + ")";
    }

    private static String getDecoderCountersBufferCountString(DecoderCounters counters) {
        if (counters == null) {
            return "";
        }
        counters.ensureUpdated();
        return " sib:" + counters.skippedInputBufferCount + " sb:" + counters.skippedOutputBufferCount + " rb:" + counters.renderedOutputBufferCount + " db:" + counters.droppedBufferCount + " mcdb:" + counters.maxConsecutiveDroppedBufferCount + " dk:" + counters.droppedToKeyframeCount;
    }

    private static String getPixelAspectRatioString(float pixelAspectRatio) {
        return pixelAspectRatio == -1.0f || pixelAspectRatio == 1.0f ? "" : " par:" + String.format(Locale.US, "%.02f", Float.valueOf(pixelAspectRatio));
    }
}

