/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.RelativeSizeSpan;
import android.util.DisplayMetrics;
import com.google.android.exoplayer2.text.CaptionStyleCompat;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;

final class SubtitlePainter {
    private static final String TAG = "SubtitlePainter";
    private static final float INNER_PADDING_RATIO = 0.125f;
    private final float outlineWidth;
    private final float shadowRadius;
    private final float shadowOffset;
    private final float spacingMult;
    private final float spacingAdd;
    private final TextPaint textPaint;
    private final Paint paint;
    private CharSequence cueText;
    private Layout.Alignment cueTextAlignment;
    private Bitmap cueBitmap;
    private float cueLine;
    private int cueLineType;
    private int cueLineAnchor;
    private float cuePosition;
    private int cuePositionAnchor;
    private float cueSize;
    private float cueBitmapHeight;
    private boolean applyEmbeddedStyles;
    private boolean applyEmbeddedFontSizes;
    private int foregroundColor;
    private int backgroundColor;
    private int windowColor;
    private int edgeColor;
    private int edgeType;
    private float defaultTextSizePx;
    private float cueTextSizePx;
    private float bottomPaddingFraction;
    private int parentLeft;
    private int parentTop;
    private int parentRight;
    private int parentBottom;
    private StaticLayout textLayout;
    private int textLeft;
    private int textTop;
    private int textPaddingX;
    private Rect bitmapRect;

    public SubtitlePainter(Context context) {
        int[] viewAttr = new int[]{16843287, 16843288};
        TypedArray styledAttributes = context.obtainStyledAttributes(null, viewAttr, 0, 0);
        this.spacingAdd = styledAttributes.getDimensionPixelSize(0, 0);
        this.spacingMult = styledAttributes.getFloat(1, 1.0f);
        styledAttributes.recycle();
        Resources resources = context.getResources();
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        int twoDpInPx = Math.round(2.0f * (float)displayMetrics.densityDpi / 160.0f);
        this.outlineWidth = twoDpInPx;
        this.shadowRadius = twoDpInPx;
        this.shadowOffset = twoDpInPx;
        this.textPaint = new TextPaint();
        this.textPaint.setAntiAlias(true);
        this.textPaint.setSubpixelText(true);
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.paint.setStyle(Paint.Style.FILL);
    }

    public void draw(Cue cue, boolean applyEmbeddedStyles, boolean applyEmbeddedFontSizes, CaptionStyleCompat style, float defaultTextSizePx, float cueTextSizePx, float bottomPaddingFraction, Canvas canvas, int cueBoxLeft, int cueBoxTop, int cueBoxRight, int cueBoxBottom) {
        boolean isTextCue = cue.bitmap == null;
        int windowColor = -16777216;
        if (isTextCue) {
            if (TextUtils.isEmpty((CharSequence)cue.text)) {
                return;
            }
            int n = windowColor = cue.windowColorSet && applyEmbeddedStyles ? cue.windowColor : style.windowColor;
        }
        if (SubtitlePainter.areCharSequencesEqual(this.cueText, cue.text) && Util.areEqual((Object)this.cueTextAlignment, (Object)cue.textAlignment) && this.cueBitmap == cue.bitmap && this.cueLine == cue.line && this.cueLineType == cue.lineType && Util.areEqual((Object)this.cueLineAnchor, (Object)cue.lineAnchor) && this.cuePosition == cue.position && Util.areEqual((Object)this.cuePositionAnchor, (Object)cue.positionAnchor) && this.cueSize == cue.size && this.cueBitmapHeight == cue.bitmapHeight && this.applyEmbeddedStyles == applyEmbeddedStyles && this.applyEmbeddedFontSizes == applyEmbeddedFontSizes && this.foregroundColor == style.foregroundColor && this.backgroundColor == style.backgroundColor && this.windowColor == windowColor && this.edgeType == style.edgeType && this.edgeColor == style.edgeColor && Util.areEqual((Object)this.textPaint.getTypeface(), (Object)style.typeface) && this.defaultTextSizePx == defaultTextSizePx && this.cueTextSizePx == cueTextSizePx && this.bottomPaddingFraction == bottomPaddingFraction && this.parentLeft == cueBoxLeft && this.parentTop == cueBoxTop && this.parentRight == cueBoxRight && this.parentBottom == cueBoxBottom) {
            this.drawLayout(canvas, isTextCue);
            return;
        }
        this.cueText = cue.text;
        this.cueTextAlignment = cue.textAlignment;
        this.cueBitmap = cue.bitmap;
        this.cueLine = cue.line;
        this.cueLineType = cue.lineType;
        this.cueLineAnchor = cue.lineAnchor;
        this.cuePosition = cue.position;
        this.cuePositionAnchor = cue.positionAnchor;
        this.cueSize = cue.size;
        this.cueBitmapHeight = cue.bitmapHeight;
        this.applyEmbeddedStyles = applyEmbeddedStyles;
        this.applyEmbeddedFontSizes = applyEmbeddedFontSizes;
        this.foregroundColor = style.foregroundColor;
        this.backgroundColor = style.backgroundColor;
        this.windowColor = windowColor;
        this.edgeType = style.edgeType;
        this.edgeColor = style.edgeColor;
        this.textPaint.setTypeface(style.typeface);
        this.defaultTextSizePx = defaultTextSizePx;
        this.cueTextSizePx = cueTextSizePx;
        this.bottomPaddingFraction = bottomPaddingFraction;
        this.parentLeft = cueBoxLeft;
        this.parentTop = cueBoxTop;
        this.parentRight = cueBoxRight;
        this.parentBottom = cueBoxBottom;
        if (isTextCue) {
            this.setupTextLayout();
        } else {
            this.setupBitmapLayout();
        }
        this.drawLayout(canvas, isTextCue);
    }

    /*
     * WARNING - void declaration
     */
    private void setupTextLayout() {
        int textTop;
        int textRight;
        int textLeft;
        SpannableStringBuilder newCueText;
        int parentWidth = this.parentRight - this.parentLeft;
        int parentHeight = this.parentBottom - this.parentTop;
        this.textPaint.setTextSize(this.defaultTextSizePx);
        int textPaddingX = (int)(this.defaultTextSizePx * 0.125f + 0.5f);
        int availableWidth = parentWidth - textPaddingX * 2;
        if (this.cueSize != Float.MIN_VALUE) {
            availableWidth = (int)((float)availableWidth * this.cueSize);
        }
        if (availableWidth <= 0) {
            Log.w((String)TAG, (String)"Skipped drawing subtitle cue (insufficient space)");
            return;
        }
        CharSequence cueText = this.cueText;
        if (!this.applyEmbeddedStyles) {
            cueText = cueText.toString();
        } else if (!this.applyEmbeddedFontSizes) {
            newCueText = new SpannableStringBuilder(cueText);
            int cueLength = newCueText.length();
            AbsoluteSizeSpan[] absSpans = (AbsoluteSizeSpan[])newCueText.getSpans(0, cueLength, AbsoluteSizeSpan.class);
            RelativeSizeSpan[] relSpans = (RelativeSizeSpan[])newCueText.getSpans(0, cueLength, RelativeSizeSpan.class);
            for (AbsoluteSizeSpan absoluteSizeSpan : absSpans) {
                newCueText.removeSpan((Object)absoluteSizeSpan);
            }
            for (AbsoluteSizeSpan absoluteSizeSpan : relSpans) {
                newCueText.removeSpan((Object)absoluteSizeSpan);
            }
            cueText = newCueText;
        } else if (this.cueTextSizePx > 0.0f) {
            newCueText = new SpannableStringBuilder(cueText);
            newCueText.setSpan((Object)new AbsoluteSizeSpan((int)this.cueTextSizePx), 0, newCueText.length(), 0xFF0000);
            cueText = newCueText;
        }
        if (Color.alpha((int)this.backgroundColor) > 0) {
            newCueText = new SpannableStringBuilder(cueText);
            newCueText.setSpan((Object)new BackgroundColorSpan(this.backgroundColor), 0, newCueText.length(), 0xFF0000);
            cueText = newCueText;
        }
        Layout.Alignment textAlignment = this.cueTextAlignment == null ? Layout.Alignment.ALIGN_CENTER : this.cueTextAlignment;
        this.textLayout = new StaticLayout(cueText, this.textPaint, availableWidth, textAlignment, this.spacingMult, this.spacingAdd, true);
        int textHeight = this.textLayout.getHeight();
        int textWidth = 0;
        int lineCount = this.textLayout.getLineCount();
        for (int i = 0; i < lineCount; ++i) {
            textWidth = Math.max((int)Math.ceil(this.textLayout.getLineWidth(i)), textWidth);
        }
        if (this.cueSize != Float.MIN_VALUE && textWidth < availableWidth) {
            textWidth = availableWidth;
        }
        textWidth += textPaddingX * 2;
        if (this.cuePosition != Float.MIN_VALUE) {
            int anchorPosition = Math.round((float)parentWidth * this.cuePosition) + this.parentLeft;
            textLeft = this.cuePositionAnchor == 2 ? anchorPosition - textWidth : (this.cuePositionAnchor == 1 ? (anchorPosition * 2 - textWidth) / 2 : anchorPosition);
            textLeft = Math.max(textLeft, this.parentLeft);
            textRight = Math.min(textLeft + textWidth, this.parentRight);
        } else {
            textLeft = (parentWidth - textWidth) / 2 + this.parentLeft;
            textRight = textLeft + textWidth;
        }
        textWidth = textRight - textLeft;
        if (textWidth <= 0) {
            Log.w((String)TAG, (String)"Skipped drawing subtitle cue (invalid horizontal positioning)");
            return;
        }
        if (this.cueLine != Float.MIN_VALUE) {
            void var13_22;
            if (this.cueLineType == 0) {
                int n = Math.round((float)parentHeight * this.cueLine) + this.parentTop;
            } else {
                int firstLineHeight = this.textLayout.getLineBottom(0) - this.textLayout.getLineTop(0);
                if (this.cueLine >= 0.0f) {
                    int n = Math.round(this.cueLine * (float)firstLineHeight) + this.parentTop;
                } else {
                    int n = Math.round((this.cueLine + 1.0f) * (float)firstLineHeight) + this.parentBottom;
                }
            }
            int n = this.cueLineAnchor == 2 ? var13_22 - textHeight : (textTop = this.cueLineAnchor == 1 ? (var13_22 * 2 - textHeight) / 2 : var13_22);
            if (textTop + textHeight > this.parentBottom) {
                textTop = this.parentBottom - textHeight;
            } else if (textTop < this.parentTop) {
                textTop = this.parentTop;
            }
        } else {
            textTop = this.parentBottom - textHeight - (int)((float)parentHeight * this.bottomPaddingFraction);
        }
        this.textLayout = new StaticLayout(cueText, this.textPaint, textWidth, textAlignment, this.spacingMult, this.spacingAdd, true);
        this.textLeft = textLeft;
        this.textTop = textTop;
        this.textPaddingX = textPaddingX;
    }

    private void setupBitmapLayout() {
        int height;
        int parentWidth = this.parentRight - this.parentLeft;
        int parentHeight = this.parentBottom - this.parentTop;
        float anchorX = (float)this.parentLeft + (float)parentWidth * this.cuePosition;
        float anchorY = (float)this.parentTop + (float)parentHeight * this.cueLine;
        int width = Math.round((float)parentWidth * this.cueSize);
        int n = height = this.cueBitmapHeight != Float.MIN_VALUE ? Math.round((float)parentHeight * this.cueBitmapHeight) : Math.round((float)width * ((float)this.cueBitmap.getHeight() / (float)this.cueBitmap.getWidth()));
        int x = Math.round(this.cueLineAnchor == 2 ? anchorX - (float)width : (this.cueLineAnchor == 1 ? anchorX - (float)(width / 2) : anchorX));
        int y = Math.round(this.cuePositionAnchor == 2 ? anchorY - (float)height : (this.cuePositionAnchor == 1 ? anchorY - (float)(height / 2) : anchorY));
        this.bitmapRect = new Rect(x, y, x + width, y + height);
    }

    private void drawLayout(Canvas canvas, boolean isTextCue) {
        if (isTextCue) {
            this.drawTextLayout(canvas);
        } else {
            this.drawBitmapLayout(canvas);
        }
    }

    private void drawTextLayout(Canvas canvas) {
        StaticLayout layout2 = this.textLayout;
        if (layout2 == null) {
            return;
        }
        int saveCount = canvas.save();
        canvas.translate((float)this.textLeft, (float)this.textTop);
        if (Color.alpha((int)this.windowColor) > 0) {
            this.paint.setColor(this.windowColor);
            canvas.drawRect((float)(-this.textPaddingX), 0.0f, (float)(layout2.getWidth() + this.textPaddingX), (float)layout2.getHeight(), this.paint);
        }
        if (this.edgeType == 1) {
            this.textPaint.setStrokeJoin(Paint.Join.ROUND);
            this.textPaint.setStrokeWidth(this.outlineWidth);
            this.textPaint.setColor(this.edgeColor);
            this.textPaint.setStyle(Paint.Style.FILL_AND_STROKE);
            layout2.draw(canvas);
        } else if (this.edgeType == 2) {
            this.textPaint.setShadowLayer(this.shadowRadius, this.shadowOffset, this.shadowOffset, this.edgeColor);
        } else if (this.edgeType == 3 || this.edgeType == 4) {
            boolean raised = this.edgeType == 3;
            int colorUp = raised ? -1 : this.edgeColor;
            int colorDown = raised ? this.edgeColor : -1;
            float offset = this.shadowRadius / 2.0f;
            this.textPaint.setColor(this.foregroundColor);
            this.textPaint.setStyle(Paint.Style.FILL);
            this.textPaint.setShadowLayer(this.shadowRadius, -offset, -offset, colorUp);
            layout2.draw(canvas);
            this.textPaint.setShadowLayer(this.shadowRadius, offset, offset, colorDown);
        }
        this.textPaint.setColor(this.foregroundColor);
        this.textPaint.setStyle(Paint.Style.FILL);
        layout2.draw(canvas);
        this.textPaint.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
        canvas.restoreToCount(saveCount);
    }

    private void drawBitmapLayout(Canvas canvas) {
        canvas.drawBitmap(this.cueBitmap, null, this.bitmapRect, null);
    }

    private static boolean areCharSequencesEqual(CharSequence first, CharSequence second) {
        return first == second || first != null && first.equals(second);
    }
}

