/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import android.support.v4.media.app.NotificationCompat;
import android.support.v4.media.session.MediaSessionCompat;
import com.google.android.exoplayer2.ControlDispatcher;
import com.google.android.exoplayer2.DefaultControlDispatcher;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.ui.R;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.NotificationUtil;
import com.google.android.exoplayer2.util.Util;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public class PlayerNotificationManager {
    public static final String ACTION_PLAY = "com.google.android.exoplayer.play";
    public static final String ACTION_PAUSE = "com.google.android.exoplayer.pause";
    public static final String ACTION_PREVIOUS = "com.google.android.exoplayer.prev";
    public static final String ACTION_NEXT = "com.google.android.exoplayer.next";
    public static final String ACTION_FAST_FORWARD = "com.google.android.exoplayer.ffwd";
    public static final String ACTION_REWIND = "com.google.android.exoplayer.rewind";
    public static final String ACTION_STOP = "com.google.android.exoplayer.stop";
    public static final String EXTRA_INSTANCE_ID = "INSTANCE_ID";
    public static final int DEFAULT_FAST_FORWARD_MS = 15000;
    public static final int DEFAULT_REWIND_MS = 5000;
    private static final long MAX_POSITION_FOR_SEEK_TO_PREVIOUS = 3000L;
    private static int instanceIdCounter;
    private final Context context;
    private final String channelId;
    private final int notificationId;
    private final MediaDescriptionAdapter mediaDescriptionAdapter;
    @Nullable
    private final CustomActionReceiver customActionReceiver;
    private final Handler mainHandler;
    private final NotificationManagerCompat notificationManager;
    private final IntentFilter intentFilter;
    private final Player.EventListener playerListener;
    private final NotificationBroadcastReceiver notificationBroadcastReceiver;
    private final Map<String, NotificationCompat.Action> playbackActions;
    private final Map<String, NotificationCompat.Action> customActions;
    private final int instanceId;
    @Nullable
    private Player player;
    private ControlDispatcher controlDispatcher;
    private boolean isNotificationStarted;
    private int currentNotificationTag;
    @Nullable
    private NotificationListener notificationListener;
    @Nullable
    private MediaSessionCompat.Token mediaSessionToken;
    private boolean useNavigationActions;
    private boolean usePlayPauseActions;
    @Nullable
    private String stopAction;
    @Nullable
    private PendingIntent stopPendingIntent;
    private long fastForwardMs;
    private long rewindMs;
    private int badgeIconType;
    private boolean colorized;
    private int defaults;
    private int color;
    @DrawableRes
    private int smallIconResourceId;
    private int visibility;
    private int priority;
    private boolean ongoing;
    private boolean useChronometer;
    private boolean wasPlayWhenReady;
    private int lastPlaybackState;

    public static PlayerNotificationManager createWithNotificationChannel(Context context, String channelId, @StringRes int channelName, int notificationId, MediaDescriptionAdapter mediaDescriptionAdapter) {
        NotificationUtil.createNotificationChannel((Context)context, (String)channelId, (int)channelName, (int)2);
        return new PlayerNotificationManager(context, channelId, notificationId, mediaDescriptionAdapter);
    }

    public PlayerNotificationManager(Context context, String channelId, int notificationId, MediaDescriptionAdapter mediaDescriptionAdapter) {
        this(context, channelId, notificationId, mediaDescriptionAdapter, null);
    }

    public PlayerNotificationManager(Context context, String channelId, int notificationId, MediaDescriptionAdapter mediaDescriptionAdapter, @Nullable CustomActionReceiver customActionReceiver) {
        this.context = context.getApplicationContext();
        this.channelId = channelId;
        this.notificationId = notificationId;
        this.mediaDescriptionAdapter = mediaDescriptionAdapter;
        this.customActionReceiver = customActionReceiver;
        this.controlDispatcher = new DefaultControlDispatcher();
        this.instanceId = instanceIdCounter++;
        this.mainHandler = new Handler(Looper.getMainLooper());
        this.notificationManager = NotificationManagerCompat.from((Context)context);
        this.playerListener = new PlayerListener();
        this.notificationBroadcastReceiver = new NotificationBroadcastReceiver();
        this.intentFilter = new IntentFilter();
        this.useNavigationActions = true;
        this.usePlayPauseActions = true;
        this.ongoing = true;
        this.colorized = true;
        this.useChronometer = true;
        this.color = 0;
        this.smallIconResourceId = R.drawable.exo_notification_small_icon;
        this.defaults = 0;
        this.priority = -1;
        this.fastForwardMs = 15000L;
        this.rewindMs = 5000L;
        this.stopAction = ACTION_STOP;
        this.badgeIconType = 1;
        this.visibility = 1;
        this.playbackActions = PlayerNotificationManager.createPlaybackActions(context, this.instanceId);
        for (String action : this.playbackActions.keySet()) {
            this.intentFilter.addAction(action);
        }
        this.customActions = customActionReceiver != null ? customActionReceiver.createCustomActions(context, this.instanceId) : Collections.emptyMap();
        for (String action : this.customActions.keySet()) {
            this.intentFilter.addAction(action);
        }
        this.stopPendingIntent = ((NotificationCompat.Action)Assertions.checkNotNull((Object)this.playbackActions.get((Object)ACTION_STOP))).actionIntent;
    }

    public final void setPlayer(@Nullable Player player) {
        Assertions.checkState((Looper.myLooper() == Looper.getMainLooper() ? 1 : 0) != 0);
        Assertions.checkArgument((player == null || player.getApplicationLooper() == Looper.getMainLooper() ? 1 : 0) != 0);
        if (this.player == player) {
            return;
        }
        if (this.player != null) {
            this.player.removeListener(this.playerListener);
            if (player == null) {
                this.stopNotification();
            }
        }
        this.player = player;
        if (player != null) {
            this.wasPlayWhenReady = player.getPlayWhenReady();
            this.lastPlaybackState = player.getPlaybackState();
            player.addListener(this.playerListener);
            if (this.lastPlaybackState != 1) {
                this.startOrUpdateNotification();
            }
        }
    }

    public final void setControlDispatcher(ControlDispatcher controlDispatcher) {
        this.controlDispatcher = controlDispatcher != null ? controlDispatcher : new DefaultControlDispatcher();
    }

    public final void setNotificationListener(NotificationListener notificationListener) {
        this.notificationListener = notificationListener;
    }

    public final void setFastForwardIncrementMs(long fastForwardMs) {
        if (this.fastForwardMs == fastForwardMs) {
            return;
        }
        this.fastForwardMs = fastForwardMs;
        this.invalidate();
    }

    public final void setRewindIncrementMs(long rewindMs) {
        if (this.rewindMs == rewindMs) {
            return;
        }
        this.rewindMs = rewindMs;
        this.invalidate();
    }

    public final void setUseNavigationActions(boolean useNavigationActions) {
        if (this.useNavigationActions != useNavigationActions) {
            this.useNavigationActions = useNavigationActions;
            this.invalidate();
        }
    }

    public final void setUsePlayPauseActions(boolean usePlayPauseActions) {
        if (this.usePlayPauseActions != usePlayPauseActions) {
            this.usePlayPauseActions = usePlayPauseActions;
            this.invalidate();
        }
    }

    public final void setStopAction(@Nullable String stopAction) {
        if (Util.areEqual((Object)stopAction, (Object)this.stopAction)) {
            return;
        }
        this.stopAction = stopAction;
        this.stopPendingIntent = ACTION_STOP.equals(stopAction) ? ((NotificationCompat.Action)Assertions.checkNotNull((Object)this.playbackActions.get((Object)ACTION_STOP))).actionIntent : (stopAction != null ? ((NotificationCompat.Action)Assertions.checkNotNull((Object)this.customActions.get((Object)stopAction))).actionIntent : null);
        this.invalidate();
    }

    public final void setMediaSessionToken(MediaSessionCompat.Token token) {
        if (!Util.areEqual((Object)this.mediaSessionToken, (Object)token)) {
            this.mediaSessionToken = token;
            this.invalidate();
        }
    }

    public final void setBadgeIconType(int badgeIconType) {
        if (this.badgeIconType == badgeIconType) {
            return;
        }
        switch (badgeIconType) {
            case 0: 
            case 1: 
            case 2: {
                this.badgeIconType = badgeIconType;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.invalidate();
    }

    public final void setColorized(boolean colorized) {
        if (this.colorized != colorized) {
            this.colorized = colorized;
            this.invalidate();
        }
    }

    public final void setDefaults(int defaults) {
        if (this.defaults != defaults) {
            this.defaults = defaults;
            this.invalidate();
        }
    }

    public final void setColor(int color) {
        if (this.color != color) {
            this.color = color;
            this.invalidate();
        }
    }

    public final void setOngoing(boolean ongoing) {
        if (this.ongoing != ongoing) {
            this.ongoing = ongoing;
            this.invalidate();
        }
    }

    public final void setPriority(int priority) {
        if (this.priority == priority) {
            return;
        }
        switch (priority) {
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 2: {
                this.priority = priority;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.invalidate();
    }

    public final void setSmallIcon(@DrawableRes int smallIconResourceId) {
        if (this.smallIconResourceId != smallIconResourceId) {
            this.smallIconResourceId = smallIconResourceId;
            this.invalidate();
        }
    }

    public final void setUseChronometer(boolean useChronometer) {
        if (this.useChronometer != useChronometer) {
            this.useChronometer = useChronometer;
            this.invalidate();
        }
    }

    public final void setVisibility(int visibility) {
        if (this.visibility == visibility) {
            return;
        }
        switch (visibility) {
            case -1: 
            case 0: 
            case 1: {
                this.visibility = visibility;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.invalidate();
    }

    public void invalidate() {
        if (this.isNotificationStarted && this.player != null) {
            this.updateNotification(null);
        }
    }

    @RequiresNonNull(value={"player"})
    private Notification updateNotification(@Nullable Bitmap bitmap) {
        Notification notification = this.createNotification(this.player, bitmap);
        this.notificationManager.notify(this.notificationId, notification);
        return notification;
    }

    private void startOrUpdateNotification() {
        if (this.player != null) {
            Notification notification = this.updateNotification(null);
            if (!this.isNotificationStarted) {
                this.isNotificationStarted = true;
                this.context.registerReceiver((BroadcastReceiver)this.notificationBroadcastReceiver, this.intentFilter);
                if (this.notificationListener != null) {
                    this.notificationListener.onNotificationStarted(this.notificationId, notification);
                }
            }
        }
    }

    private void stopNotification() {
        if (this.isNotificationStarted) {
            this.notificationManager.cancel(this.notificationId);
            this.isNotificationStarted = false;
            this.context.unregisterReceiver((BroadcastReceiver)this.notificationBroadcastReceiver);
            if (this.notificationListener != null) {
                this.notificationListener.onNotificationCancelled(this.notificationId);
            }
        }
    }

    protected Notification createNotification(Player player, @Nullable Bitmap largeIcon) {
        PendingIntent contentIntent;
        NotificationCompat.Builder builder = new NotificationCompat.Builder(this.context, this.channelId);
        List<String> actionNames = this.getActions(player);
        for (int i = 0; i < actionNames.size(); ++i) {
            NotificationCompat.Action action;
            String actionName = actionNames.get(i);
            NotificationCompat.Action action2 = action = this.playbackActions.containsKey(actionName) ? this.playbackActions.get(actionName) : this.customActions.get(actionName);
            if (action == null) continue;
            builder.addAction(action);
        }
        NotificationCompat.MediaStyle mediaStyle = new NotificationCompat.MediaStyle();
        if (this.mediaSessionToken != null) {
            mediaStyle.setMediaSession(this.mediaSessionToken);
        }
        mediaStyle.setShowActionsInCompactView(this.getActionIndicesForCompactView(actionNames, player));
        boolean useStopAction = this.stopAction != null;
        mediaStyle.setShowCancelButton(useStopAction);
        if (useStopAction && this.stopPendingIntent != null) {
            builder.setDeleteIntent(this.stopPendingIntent);
            mediaStyle.setCancelButtonIntent(this.stopPendingIntent);
        }
        builder.setStyle((NotificationCompat.Style)mediaStyle);
        builder.setBadgeIconType(this.badgeIconType).setOngoing(this.ongoing).setColor(this.color).setColorized(this.colorized).setSmallIcon(this.smallIconResourceId).setVisibility(this.visibility).setPriority(this.priority).setDefaults(this.defaults);
        if (this.useChronometer && !player.isPlayingAd() && !player.isCurrentWindowDynamic() && player.getPlayWhenReady() && player.getPlaybackState() == 3) {
            builder.setWhen(System.currentTimeMillis() - player.getContentPosition()).setShowWhen(true).setUsesChronometer(true);
        } else {
            builder.setShowWhen(false).setUsesChronometer(false);
        }
        builder.setContentTitle((CharSequence)this.mediaDescriptionAdapter.getCurrentContentTitle(player));
        builder.setContentText((CharSequence)this.mediaDescriptionAdapter.getCurrentContentText(player));
        if (largeIcon == null) {
            largeIcon = this.mediaDescriptionAdapter.getCurrentLargeIcon(player, new BitmapCallback(++this.currentNotificationTag));
        }
        if (largeIcon != null) {
            builder.setLargeIcon(largeIcon);
        }
        if ((contentIntent = this.mediaDescriptionAdapter.createCurrentContentIntent(player)) != null) {
            builder.setContentIntent(contentIntent);
        }
        return builder.build();
    }

    protected List<String> getActions(Player player) {
        boolean isPlayingAd = player.isPlayingAd();
        ArrayList<String> stringActions = new ArrayList<String>();
        if (!isPlayingAd) {
            if (this.useNavigationActions) {
                stringActions.add(ACTION_PREVIOUS);
            }
            if (this.rewindMs > 0L) {
                stringActions.add(ACTION_REWIND);
            }
        }
        if (this.usePlayPauseActions) {
            if (player.getPlayWhenReady()) {
                stringActions.add(ACTION_PAUSE);
            } else {
                stringActions.add(ACTION_PLAY);
            }
        }
        if (!isPlayingAd) {
            if (this.fastForwardMs > 0L) {
                stringActions.add(ACTION_FAST_FORWARD);
            }
            if (this.useNavigationActions && player.getNextWindowIndex() != -1) {
                stringActions.add(ACTION_NEXT);
            }
        }
        if (this.customActionReceiver != null) {
            stringActions.addAll(this.customActionReceiver.getCustomActions(player));
        }
        if (ACTION_STOP.equals(this.stopAction)) {
            stringActions.add(this.stopAction);
        }
        return stringActions;
    }

    protected int[] getActionIndicesForCompactView(List<String> actionNames, Player player) {
        int[] nArray;
        int pauseActionIndex = actionNames.indexOf(ACTION_PAUSE);
        int playActionIndex = actionNames.indexOf(ACTION_PLAY);
        if (pauseActionIndex != -1) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = pauseActionIndex;
        } else if (playActionIndex != -1) {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = playActionIndex;
        } else {
            nArray = new int[]{};
        }
        return nArray;
    }

    private static Map<String, NotificationCompat.Action> createPlaybackActions(Context context, int instanceId) {
        HashMap<String, NotificationCompat.Action> actions = new HashMap<String, NotificationCompat.Action>();
        actions.put(ACTION_PLAY, new NotificationCompat.Action(R.drawable.exo_notification_play, (CharSequence)context.getString(R.string.exo_controls_play_description), PlayerNotificationManager.createBroadcastIntent(ACTION_PLAY, context, instanceId)));
        actions.put(ACTION_PAUSE, new NotificationCompat.Action(R.drawable.exo_notification_pause, (CharSequence)context.getString(R.string.exo_controls_pause_description), PlayerNotificationManager.createBroadcastIntent(ACTION_PAUSE, context, instanceId)));
        actions.put(ACTION_STOP, new NotificationCompat.Action(R.drawable.exo_notification_stop, (CharSequence)context.getString(R.string.exo_controls_stop_description), PlayerNotificationManager.createBroadcastIntent(ACTION_STOP, context, instanceId)));
        actions.put(ACTION_REWIND, new NotificationCompat.Action(R.drawable.exo_notification_rewind, (CharSequence)context.getString(R.string.exo_controls_rewind_description), PlayerNotificationManager.createBroadcastIntent(ACTION_REWIND, context, instanceId)));
        actions.put(ACTION_FAST_FORWARD, new NotificationCompat.Action(R.drawable.exo_notification_fastforward, (CharSequence)context.getString(R.string.exo_controls_fastforward_description), PlayerNotificationManager.createBroadcastIntent(ACTION_FAST_FORWARD, context, instanceId)));
        actions.put(ACTION_PREVIOUS, new NotificationCompat.Action(R.drawable.exo_notification_previous, (CharSequence)context.getString(R.string.exo_controls_previous_description), PlayerNotificationManager.createBroadcastIntent(ACTION_PREVIOUS, context, instanceId)));
        actions.put(ACTION_NEXT, new NotificationCompat.Action(R.drawable.exo_notification_next, (CharSequence)context.getString(R.string.exo_controls_next_description), PlayerNotificationManager.createBroadcastIntent(ACTION_NEXT, context, instanceId)));
        return actions;
    }

    private static PendingIntent createBroadcastIntent(String action, Context context, int instanceId) {
        Intent intent = new Intent(action).setPackage(context.getPackageName());
        intent.putExtra(EXTRA_INSTANCE_ID, instanceId);
        return PendingIntent.getBroadcast((Context)context, (int)instanceId, (Intent)intent, (int)0x10000000);
    }

    private class NotificationBroadcastReceiver
    extends BroadcastReceiver {
        private final Timeline.Window window = new Timeline.Window();

        public void onReceive(Context context, Intent intent) {
            Player player = PlayerNotificationManager.this.player;
            if (player == null || !PlayerNotificationManager.this.isNotificationStarted || intent.getIntExtra(PlayerNotificationManager.EXTRA_INSTANCE_ID, PlayerNotificationManager.this.instanceId) != PlayerNotificationManager.this.instanceId) {
                return;
            }
            String action = intent.getAction();
            if (PlayerNotificationManager.ACTION_PLAY.equals(action) || PlayerNotificationManager.ACTION_PAUSE.equals(action)) {
                PlayerNotificationManager.this.controlDispatcher.dispatchSetPlayWhenReady(player, PlayerNotificationManager.ACTION_PLAY.equals(action));
            } else if (PlayerNotificationManager.ACTION_FAST_FORWARD.equals(action) || PlayerNotificationManager.ACTION_REWIND.equals(action)) {
                long increment = PlayerNotificationManager.ACTION_FAST_FORWARD.equals(action) ? PlayerNotificationManager.this.fastForwardMs : -PlayerNotificationManager.this.rewindMs;
                PlayerNotificationManager.this.controlDispatcher.dispatchSeekTo(player, player.getCurrentWindowIndex(), player.getCurrentPosition() + increment);
            } else if (PlayerNotificationManager.ACTION_NEXT.equals(action)) {
                int nextWindowIndex = player.getNextWindowIndex();
                if (nextWindowIndex != -1) {
                    PlayerNotificationManager.this.controlDispatcher.dispatchSeekTo(player, nextWindowIndex, -9223372036854775807L);
                }
            } else if (PlayerNotificationManager.ACTION_PREVIOUS.equals(action)) {
                player.getCurrentTimeline().getWindow(player.getCurrentWindowIndex(), this.window);
                int previousWindowIndex = player.getPreviousWindowIndex();
                if (previousWindowIndex != -1 && (player.getCurrentPosition() <= 3000L || this.window.isDynamic && !this.window.isSeekable)) {
                    PlayerNotificationManager.this.controlDispatcher.dispatchSeekTo(player, previousWindowIndex, -9223372036854775807L);
                } else {
                    PlayerNotificationManager.this.controlDispatcher.dispatchSeekTo(player, player.getCurrentWindowIndex(), -9223372036854775807L);
                }
            } else if (PlayerNotificationManager.ACTION_STOP.equals(action)) {
                PlayerNotificationManager.this.controlDispatcher.dispatchStop(player, true);
                PlayerNotificationManager.this.stopNotification();
            } else if (PlayerNotificationManager.this.customActionReceiver != null && PlayerNotificationManager.this.customActions.containsKey(action)) {
                PlayerNotificationManager.this.customActionReceiver.onCustomAction(player, action, intent);
            }
        }
    }

    private class PlayerListener
    implements Player.EventListener {
        private PlayerListener() {
        }

        public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
            if (PlayerNotificationManager.this.wasPlayWhenReady != playWhenReady && playbackState != 1 || PlayerNotificationManager.this.lastPlaybackState != playbackState) {
                PlayerNotificationManager.this.startOrUpdateNotification();
            }
            PlayerNotificationManager.this.wasPlayWhenReady = playWhenReady;
            PlayerNotificationManager.this.lastPlaybackState = playbackState;
        }

        public void onTimelineChanged(Timeline timeline, @Nullable Object manifest, int reason) {
            if (PlayerNotificationManager.this.player == null || PlayerNotificationManager.this.player.getPlaybackState() == 1) {
                return;
            }
            PlayerNotificationManager.this.startOrUpdateNotification();
        }

        public void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
            if (PlayerNotificationManager.this.player == null || PlayerNotificationManager.this.player.getPlaybackState() == 1) {
                return;
            }
            PlayerNotificationManager.this.startOrUpdateNotification();
        }

        public void onPositionDiscontinuity(int reason) {
            PlayerNotificationManager.this.startOrUpdateNotification();
        }

        public void onRepeatModeChanged(int repeatMode) {
            if (PlayerNotificationManager.this.player == null || PlayerNotificationManager.this.player.getPlaybackState() == 1) {
                return;
            }
            PlayerNotificationManager.this.startOrUpdateNotification();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Priority {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Visibility {
    }

    public final class BitmapCallback {
        private final int notificationTag;

        private BitmapCallback(int notificationTag) {
            this.notificationTag = notificationTag;
        }

        public void onBitmap(Bitmap bitmap) {
            if (bitmap != null) {
                PlayerNotificationManager.this.mainHandler.post(() -> {
                    if (PlayerNotificationManager.this.player != null && this.notificationTag == PlayerNotificationManager.this.currentNotificationTag && PlayerNotificationManager.this.isNotificationStarted) {
                        PlayerNotificationManager.this.updateNotification(bitmap);
                    }
                });
            }
        }
    }

    public static interface NotificationListener {
        public void onNotificationStarted(int var1, Notification var2);

        public void onNotificationCancelled(int var1);
    }

    public static interface CustomActionReceiver {
        public Map<String, NotificationCompat.Action> createCustomActions(Context var1, int var2);

        public List<String> getCustomActions(Player var1);

        public void onCustomAction(Player var1, String var2, Intent var3);
    }

    public static interface MediaDescriptionAdapter {
        public String getCurrentContentTitle(Player var1);

        @Nullable
        public PendingIntent createCurrentContentIntent(Player var1);

        @Nullable
        public String getCurrentContentText(Player var1);

        @Nullable
        public Bitmap getCurrentLargeIcon(Player var1, BitmapCallback var2);
    }
}

