/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.accessibility.CaptioningManager;
import com.google.android.exoplayer2.text.CaptionStyleCompat;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.TextOutput;
import com.google.android.exoplayer2.ui.SubtitlePainter;
import com.google.android.exoplayer2.util.Util;
import java.util.ArrayList;
import java.util.List;

public final class SubtitleView
extends View
implements TextOutput {
    public static final float DEFAULT_TEXT_SIZE_FRACTION = 0.0533f;
    public static final float DEFAULT_BOTTOM_PADDING_FRACTION = 0.08f;
    private final List<SubtitlePainter> painters = new ArrayList<SubtitlePainter>();
    private List<Cue> cues;
    private int textSizeType = 0;
    private float textSize = 0.0533f;
    private boolean applyEmbeddedStyles = true;
    private boolean applyEmbeddedFontSizes = true;
    private CaptionStyleCompat style = CaptionStyleCompat.DEFAULT;
    private float bottomPaddingFraction = 0.08f;

    public SubtitleView(Context context) {
        this(context, null);
    }

    public SubtitleView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void onCues(List<Cue> cues) {
        this.setCues(cues);
    }

    public void setCues(@Nullable List<Cue> cues) {
        int cueCount;
        if (this.cues == cues) {
            return;
        }
        this.cues = cues;
        int n = cueCount = cues == null ? 0 : cues.size();
        while (this.painters.size() < cueCount) {
            this.painters.add(new SubtitlePainter(this.getContext()));
        }
        this.invalidate();
    }

    public void setFixedTextSize(int unit, float size) {
        Context context = this.getContext();
        Resources resources = context == null ? Resources.getSystem() : context.getResources();
        this.setTextSize(2, TypedValue.applyDimension((int)unit, (float)size, (DisplayMetrics)resources.getDisplayMetrics()));
    }

    public void setUserDefaultTextSize() {
        float fontScale = Util.SDK_INT >= 19 && !this.isInEditMode() ? this.getUserCaptionFontScaleV19() : 1.0f;
        this.setFractionalTextSize(0.0533f * fontScale);
    }

    public void setFractionalTextSize(float fractionOfHeight) {
        this.setFractionalTextSize(fractionOfHeight, false);
    }

    public void setFractionalTextSize(float fractionOfHeight, boolean ignorePadding) {
        this.setTextSize(ignorePadding ? 1 : 0, fractionOfHeight);
    }

    private void setTextSize(int textSizeType, float textSize) {
        if (this.textSizeType == textSizeType && this.textSize == textSize) {
            return;
        }
        this.textSizeType = textSizeType;
        this.textSize = textSize;
        this.invalidate();
    }

    public void setApplyEmbeddedStyles(boolean applyEmbeddedStyles) {
        if (this.applyEmbeddedStyles == applyEmbeddedStyles && this.applyEmbeddedFontSizes == applyEmbeddedStyles) {
            return;
        }
        this.applyEmbeddedStyles = applyEmbeddedStyles;
        this.applyEmbeddedFontSizes = applyEmbeddedStyles;
        this.invalidate();
    }

    public void setApplyEmbeddedFontSizes(boolean applyEmbeddedFontSizes) {
        if (this.applyEmbeddedFontSizes == applyEmbeddedFontSizes) {
            return;
        }
        this.applyEmbeddedFontSizes = applyEmbeddedFontSizes;
        this.invalidate();
    }

    public void setUserDefaultStyle() {
        this.setStyle(Util.SDK_INT >= 19 && this.isCaptionManagerEnabled() && !this.isInEditMode() ? this.getUserCaptionStyleV19() : CaptionStyleCompat.DEFAULT);
    }

    public void setStyle(CaptionStyleCompat style) {
        if (this.style == style) {
            return;
        }
        this.style = style;
        this.invalidate();
    }

    public void setBottomPaddingFraction(float bottomPaddingFraction) {
        if (this.bottomPaddingFraction == bottomPaddingFraction) {
            return;
        }
        this.bottomPaddingFraction = bottomPaddingFraction;
        this.invalidate();
    }

    public void dispatchDraw(Canvas canvas) {
        int cueCount = this.cues == null ? 0 : this.cues.size();
        int rawTop = this.getTop();
        int rawBottom = this.getBottom();
        int left = this.getLeft() + this.getPaddingLeft();
        int top = rawTop + this.getPaddingTop();
        int right = this.getRight() - this.getPaddingRight();
        int bottom = rawBottom - this.getPaddingBottom();
        if (bottom <= top || right <= left) {
            return;
        }
        int rawViewHeight = rawBottom - rawTop;
        int viewHeightMinusPadding = bottom - top;
        float defaultViewTextSizePx = this.resolveTextSize(this.textSizeType, this.textSize, rawViewHeight, viewHeightMinusPadding);
        if (defaultViewTextSizePx <= 0.0f) {
            return;
        }
        for (int i = 0; i < cueCount; ++i) {
            Cue cue = this.cues.get(i);
            float cueTextSizePx = this.resolveCueTextSize(cue, rawViewHeight, viewHeightMinusPadding);
            SubtitlePainter painter = this.painters.get(i);
            painter.draw(cue, this.applyEmbeddedStyles, this.applyEmbeddedFontSizes, this.style, defaultViewTextSizePx, cueTextSizePx, this.bottomPaddingFraction, canvas, left, top, right, bottom);
        }
    }

    private float resolveCueTextSize(Cue cue, int rawViewHeight, int viewHeightMinusPadding) {
        if (cue.textSizeType == Integer.MIN_VALUE || cue.textSize == Float.MIN_VALUE) {
            return 0.0f;
        }
        float defaultCueTextSizePx = this.resolveTextSize(cue.textSizeType, cue.textSize, rawViewHeight, viewHeightMinusPadding);
        return Math.max(defaultCueTextSizePx, 0.0f);
    }

    private float resolveTextSize(int textSizeType, float textSize, int rawViewHeight, int viewHeightMinusPadding) {
        switch (textSizeType) {
            case 2: {
                return textSize;
            }
            case 0: {
                return textSize * (float)viewHeightMinusPadding;
            }
            case 1: {
                return textSize * (float)rawViewHeight;
            }
        }
        return Float.MIN_VALUE;
    }

    @TargetApi(value=19)
    private boolean isCaptionManagerEnabled() {
        CaptioningManager captioningManager = (CaptioningManager)this.getContext().getSystemService("captioning");
        return captioningManager.isEnabled();
    }

    @TargetApi(value=19)
    private float getUserCaptionFontScaleV19() {
        CaptioningManager captioningManager = (CaptioningManager)this.getContext().getSystemService("captioning");
        return captioningManager.getFontScale();
    }

    @TargetApi(value=19)
    private CaptionStyleCompat getUserCaptionStyleV19() {
        CaptioningManager captioningManager = (CaptioningManager)this.getContext().getSystemService("captioning");
        return CaptionStyleCompat.createFromCaptionStyle((CaptioningManager.CaptionStyle)captioningManager.getUserStyle());
    }
}

