/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.ControlDispatcher;
import com.google.android.exoplayer2.DefaultControlDispatcher;
import com.google.android.exoplayer2.ExoPlayerLibraryInfo;
import com.google.android.exoplayer2.PlaybackPreparer;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.ui.R;
import com.google.android.exoplayer2.ui.TimeBar;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.RepeatModeUtil;
import com.google.android.exoplayer2.util.Util;
import java.util.Arrays;
import java.util.Formatter;
import java.util.Locale;

public class PlayerControlView
extends FrameLayout {
    public static final int DEFAULT_FAST_FORWARD_MS = 15000;
    public static final int DEFAULT_REWIND_MS = 5000;
    public static final int DEFAULT_SHOW_TIMEOUT_MS = 5000;
    public static final int DEFAULT_REPEAT_TOGGLE_MODES = 0;
    public static final int MAX_WINDOWS_FOR_MULTI_WINDOW_TIME_BAR = 100;
    private static final long MAX_POSITION_FOR_SEEK_TO_PREVIOUS = 3000L;
    private final ComponentListener componentListener;
    private final View previousButton;
    private final View nextButton;
    private final View playButton;
    private final View pauseButton;
    private final View fastForwardButton;
    private final View rewindButton;
    private final ImageView repeatToggleButton;
    private final View shuffleButton;
    private final TextView durationView;
    private final TextView positionView;
    private final TimeBar timeBar;
    private final StringBuilder formatBuilder;
    private final Formatter formatter;
    private final Timeline.Period period;
    private final Timeline.Window window;
    private final Drawable repeatOffButtonDrawable;
    private final Drawable repeatOneButtonDrawable;
    private final Drawable repeatAllButtonDrawable;
    private final String repeatOffButtonContentDescription;
    private final String repeatOneButtonContentDescription;
    private final String repeatAllButtonContentDescription;
    private Player player;
    private ControlDispatcher controlDispatcher;
    private VisibilityListener visibilityListener;
    @Nullable
    private PlaybackPreparer playbackPreparer;
    private boolean isAttachedToWindow;
    private boolean showMultiWindowTimeBar;
    private boolean multiWindowTimeBar;
    private boolean scrubbing;
    private int rewindMs;
    private int fastForwardMs;
    private int showTimeoutMs;
    private int repeatToggleModes;
    private boolean showShuffleButton;
    private long hideAtMs;
    private long[] adGroupTimesMs;
    private boolean[] playedAdGroups;
    private long[] extraAdGroupTimesMs;
    private boolean[] extraPlayedAdGroups;
    private final Runnable updateProgressAction = new Runnable(){

        @Override
        public void run() {
            PlayerControlView.this.updateProgress();
        }
    };
    private final Runnable hideAction = new Runnable(){

        @Override
        public void run() {
            PlayerControlView.this.hide();
        }
    };

    public PlayerControlView(Context context) {
        this(context, null);
    }

    public PlayerControlView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PlayerControlView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlayerControlView(Context context, AttributeSet attrs, int defStyleAttr, AttributeSet playbackAttrs) {
        super(context, attrs, defStyleAttr);
        int controllerLayoutId = R.layout.exo_player_control_view;
        this.rewindMs = 5000;
        this.fastForwardMs = 15000;
        this.showTimeoutMs = 5000;
        this.repeatToggleModes = 0;
        this.hideAtMs = -9223372036854775807L;
        this.showShuffleButton = false;
        if (playbackAttrs != null) {
            TypedArray a = context.getTheme().obtainStyledAttributes(playbackAttrs, R.styleable.PlayerControlView, 0, 0);
            try {
                this.rewindMs = a.getInt(R.styleable.PlayerControlView_rewind_increment, this.rewindMs);
                this.fastForwardMs = a.getInt(R.styleable.PlayerControlView_fastforward_increment, this.fastForwardMs);
                this.showTimeoutMs = a.getInt(R.styleable.PlayerControlView_show_timeout, this.showTimeoutMs);
                controllerLayoutId = a.getResourceId(R.styleable.PlayerControlView_controller_layout_id, controllerLayoutId);
                this.repeatToggleModes = PlayerControlView.getRepeatToggleModes(a, this.repeatToggleModes);
                this.showShuffleButton = a.getBoolean(R.styleable.PlayerControlView_show_shuffle_button, this.showShuffleButton);
            }
            finally {
                a.recycle();
            }
        }
        this.period = new Timeline.Period();
        this.window = new Timeline.Window();
        this.formatBuilder = new StringBuilder();
        this.formatter = new Formatter(this.formatBuilder, Locale.getDefault());
        this.adGroupTimesMs = new long[0];
        this.playedAdGroups = new boolean[0];
        this.extraAdGroupTimesMs = new long[0];
        this.extraPlayedAdGroups = new boolean[0];
        this.componentListener = new ComponentListener();
        this.controlDispatcher = new DefaultControlDispatcher();
        LayoutInflater.from((Context)context).inflate(controllerLayoutId, (ViewGroup)this);
        this.setDescendantFocusability(262144);
        this.durationView = (TextView)this.findViewById(R.id.exo_duration);
        this.positionView = (TextView)this.findViewById(R.id.exo_position);
        this.timeBar = (TimeBar)this.findViewById(R.id.exo_progress);
        if (this.timeBar != null) {
            this.timeBar.addListener(this.componentListener);
        }
        this.playButton = this.findViewById(R.id.exo_play);
        if (this.playButton != null) {
            this.playButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.pauseButton = this.findViewById(R.id.exo_pause);
        if (this.pauseButton != null) {
            this.pauseButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.previousButton = this.findViewById(R.id.exo_prev);
        if (this.previousButton != null) {
            this.previousButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.nextButton = this.findViewById(R.id.exo_next);
        if (this.nextButton != null) {
            this.nextButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.rewindButton = this.findViewById(R.id.exo_rew);
        if (this.rewindButton != null) {
            this.rewindButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.fastForwardButton = this.findViewById(R.id.exo_ffwd);
        if (this.fastForwardButton != null) {
            this.fastForwardButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.repeatToggleButton = (ImageView)this.findViewById(R.id.exo_repeat_toggle);
        if (this.repeatToggleButton != null) {
            this.repeatToggleButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.shuffleButton = this.findViewById(R.id.exo_shuffle);
        if (this.shuffleButton != null) {
            this.shuffleButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        Resources resources = context.getResources();
        this.repeatOffButtonDrawable = resources.getDrawable(R.drawable.exo_controls_repeat_off);
        this.repeatOneButtonDrawable = resources.getDrawable(R.drawable.exo_controls_repeat_one);
        this.repeatAllButtonDrawable = resources.getDrawable(R.drawable.exo_controls_repeat_all);
        this.repeatOffButtonContentDescription = resources.getString(R.string.exo_controls_repeat_off_description);
        this.repeatOneButtonContentDescription = resources.getString(R.string.exo_controls_repeat_one_description);
        this.repeatAllButtonContentDescription = resources.getString(R.string.exo_controls_repeat_all_description);
    }

    private static int getRepeatToggleModes(TypedArray a, int repeatToggleModes) {
        return a.getInt(R.styleable.PlayerControlView_repeat_toggle_modes, repeatToggleModes);
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        if (this.player == player) {
            return;
        }
        if (this.player != null) {
            this.player.removeListener((Player.EventListener)this.componentListener);
        }
        this.player = player;
        if (player != null) {
            player.addListener((Player.EventListener)this.componentListener);
        }
        this.updateAll();
    }

    public void setShowMultiWindowTimeBar(boolean showMultiWindowTimeBar) {
        this.showMultiWindowTimeBar = showMultiWindowTimeBar;
        this.updateTimeBarMode();
    }

    public void setExtraAdGroupMarkers(@Nullable long[] extraAdGroupTimesMs, @Nullable boolean[] extraPlayedAdGroups) {
        if (extraAdGroupTimesMs == null) {
            this.extraAdGroupTimesMs = new long[0];
            this.extraPlayedAdGroups = new boolean[0];
        } else {
            Assertions.checkArgument((extraAdGroupTimesMs.length == extraPlayedAdGroups.length ? 1 : 0) != 0);
            this.extraAdGroupTimesMs = extraAdGroupTimesMs;
            this.extraPlayedAdGroups = extraPlayedAdGroups;
        }
        this.updateProgress();
    }

    public void setVisibilityListener(VisibilityListener listener) {
        this.visibilityListener = listener;
    }

    public void setPlaybackPreparer(@Nullable PlaybackPreparer playbackPreparer) {
        this.playbackPreparer = playbackPreparer;
    }

    public void setControlDispatcher(@Nullable ControlDispatcher controlDispatcher) {
        this.controlDispatcher = controlDispatcher == null ? new DefaultControlDispatcher() : controlDispatcher;
    }

    public void setRewindIncrementMs(int rewindMs) {
        this.rewindMs = rewindMs;
        this.updateNavigation();
    }

    public void setFastForwardIncrementMs(int fastForwardMs) {
        this.fastForwardMs = fastForwardMs;
        this.updateNavigation();
    }

    public int getShowTimeoutMs() {
        return this.showTimeoutMs;
    }

    public void setShowTimeoutMs(int showTimeoutMs) {
        this.showTimeoutMs = showTimeoutMs;
        if (this.isVisible()) {
            this.hideAfterTimeout();
        }
    }

    public int getRepeatToggleModes() {
        return this.repeatToggleModes;
    }

    public void setRepeatToggleModes(int repeatToggleModes) {
        this.repeatToggleModes = repeatToggleModes;
        if (this.player != null) {
            int currentMode = this.player.getRepeatMode();
            if (repeatToggleModes == 0 && currentMode != 0) {
                this.controlDispatcher.dispatchSetRepeatMode(this.player, 0);
            } else if (repeatToggleModes == 1 && currentMode == 2) {
                this.controlDispatcher.dispatchSetRepeatMode(this.player, 1);
            } else if (repeatToggleModes == 2 && currentMode == 1) {
                this.controlDispatcher.dispatchSetRepeatMode(this.player, 2);
            }
        }
    }

    public boolean getShowShuffleButton() {
        return this.showShuffleButton;
    }

    public void setShowShuffleButton(boolean showShuffleButton) {
        this.showShuffleButton = showShuffleButton;
        this.updateShuffleButton();
    }

    public void show() {
        if (!this.isVisible()) {
            this.setVisibility(0);
            if (this.visibilityListener != null) {
                this.visibilityListener.onVisibilityChange(this.getVisibility());
            }
            this.updateAll();
            this.requestPlayPauseFocus();
        }
        this.hideAfterTimeout();
    }

    public void hide() {
        if (this.isVisible()) {
            this.setVisibility(8);
            if (this.visibilityListener != null) {
                this.visibilityListener.onVisibilityChange(this.getVisibility());
            }
            this.removeCallbacks(this.updateProgressAction);
            this.removeCallbacks(this.hideAction);
            this.hideAtMs = -9223372036854775807L;
        }
    }

    public boolean isVisible() {
        return this.getVisibility() == 0;
    }

    private void hideAfterTimeout() {
        this.removeCallbacks(this.hideAction);
        if (this.showTimeoutMs > 0) {
            this.hideAtMs = SystemClock.uptimeMillis() + (long)this.showTimeoutMs;
            if (this.isAttachedToWindow) {
                this.postDelayed(this.hideAction, this.showTimeoutMs);
            }
        } else {
            this.hideAtMs = -9223372036854775807L;
        }
    }

    private void updateAll() {
        this.updatePlayPauseButton();
        this.updateNavigation();
        this.updateRepeatModeButton();
        this.updateShuffleButton();
        this.updateProgress();
    }

    private void updatePlayPauseButton() {
        if (!this.isVisible() || !this.isAttachedToWindow) {
            return;
        }
        boolean requestPlayPauseFocus = false;
        boolean playing = this.isPlaying();
        if (this.playButton != null) {
            requestPlayPauseFocus |= playing && this.playButton.isFocused();
            this.playButton.setVisibility(playing ? 8 : 0);
        }
        if (this.pauseButton != null) {
            requestPlayPauseFocus |= !playing && this.pauseButton.isFocused();
            this.pauseButton.setVisibility(!playing ? 8 : 0);
        }
        if (requestPlayPauseFocus) {
            this.requestPlayPauseFocus();
        }
    }

    private void updateNavigation() {
        if (!this.isVisible() || !this.isAttachedToWindow) {
            return;
        }
        Timeline timeline = this.player != null ? this.player.getCurrentTimeline() : null;
        boolean haveNonEmptyTimeline = timeline != null && !timeline.isEmpty();
        boolean isSeekable = false;
        boolean enablePrevious = false;
        boolean enableNext = false;
        if (haveNonEmptyTimeline && !this.player.isPlayingAd()) {
            int windowIndex = this.player.getCurrentWindowIndex();
            timeline.getWindow(windowIndex, this.window);
            isSeekable = this.window.isSeekable;
            enablePrevious = isSeekable || !this.window.isDynamic || this.player.getPreviousWindowIndex() != -1;
            enableNext = this.window.isDynamic || this.player.getNextWindowIndex() != -1;
        }
        this.setButtonEnabled(enablePrevious, this.previousButton);
        this.setButtonEnabled(enableNext, this.nextButton);
        this.setButtonEnabled(this.fastForwardMs > 0 && isSeekable, this.fastForwardButton);
        this.setButtonEnabled(this.rewindMs > 0 && isSeekable, this.rewindButton);
        if (this.timeBar != null) {
            this.timeBar.setEnabled(isSeekable);
        }
    }

    private void updateRepeatModeButton() {
        if (!this.isVisible() || !this.isAttachedToWindow || this.repeatToggleButton == null) {
            return;
        }
        if (this.repeatToggleModes == 0) {
            this.repeatToggleButton.setVisibility(8);
            return;
        }
        if (this.player == null) {
            this.setButtonEnabled(false, (View)this.repeatToggleButton);
            return;
        }
        this.setButtonEnabled(true, (View)this.repeatToggleButton);
        switch (this.player.getRepeatMode()) {
            case 0: {
                this.repeatToggleButton.setImageDrawable(this.repeatOffButtonDrawable);
                this.repeatToggleButton.setContentDescription((CharSequence)this.repeatOffButtonContentDescription);
                break;
            }
            case 1: {
                this.repeatToggleButton.setImageDrawable(this.repeatOneButtonDrawable);
                this.repeatToggleButton.setContentDescription((CharSequence)this.repeatOneButtonContentDescription);
                break;
            }
            case 2: {
                this.repeatToggleButton.setImageDrawable(this.repeatAllButtonDrawable);
                this.repeatToggleButton.setContentDescription((CharSequence)this.repeatAllButtonContentDescription);
                break;
            }
        }
        this.repeatToggleButton.setVisibility(0);
    }

    private void updateShuffleButton() {
        if (!this.isVisible() || !this.isAttachedToWindow || this.shuffleButton == null) {
            return;
        }
        if (!this.showShuffleButton) {
            this.shuffleButton.setVisibility(8);
        } else if (this.player == null) {
            this.setButtonEnabled(false, this.shuffleButton);
        } else {
            this.shuffleButton.setAlpha(this.player.getShuffleModeEnabled() ? 1.0f : 0.3f);
            this.shuffleButton.setEnabled(true);
            this.shuffleButton.setVisibility(0);
        }
    }

    private void updateTimeBarMode() {
        if (this.player == null) {
            return;
        }
        this.multiWindowTimeBar = this.showMultiWindowTimeBar && PlayerControlView.canShowMultiWindowTimeBar(this.player.getCurrentTimeline(), this.window);
    }

    private void updateProgress() {
        int playbackState;
        if (!this.isVisible() || !this.isAttachedToWindow) {
            return;
        }
        long position = 0L;
        long bufferedPosition = 0L;
        long duration = 0L;
        if (this.player != null) {
            long currentWindowTimeBarOffsetUs = 0L;
            long durationUs = 0L;
            int adGroupCount = 0;
            Timeline timeline = this.player.getCurrentTimeline();
            if (!timeline.isEmpty()) {
                int currentWindowIndex = this.player.getCurrentWindowIndex();
                int firstWindowIndex = this.multiWindowTimeBar ? 0 : currentWindowIndex;
                int lastWindowIndex = this.multiWindowTimeBar ? timeline.getWindowCount() - 1 : currentWindowIndex;
                for (int i = firstWindowIndex; i <= lastWindowIndex; ++i) {
                    if (i == currentWindowIndex) {
                        currentWindowTimeBarOffsetUs = durationUs;
                    }
                    timeline.getWindow(i, this.window);
                    if (this.window.durationUs == -9223372036854775807L) {
                        Assertions.checkState((!this.multiWindowTimeBar ? 1 : 0) != 0);
                        break;
                    }
                    for (int j = this.window.firstPeriodIndex; j <= this.window.lastPeriodIndex; ++j) {
                        timeline.getPeriod(j, this.period);
                        int periodAdGroupCount = this.period.getAdGroupCount();
                        for (int adGroupIndex = 0; adGroupIndex < periodAdGroupCount; ++adGroupIndex) {
                            long adGroupTimeInWindowUs;
                            long adGroupTimeInPeriodUs = this.period.getAdGroupTimeUs(adGroupIndex);
                            if (adGroupTimeInPeriodUs == Long.MIN_VALUE) {
                                if (this.period.durationUs == -9223372036854775807L) continue;
                                adGroupTimeInPeriodUs = this.period.durationUs;
                            }
                            if ((adGroupTimeInWindowUs = adGroupTimeInPeriodUs + this.period.getPositionInWindowUs()) < 0L || adGroupTimeInWindowUs > this.window.durationUs) continue;
                            if (adGroupCount == this.adGroupTimesMs.length) {
                                int newLength = this.adGroupTimesMs.length == 0 ? 1 : this.adGroupTimesMs.length * 2;
                                this.adGroupTimesMs = Arrays.copyOf(this.adGroupTimesMs, newLength);
                                this.playedAdGroups = Arrays.copyOf(this.playedAdGroups, newLength);
                            }
                            this.adGroupTimesMs[adGroupCount] = C.usToMs((long)(durationUs + adGroupTimeInWindowUs));
                            this.playedAdGroups[adGroupCount] = this.period.hasPlayedAdGroup(adGroupIndex);
                            ++adGroupCount;
                        }
                    }
                    durationUs += this.window.durationUs;
                }
            }
            duration = C.usToMs((long)durationUs);
            bufferedPosition = position = C.usToMs((long)currentWindowTimeBarOffsetUs);
            if (this.player.isPlayingAd()) {
                bufferedPosition = position += this.player.getContentPosition();
            } else {
                position += this.player.getCurrentPosition();
                bufferedPosition += this.player.getBufferedPosition();
            }
            if (this.timeBar != null) {
                int extraAdGroupCount = this.extraAdGroupTimesMs.length;
                int totalAdGroupCount = adGroupCount + extraAdGroupCount;
                if (totalAdGroupCount > this.adGroupTimesMs.length) {
                    this.adGroupTimesMs = Arrays.copyOf(this.adGroupTimesMs, totalAdGroupCount);
                    this.playedAdGroups = Arrays.copyOf(this.playedAdGroups, totalAdGroupCount);
                }
                System.arraycopy(this.extraAdGroupTimesMs, 0, this.adGroupTimesMs, adGroupCount, extraAdGroupCount);
                System.arraycopy(this.extraPlayedAdGroups, 0, this.playedAdGroups, adGroupCount, extraAdGroupCount);
                this.timeBar.setAdGroupTimesMs(this.adGroupTimesMs, this.playedAdGroups, totalAdGroupCount);
            }
        }
        if (this.durationView != null) {
            this.durationView.setText((CharSequence)Util.getStringForTime((StringBuilder)this.formatBuilder, (Formatter)this.formatter, (long)duration));
        }
        if (this.positionView != null && !this.scrubbing) {
            this.positionView.setText((CharSequence)Util.getStringForTime((StringBuilder)this.formatBuilder, (Formatter)this.formatter, (long)position));
        }
        if (this.timeBar != null) {
            this.timeBar.setPosition(position);
            this.timeBar.setBufferedPosition(bufferedPosition);
            this.timeBar.setDuration(duration);
        }
        this.removeCallbacks(this.updateProgressAction);
        int n = playbackState = this.player == null ? 1 : this.player.getPlaybackState();
        if (playbackState != 1 && playbackState != 4) {
            long delayMs;
            if (this.player.getPlayWhenReady() && playbackState == 3) {
                float playbackSpeed = this.player.getPlaybackParameters().speed;
                if (playbackSpeed <= 0.1f) {
                    delayMs = 1000L;
                } else if (playbackSpeed <= 5.0f) {
                    long mediaTimeUpdatePeriodMs = 1000 / Math.max(1, Math.round(1.0f / playbackSpeed));
                    long mediaTimeDelayMs = mediaTimeUpdatePeriodMs - position % mediaTimeUpdatePeriodMs;
                    if (mediaTimeDelayMs < mediaTimeUpdatePeriodMs / 5L) {
                        mediaTimeDelayMs += mediaTimeUpdatePeriodMs;
                    }
                    delayMs = playbackSpeed == 1.0f ? mediaTimeDelayMs : (long)((float)mediaTimeDelayMs / playbackSpeed);
                } else {
                    delayMs = 200L;
                }
            } else {
                delayMs = 1000L;
            }
            this.postDelayed(this.updateProgressAction, delayMs);
        }
    }

    private void requestPlayPauseFocus() {
        boolean playing = this.isPlaying();
        if (!playing && this.playButton != null) {
            this.playButton.requestFocus();
        } else if (playing && this.pauseButton != null) {
            this.pauseButton.requestFocus();
        }
    }

    private void setButtonEnabled(boolean enabled, View view) {
        if (view == null) {
            return;
        }
        view.setEnabled(enabled);
        view.setAlpha(enabled ? 1.0f : 0.3f);
        view.setVisibility(0);
    }

    private void previous() {
        Timeline timeline = this.player.getCurrentTimeline();
        if (timeline.isEmpty()) {
            return;
        }
        int windowIndex = this.player.getCurrentWindowIndex();
        timeline.getWindow(windowIndex, this.window);
        int previousWindowIndex = this.player.getPreviousWindowIndex();
        if (previousWindowIndex != -1 && (this.player.getCurrentPosition() <= 3000L || this.window.isDynamic && !this.window.isSeekable)) {
            this.seekTo(previousWindowIndex, -9223372036854775807L);
        } else {
            this.seekTo(0L);
        }
    }

    private void next() {
        Timeline timeline = this.player.getCurrentTimeline();
        if (timeline.isEmpty()) {
            return;
        }
        int windowIndex = this.player.getCurrentWindowIndex();
        int nextWindowIndex = this.player.getNextWindowIndex();
        if (nextWindowIndex != -1) {
            this.seekTo(nextWindowIndex, -9223372036854775807L);
        } else if (timeline.getWindow((int)windowIndex, (Timeline.Window)this.window, (boolean)false).isDynamic) {
            this.seekTo(windowIndex, -9223372036854775807L);
        }
    }

    private void rewind() {
        if (this.rewindMs <= 0) {
            return;
        }
        this.seekTo(Math.max(this.player.getCurrentPosition() - (long)this.rewindMs, 0L));
    }

    private void fastForward() {
        if (this.fastForwardMs <= 0) {
            return;
        }
        long durationMs = this.player.getDuration();
        long seekPositionMs = this.player.getCurrentPosition() + (long)this.fastForwardMs;
        if (durationMs != -9223372036854775807L) {
            seekPositionMs = Math.min(seekPositionMs, durationMs);
        }
        this.seekTo(seekPositionMs);
    }

    private void seekTo(long positionMs) {
        this.seekTo(this.player.getCurrentWindowIndex(), positionMs);
    }

    private void seekTo(int windowIndex, long positionMs) {
        boolean dispatched = this.controlDispatcher.dispatchSeekTo(this.player, windowIndex, positionMs);
        if (!dispatched) {
            this.updateProgress();
        }
    }

    private void seekToTimeBarPosition(long positionMs) {
        int windowIndex;
        Timeline timeline = this.player.getCurrentTimeline();
        if (this.multiWindowTimeBar && !timeline.isEmpty()) {
            long windowDurationMs;
            int windowCount = timeline.getWindowCount();
            windowIndex = 0;
            while (positionMs >= (windowDurationMs = timeline.getWindow(windowIndex, this.window).getDurationMs())) {
                if (windowIndex == windowCount - 1) {
                    positionMs = windowDurationMs;
                    break;
                }
                positionMs -= windowDurationMs;
                ++windowIndex;
            }
        } else {
            windowIndex = this.player.getCurrentWindowIndex();
        }
        this.seekTo(windowIndex, positionMs);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.isAttachedToWindow = true;
        if (this.hideAtMs != -9223372036854775807L) {
            long delayMs = this.hideAtMs - SystemClock.uptimeMillis();
            if (delayMs <= 0L) {
                this.hide();
            } else {
                this.postDelayed(this.hideAction, delayMs);
            }
        } else if (this.isVisible()) {
            this.hideAfterTimeout();
        }
        this.updateAll();
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.isAttachedToWindow = false;
        this.removeCallbacks(this.updateProgressAction);
        this.removeCallbacks(this.hideAction);
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        return this.dispatchMediaKeyEvent(event) || super.dispatchKeyEvent(event);
    }

    public boolean dispatchMediaKeyEvent(KeyEvent event) {
        int keyCode = event.getKeyCode();
        if (this.player == null || !PlayerControlView.isHandledMediaKey(keyCode)) {
            return false;
        }
        if (event.getAction() == 0) {
            if (keyCode == 90) {
                this.fastForward();
            } else if (keyCode == 89) {
                this.rewind();
            } else if (event.getRepeatCount() == 0) {
                switch (keyCode) {
                    case 85: {
                        this.controlDispatcher.dispatchSetPlayWhenReady(this.player, !this.player.getPlayWhenReady());
                        break;
                    }
                    case 126: {
                        this.controlDispatcher.dispatchSetPlayWhenReady(this.player, true);
                        break;
                    }
                    case 127: {
                        this.controlDispatcher.dispatchSetPlayWhenReady(this.player, false);
                        break;
                    }
                    case 87: {
                        this.next();
                        break;
                    }
                    case 88: {
                        this.previous();
                        break;
                    }
                }
            }
        }
        return true;
    }

    private boolean isPlaying() {
        return this.player != null && this.player.getPlaybackState() != 4 && this.player.getPlaybackState() != 1 && this.player.getPlayWhenReady();
    }

    @SuppressLint(value={"InlinedApi"})
    private static boolean isHandledMediaKey(int keyCode) {
        return keyCode == 90 || keyCode == 89 || keyCode == 85 || keyCode == 126 || keyCode == 127 || keyCode == 87 || keyCode == 88;
    }

    private static boolean canShowMultiWindowTimeBar(Timeline timeline, Timeline.Window window) {
        if (timeline.getWindowCount() > 100) {
            return false;
        }
        int windowCount = timeline.getWindowCount();
        for (int i = 0; i < windowCount; ++i) {
            if (timeline.getWindow((int)i, (Timeline.Window)window).durationUs != -9223372036854775807L) continue;
            return false;
        }
        return true;
    }

    static {
        ExoPlayerLibraryInfo.registerModule((String)"goog.exo.ui");
    }

    private final class ComponentListener
    extends Player.DefaultEventListener
    implements TimeBar.OnScrubListener,
    View.OnClickListener {
        private ComponentListener() {
        }

        @Override
        public void onScrubStart(TimeBar timeBar, long position) {
            PlayerControlView.this.removeCallbacks(PlayerControlView.this.hideAction);
            PlayerControlView.this.scrubbing = true;
        }

        @Override
        public void onScrubMove(TimeBar timeBar, long position) {
            if (PlayerControlView.this.positionView != null) {
                PlayerControlView.this.positionView.setText((CharSequence)Util.getStringForTime((StringBuilder)PlayerControlView.this.formatBuilder, (Formatter)PlayerControlView.this.formatter, (long)position));
            }
        }

        @Override
        public void onScrubStop(TimeBar timeBar, long position, boolean canceled) {
            PlayerControlView.this.scrubbing = false;
            if (!canceled && PlayerControlView.this.player != null) {
                PlayerControlView.this.seekToTimeBarPosition(position);
            }
            PlayerControlView.this.hideAfterTimeout();
        }

        public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
            PlayerControlView.this.updatePlayPauseButton();
            PlayerControlView.this.updateProgress();
        }

        public void onRepeatModeChanged(int repeatMode) {
            PlayerControlView.this.updateRepeatModeButton();
            PlayerControlView.this.updateNavigation();
        }

        public void onShuffleModeEnabledChanged(boolean shuffleModeEnabled) {
            PlayerControlView.this.updateShuffleButton();
            PlayerControlView.this.updateNavigation();
        }

        public void onPositionDiscontinuity(int reason) {
            PlayerControlView.this.updateNavigation();
            PlayerControlView.this.updateProgress();
        }

        public void onTimelineChanged(Timeline timeline, @Nullable Object manifest, int reason) {
            PlayerControlView.this.updateNavigation();
            PlayerControlView.this.updateTimeBarMode();
            PlayerControlView.this.updateProgress();
        }

        public void onClick(View view) {
            if (PlayerControlView.this.player != null) {
                if (PlayerControlView.this.nextButton == view) {
                    PlayerControlView.this.next();
                } else if (PlayerControlView.this.previousButton == view) {
                    PlayerControlView.this.previous();
                } else if (PlayerControlView.this.fastForwardButton == view) {
                    PlayerControlView.this.fastForward();
                } else if (PlayerControlView.this.rewindButton == view) {
                    PlayerControlView.this.rewind();
                } else if (PlayerControlView.this.playButton == view) {
                    if (PlayerControlView.this.player.getPlaybackState() == 1) {
                        if (PlayerControlView.this.playbackPreparer != null) {
                            PlayerControlView.this.playbackPreparer.preparePlayback();
                        }
                    } else if (PlayerControlView.this.player.getPlaybackState() == 4) {
                        PlayerControlView.this.controlDispatcher.dispatchSeekTo(PlayerControlView.this.player, PlayerControlView.this.player.getCurrentWindowIndex(), -9223372036854775807L);
                    }
                    PlayerControlView.this.controlDispatcher.dispatchSetPlayWhenReady(PlayerControlView.this.player, true);
                } else if (PlayerControlView.this.pauseButton == view) {
                    PlayerControlView.this.controlDispatcher.dispatchSetPlayWhenReady(PlayerControlView.this.player, false);
                } else if (PlayerControlView.this.repeatToggleButton == view) {
                    PlayerControlView.this.controlDispatcher.dispatchSetRepeatMode(PlayerControlView.this.player, RepeatModeUtil.getNextRepeatMode((int)PlayerControlView.this.player.getRepeatMode(), (int)PlayerControlView.this.repeatToggleModes));
                } else if (PlayerControlView.this.shuffleButton == view) {
                    PlayerControlView.this.controlDispatcher.dispatchSetShuffleModeEnabled(PlayerControlView.this.player, !PlayerControlView.this.player.getShuffleModeEnabled());
                }
            }
            PlayerControlView.this.hideAfterTimeout();
        }
    }

    public static interface VisibilityListener {
        public void onVisibilityChange(int var1);
    }
}

