/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.google.android.exoplayer2.ControlDispatcher;
import com.google.android.exoplayer2.PlaybackPreparer;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.id3.ApicFrame;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.TextOutput;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.ui.AspectRatioFrameLayout;
import com.google.android.exoplayer2.ui.PlayerControlView;
import com.google.android.exoplayer2.ui.R;
import com.google.android.exoplayer2.ui.SubtitleView;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.VideoListener;
import java.util.List;

public class PlayerView
extends FrameLayout {
    private static final int SURFACE_TYPE_NONE = 0;
    private static final int SURFACE_TYPE_SURFACE_VIEW = 1;
    private static final int SURFACE_TYPE_TEXTURE_VIEW = 2;
    private final AspectRatioFrameLayout contentFrame;
    private final View shutterView;
    private final View surfaceView;
    private final ImageView artworkView;
    private final SubtitleView subtitleView;
    private final PlayerControlView controller;
    private final ComponentListener componentListener;
    private final FrameLayout overlayFrameLayout;
    private Player player;
    private boolean useController;
    private boolean useArtwork;
    private Bitmap defaultArtwork;
    private int controllerShowTimeoutMs;
    private boolean controllerAutoShow;
    private boolean controllerHideDuringAds;
    private boolean controllerHideOnTouch;
    private int textureViewRotation;

    public PlayerView(Context context) {
        this(context, null);
    }

    public PlayerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlayerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (this.isInEditMode()) {
            this.contentFrame = null;
            this.shutterView = null;
            this.surfaceView = null;
            this.artworkView = null;
            this.subtitleView = null;
            this.controller = null;
            this.componentListener = null;
            this.overlayFrameLayout = null;
            ImageView logo = new ImageView(context);
            if (Util.SDK_INT >= 23) {
                PlayerView.configureEditModeLogoV23(this.getResources(), logo);
            } else {
                PlayerView.configureEditModeLogo(this.getResources(), logo);
            }
            this.addView((View)logo);
            return;
        }
        boolean shutterColorSet = false;
        int shutterColor = 0;
        int playerLayoutId = R.layout.exo_player_view;
        boolean useArtwork = true;
        int defaultArtworkId = 0;
        boolean useController = true;
        int surfaceType = 1;
        int resizeMode = 0;
        int controllerShowTimeoutMs = 5000;
        boolean controllerHideOnTouch = true;
        boolean controllerAutoShow = true;
        boolean controllerHideDuringAds = true;
        if (attrs != null) {
            TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.PlayerView, 0, 0);
            try {
                shutterColorSet = a.hasValue(R.styleable.PlayerView_shutter_background_color);
                shutterColor = a.getColor(R.styleable.PlayerView_shutter_background_color, shutterColor);
                playerLayoutId = a.getResourceId(R.styleable.PlayerView_player_layout_id, playerLayoutId);
                useArtwork = a.getBoolean(R.styleable.PlayerView_use_artwork, useArtwork);
                defaultArtworkId = a.getResourceId(R.styleable.PlayerView_default_artwork, defaultArtworkId);
                useController = a.getBoolean(R.styleable.PlayerView_use_controller, useController);
                surfaceType = a.getInt(R.styleable.PlayerView_surface_type, surfaceType);
                resizeMode = a.getInt(R.styleable.PlayerView_resize_mode, resizeMode);
                controllerShowTimeoutMs = a.getInt(R.styleable.PlayerView_show_timeout, controllerShowTimeoutMs);
                controllerHideOnTouch = a.getBoolean(R.styleable.PlayerView_hide_on_touch, controllerHideOnTouch);
                controllerAutoShow = a.getBoolean(R.styleable.PlayerView_auto_show, controllerAutoShow);
                controllerHideDuringAds = a.getBoolean(R.styleable.PlayerView_hide_during_ads, controllerHideDuringAds);
            }
            finally {
                a.recycle();
            }
        }
        LayoutInflater.from((Context)context).inflate(playerLayoutId, (ViewGroup)this);
        this.componentListener = new ComponentListener();
        this.setDescendantFocusability(262144);
        this.contentFrame = (AspectRatioFrameLayout)this.findViewById(R.id.exo_content_frame);
        if (this.contentFrame != null) {
            PlayerView.setResizeModeRaw(this.contentFrame, resizeMode);
        }
        this.shutterView = this.findViewById(R.id.exo_shutter);
        if (this.shutterView != null && shutterColorSet) {
            this.shutterView.setBackgroundColor(shutterColor);
        }
        if (this.contentFrame != null && surfaceType != 0) {
            ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
            this.surfaceView = surfaceType == 2 ? new TextureView(context) : new SurfaceView(context);
            this.surfaceView.setLayoutParams(params);
            this.contentFrame.addView(this.surfaceView, 0);
        } else {
            this.surfaceView = null;
        }
        this.overlayFrameLayout = (FrameLayout)this.findViewById(R.id.exo_overlay);
        this.artworkView = (ImageView)this.findViewById(R.id.exo_artwork);
        boolean bl = this.useArtwork = useArtwork && this.artworkView != null;
        if (defaultArtworkId != 0) {
            this.defaultArtwork = BitmapFactory.decodeResource((Resources)context.getResources(), (int)defaultArtworkId);
        }
        this.subtitleView = (SubtitleView)this.findViewById(R.id.exo_subtitles);
        if (this.subtitleView != null) {
            this.subtitleView.setUserDefaultStyle();
            this.subtitleView.setUserDefaultTextSize();
        }
        PlayerControlView customController = (PlayerControlView)this.findViewById(R.id.exo_controller);
        View controllerPlaceholder = this.findViewById(R.id.exo_controller_placeholder);
        if (customController != null) {
            this.controller = customController;
        } else if (controllerPlaceholder != null) {
            this.controller = new PlayerControlView(context, null, 0, attrs);
            this.controller.setLayoutParams(controllerPlaceholder.getLayoutParams());
            ViewGroup parent = (ViewGroup)controllerPlaceholder.getParent();
            int controllerIndex = parent.indexOfChild(controllerPlaceholder);
            parent.removeView(controllerPlaceholder);
            parent.addView((View)this.controller, controllerIndex);
        } else {
            this.controller = null;
        }
        this.controllerShowTimeoutMs = this.controller != null ? controllerShowTimeoutMs : 0;
        this.controllerHideOnTouch = controllerHideOnTouch;
        this.controllerAutoShow = controllerAutoShow;
        this.controllerHideDuringAds = controllerHideDuringAds;
        this.useController = useController && this.controller != null;
        this.hideController();
    }

    public static void switchTargetView(@NonNull Player player, @Nullable PlayerView oldPlayerView, @Nullable PlayerView newPlayerView) {
        if (oldPlayerView == newPlayerView) {
            return;
        }
        if (newPlayerView != null) {
            newPlayerView.setPlayer(player);
        }
        if (oldPlayerView != null) {
            oldPlayerView.setPlayer(null);
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        if (this.player == player) {
            return;
        }
        if (this.player != null) {
            Player.TextComponent oldTextComponent;
            this.player.removeListener((Player.EventListener)this.componentListener);
            Player.VideoComponent oldVideoComponent = this.player.getVideoComponent();
            if (oldVideoComponent != null) {
                oldVideoComponent.removeVideoListener((VideoListener)this.componentListener);
                if (this.surfaceView instanceof TextureView) {
                    oldVideoComponent.clearVideoTextureView((TextureView)this.surfaceView);
                } else if (this.surfaceView instanceof SurfaceView) {
                    oldVideoComponent.clearVideoSurfaceView((SurfaceView)this.surfaceView);
                }
            }
            if ((oldTextComponent = this.player.getTextComponent()) != null) {
                oldTextComponent.removeTextOutput((TextOutput)this.componentListener);
            }
        }
        this.player = player;
        if (this.useController) {
            this.controller.setPlayer(player);
        }
        if (this.shutterView != null) {
            this.shutterView.setVisibility(0);
        }
        if (this.subtitleView != null) {
            this.subtitleView.setCues(null);
        }
        if (player != null) {
            Player.TextComponent newTextComponent;
            Player.VideoComponent newVideoComponent = player.getVideoComponent();
            if (newVideoComponent != null) {
                if (this.surfaceView instanceof TextureView) {
                    newVideoComponent.setVideoTextureView((TextureView)this.surfaceView);
                } else if (this.surfaceView instanceof SurfaceView) {
                    newVideoComponent.setVideoSurfaceView((SurfaceView)this.surfaceView);
                }
                newVideoComponent.addVideoListener((VideoListener)this.componentListener);
            }
            if ((newTextComponent = player.getTextComponent()) != null) {
                newTextComponent.addTextOutput((TextOutput)this.componentListener);
            }
            player.addListener((Player.EventListener)this.componentListener);
            this.maybeShowController(false);
            this.updateForCurrentTrackSelections();
        } else {
            this.hideController();
            this.hideArtwork();
        }
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (this.surfaceView instanceof SurfaceView) {
            this.surfaceView.setVisibility(visibility);
        }
    }

    public void setResizeMode(int resizeMode) {
        Assertions.checkState((this.contentFrame != null ? 1 : 0) != 0);
        this.contentFrame.setResizeMode(resizeMode);
    }

    public boolean getUseArtwork() {
        return this.useArtwork;
    }

    public void setUseArtwork(boolean useArtwork) {
        Assertions.checkState((!useArtwork || this.artworkView != null ? 1 : 0) != 0);
        if (this.useArtwork != useArtwork) {
            this.useArtwork = useArtwork;
            this.updateForCurrentTrackSelections();
        }
    }

    public Bitmap getDefaultArtwork() {
        return this.defaultArtwork;
    }

    public void setDefaultArtwork(Bitmap defaultArtwork) {
        if (this.defaultArtwork != defaultArtwork) {
            this.defaultArtwork = defaultArtwork;
            this.updateForCurrentTrackSelections();
        }
    }

    public boolean getUseController() {
        return this.useController;
    }

    public void setUseController(boolean useController) {
        Assertions.checkState((!useController || this.controller != null ? 1 : 0) != 0);
        if (this.useController == useController) {
            return;
        }
        this.useController = useController;
        if (useController) {
            this.controller.setPlayer(this.player);
        } else if (this.controller != null) {
            this.controller.hide();
            this.controller.setPlayer(null);
        }
    }

    public void setShutterBackgroundColor(int color2) {
        if (this.shutterView != null) {
            this.shutterView.setBackgroundColor(color2);
        }
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (this.player != null && this.player.isPlayingAd()) {
            this.overlayFrameLayout.requestFocus();
            return super.dispatchKeyEvent(event);
        }
        boolean isDpadWhenControlHidden = this.isDpadKey(event.getKeyCode()) && this.useController && !this.controller.isVisible();
        this.maybeShowController(true);
        return isDpadWhenControlHidden || this.dispatchMediaKeyEvent(event) || super.dispatchKeyEvent(event);
    }

    public boolean dispatchMediaKeyEvent(KeyEvent event) {
        return this.useController && this.controller.dispatchMediaKeyEvent(event);
    }

    public void showController() {
        this.showController(this.shouldShowControllerIndefinitely());
    }

    public void hideController() {
        if (this.controller != null) {
            this.controller.hide();
        }
    }

    public int getControllerShowTimeoutMs() {
        return this.controllerShowTimeoutMs;
    }

    public void setControllerShowTimeoutMs(int controllerShowTimeoutMs) {
        Assertions.checkState((this.controller != null ? 1 : 0) != 0);
        this.controllerShowTimeoutMs = controllerShowTimeoutMs;
        if (this.controller.isVisible()) {
            this.showController();
        }
    }

    public boolean getControllerHideOnTouch() {
        return this.controllerHideOnTouch;
    }

    public void setControllerHideOnTouch(boolean controllerHideOnTouch) {
        Assertions.checkState((this.controller != null ? 1 : 0) != 0);
        this.controllerHideOnTouch = controllerHideOnTouch;
    }

    public boolean getControllerAutoShow() {
        return this.controllerAutoShow;
    }

    public void setControllerAutoShow(boolean controllerAutoShow) {
        this.controllerAutoShow = controllerAutoShow;
    }

    public void setControllerHideDuringAds(boolean controllerHideDuringAds) {
        this.controllerHideDuringAds = controllerHideDuringAds;
    }

    public void setControllerVisibilityListener(PlayerControlView.VisibilityListener listener) {
        Assertions.checkState((this.controller != null ? 1 : 0) != 0);
        this.controller.setVisibilityListener(listener);
    }

    public void setPlaybackPreparer(@Nullable PlaybackPreparer playbackPreparer) {
        Assertions.checkState((this.controller != null ? 1 : 0) != 0);
        this.controller.setPlaybackPreparer(playbackPreparer);
    }

    public void setControlDispatcher(@Nullable ControlDispatcher controlDispatcher) {
        Assertions.checkState((this.controller != null ? 1 : 0) != 0);
        this.controller.setControlDispatcher(controlDispatcher);
    }

    public void setRewindIncrementMs(int rewindMs) {
        Assertions.checkState((this.controller != null ? 1 : 0) != 0);
        this.controller.setRewindIncrementMs(rewindMs);
    }

    public void setFastForwardIncrementMs(int fastForwardMs) {
        Assertions.checkState((this.controller != null ? 1 : 0) != 0);
        this.controller.setFastForwardIncrementMs(fastForwardMs);
    }

    public void setRepeatToggleModes(int repeatToggleModes) {
        Assertions.checkState((this.controller != null ? 1 : 0) != 0);
        this.controller.setRepeatToggleModes(repeatToggleModes);
    }

    public void setShowShuffleButton(boolean showShuffleButton) {
        Assertions.checkState((this.controller != null ? 1 : 0) != 0);
        this.controller.setShowShuffleButton(showShuffleButton);
    }

    public void setShowMultiWindowTimeBar(boolean showMultiWindowTimeBar) {
        Assertions.checkState((this.controller != null ? 1 : 0) != 0);
        this.controller.setShowMultiWindowTimeBar(showMultiWindowTimeBar);
    }

    public View getVideoSurfaceView() {
        return this.surfaceView;
    }

    public FrameLayout getOverlayFrameLayout() {
        return this.overlayFrameLayout;
    }

    public SubtitleView getSubtitleView() {
        return this.subtitleView;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.useController || this.player == null || ev.getActionMasked() != 0) {
            return false;
        }
        if (!this.controller.isVisible()) {
            this.maybeShowController(true);
        } else if (this.controllerHideOnTouch) {
            this.controller.hide();
        }
        return true;
    }

    public boolean onTrackballEvent(MotionEvent ev) {
        if (!this.useController || this.player == null) {
            return false;
        }
        this.maybeShowController(true);
        return true;
    }

    private void maybeShowController(boolean isForced) {
        if (this.isPlayingAd() && this.controllerHideDuringAds) {
            return;
        }
        if (this.useController) {
            boolean wasShowingIndefinitely = this.controller.isVisible() && this.controller.getShowTimeoutMs() <= 0;
            boolean shouldShowIndefinitely = this.shouldShowControllerIndefinitely();
            if (isForced || wasShowingIndefinitely || shouldShowIndefinitely) {
                this.showController(shouldShowIndefinitely);
            }
        }
    }

    private boolean shouldShowControllerIndefinitely() {
        if (this.player == null) {
            return true;
        }
        int playbackState = this.player.getPlaybackState();
        return this.controllerAutoShow && (playbackState == 1 || playbackState == 4 || !this.player.getPlayWhenReady());
    }

    private void showController(boolean showIndefinitely) {
        if (!this.useController) {
            return;
        }
        this.controller.setShowTimeoutMs(showIndefinitely ? 0 : this.controllerShowTimeoutMs);
        this.controller.show();
    }

    private boolean isPlayingAd() {
        return this.player != null && this.player.isPlayingAd() && this.player.getPlayWhenReady();
    }

    private void updateForCurrentTrackSelections() {
        int i;
        if (this.player == null) {
            return;
        }
        TrackSelectionArray selections = this.player.getCurrentTrackSelections();
        for (i = 0; i < selections.length; ++i) {
            if (this.player.getRendererType(i) != 2 || selections.get(i) == null) continue;
            this.hideArtwork();
            return;
        }
        if (this.shutterView != null) {
            this.shutterView.setVisibility(0);
        }
        if (this.useArtwork) {
            for (i = 0; i < selections.length; ++i) {
                TrackSelection selection = selections.get(i);
                if (selection == null) continue;
                for (int j = 0; j < selection.length(); ++j) {
                    Metadata metadata = selection.getFormat((int)j).metadata;
                    if (metadata == null || !this.setArtworkFromMetadata(metadata)) continue;
                    return;
                }
            }
            if (this.setArtworkFromBitmap(this.defaultArtwork)) {
                return;
            }
        }
        this.hideArtwork();
    }

    private boolean setArtworkFromMetadata(Metadata metadata) {
        for (int i = 0; i < metadata.length(); ++i) {
            Metadata.Entry metadataEntry = metadata.get(i);
            if (!(metadataEntry instanceof ApicFrame)) continue;
            byte[] bitmapData = ((ApicFrame)metadataEntry).pictureData;
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])bitmapData, (int)0, (int)bitmapData.length);
            return this.setArtworkFromBitmap(bitmap);
        }
        return false;
    }

    private boolean setArtworkFromBitmap(Bitmap bitmap) {
        if (bitmap != null) {
            int bitmapWidth = bitmap.getWidth();
            int bitmapHeight = bitmap.getHeight();
            if (bitmapWidth > 0 && bitmapHeight > 0) {
                if (this.contentFrame != null) {
                    this.contentFrame.setAspectRatio((float)bitmapWidth / (float)bitmapHeight);
                }
                this.artworkView.setImageBitmap(bitmap);
                this.artworkView.setVisibility(0);
                return true;
            }
        }
        return false;
    }

    private void hideArtwork() {
        if (this.artworkView != null) {
            this.artworkView.setImageResource(17170445);
            this.artworkView.setVisibility(4);
        }
    }

    @TargetApi(value=23)
    private static void configureEditModeLogoV23(Resources resources, ImageView logo) {
        logo.setImageDrawable(resources.getDrawable(R.drawable.exo_edit_mode_logo, null));
        logo.setBackgroundColor(resources.getColor(R.color.exo_edit_mode_background_color, null));
    }

    private static void configureEditModeLogo(Resources resources, ImageView logo) {
        logo.setImageDrawable(resources.getDrawable(R.drawable.exo_edit_mode_logo));
        logo.setBackgroundColor(resources.getColor(R.color.exo_edit_mode_background_color));
    }

    private static void setResizeModeRaw(AspectRatioFrameLayout aspectRatioFrame, int resizeMode) {
        aspectRatioFrame.setResizeMode(resizeMode);
    }

    private static void applyTextureViewRotation(TextureView textureView, int textureViewRotation) {
        float textureViewWidth = textureView.getWidth();
        float textureViewHeight = textureView.getHeight();
        if (textureViewWidth == 0.0f || textureViewHeight == 0.0f || textureViewRotation == 0) {
            textureView.setTransform(null);
        } else {
            Matrix transformMatrix = new Matrix();
            float pivotX = textureViewWidth / 2.0f;
            float pivotY = textureViewHeight / 2.0f;
            transformMatrix.postRotate((float)textureViewRotation, pivotX, pivotY);
            RectF originalTextureRect = new RectF(0.0f, 0.0f, textureViewWidth, textureViewHeight);
            RectF rotatedTextureRect = new RectF();
            transformMatrix.mapRect(rotatedTextureRect, originalTextureRect);
            transformMatrix.postScale(textureViewWidth / rotatedTextureRect.width(), textureViewHeight / rotatedTextureRect.height(), pivotX, pivotY);
            textureView.setTransform(transformMatrix);
        }
    }

    @SuppressLint(value={"InlinedApi"})
    private boolean isDpadKey(int keyCode) {
        return keyCode == 19 || keyCode == 270 || keyCode == 22 || keyCode == 271 || keyCode == 20 || keyCode == 269 || keyCode == 21 || keyCode == 268 || keyCode == 23;
    }

    private final class ComponentListener
    extends Player.DefaultEventListener
    implements TextOutput,
    VideoListener,
    View.OnLayoutChangeListener {
        private ComponentListener() {
        }

        public void onCues(List<Cue> cues) {
            if (PlayerView.this.subtitleView != null) {
                PlayerView.this.subtitleView.onCues(cues);
            }
        }

        public void onVideoSizeChanged(int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
            float videoAspectRatio;
            if (PlayerView.this.contentFrame == null) {
                return;
            }
            float f = videoAspectRatio = height == 0 || width == 0 ? 1.0f : (float)width * pixelWidthHeightRatio / (float)height;
            if (PlayerView.this.surfaceView instanceof TextureView) {
                if (unappliedRotationDegrees == 90 || unappliedRotationDegrees == 270) {
                    videoAspectRatio = 1.0f / videoAspectRatio;
                }
                if (PlayerView.this.textureViewRotation != 0) {
                    PlayerView.this.surfaceView.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                }
                PlayerView.this.textureViewRotation = unappliedRotationDegrees;
                if (PlayerView.this.textureViewRotation != 0) {
                    PlayerView.this.surfaceView.addOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                }
                PlayerView.applyTextureViewRotation((TextureView)PlayerView.this.surfaceView, PlayerView.this.textureViewRotation);
            }
            PlayerView.this.contentFrame.setAspectRatio(videoAspectRatio);
        }

        public void onRenderedFirstFrame() {
            if (PlayerView.this.shutterView != null) {
                PlayerView.this.shutterView.setVisibility(4);
            }
        }

        public void onTracksChanged(TrackGroupArray tracks, TrackSelectionArray selections) {
            PlayerView.this.updateForCurrentTrackSelections();
        }

        public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
            if (PlayerView.this.isPlayingAd() && PlayerView.this.controllerHideDuringAds) {
                PlayerView.this.hideController();
            } else {
                PlayerView.this.maybeShowController(false);
            }
        }

        public void onPositionDiscontinuity(int reason) {
            if (PlayerView.this.isPlayingAd() && PlayerView.this.controllerHideDuringAds) {
                PlayerView.this.hideController();
            }
        }

        public void onLayoutChange(View view, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
            PlayerView.applyTextureViewRotation((TextureView)view, PlayerView.this.textureViewRotation);
        }
    }
}

