/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.annotation.SuppressLint;
import android.widget.TextView;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.decoder.DecoderCounters;
import java.util.Locale;

public final class DebugTextViewHelper
extends Player.DefaultEventListener
implements Runnable {
    private static final int REFRESH_INTERVAL_MS = 1000;
    private final SimpleExoPlayer player;
    private final TextView textView;
    private boolean started;

    public DebugTextViewHelper(SimpleExoPlayer player, TextView textView) {
        this.player = player;
        this.textView = textView;
    }

    public void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.player.addListener((Player.EventListener)this);
        this.updateAndPost();
    }

    public void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        this.player.removeListener((Player.EventListener)this);
        this.textView.removeCallbacks((Runnable)this);
    }

    public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
        this.updateAndPost();
    }

    public void onPositionDiscontinuity(int reason) {
        this.updateAndPost();
    }

    @Override
    public void run() {
        this.updateAndPost();
    }

    @SuppressLint(value={"SetTextI18n"})
    private void updateAndPost() {
        this.textView.setText((CharSequence)(this.getPlayerStateString() + this.getPlayerWindowIndexString() + this.getVideoString() + this.getAudioString()));
        this.textView.removeCallbacks((Runnable)this);
        this.textView.postDelayed((Runnable)this, 1000L);
    }

    private String getPlayerStateString() {
        String text = "playWhenReady:" + this.player.getPlayWhenReady() + " playbackState:";
        switch (this.player.getPlaybackState()) {
            case 2: {
                text = text + "buffering";
                break;
            }
            case 4: {
                text = text + "ended";
                break;
            }
            case 1: {
                text = text + "idle";
                break;
            }
            case 3: {
                text = text + "ready";
                break;
            }
            default: {
                text = text + "unknown";
            }
        }
        return text;
    }

    private String getPlayerWindowIndexString() {
        return " window:" + this.player.getCurrentWindowIndex();
    }

    private String getVideoString() {
        Format format = this.player.getVideoFormat();
        if (format == null) {
            return "";
        }
        return "\n" + format.sampleMimeType + "(id:" + format.id + " r:" + format.width + "x" + format.height + DebugTextViewHelper.getPixelAspectRatioString(format.pixelWidthHeightRatio) + DebugTextViewHelper.getDecoderCountersBufferCountString(this.player.getVideoDecoderCounters()) + ")";
    }

    private String getAudioString() {
        Format format = this.player.getAudioFormat();
        if (format == null) {
            return "";
        }
        return "\n" + format.sampleMimeType + "(id:" + format.id + " hz:" + format.sampleRate + " ch:" + format.channelCount + DebugTextViewHelper.getDecoderCountersBufferCountString(this.player.getAudioDecoderCounters()) + ")";
    }

    private static String getDecoderCountersBufferCountString(DecoderCounters counters) {
        if (counters == null) {
            return "";
        }
        counters.ensureUpdated();
        return " sib:" + counters.skippedInputBufferCount + " sb:" + counters.skippedOutputBufferCount + " rb:" + counters.renderedOutputBufferCount + " db:" + counters.droppedBufferCount + " mcdb:" + counters.maxConsecutiveDroppedBufferCount + " dk:" + counters.droppedToKeyframeCount;
    }

    private static String getPixelAspectRatioString(float pixelAspectRatio) {
        return pixelAspectRatio == -1.0f || pixelAspectRatio == 1.0f ? "" : " par:" + String.format(Locale.US, "%.02f", Float.valueOf(pixelAspectRatio));
    }
}

