/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.text.Spannable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.RelativeSizeSpan;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.span.LanguageFeatureSpan;
import com.google.android.exoplayer2.util.Assertions;
import com.google.common.base.Predicate;

final class SubtitleViewUtils {
    public static float resolveTextSize(int textSizeType, float textSize, int rawViewHeight, int viewHeightMinusPadding) {
        if (textSize == -3.4028235E38f) {
            return -3.4028235E38f;
        }
        switch (textSizeType) {
            case 2: {
                return textSize;
            }
            case 0: {
                return textSize * (float)viewHeightMinusPadding;
            }
            case 1: {
                return textSize * (float)rawViewHeight;
            }
        }
        return -3.4028235E38f;
    }

    public static void removeAllEmbeddedStyling(Cue.Builder cue) {
        cue.clearWindowColor();
        if (cue.getText() instanceof Spanned) {
            if (!(cue.getText() instanceof Spannable)) {
                cue.setText((CharSequence)SpannableString.valueOf((CharSequence)cue.getText()));
            }
            SubtitleViewUtils.removeSpansIf((Spannable)Assertions.checkNotNull((Object)cue.getText()), (Predicate<Object>)((Predicate)span -> !(span instanceof LanguageFeatureSpan)));
        }
        SubtitleViewUtils.removeEmbeddedFontSizes(cue);
    }

    public static void removeEmbeddedFontSizes(Cue.Builder cue) {
        cue.setTextSize(-3.4028235E38f, Integer.MIN_VALUE);
        if (cue.getText() instanceof Spanned) {
            if (!(cue.getText() instanceof Spannable)) {
                cue.setText((CharSequence)SpannableString.valueOf((CharSequence)cue.getText()));
            }
            SubtitleViewUtils.removeSpansIf((Spannable)Assertions.checkNotNull((Object)cue.getText()), (Predicate<Object>)((Predicate)span -> span instanceof AbsoluteSizeSpan || span instanceof RelativeSizeSpan));
        }
    }

    private static void removeSpansIf(Spannable spannable, Predicate<Object> removeFilter) {
        Object[] spans;
        for (Object span : spans = spannable.getSpans(0, spannable.length(), Object.class)) {
            if (!removeFilter.apply(span)) continue;
            spannable.removeSpan(span);
        }
    }

    private SubtitleViewUtils() {
    }
}

