/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.v4.media.session.MediaSessionCompat;
import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import androidx.media.app.NotificationCompat;
import com.google.android.exoplayer2.ControlDispatcher;
import com.google.android.exoplayer2.DefaultControlDispatcher;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.ui.DefaultMediaDescriptionAdapter;
import com.google.android.exoplayer2.ui.R;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.NotificationUtil;
import com.google.android.exoplayer2.util.Util;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PlayerNotificationManager {
    public static final String ACTION_PLAY = "com.google.android.exoplayer.play";
    public static final String ACTION_PAUSE = "com.google.android.exoplayer.pause";
    public static final String ACTION_PREVIOUS = "com.google.android.exoplayer.prev";
    public static final String ACTION_NEXT = "com.google.android.exoplayer.next";
    public static final String ACTION_FAST_FORWARD = "com.google.android.exoplayer.ffwd";
    public static final String ACTION_REWIND = "com.google.android.exoplayer.rewind";
    public static final String ACTION_STOP = "com.google.android.exoplayer.stop";
    public static final String EXTRA_INSTANCE_ID = "INSTANCE_ID";
    private static final String ACTION_DISMISS = "com.google.android.exoplayer.dismiss";
    private static final int MSG_START_OR_UPDATE_NOTIFICATION = 0;
    private static final int MSG_UPDATE_NOTIFICATION_BITMAP = 1;
    private static int instanceIdCounter;
    private final Context context;
    private final String channelId;
    private final int notificationId;
    private final MediaDescriptionAdapter mediaDescriptionAdapter;
    @Nullable
    private final NotificationListener notificationListener;
    @Nullable
    private final CustomActionReceiver customActionReceiver;
    private final Handler mainHandler;
    private final NotificationManagerCompat notificationManager;
    private final IntentFilter intentFilter;
    private final Player.Listener playerListener;
    private final NotificationBroadcastReceiver notificationBroadcastReceiver;
    private final Map<String, NotificationCompat.Action> playbackActions;
    private final Map<String, NotificationCompat.Action> customActions;
    private final PendingIntent dismissPendingIntent;
    private final int instanceId;
    @Nullable
    private NotificationCompat.Builder builder;
    @Nullable
    private List<NotificationCompat.Action> builderActions;
    @Nullable
    private Player player;
    private ControlDispatcher controlDispatcher;
    private boolean isNotificationStarted;
    private int currentNotificationTag;
    @Nullable
    private MediaSessionCompat.Token mediaSessionToken;
    private boolean usePreviousAction;
    private boolean useNextAction;
    private boolean usePreviousActionInCompactView;
    private boolean useNextActionInCompactView;
    private boolean useRewindAction;
    private boolean useFastForwardAction;
    private boolean useRewindActionInCompactView;
    private boolean useFastForwardActionInCompactView;
    private boolean usePlayPauseActions;
    private boolean useStopAction;
    private int badgeIconType;
    private boolean colorized;
    private int defaults;
    private int color;
    @DrawableRes
    private int smallIconResourceId;
    private int visibility;
    private int priority;
    private boolean useChronometer;
    @Nullable
    private String groupKey;

    protected PlayerNotificationManager(Context context, String channelId, int notificationId, MediaDescriptionAdapter mediaDescriptionAdapter, @Nullable NotificationListener notificationListener, @Nullable CustomActionReceiver customActionReceiver, int smallIconResourceId, int playActionIconResourceId, int pauseActionIconResourceId, int stopActionIconResourceId, int rewindActionIconResourceId, int fastForwardActionIconResourceId, int previousActionIconResourceId, int nextActionIconResourceId, @Nullable String groupKey) {
        Handler mainHandler;
        this.context = context = context.getApplicationContext();
        this.channelId = channelId;
        this.notificationId = notificationId;
        this.mediaDescriptionAdapter = mediaDescriptionAdapter;
        this.notificationListener = notificationListener;
        this.customActionReceiver = customActionReceiver;
        this.smallIconResourceId = smallIconResourceId;
        this.groupKey = groupKey;
        this.controlDispatcher = new DefaultControlDispatcher();
        this.instanceId = instanceIdCounter++;
        this.mainHandler = mainHandler = Util.createHandler((Looper)Looper.getMainLooper(), this::handleMessage);
        this.notificationManager = NotificationManagerCompat.from((Context)context);
        this.playerListener = new PlayerListener();
        this.notificationBroadcastReceiver = new NotificationBroadcastReceiver();
        this.intentFilter = new IntentFilter();
        this.usePreviousAction = true;
        this.useNextAction = true;
        this.usePlayPauseActions = true;
        this.useRewindAction = true;
        this.useFastForwardAction = true;
        this.colorized = true;
        this.useChronometer = true;
        this.color = 0;
        this.defaults = 0;
        this.priority = -1;
        this.badgeIconType = 1;
        this.visibility = 1;
        this.playbackActions = PlayerNotificationManager.createPlaybackActions(context, this.instanceId, playActionIconResourceId, pauseActionIconResourceId, stopActionIconResourceId, rewindActionIconResourceId, fastForwardActionIconResourceId, previousActionIconResourceId, nextActionIconResourceId);
        for (String action : this.playbackActions.keySet()) {
            this.intentFilter.addAction(action);
        }
        this.customActions = customActionReceiver != null ? customActionReceiver.createCustomActions(context, this.instanceId) : Collections.emptyMap();
        for (String action : this.customActions.keySet()) {
            this.intentFilter.addAction(action);
        }
        this.dismissPendingIntent = PlayerNotificationManager.createBroadcastIntent(ACTION_DISMISS, context, this.instanceId);
        this.intentFilter.addAction(ACTION_DISMISS);
    }

    public final void setPlayer(@Nullable Player player) {
        Assertions.checkState((Looper.myLooper() == Looper.getMainLooper() ? 1 : 0) != 0);
        Assertions.checkArgument((player == null || player.getApplicationLooper() == Looper.getMainLooper() ? 1 : 0) != 0);
        if (this.player == player) {
            return;
        }
        if (this.player != null) {
            this.player.removeListener(this.playerListener);
            if (player == null) {
                this.stopNotification(false);
            }
        }
        this.player = player;
        if (player != null) {
            player.addListener(this.playerListener);
            this.postStartOrUpdateNotification();
        }
    }

    @Deprecated
    public final void setControlDispatcher(ControlDispatcher controlDispatcher) {
        if (this.controlDispatcher != controlDispatcher) {
            this.controlDispatcher = controlDispatcher;
            this.invalidate();
        }
    }

    public final void setUseNextAction(boolean useNextAction) {
        if (this.useNextAction != useNextAction) {
            this.useNextAction = useNextAction;
            this.invalidate();
        }
    }

    public final void setUsePreviousAction(boolean usePreviousAction) {
        if (this.usePreviousAction != usePreviousAction) {
            this.usePreviousAction = usePreviousAction;
            this.invalidate();
        }
    }

    public final void setUseNextActionInCompactView(boolean useNextActionInCompactView) {
        if (this.useNextActionInCompactView != useNextActionInCompactView) {
            this.useNextActionInCompactView = useNextActionInCompactView;
            if (useNextActionInCompactView) {
                this.useFastForwardActionInCompactView = false;
            }
            this.invalidate();
        }
    }

    public final void setUsePreviousActionInCompactView(boolean usePreviousActionInCompactView) {
        if (this.usePreviousActionInCompactView != usePreviousActionInCompactView) {
            this.usePreviousActionInCompactView = usePreviousActionInCompactView;
            if (usePreviousActionInCompactView) {
                this.useRewindActionInCompactView = false;
            }
            this.invalidate();
        }
    }

    public final void setUseFastForwardAction(boolean useFastForwardAction) {
        if (this.useFastForwardAction != useFastForwardAction) {
            this.useFastForwardAction = useFastForwardAction;
            this.invalidate();
        }
    }

    public final void setUseRewindAction(boolean useRewindAction) {
        if (this.useRewindAction != useRewindAction) {
            this.useRewindAction = useRewindAction;
            this.invalidate();
        }
    }

    public final void setUseFastForwardActionInCompactView(boolean useFastForwardActionInCompactView) {
        if (this.useFastForwardActionInCompactView != useFastForwardActionInCompactView) {
            this.useFastForwardActionInCompactView = useFastForwardActionInCompactView;
            if (useFastForwardActionInCompactView) {
                this.useNextActionInCompactView = false;
            }
            this.invalidate();
        }
    }

    public final void setUseRewindActionInCompactView(boolean useRewindActionInCompactView) {
        if (this.useRewindActionInCompactView != useRewindActionInCompactView) {
            this.useRewindActionInCompactView = useRewindActionInCompactView;
            if (useRewindActionInCompactView) {
                this.usePreviousActionInCompactView = false;
            }
            this.invalidate();
        }
    }

    public final void setUsePlayPauseActions(boolean usePlayPauseActions) {
        if (this.usePlayPauseActions != usePlayPauseActions) {
            this.usePlayPauseActions = usePlayPauseActions;
            this.invalidate();
        }
    }

    public final void setUseStopAction(boolean useStopAction) {
        if (this.useStopAction == useStopAction) {
            return;
        }
        this.useStopAction = useStopAction;
        this.invalidate();
    }

    public final void setMediaSessionToken(MediaSessionCompat.Token token) {
        if (!Util.areEqual((Object)this.mediaSessionToken, (Object)token)) {
            this.mediaSessionToken = token;
            this.invalidate();
        }
    }

    public final void setBadgeIconType(int badgeIconType) {
        if (this.badgeIconType == badgeIconType) {
            return;
        }
        switch (badgeIconType) {
            case 0: 
            case 1: 
            case 2: {
                this.badgeIconType = badgeIconType;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.invalidate();
    }

    public final void setColorized(boolean colorized) {
        if (this.colorized != colorized) {
            this.colorized = colorized;
            this.invalidate();
        }
    }

    public final void setDefaults(int defaults) {
        if (this.defaults != defaults) {
            this.defaults = defaults;
            this.invalidate();
        }
    }

    public final void setColor(int color) {
        if (this.color != color) {
            this.color = color;
            this.invalidate();
        }
    }

    public final void setPriority(int priority) {
        if (this.priority == priority) {
            return;
        }
        switch (priority) {
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 2: {
                this.priority = priority;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.invalidate();
    }

    public final void setSmallIcon(@DrawableRes int smallIconResourceId) {
        if (this.smallIconResourceId != smallIconResourceId) {
            this.smallIconResourceId = smallIconResourceId;
            this.invalidate();
        }
    }

    public final void setUseChronometer(boolean useChronometer) {
        if (this.useChronometer != useChronometer) {
            this.useChronometer = useChronometer;
            this.invalidate();
        }
    }

    public final void setVisibility(int visibility) {
        if (this.visibility == visibility) {
            return;
        }
        switch (visibility) {
            case -1: 
            case 0: 
            case 1: {
                this.visibility = visibility;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.invalidate();
    }

    public final void invalidate() {
        if (this.isNotificationStarted) {
            this.postStartOrUpdateNotification();
        }
    }

    private void startOrUpdateNotification(Player player, @Nullable Bitmap bitmap) {
        boolean ongoing = this.getOngoing(player);
        this.builder = this.createNotification(player, this.builder, ongoing, bitmap);
        if (this.builder == null) {
            this.stopNotification(false);
            return;
        }
        Notification notification = this.builder.build();
        this.notificationManager.notify(this.notificationId, notification);
        if (!this.isNotificationStarted) {
            this.context.registerReceiver((BroadcastReceiver)this.notificationBroadcastReceiver, this.intentFilter);
        }
        if (this.notificationListener != null) {
            this.notificationListener.onNotificationPosted(this.notificationId, notification, ongoing || !this.isNotificationStarted);
        }
        this.isNotificationStarted = true;
    }

    private void stopNotification(boolean dismissedByUser) {
        if (this.isNotificationStarted) {
            this.isNotificationStarted = false;
            this.mainHandler.removeMessages(0);
            this.notificationManager.cancel(this.notificationId);
            this.context.unregisterReceiver((BroadcastReceiver)this.notificationBroadcastReceiver);
            if (this.notificationListener != null) {
                this.notificationListener.onNotificationCancelled(this.notificationId, dismissedByUser);
            }
        }
    }

    @Nullable
    protected NotificationCompat.Builder createNotification(Player player, @Nullable NotificationCompat.Builder builder, boolean ongoing, @Nullable Bitmap largeIcon) {
        int i;
        if (player.getPlaybackState() == 1 && player.getCurrentTimeline().isEmpty()) {
            this.builderActions = null;
            return null;
        }
        List<String> actionNames = this.getActions(player);
        ArrayList<NotificationCompat.Action> actions = new ArrayList<NotificationCompat.Action>(actionNames.size());
        for (i = 0; i < actionNames.size(); ++i) {
            NotificationCompat.Action action;
            String actionName = actionNames.get(i);
            NotificationCompat.Action action2 = action = this.playbackActions.containsKey(actionName) ? this.playbackActions.get(actionName) : this.customActions.get(actionName);
            if (action == null) continue;
            actions.add(action);
        }
        if (builder == null || !actions.equals(this.builderActions)) {
            builder = new NotificationCompat.Builder(this.context, this.channelId);
            this.builderActions = actions;
            for (i = 0; i < actions.size(); ++i) {
                builder.addAction((NotificationCompat.Action)actions.get(i));
            }
        }
        NotificationCompat.MediaStyle mediaStyle = new NotificationCompat.MediaStyle();
        if (this.mediaSessionToken != null) {
            mediaStyle.setMediaSession(this.mediaSessionToken);
        }
        mediaStyle.setShowActionsInCompactView(this.getActionIndicesForCompactView(actionNames, player));
        mediaStyle.setShowCancelButton(!ongoing);
        mediaStyle.setCancelButtonIntent(this.dismissPendingIntent);
        builder.setStyle((NotificationCompat.Style)mediaStyle);
        builder.setDeleteIntent(this.dismissPendingIntent);
        builder.setBadgeIconType(this.badgeIconType).setOngoing(ongoing).setColor(this.color).setColorized(this.colorized).setSmallIcon(this.smallIconResourceId).setVisibility(this.visibility).setPriority(this.priority).setDefaults(this.defaults);
        if (Util.SDK_INT >= 21 && this.useChronometer && player.isPlaying() && !player.isPlayingAd() && !player.isCurrentWindowDynamic() && player.getPlaybackParameters().speed == 1.0f) {
            builder.setWhen(System.currentTimeMillis() - player.getContentPosition()).setShowWhen(true).setUsesChronometer(true);
        } else {
            builder.setShowWhen(false).setUsesChronometer(false);
        }
        builder.setContentTitle(this.mediaDescriptionAdapter.getCurrentContentTitle(player));
        builder.setContentText(this.mediaDescriptionAdapter.getCurrentContentText(player));
        builder.setSubText(this.mediaDescriptionAdapter.getCurrentSubText(player));
        if (largeIcon == null) {
            largeIcon = this.mediaDescriptionAdapter.getCurrentLargeIcon(player, new BitmapCallback(++this.currentNotificationTag));
        }
        PlayerNotificationManager.setLargeIcon(builder, largeIcon);
        builder.setContentIntent(this.mediaDescriptionAdapter.createCurrentContentIntent(player));
        if (this.groupKey != null) {
            builder.setGroup(this.groupKey);
        }
        builder.setOnlyAlertOnce(true);
        return builder;
    }

    protected List<String> getActions(Player player) {
        boolean enablePrevious = player.isCommandAvailable(6);
        boolean enableRewind = player.isCommandAvailable(10) && this.controlDispatcher.isRewindEnabled();
        boolean enableFastForward = player.isCommandAvailable(11) && this.controlDispatcher.isFastForwardEnabled();
        boolean enableNext = player.isCommandAvailable(8);
        ArrayList<String> stringActions = new ArrayList<String>();
        if (this.usePreviousAction && enablePrevious) {
            stringActions.add(ACTION_PREVIOUS);
        }
        if (this.useRewindAction && enableRewind) {
            stringActions.add(ACTION_REWIND);
        }
        if (this.usePlayPauseActions) {
            if (this.shouldShowPauseButton(player)) {
                stringActions.add(ACTION_PAUSE);
            } else {
                stringActions.add(ACTION_PLAY);
            }
        }
        if (this.useFastForwardAction && enableFastForward) {
            stringActions.add(ACTION_FAST_FORWARD);
        }
        if (this.useNextAction && enableNext) {
            stringActions.add(ACTION_NEXT);
        }
        if (this.customActionReceiver != null) {
            stringActions.addAll(this.customActionReceiver.getCustomActions(player));
        }
        if (this.useStopAction) {
            stringActions.add(ACTION_STOP);
        }
        return stringActions;
    }

    protected int[] getActionIndicesForCompactView(List<String> actionNames, Player player) {
        int leftSideActionIndex;
        int pauseActionIndex = actionNames.indexOf(ACTION_PAUSE);
        int playActionIndex = actionNames.indexOf(ACTION_PLAY);
        int n = this.usePreviousActionInCompactView ? actionNames.indexOf(ACTION_PREVIOUS) : (leftSideActionIndex = this.useRewindActionInCompactView ? actionNames.indexOf(ACTION_REWIND) : -1);
        int rightSideActionIndex = this.useNextActionInCompactView ? actionNames.indexOf(ACTION_NEXT) : (this.useFastForwardActionInCompactView ? actionNames.indexOf(ACTION_FAST_FORWARD) : -1);
        int[] actionIndices = new int[3];
        int actionCounter = 0;
        if (leftSideActionIndex != -1) {
            actionIndices[actionCounter++] = leftSideActionIndex;
        }
        boolean shouldShowPauseButton = this.shouldShowPauseButton(player);
        if (pauseActionIndex != -1 && shouldShowPauseButton) {
            actionIndices[actionCounter++] = pauseActionIndex;
        } else if (playActionIndex != -1 && !shouldShowPauseButton) {
            actionIndices[actionCounter++] = playActionIndex;
        }
        if (rightSideActionIndex != -1) {
            actionIndices[actionCounter++] = rightSideActionIndex;
        }
        return Arrays.copyOf(actionIndices, actionCounter);
    }

    protected boolean getOngoing(Player player) {
        int playbackState = player.getPlaybackState();
        return (playbackState == 2 || playbackState == 3) && player.getPlayWhenReady();
    }

    private boolean shouldShowPauseButton(Player player) {
        return player.getPlaybackState() != 4 && player.getPlaybackState() != 1 && player.getPlayWhenReady();
    }

    private void postStartOrUpdateNotification() {
        if (!this.mainHandler.hasMessages(0)) {
            this.mainHandler.sendEmptyMessage(0);
        }
    }

    private void postUpdateNotificationBitmap(Bitmap bitmap, int notificationTag) {
        this.mainHandler.obtainMessage(1, notificationTag, -1, (Object)bitmap).sendToTarget();
    }

    private boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                if (this.player == null) break;
                this.startOrUpdateNotification(this.player, null);
                break;
            }
            case 1: {
                if (this.player == null || !this.isNotificationStarted || this.currentNotificationTag != msg.arg1) break;
                this.startOrUpdateNotification(this.player, (Bitmap)msg.obj);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private static Map<String, NotificationCompat.Action> createPlaybackActions(Context context, int instanceId, int playActionIconResourceId, int pauseActionIconResourceId, int stopActionIconResourceId, int rewindActionIconResourceId, int fastForwardActionIconResourceId, int previousActionIconResourceId, int nextActionIconResourceId) {
        HashMap<String, NotificationCompat.Action> actions = new HashMap<String, NotificationCompat.Action>();
        actions.put(ACTION_PLAY, new NotificationCompat.Action(playActionIconResourceId, (CharSequence)context.getString(R.string.exo_controls_play_description), PlayerNotificationManager.createBroadcastIntent(ACTION_PLAY, context, instanceId)));
        actions.put(ACTION_PAUSE, new NotificationCompat.Action(pauseActionIconResourceId, (CharSequence)context.getString(R.string.exo_controls_pause_description), PlayerNotificationManager.createBroadcastIntent(ACTION_PAUSE, context, instanceId)));
        actions.put(ACTION_STOP, new NotificationCompat.Action(stopActionIconResourceId, (CharSequence)context.getString(R.string.exo_controls_stop_description), PlayerNotificationManager.createBroadcastIntent(ACTION_STOP, context, instanceId)));
        actions.put(ACTION_REWIND, new NotificationCompat.Action(rewindActionIconResourceId, (CharSequence)context.getString(R.string.exo_controls_rewind_description), PlayerNotificationManager.createBroadcastIntent(ACTION_REWIND, context, instanceId)));
        actions.put(ACTION_FAST_FORWARD, new NotificationCompat.Action(fastForwardActionIconResourceId, (CharSequence)context.getString(R.string.exo_controls_fastforward_description), PlayerNotificationManager.createBroadcastIntent(ACTION_FAST_FORWARD, context, instanceId)));
        actions.put(ACTION_PREVIOUS, new NotificationCompat.Action(previousActionIconResourceId, (CharSequence)context.getString(R.string.exo_controls_previous_description), PlayerNotificationManager.createBroadcastIntent(ACTION_PREVIOUS, context, instanceId)));
        actions.put(ACTION_NEXT, new NotificationCompat.Action(nextActionIconResourceId, (CharSequence)context.getString(R.string.exo_controls_next_description), PlayerNotificationManager.createBroadcastIntent(ACTION_NEXT, context, instanceId)));
        return actions;
    }

    private static PendingIntent createBroadcastIntent(String action, Context context, int instanceId) {
        Intent intent = new Intent(action).setPackage(context.getPackageName());
        intent.putExtra(EXTRA_INSTANCE_ID, instanceId);
        int pendingFlags = Util.SDK_INT >= 23 ? 0xC000000 : 0x8000000;
        return PendingIntent.getBroadcast((Context)context, (int)instanceId, (Intent)intent, (int)pendingFlags);
    }

    private static void setLargeIcon(NotificationCompat.Builder builder, @Nullable Bitmap largeIcon) {
        builder.setLargeIcon(largeIcon);
    }

    private class NotificationBroadcastReceiver
    extends BroadcastReceiver {
        private NotificationBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            Player player = PlayerNotificationManager.this.player;
            if (player == null || !PlayerNotificationManager.this.isNotificationStarted || intent.getIntExtra(PlayerNotificationManager.EXTRA_INSTANCE_ID, PlayerNotificationManager.this.instanceId) != PlayerNotificationManager.this.instanceId) {
                return;
            }
            String action = intent.getAction();
            if (PlayerNotificationManager.ACTION_PLAY.equals(action)) {
                if (player.getPlaybackState() == 1) {
                    PlayerNotificationManager.this.controlDispatcher.dispatchPrepare(player);
                } else if (player.getPlaybackState() == 4) {
                    PlayerNotificationManager.this.controlDispatcher.dispatchSeekTo(player, player.getCurrentWindowIndex(), -9223372036854775807L);
                }
                PlayerNotificationManager.this.controlDispatcher.dispatchSetPlayWhenReady(player, true);
            } else if (PlayerNotificationManager.ACTION_PAUSE.equals(action)) {
                PlayerNotificationManager.this.controlDispatcher.dispatchSetPlayWhenReady(player, false);
            } else if (PlayerNotificationManager.ACTION_PREVIOUS.equals(action)) {
                PlayerNotificationManager.this.controlDispatcher.dispatchPrevious(player);
            } else if (PlayerNotificationManager.ACTION_REWIND.equals(action)) {
                PlayerNotificationManager.this.controlDispatcher.dispatchRewind(player);
            } else if (PlayerNotificationManager.ACTION_FAST_FORWARD.equals(action)) {
                PlayerNotificationManager.this.controlDispatcher.dispatchFastForward(player);
            } else if (PlayerNotificationManager.ACTION_NEXT.equals(action)) {
                PlayerNotificationManager.this.controlDispatcher.dispatchNext(player);
            } else if (PlayerNotificationManager.ACTION_STOP.equals(action)) {
                PlayerNotificationManager.this.controlDispatcher.dispatchStop(player, true);
            } else if (PlayerNotificationManager.ACTION_DISMISS.equals(action)) {
                PlayerNotificationManager.this.stopNotification(true);
            } else if (action != null && PlayerNotificationManager.this.customActionReceiver != null && PlayerNotificationManager.this.customActions.containsKey(action)) {
                PlayerNotificationManager.this.customActionReceiver.onCustomAction(player, action, intent);
            }
        }
    }

    private class PlayerListener
    implements Player.Listener {
        private PlayerListener() {
        }

        public void onEvents(Player player, Player.Events events) {
            if (events.containsAny(new int[]{5, 6, 8, 0, 13, 12, 9, 10, 15})) {
                PlayerNotificationManager.this.postStartOrUpdateNotification();
            }
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Priority {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Visibility {
    }

    public final class BitmapCallback {
        private final int notificationTag;

        private BitmapCallback(int notificationTag) {
            this.notificationTag = notificationTag;
        }

        public void onBitmap(Bitmap bitmap) {
            if (bitmap != null) {
                PlayerNotificationManager.this.postUpdateNotificationBitmap(bitmap, this.notificationTag);
            }
        }
    }

    public static class Builder {
        protected final Context context;
        protected final int notificationId;
        protected final String channelId;
        @Nullable
        protected NotificationListener notificationListener;
        @Nullable
        protected CustomActionReceiver customActionReceiver;
        protected MediaDescriptionAdapter mediaDescriptionAdapter;
        protected int channelNameResourceId;
        protected int channelDescriptionResourceId;
        protected int channelImportance;
        protected int smallIconResourceId;
        protected int rewindActionIconResourceId;
        protected int playActionIconResourceId;
        protected int pauseActionIconResourceId;
        protected int stopActionIconResourceId;
        protected int fastForwardActionIconResourceId;
        protected int previousActionIconResourceId;
        protected int nextActionIconResourceId;
        @Nullable
        protected String groupKey;

        @Deprecated
        public Builder(Context context, int notificationId, String channelId, MediaDescriptionAdapter mediaDescriptionAdapter) {
            this(context, notificationId, channelId);
            this.mediaDescriptionAdapter = mediaDescriptionAdapter;
        }

        public Builder(Context context, int notificationId, String channelId) {
            Assertions.checkArgument((notificationId > 0 ? 1 : 0) != 0);
            this.context = context;
            this.notificationId = notificationId;
            this.channelId = channelId;
            this.channelImportance = 2;
            this.mediaDescriptionAdapter = new DefaultMediaDescriptionAdapter(null);
            this.smallIconResourceId = R.drawable.exo_notification_small_icon;
            this.playActionIconResourceId = R.drawable.exo_notification_play;
            this.pauseActionIconResourceId = R.drawable.exo_notification_pause;
            this.stopActionIconResourceId = R.drawable.exo_notification_stop;
            this.rewindActionIconResourceId = R.drawable.exo_notification_rewind;
            this.fastForwardActionIconResourceId = R.drawable.exo_notification_fastforward;
            this.previousActionIconResourceId = R.drawable.exo_notification_previous;
            this.nextActionIconResourceId = R.drawable.exo_notification_next;
        }

        public Builder setChannelNameResourceId(int channelNameResourceId) {
            this.channelNameResourceId = channelNameResourceId;
            return this;
        }

        public Builder setChannelDescriptionResourceId(int channelDescriptionResourceId) {
            this.channelDescriptionResourceId = channelDescriptionResourceId;
            return this;
        }

        public Builder setChannelImportance(int channelImportance) {
            this.channelImportance = channelImportance;
            return this;
        }

        public Builder setNotificationListener(NotificationListener notificationListener) {
            this.notificationListener = notificationListener;
            return this;
        }

        public Builder setCustomActionReceiver(CustomActionReceiver customActionReceiver) {
            this.customActionReceiver = customActionReceiver;
            return this;
        }

        public Builder setSmallIconResourceId(int smallIconResourceId) {
            this.smallIconResourceId = smallIconResourceId;
            return this;
        }

        public Builder setPlayActionIconResourceId(int playActionIconResourceId) {
            this.playActionIconResourceId = playActionIconResourceId;
            return this;
        }

        public Builder setPauseActionIconResourceId(int pauseActionIconResourceId) {
            this.pauseActionIconResourceId = pauseActionIconResourceId;
            return this;
        }

        public Builder setStopActionIconResourceId(int stopActionIconResourceId) {
            this.stopActionIconResourceId = stopActionIconResourceId;
            return this;
        }

        public Builder setRewindActionIconResourceId(int rewindActionIconResourceId) {
            this.rewindActionIconResourceId = rewindActionIconResourceId;
            return this;
        }

        public Builder setFastForwardActionIconResourceId(int fastForwardActionIconResourceId) {
            this.fastForwardActionIconResourceId = fastForwardActionIconResourceId;
            return this;
        }

        public Builder setPreviousActionIconResourceId(int previousActionIconResourceId) {
            this.previousActionIconResourceId = previousActionIconResourceId;
            return this;
        }

        public Builder setNextActionIconResourceId(int nextActionIconResourceId) {
            this.nextActionIconResourceId = nextActionIconResourceId;
            return this;
        }

        public Builder setGroup(String groupKey) {
            this.groupKey = groupKey;
            return this;
        }

        public Builder setMediaDescriptionAdapter(MediaDescriptionAdapter mediaDescriptionAdapter) {
            this.mediaDescriptionAdapter = mediaDescriptionAdapter;
            return this;
        }

        public PlayerNotificationManager build() {
            if (this.channelNameResourceId != 0) {
                NotificationUtil.createNotificationChannel((Context)this.context, (String)this.channelId, (int)this.channelNameResourceId, (int)this.channelDescriptionResourceId, (int)this.channelImportance);
            }
            return new PlayerNotificationManager(this.context, this.channelId, this.notificationId, this.mediaDescriptionAdapter, this.notificationListener, this.customActionReceiver, this.smallIconResourceId, this.playActionIconResourceId, this.pauseActionIconResourceId, this.stopActionIconResourceId, this.rewindActionIconResourceId, this.fastForwardActionIconResourceId, this.previousActionIconResourceId, this.nextActionIconResourceId, this.groupKey);
        }
    }

    public static interface NotificationListener {
        default public void onNotificationCancelled(int notificationId, boolean dismissedByUser) {
        }

        default public void onNotificationPosted(int notificationId, Notification notification, boolean ongoing) {
        }
    }

    public static interface CustomActionReceiver {
        public Map<String, NotificationCompat.Action> createCustomActions(Context var1, int var2);

        public List<String> getCustomActions(Player var1);

        public void onCustomAction(Player var1, String var2, Intent var3);
    }

    public static interface MediaDescriptionAdapter {
        public CharSequence getCurrentContentTitle(Player var1);

        @Nullable
        public PendingIntent createCurrentContentIntent(Player var1);

        @Nullable
        public CharSequence getCurrentContentText(Player var1);

        @Nullable
        default public CharSequence getCurrentSubText(Player player) {
            return null;
        }

        @Nullable
        public Bitmap getCurrentLargeIcon(Player var1, BitmapCallback var2);
    }
}

