/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui.spherical;

import android.content.Context;
import android.graphics.PointF;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.BinderThread;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.ui.spherical.OrientationListener;
import com.google.android.exoplayer2.ui.spherical.SingleTapListener;

class TouchTracker
extends GestureDetector.SimpleOnGestureListener
implements View.OnTouchListener,
OrientationListener.Listener {
    static final float MAX_PITCH_DEGREES = 45.0f;
    private final PointF previousTouchPointPx = new PointF();
    private final PointF accumulatedTouchOffsetDegrees = new PointF();
    private final Listener listener;
    private final float pxPerDegrees;
    private final GestureDetector gestureDetector;
    private volatile float roll;
    @Nullable
    private SingleTapListener singleTapListener;

    public TouchTracker(Context context, Listener listener, float pxPerDegrees) {
        this.listener = listener;
        this.pxPerDegrees = pxPerDegrees;
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this);
        this.roll = (float)Math.PI;
    }

    public void setSingleTapListener(@Nullable SingleTapListener listener) {
        this.singleTapListener = listener;
    }

    public boolean onTouch(View v, MotionEvent event) {
        return this.gestureDetector.onTouchEvent(event);
    }

    public boolean onDown(MotionEvent e) {
        this.previousTouchPointPx.set(e.getX(), e.getY());
        return true;
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        float touchX = (e2.getX() - this.previousTouchPointPx.x) / this.pxPerDegrees;
        float touchY = (e2.getY() - this.previousTouchPointPx.y) / this.pxPerDegrees;
        this.previousTouchPointPx.set(e2.getX(), e2.getY());
        float r = this.roll;
        float cr = (float)Math.cos(r);
        float sr = (float)Math.sin(r);
        this.accumulatedTouchOffsetDegrees.x -= cr * touchX - sr * touchY;
        this.accumulatedTouchOffsetDegrees.y += sr * touchX + cr * touchY;
        this.accumulatedTouchOffsetDegrees.y = Math.max(-45.0f, Math.min(45.0f, this.accumulatedTouchOffsetDegrees.y));
        this.listener.onScrollChange(this.accumulatedTouchOffsetDegrees);
        return true;
    }

    public boolean onSingleTapUp(MotionEvent e) {
        if (this.singleTapListener != null) {
            return this.singleTapListener.onSingleTapUp(e);
        }
        return false;
    }

    @Override
    @BinderThread
    public void onOrientationChange(float[] deviceOrientationMatrix, float roll) {
        this.roll = -roll;
    }

    static interface Listener {
        public void onScrollChange(PointF var1);
    }
}

