/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.text.CaptionStyleCompat;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.ui.SubtitlePainter;
import com.google.android.exoplayer2.ui.SubtitleView;
import com.google.android.exoplayer2.ui.SubtitleViewUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class CanvasSubtitleOutput
extends View
implements SubtitleView.Output {
    private final List<SubtitlePainter> painters = new ArrayList<SubtitlePainter>();
    private List<Cue> cues = Collections.emptyList();
    private int textSizeType = 0;
    private float textSize = 0.0533f;
    private CaptionStyleCompat style = CaptionStyleCompat.DEFAULT;
    private float bottomPaddingFraction = 0.08f;

    public CanvasSubtitleOutput(Context context) {
        this(context, null);
    }

    public CanvasSubtitleOutput(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public void update(List<Cue> cues, CaptionStyleCompat style2, float textSize, int textSizeType, float bottomPaddingFraction) {
        this.cues = cues;
        this.style = style2;
        this.textSize = textSize;
        this.textSizeType = textSizeType;
        this.bottomPaddingFraction = bottomPaddingFraction;
        while (this.painters.size() < cues.size()) {
            this.painters.add(new SubtitlePainter(this.getContext()));
        }
        this.invalidate();
    }

    public void dispatchDraw(Canvas canvas) {
        List<Cue> cues = this.cues;
        if (cues.isEmpty()) {
            return;
        }
        int rawViewHeight = this.getHeight();
        int left = this.getPaddingLeft();
        int top = this.getPaddingTop();
        int right = this.getWidth() - this.getPaddingRight();
        int bottom = rawViewHeight - this.getPaddingBottom();
        if (bottom <= top || right <= left) {
            return;
        }
        int viewHeightMinusPadding = bottom - top;
        float defaultViewTextSizePx = SubtitleViewUtils.resolveTextSize(this.textSizeType, this.textSize, rawViewHeight, viewHeightMinusPadding);
        if (defaultViewTextSizePx <= 0.0f) {
            return;
        }
        int cueCount = cues.size();
        for (int i = 0; i < cueCount; ++i) {
            Cue cue = cues.get(i);
            if (cue.verticalType != Integer.MIN_VALUE) {
                cue = CanvasSubtitleOutput.repositionVerticalCue(cue);
            }
            float cueTextSizePx = SubtitleViewUtils.resolveTextSize(cue.textSizeType, cue.textSize, rawViewHeight, viewHeightMinusPadding);
            SubtitlePainter painter = this.painters.get(i);
            painter.draw(cue, this.style, defaultViewTextSizePx, cueTextSizePx, this.bottomPaddingFraction, canvas, left, top, right, bottom);
        }
    }

    private static Cue repositionVerticalCue(Cue cue) {
        Cue.Builder cueBuilder = cue.buildUpon().setPosition(-3.4028235E38f).setPositionAnchor(Integer.MIN_VALUE).setTextAlignment(null);
        if (cue.lineType == 0) {
            cueBuilder.setLine(1.0f - cue.line, 0);
        } else {
            cueBuilder.setLine(-cue.line - 1.0f, 1);
        }
        switch (cue.lineAnchor) {
            case 2: {
                cueBuilder.setLineAnchor(0);
                break;
            }
            case 0: {
                cueBuilder.setLineAnchor(2);
                break;
            }
        }
        return cueBuilder.build();
    }
}

