/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.text.Html;
import android.text.Spanned;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.TypefaceSpan;
import android.text.style.UnderlineSpan;
import android.util.SparseArray;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.text.span.HorizontalTextInVerticalContextSpan;
import com.google.android.exoplayer2.text.span.RubySpan;
import com.google.android.exoplayer2.ui.HtmlUtils;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

final class SpannedToHtmlConverter {
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("(&#13;)?&#10;");

    private SpannedToHtmlConverter() {
    }

    public static HtmlAndCss convert(@Nullable CharSequence text, float displayDensity) {
        if (text == null) {
            return new HtmlAndCss("", (Map)ImmutableMap.of());
        }
        if (!(text instanceof Spanned)) {
            return new HtmlAndCss(SpannedToHtmlConverter.escapeHtml(text), (Map)ImmutableMap.of());
        }
        Spanned spanned = (Spanned)text;
        HashSet<Integer> backgroundColors = new HashSet<Integer>();
        for (BackgroundColorSpan backgroundColorSpan : (BackgroundColorSpan[])spanned.getSpans(0, spanned.length(), BackgroundColorSpan.class)) {
            backgroundColors.add(backgroundColorSpan.getBackgroundColor());
        }
        HashMap<String, String> cssRuleSets = new HashMap<String, String>();
        Iterator iterator = backgroundColors.iterator();
        while (iterator.hasNext()) {
            int backgroundColor = (Integer)iterator.next();
            cssRuleSets.put(HtmlUtils.cssAllClassDescendantsSelector("bg_" + backgroundColor), Util.formatInvariant((String)"background-color:%s;", (Object[])new Object[]{HtmlUtils.toCssRgba(backgroundColor)}));
        }
        SparseArray<Transition> spanTransitions = SpannedToHtmlConverter.findSpanTransitions(spanned, displayDensity);
        StringBuilder html = new StringBuilder(spanned.length());
        int previousTransition = 0;
        for (int i = 0; i < spanTransitions.size(); ++i) {
            int index = spanTransitions.keyAt(i);
            html.append(SpannedToHtmlConverter.escapeHtml(spanned.subSequence(previousTransition, index)));
            Transition transition = (Transition)spanTransitions.get(index);
            Collections.sort(transition.spansRemoved, SpanInfo.FOR_CLOSING_TAGS);
            for (SpanInfo spanInfo : transition.spansRemoved) {
                html.append(spanInfo.closingTag);
            }
            Collections.sort(transition.spansAdded, SpanInfo.FOR_OPENING_TAGS);
            for (SpanInfo spanInfo : transition.spansAdded) {
                html.append(spanInfo.openingTag);
            }
            previousTransition = index;
        }
        html.append(SpannedToHtmlConverter.escapeHtml(spanned.subSequence(previousTransition, spanned.length())));
        return new HtmlAndCss(html.toString(), cssRuleSets);
    }

    private static SparseArray<Transition> findSpanTransitions(Spanned spanned, float displayDensity) {
        SparseArray spanTransitions = new SparseArray();
        for (Object span : spanned.getSpans(0, spanned.length(), Object.class)) {
            String openingTag = SpannedToHtmlConverter.getOpeningTag(span, displayDensity);
            String closingTag = SpannedToHtmlConverter.getClosingTag(span);
            int spanStart = spanned.getSpanStart(span);
            int spanEnd = spanned.getSpanEnd(span);
            if (openingTag == null) continue;
            Assertions.checkNotNull((Object)closingTag);
            SpanInfo spanInfo = new SpanInfo(spanStart, spanEnd, openingTag, closingTag);
            SpannedToHtmlConverter.getOrCreate((SparseArray<Transition>)spanTransitions, spanStart).spansAdded.add(spanInfo);
            SpannedToHtmlConverter.getOrCreate((SparseArray<Transition>)spanTransitions, spanEnd).spansRemoved.add(spanInfo);
        }
        return spanTransitions;
    }

    @Nullable
    private static String getOpeningTag(Object span, float displayDensity) {
        if (span instanceof StrikethroughSpan) {
            return "<span style='text-decoration:line-through;'>";
        }
        if (span instanceof ForegroundColorSpan) {
            ForegroundColorSpan colorSpan = (ForegroundColorSpan)span;
            return Util.formatInvariant((String)"<span style='color:%s;'>", (Object[])new Object[]{HtmlUtils.toCssRgba(colorSpan.getForegroundColor())});
        }
        if (span instanceof BackgroundColorSpan) {
            BackgroundColorSpan colorSpan = (BackgroundColorSpan)span;
            return Util.formatInvariant((String)"<span class='bg_%s'>", (Object[])new Object[]{colorSpan.getBackgroundColor()});
        }
        if (span instanceof HorizontalTextInVerticalContextSpan) {
            return "<span style='text-combine-upright:all;'>";
        }
        if (span instanceof AbsoluteSizeSpan) {
            AbsoluteSizeSpan absoluteSizeSpan = (AbsoluteSizeSpan)span;
            float sizeCssPx = absoluteSizeSpan.getDip() ? (float)absoluteSizeSpan.getSize() : (float)absoluteSizeSpan.getSize() / displayDensity;
            return Util.formatInvariant((String)"<span style='font-size:%.2fpx;'>", (Object[])new Object[]{Float.valueOf(sizeCssPx)});
        }
        if (span instanceof RelativeSizeSpan) {
            return Util.formatInvariant((String)"<span style='font-size:%.2f%%;'>", (Object[])new Object[]{Float.valueOf(((RelativeSizeSpan)span).getSizeChange() * 100.0f)});
        }
        if (span instanceof TypefaceSpan) {
            String fontFamily = ((TypefaceSpan)span).getFamily();
            return fontFamily != null ? Util.formatInvariant((String)"<span style='font-family:\"%s\";'>", (Object[])new Object[]{fontFamily}) : null;
        }
        if (span instanceof StyleSpan) {
            switch (((StyleSpan)span).getStyle()) {
                case 1: {
                    return "<b>";
                }
                case 2: {
                    return "<i>";
                }
                case 3: {
                    return "<b><i>";
                }
            }
            return null;
        }
        if (span instanceof RubySpan) {
            RubySpan rubySpan = (RubySpan)span;
            switch (rubySpan.position) {
                case 1: {
                    return "<ruby style='ruby-position:over;'>";
                }
                case 2: {
                    return "<ruby style='ruby-position:under;'>";
                }
                case -1: {
                    return "<ruby style='ruby-position:unset;'>";
                }
            }
            return null;
        }
        if (span instanceof UnderlineSpan) {
            return "<u>";
        }
        return null;
    }

    @Nullable
    private static String getClosingTag(Object span) {
        if (span instanceof StrikethroughSpan || span instanceof ForegroundColorSpan || span instanceof BackgroundColorSpan || span instanceof HorizontalTextInVerticalContextSpan || span instanceof AbsoluteSizeSpan || span instanceof RelativeSizeSpan) {
            return "</span>";
        }
        if (span instanceof TypefaceSpan) {
            String fontFamily = ((TypefaceSpan)span).getFamily();
            return fontFamily != null ? "</span>" : null;
        }
        if (span instanceof StyleSpan) {
            switch (((StyleSpan)span).getStyle()) {
                case 1: {
                    return "</b>";
                }
                case 2: {
                    return "</i>";
                }
                case 3: {
                    return "</i></b>";
                }
            }
        } else {
            if (span instanceof RubySpan) {
                RubySpan rubySpan = (RubySpan)span;
                return "<rt>" + SpannedToHtmlConverter.escapeHtml(rubySpan.rubyText) + "</rt></ruby>";
            }
            if (span instanceof UnderlineSpan) {
                return "</u>";
            }
        }
        return null;
    }

    private static Transition getOrCreate(SparseArray<Transition> transitions, int key) {
        Transition transition = (Transition)transitions.get(key);
        if (transition == null) {
            transition = new Transition();
            transitions.put(key, (Object)transition);
        }
        return transition;
    }

    private static String escapeHtml(CharSequence text) {
        String escaped = Html.escapeHtml((CharSequence)text);
        return NEWLINE_PATTERN.matcher(escaped).replaceAll("<br>");
    }

    private static final class Transition {
        private final List<SpanInfo> spansAdded = new ArrayList<SpanInfo>();
        private final List<SpanInfo> spansRemoved = new ArrayList<SpanInfo>();
    }

    private static final class SpanInfo {
        private static final Comparator<SpanInfo> FOR_OPENING_TAGS = (info1, info2) -> {
            int result = Integer.compare(info2.end, info1.end);
            if (result != 0) {
                return result;
            }
            result = info1.openingTag.compareTo(info2.openingTag);
            if (result != 0) {
                return result;
            }
            return info1.closingTag.compareTo(info2.closingTag);
        };
        private static final Comparator<SpanInfo> FOR_CLOSING_TAGS = (info1, info2) -> {
            int result = Integer.compare(info2.start, info1.start);
            if (result != 0) {
                return result;
            }
            result = info2.openingTag.compareTo(info1.openingTag);
            if (result != 0) {
                return result;
            }
            return info2.closingTag.compareTo(info1.closingTag);
        };
        public final int start;
        public final int end;
        public final String openingTag;
        public final String closingTag;

        private SpanInfo(int start, int end, String openingTag, String closingTag) {
            this.start = start;
            this.end = end;
            this.openingTag = openingTag;
            this.closingTag = closingTag;
        }
    }

    public static class HtmlAndCss {
        public final String html;
        public final Map<String, String> cssRuleSets;

        private HtmlAndCss(String html, Map<String, String> cssRuleSets) {
            this.html = html;
            this.cssRuleSets = cssRuleSets;
        }
    }
}

