/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.res.Resources;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.ui.DefaultTimeBar;
import com.google.android.exoplayer2.ui.R;
import com.google.android.exoplayer2.ui.StyledPlayerControlView;
import java.util.ArrayList;
import java.util.List;

final class StyledPlayerControlViewLayoutManager {
    private static final long ANIMATION_INTERVAL_MS = 2000L;
    private static final long DURATION_FOR_HIDING_ANIMATION_MS = 250L;
    private static final long DURATION_FOR_SHOWING_ANIMATION_MS = 250L;
    private static final int UX_STATE_ALL_VISIBLE = 0;
    private static final int UX_STATE_ONLY_PROGRESS_VISIBLE = 1;
    private static final int UX_STATE_NONE_VISIBLE = 2;
    private static final int UX_STATE_ANIMATING_HIDE = 3;
    private static final int UX_STATE_ANIMATING_SHOW = 4;
    private final StyledPlayerControlView styledPlayerControlView;
    @Nullable
    private final ViewGroup embeddedTransportControls;
    @Nullable
    private final ViewGroup bottomBar;
    @Nullable
    private final ViewGroup minimalControls;
    @Nullable
    private final ViewGroup basicControls;
    @Nullable
    private final ViewGroup extraControls;
    @Nullable
    private final ViewGroup extraControlsScrollView;
    @Nullable
    private final ViewGroup timeView;
    @Nullable
    private final View timeBar;
    @Nullable
    private final View overflowShowButton;
    private final AnimatorSet hideMainBarsAnimator;
    private final AnimatorSet hideProgressBarAnimator;
    private final AnimatorSet hideAllBarsAnimator;
    private final AnimatorSet showMainBarsAnimator;
    private final AnimatorSet showAllBarsAnimator;
    private final ValueAnimator overflowShowAnimator;
    private final ValueAnimator overflowHideAnimator;
    private final Runnable showAllBarsRunnable;
    private final Runnable hideAllBarsRunnable;
    private final Runnable hideProgressBarRunnable;
    private final Runnable hideMainBarsRunnable;
    private final Runnable hideControllerRunnable;
    private final View.OnLayoutChangeListener onLayoutChangeListener;
    private final List<View> shownButtons;
    private int uxState;
    private boolean isMinimalMode;
    private boolean needToShowBars;
    private boolean animationEnabled;

    public StyledPlayerControlViewLayoutManager(final StyledPlayerControlView styledPlayerControlView) {
        this.styledPlayerControlView = styledPlayerControlView;
        this.showAllBarsRunnable = this::showAllBars;
        this.hideAllBarsRunnable = this::hideAllBars;
        this.hideProgressBarRunnable = this::hideProgressBar;
        this.hideMainBarsRunnable = this::hideMainBars;
        this.hideControllerRunnable = this::hideController;
        this.onLayoutChangeListener = this::onLayoutChange;
        this.animationEnabled = true;
        this.uxState = 0;
        this.shownButtons = new ArrayList<View>();
        final ViewGroup centerView = (ViewGroup)styledPlayerControlView.findViewById(R.id.exo_center_view);
        this.embeddedTransportControls = (ViewGroup)styledPlayerControlView.findViewById(R.id.exo_embedded_transport_controls);
        this.minimalControls = (ViewGroup)styledPlayerControlView.findViewById(R.id.exo_minimal_controls);
        this.bottomBar = (ViewGroup)styledPlayerControlView.findViewById(R.id.exo_bottom_bar);
        this.timeView = (ViewGroup)styledPlayerControlView.findViewById(R.id.exo_time);
        this.timeBar = styledPlayerControlView.findViewById(R.id.exo_progress);
        this.basicControls = (ViewGroup)styledPlayerControlView.findViewById(R.id.exo_basic_controls);
        this.extraControls = (ViewGroup)styledPlayerControlView.findViewById(R.id.exo_extra_controls);
        this.extraControlsScrollView = (ViewGroup)styledPlayerControlView.findViewById(R.id.exo_extra_controls_scroll_view);
        this.overflowShowButton = styledPlayerControlView.findViewById(R.id.exo_overflow_show);
        View overflowHideButton = styledPlayerControlView.findViewById(R.id.exo_overflow_hide);
        if (this.overflowShowButton != null && overflowHideButton != null) {
            this.overflowShowButton.setOnClickListener(this::onOverflowButtonClick);
            overflowHideButton.setOnClickListener(this::onOverflowButtonClick);
        }
        Resources resources = styledPlayerControlView.getResources();
        float bottomBarHeight = resources.getDimension(R.dimen.exo_bottom_bar_height) - resources.getDimension(R.dimen.exo_styled_progress_bar_height);
        float progressBarHeight = resources.getDimension(R.dimen.exo_styled_progress_margin_bottom) + resources.getDimension(R.dimen.exo_styled_progress_layout_height) - bottomBarHeight;
        ValueAnimator fadeOutAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        fadeOutAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        fadeOutAnimator.addUpdateListener(animation -> {
            float animatedValue = ((Float)animation.getAnimatedValue()).floatValue();
            if (centerView != null) {
                centerView.setAlpha(animatedValue);
            }
            if (this.minimalControls != null) {
                this.minimalControls.setAlpha(animatedValue);
            }
        });
        fadeOutAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                if (StyledPlayerControlViewLayoutManager.this.timeBar instanceof DefaultTimeBar && !StyledPlayerControlViewLayoutManager.this.isMinimalMode) {
                    ((DefaultTimeBar)StyledPlayerControlViewLayoutManager.this.timeBar).hideScrubber(250L);
                }
            }

            public void onAnimationEnd(Animator animation) {
                if (centerView != null) {
                    centerView.setVisibility(4);
                }
                if (StyledPlayerControlViewLayoutManager.this.minimalControls != null) {
                    StyledPlayerControlViewLayoutManager.this.minimalControls.setVisibility(4);
                }
            }
        });
        ValueAnimator fadeInAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        fadeInAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        fadeInAnimator.addUpdateListener(animation -> {
            float animatedValue = ((Float)animation.getAnimatedValue()).floatValue();
            if (centerView != null) {
                centerView.setAlpha(animatedValue);
            }
            if (this.minimalControls != null) {
                this.minimalControls.setAlpha(animatedValue);
            }
        });
        fadeInAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                if (centerView != null) {
                    centerView.setVisibility(0);
                }
                if (StyledPlayerControlViewLayoutManager.this.minimalControls != null) {
                    StyledPlayerControlViewLayoutManager.this.minimalControls.setVisibility(StyledPlayerControlViewLayoutManager.this.isMinimalMode ? 0 : 4);
                }
                if (StyledPlayerControlViewLayoutManager.this.timeBar instanceof DefaultTimeBar && !StyledPlayerControlViewLayoutManager.this.isMinimalMode) {
                    ((DefaultTimeBar)StyledPlayerControlViewLayoutManager.this.timeBar).showScrubber(250L);
                }
            }
        });
        this.hideMainBarsAnimator = new AnimatorSet();
        this.hideMainBarsAnimator.setDuration(250L);
        this.hideMainBarsAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                StyledPlayerControlViewLayoutManager.this.setUxState(3);
            }

            public void onAnimationEnd(Animator animation) {
                StyledPlayerControlViewLayoutManager.this.setUxState(1);
                if (StyledPlayerControlViewLayoutManager.this.needToShowBars) {
                    styledPlayerControlView.post(StyledPlayerControlViewLayoutManager.this.showAllBarsRunnable);
                    StyledPlayerControlViewLayoutManager.this.needToShowBars = false;
                }
            }
        });
        this.hideMainBarsAnimator.play((Animator)fadeOutAnimator).with((Animator)StyledPlayerControlViewLayoutManager.ofTranslationY(0.0f, bottomBarHeight, this.timeBar)).with((Animator)StyledPlayerControlViewLayoutManager.ofTranslationY(0.0f, bottomBarHeight, (View)this.bottomBar));
        this.hideProgressBarAnimator = new AnimatorSet();
        this.hideProgressBarAnimator.setDuration(250L);
        this.hideProgressBarAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                StyledPlayerControlViewLayoutManager.this.setUxState(3);
            }

            public void onAnimationEnd(Animator animation) {
                StyledPlayerControlViewLayoutManager.this.setUxState(2);
                if (StyledPlayerControlViewLayoutManager.this.needToShowBars) {
                    styledPlayerControlView.post(StyledPlayerControlViewLayoutManager.this.showAllBarsRunnable);
                    StyledPlayerControlViewLayoutManager.this.needToShowBars = false;
                }
            }
        });
        this.hideProgressBarAnimator.play((Animator)StyledPlayerControlViewLayoutManager.ofTranslationY(bottomBarHeight, bottomBarHeight + progressBarHeight, this.timeBar)).with((Animator)StyledPlayerControlViewLayoutManager.ofTranslationY(bottomBarHeight, bottomBarHeight + progressBarHeight, (View)this.bottomBar));
        this.hideAllBarsAnimator = new AnimatorSet();
        this.hideAllBarsAnimator.setDuration(250L);
        this.hideAllBarsAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                StyledPlayerControlViewLayoutManager.this.setUxState(3);
            }

            public void onAnimationEnd(Animator animation) {
                StyledPlayerControlViewLayoutManager.this.setUxState(2);
                if (StyledPlayerControlViewLayoutManager.this.needToShowBars) {
                    styledPlayerControlView.post(StyledPlayerControlViewLayoutManager.this.showAllBarsRunnable);
                    StyledPlayerControlViewLayoutManager.this.needToShowBars = false;
                }
            }
        });
        this.hideAllBarsAnimator.play((Animator)fadeOutAnimator).with((Animator)StyledPlayerControlViewLayoutManager.ofTranslationY(0.0f, bottomBarHeight + progressBarHeight, this.timeBar)).with((Animator)StyledPlayerControlViewLayoutManager.ofTranslationY(0.0f, bottomBarHeight + progressBarHeight, (View)this.bottomBar));
        this.showMainBarsAnimator = new AnimatorSet();
        this.showMainBarsAnimator.setDuration(250L);
        this.showMainBarsAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                StyledPlayerControlViewLayoutManager.this.setUxState(4);
            }

            public void onAnimationEnd(Animator animation) {
                StyledPlayerControlViewLayoutManager.this.setUxState(0);
            }
        });
        this.showMainBarsAnimator.play((Animator)fadeInAnimator).with((Animator)StyledPlayerControlViewLayoutManager.ofTranslationY(bottomBarHeight, 0.0f, this.timeBar)).with((Animator)StyledPlayerControlViewLayoutManager.ofTranslationY(bottomBarHeight, 0.0f, (View)this.bottomBar));
        this.showAllBarsAnimator = new AnimatorSet();
        this.showAllBarsAnimator.setDuration(250L);
        this.showAllBarsAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                StyledPlayerControlViewLayoutManager.this.setUxState(4);
            }

            public void onAnimationEnd(Animator animation) {
                StyledPlayerControlViewLayoutManager.this.setUxState(0);
            }
        });
        this.showAllBarsAnimator.play((Animator)fadeInAnimator).with((Animator)StyledPlayerControlViewLayoutManager.ofTranslationY(bottomBarHeight + progressBarHeight, 0.0f, this.timeBar)).with((Animator)StyledPlayerControlViewLayoutManager.ofTranslationY(bottomBarHeight + progressBarHeight, 0.0f, (View)this.bottomBar));
        this.overflowShowAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.overflowShowAnimator.setDuration(250L);
        this.overflowShowAnimator.addUpdateListener(animation -> this.animateOverflow(((Float)animation.getAnimatedValue()).floatValue()));
        this.overflowShowAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                if (StyledPlayerControlViewLayoutManager.this.extraControlsScrollView != null) {
                    StyledPlayerControlViewLayoutManager.this.extraControlsScrollView.setVisibility(0);
                    StyledPlayerControlViewLayoutManager.this.extraControlsScrollView.setTranslationX((float)StyledPlayerControlViewLayoutManager.this.extraControlsScrollView.getWidth());
                    StyledPlayerControlViewLayoutManager.this.extraControlsScrollView.scrollTo(StyledPlayerControlViewLayoutManager.this.extraControlsScrollView.getWidth(), 0);
                }
            }

            public void onAnimationEnd(Animator animation) {
                if (StyledPlayerControlViewLayoutManager.this.basicControls != null) {
                    StyledPlayerControlViewLayoutManager.this.basicControls.setVisibility(4);
                }
            }
        });
        this.overflowHideAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        this.overflowHideAnimator.setDuration(250L);
        this.overflowHideAnimator.addUpdateListener(animation -> this.animateOverflow(((Float)animation.getAnimatedValue()).floatValue()));
        this.overflowHideAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                if (StyledPlayerControlViewLayoutManager.this.basicControls != null) {
                    StyledPlayerControlViewLayoutManager.this.basicControls.setVisibility(0);
                }
            }

            public void onAnimationEnd(Animator animation) {
                if (StyledPlayerControlViewLayoutManager.this.extraControlsScrollView != null) {
                    StyledPlayerControlViewLayoutManager.this.extraControlsScrollView.setVisibility(4);
                }
            }
        });
    }

    public void show() {
        if (!this.styledPlayerControlView.isVisible()) {
            this.styledPlayerControlView.setVisibility(0);
            this.styledPlayerControlView.updateAll();
            this.styledPlayerControlView.requestPlayPauseFocus();
        }
        this.showAllBars();
    }

    public void hide() {
        if (this.uxState == 3 || this.uxState == 2) {
            return;
        }
        this.removeHideCallbacks();
        if (!this.animationEnabled) {
            this.hideController();
        } else if (this.uxState == 1) {
            this.hideProgressBar();
        } else {
            this.hideAllBars();
        }
    }

    public void hideImmediately() {
        if (this.uxState == 3 || this.uxState == 2) {
            return;
        }
        this.removeHideCallbacks();
        this.hideController();
    }

    public void setAnimationEnabled(boolean animationEnabled) {
        this.animationEnabled = animationEnabled;
    }

    public boolean isAnimationEnabled() {
        return this.animationEnabled;
    }

    public void resetHideCallbacks() {
        if (this.uxState == 3) {
            return;
        }
        this.removeHideCallbacks();
        int showTimeoutMs = this.styledPlayerControlView.getShowTimeoutMs();
        if (showTimeoutMs > 0) {
            if (!this.animationEnabled) {
                this.postDelayedRunnable(this.hideControllerRunnable, showTimeoutMs);
            } else if (this.uxState == 1) {
                this.postDelayedRunnable(this.hideProgressBarRunnable, 2000L);
            } else {
                this.postDelayedRunnable(this.hideMainBarsRunnable, showTimeoutMs);
            }
        }
    }

    public void removeHideCallbacks() {
        this.styledPlayerControlView.removeCallbacks(this.hideControllerRunnable);
        this.styledPlayerControlView.removeCallbacks(this.hideAllBarsRunnable);
        this.styledPlayerControlView.removeCallbacks(this.hideMainBarsRunnable);
        this.styledPlayerControlView.removeCallbacks(this.hideProgressBarRunnable);
    }

    public void onAttachedToWindow() {
        this.styledPlayerControlView.addOnLayoutChangeListener(this.onLayoutChangeListener);
    }

    public void onDetachedFromWindow() {
        this.styledPlayerControlView.removeOnLayoutChangeListener(this.onLayoutChangeListener);
    }

    public boolean isFullyVisible() {
        return this.uxState == 0 && this.styledPlayerControlView.isVisible();
    }

    public void setShowButton(@Nullable View button, boolean showButton) {
        if (button == null) {
            return;
        }
        if (!showButton) {
            button.setVisibility(8);
            this.shownButtons.remove(button);
            return;
        }
        if (this.isMinimalMode && this.shouldHideInMinimalMode(button)) {
            button.setVisibility(4);
        } else {
            button.setVisibility(0);
        }
        this.shownButtons.add(button);
    }

    public boolean getShowButton(@Nullable View button) {
        return button != null && this.shownButtons.contains(button);
    }

    private void setUxState(int uxState) {
        int prevUxState = this.uxState;
        this.uxState = uxState;
        if (uxState == 2) {
            this.styledPlayerControlView.setVisibility(8);
        } else if (prevUxState == 2) {
            this.styledPlayerControlView.setVisibility(0);
        }
        if (prevUxState != uxState) {
            this.styledPlayerControlView.notifyOnVisibilityChange();
        }
    }

    private void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        boolean widthChanged;
        boolean shouldBeMinimalMode = this.shouldBeMinimalMode();
        if (this.isMinimalMode != shouldBeMinimalMode) {
            this.isMinimalMode = shouldBeMinimalMode;
            v.post(this::updateLayoutForSizeChange);
        }
        boolean bl = widthChanged = right - left != oldRight - oldLeft;
        if (!this.isMinimalMode && widthChanged) {
            v.post(this::onLayoutWidthChanged);
        }
    }

    private void onOverflowButtonClick(View v) {
        this.resetHideCallbacks();
        if (v.getId() == R.id.exo_overflow_show) {
            this.overflowShowAnimator.start();
        } else if (v.getId() == R.id.exo_overflow_hide) {
            this.overflowHideAnimator.start();
        }
    }

    private void showAllBars() {
        if (!this.animationEnabled) {
            this.setUxState(0);
            this.resetHideCallbacks();
            return;
        }
        switch (this.uxState) {
            case 2: {
                this.showAllBarsAnimator.start();
                break;
            }
            case 1: {
                this.showMainBarsAnimator.start();
                break;
            }
            case 3: {
                this.needToShowBars = true;
                break;
            }
            case 4: {
                return;
            }
        }
        this.resetHideCallbacks();
    }

    private void hideAllBars() {
        this.hideAllBarsAnimator.start();
    }

    private void hideProgressBar() {
        this.hideProgressBarAnimator.start();
    }

    private void hideMainBars() {
        this.hideMainBarsAnimator.start();
        this.postDelayedRunnable(this.hideProgressBarRunnable, 2000L);
    }

    private void hideController() {
        this.setUxState(2);
    }

    private static ObjectAnimator ofTranslationY(float startValue, float endValue, View target) {
        return ObjectAnimator.ofFloat((Object)target, (String)"translationY", (float[])new float[]{startValue, endValue});
    }

    private void postDelayedRunnable(Runnable runnable, long interval) {
        if (interval >= 0L) {
            this.styledPlayerControlView.postDelayed(runnable, interval);
        }
    }

    private void animateOverflow(float animatedValue) {
        if (this.extraControlsScrollView != null) {
            int extraControlTranslationX = (int)((float)this.extraControlsScrollView.getWidth() * (1.0f - animatedValue));
            this.extraControlsScrollView.setTranslationX((float)extraControlTranslationX);
        }
        if (this.timeView != null) {
            this.timeView.setAlpha(1.0f - animatedValue);
        }
        if (this.basicControls != null) {
            this.basicControls.setAlpha(1.0f - animatedValue);
        }
    }

    private boolean shouldBeMinimalMode() {
        int width = this.styledPlayerControlView.getWidth() - this.styledPlayerControlView.getPaddingLeft() - this.styledPlayerControlView.getPaddingRight();
        int height = this.styledPlayerControlView.getHeight() - this.styledPlayerControlView.getPaddingBottom() - this.styledPlayerControlView.getPaddingTop();
        int defaultModeWidth = Math.max(StyledPlayerControlViewLayoutManager.getWidth((View)this.embeddedTransportControls), StyledPlayerControlViewLayoutManager.getWidth((View)this.timeView) + StyledPlayerControlViewLayoutManager.getWidth(this.overflowShowButton));
        int defaultModeHeight = StyledPlayerControlViewLayoutManager.getHeight((View)this.embeddedTransportControls) + StyledPlayerControlViewLayoutManager.getHeight(this.timeBar) + StyledPlayerControlViewLayoutManager.getHeight((View)this.bottomBar);
        return width <= defaultModeWidth || height <= defaultModeHeight;
    }

    private void updateLayoutForSizeChange() {
        View fullScreenButton;
        if (this.minimalControls != null) {
            this.minimalControls.setVisibility(this.isMinimalMode ? 0 : 4);
        }
        if ((fullScreenButton = this.styledPlayerControlView.findViewById(R.id.exo_fullscreen)) != null) {
            ViewGroup parent = (ViewGroup)fullScreenButton.getParent();
            parent.removeView(fullScreenButton);
            if (this.isMinimalMode && this.minimalControls != null) {
                this.minimalControls.addView(fullScreenButton);
            } else if (!this.isMinimalMode && this.basicControls != null) {
                int index = Math.max(0, this.basicControls.getChildCount() - 1);
                this.basicControls.addView(fullScreenButton, index);
            } else {
                parent.addView(fullScreenButton);
            }
        }
        if (this.timeBar != null) {
            ViewGroup.MarginLayoutParams timeBarParams = (ViewGroup.MarginLayoutParams)this.timeBar.getLayoutParams();
            int timeBarMarginBottom = this.styledPlayerControlView.getResources().getDimensionPixelSize(R.dimen.exo_styled_progress_margin_bottom);
            timeBarParams.bottomMargin = this.isMinimalMode ? 0 : timeBarMarginBottom;
            this.timeBar.setLayoutParams((ViewGroup.LayoutParams)timeBarParams);
            if (this.timeBar instanceof DefaultTimeBar && this.uxState != 3 && this.uxState != 4) {
                if (this.isMinimalMode || this.uxState != 0) {
                    ((DefaultTimeBar)this.timeBar).hideScrubber();
                } else {
                    ((DefaultTimeBar)this.timeBar).showScrubber();
                }
            }
        }
        for (View v : this.shownButtons) {
            v.setVisibility(this.isMinimalMode && this.shouldHideInMinimalMode(v) ? 4 : 0);
        }
    }

    private boolean shouldHideInMinimalMode(View button) {
        int id2 = button.getId();
        return id2 == R.id.exo_bottom_bar || id2 == R.id.exo_prev || id2 == R.id.exo_next || id2 == R.id.exo_rew || id2 == R.id.exo_rew_with_amount || id2 == R.id.exo_ffwd || id2 == R.id.exo_ffwd_with_amount;
    }

    private void onLayoutWidthChanged() {
        block8: {
            int startIndex;
            View child3;
            int bottomBarWidth;
            int width;
            block7: {
                if (this.basicControls == null || this.extraControls == null) {
                    return;
                }
                width = this.styledPlayerControlView.getWidth() - this.styledPlayerControlView.getPaddingLeft() - this.styledPlayerControlView.getPaddingRight();
                bottomBarWidth = StyledPlayerControlViewLayoutManager.getWidth((View)this.timeView);
                for (int i = 0; i < this.basicControls.getChildCount(); ++i) {
                    bottomBarWidth += this.basicControls.getChildAt(i).getWidth();
                }
                int minBasicControlsChildCount = 1;
                int minExtraControlsChildCount = 2;
                if (bottomBarWidth <= width) break block7;
                ArrayList<View> movingChildren = new ArrayList<View>();
                int movingWidth = 0;
                int endIndex = this.basicControls.getChildCount() - minBasicControlsChildCount;
                for (int index = 0; index < endIndex; ++index) {
                    View child2 = this.basicControls.getChildAt(index);
                    movingChildren.add(child2);
                    if (bottomBarWidth - (movingWidth += child2.getWidth()) <= width) break;
                }
                if (movingChildren.isEmpty()) break block8;
                this.basicControls.removeViews(0, movingChildren.size());
                for (View child2 : movingChildren) {
                    int index = this.extraControls.getChildCount() - minExtraControlsChildCount;
                    this.extraControls.addView(child2, index);
                }
                break block8;
            }
            ArrayList<View> movingChildren = new ArrayList<View>();
            int movingWidth = 0;
            for (int index = startIndex = this.extraControls.getChildCount() - minExtraControlsChildCount - 1; index >= 0 && bottomBarWidth + (movingWidth += (child3 = this.extraControls.getChildAt(index)).getWidth()) <= width; --index) {
                movingChildren.add(child3);
            }
            if (!movingChildren.isEmpty()) {
                this.extraControls.removeViews(startIndex - movingChildren.size() + 1, movingChildren.size());
                for (View child3 : movingChildren) {
                    this.basicControls.addView(child3, 0);
                }
            }
        }
    }

    private static int getWidth(@Nullable View v) {
        return v != null ? v.getWidth() : 0;
    }

    private static int getHeight(@Nullable View v) {
        return v != null ? v.getHeight() : 0;
    }
}

