/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.LayoutInflater;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.MappingTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelectionUtil;
import com.google.android.exoplayer2.ui.R;
import com.google.android.exoplayer2.ui.TrackNameProvider;
import com.google.android.exoplayer2.ui.TrackSelectionView;
import com.google.android.exoplayer2.util.Assertions;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.List;

public final class TrackSelectionDialogBuilder {
    private final Context context;
    @StyleRes
    private int themeResId;
    private final CharSequence title;
    private final MappingTrackSelector.MappedTrackInfo mappedTrackInfo;
    private final int rendererIndex;
    private final DialogCallback callback;
    private boolean allowAdaptiveSelections;
    private boolean allowMultipleOverrides;
    private boolean showDisableOption;
    @Nullable
    private TrackNameProvider trackNameProvider;
    private boolean isDisabled;
    private List<DefaultTrackSelector.SelectionOverride> overrides;

    public TrackSelectionDialogBuilder(Context context, CharSequence title, MappingTrackSelector.MappedTrackInfo mappedTrackInfo, int rendererIndex, DialogCallback callback) {
        this.context = context;
        this.title = title;
        this.mappedTrackInfo = mappedTrackInfo;
        this.rendererIndex = rendererIndex;
        this.callback = callback;
        this.overrides = Collections.emptyList();
    }

    public TrackSelectionDialogBuilder(Context context, CharSequence title, DefaultTrackSelector trackSelector, int rendererIndex) {
        this.context = context;
        this.title = title;
        this.mappedTrackInfo = (MappingTrackSelector.MappedTrackInfo)Assertions.checkNotNull((Object)trackSelector.getCurrentMappedTrackInfo());
        this.rendererIndex = rendererIndex;
        TrackGroupArray rendererTrackGroups = this.mappedTrackInfo.getTrackGroups(rendererIndex);
        DefaultTrackSelector.Parameters selectionParameters = trackSelector.getParameters();
        this.isDisabled = selectionParameters.getRendererDisabled(rendererIndex);
        DefaultTrackSelector.SelectionOverride override = selectionParameters.getSelectionOverride(rendererIndex, rendererTrackGroups);
        this.overrides = override == null ? Collections.emptyList() : Collections.singletonList(override);
        this.callback = (newIsDisabled, newOverrides) -> trackSelector.setParameters(TrackSelectionUtil.updateParametersWithOverride((DefaultTrackSelector.Parameters)selectionParameters, (int)rendererIndex, (TrackGroupArray)rendererTrackGroups, (boolean)newIsDisabled, newOverrides.isEmpty() ? null : (DefaultTrackSelector.SelectionOverride)newOverrides.get(0)));
    }

    public TrackSelectionDialogBuilder setTheme(@StyleRes int themeResId) {
        this.themeResId = themeResId;
        return this;
    }

    public TrackSelectionDialogBuilder setIsDisabled(boolean isDisabled) {
        this.isDisabled = isDisabled;
        return this;
    }

    public TrackSelectionDialogBuilder setOverride(@Nullable DefaultTrackSelector.SelectionOverride override) {
        return this.setOverrides(override == null ? Collections.emptyList() : Collections.singletonList(override));
    }

    public TrackSelectionDialogBuilder setOverrides(List<DefaultTrackSelector.SelectionOverride> overrides) {
        this.overrides = overrides;
        return this;
    }

    public TrackSelectionDialogBuilder setAllowAdaptiveSelections(boolean allowAdaptiveSelections) {
        this.allowAdaptiveSelections = allowAdaptiveSelections;
        return this;
    }

    public TrackSelectionDialogBuilder setAllowMultipleOverrides(boolean allowMultipleOverrides) {
        this.allowMultipleOverrides = allowMultipleOverrides;
        return this;
    }

    public TrackSelectionDialogBuilder setShowDisableOption(boolean showDisableOption) {
        this.showDisableOption = showDisableOption;
        return this;
    }

    public TrackSelectionDialogBuilder setTrackNameProvider(@Nullable TrackNameProvider trackNameProvider) {
        this.trackNameProvider = trackNameProvider;
        return this;
    }

    public Dialog build() {
        Dialog dialog = this.buildForAndroidX();
        return dialog == null ? this.buildForPlatform() : dialog;
    }

    private Dialog buildForPlatform() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.context, this.themeResId);
        LayoutInflater dialogInflater = LayoutInflater.from((Context)builder.getContext());
        View dialogView = dialogInflater.inflate(R.layout.exo_track_selection_dialog, null);
        DialogInterface.OnClickListener okClickListener = this.setUpDialogView(dialogView);
        return builder.setTitle(this.title).setView(dialogView).setPositiveButton(17039370, okClickListener).setNegativeButton(0x1040000, null).create();
    }

    @Nullable
    private Dialog buildForAndroidX() {
        try {
            Class<?> builderClazz = Class.forName("androidx.appcompat.app.AlertDialog$Builder");
            Constructor<?> builderConstructor = builderClazz.getConstructor(Context.class, Integer.TYPE);
            Object builder = builderConstructor.newInstance(this.context, this.themeResId);
            Context builderContext = (Context)builderClazz.getMethod("getContext", new Class[0]).invoke(builder, new Object[0]);
            LayoutInflater dialogInflater = LayoutInflater.from((Context)builderContext);
            View dialogView = dialogInflater.inflate(R.layout.exo_track_selection_dialog, null);
            DialogInterface.OnClickListener okClickListener = this.setUpDialogView(dialogView);
            builderClazz.getMethod("setTitle", CharSequence.class).invoke(builder, this.title);
            builderClazz.getMethod("setView", View.class).invoke(builder, dialogView);
            builderClazz.getMethod("setPositiveButton", Integer.TYPE, DialogInterface.OnClickListener.class).invoke(builder, 17039370, okClickListener);
            builderClazz.getMethod("setNegativeButton", Integer.TYPE, DialogInterface.OnClickListener.class).invoke(builder, 0x1040000, null);
            return (Dialog)builderClazz.getMethod("create", new Class[0]).invoke(builder, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private DialogInterface.OnClickListener setUpDialogView(View dialogView) {
        TrackSelectionView selectionView = (TrackSelectionView)dialogView.findViewById(R.id.exo_track_selection_view);
        selectionView.setAllowMultipleOverrides(this.allowMultipleOverrides);
        selectionView.setAllowAdaptiveSelections(this.allowAdaptiveSelections);
        selectionView.setShowDisableOption(this.showDisableOption);
        if (this.trackNameProvider != null) {
            selectionView.setTrackNameProvider(this.trackNameProvider);
        }
        selectionView.init(this.mappedTrackInfo, this.rendererIndex, this.isDisabled, this.overrides, null);
        return (dialog, which) -> this.callback.onTracksSelected(selectionView.getIsDisabled(), selectionView.getOverrides());
    }

    public static interface DialogCallback {
        public void onTracksSelected(boolean var1, List<DefaultTrackSelector.SelectionOverride> var2);
    }
}

