/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.res.Resources;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.ui.DefaultTimeBar;
import com.google.android.exoplayer2.ui.R;
import com.google.android.exoplayer2.ui.StyledPlayerControlView;
import java.util.ArrayList;
import java.util.List;

final class StyledPlayerControlViewLayoutManager {
    private static final long ANIMATION_INTERVAL_MS = 2000L;
    private static final long DURATION_FOR_HIDING_ANIMATION_MS = 250L;
    private static final long DURATION_FOR_SHOWING_ANIMATION_MS = 250L;
    private static final int UX_STATE_ALL_VISIBLE = 0;
    private static final int UX_STATE_ONLY_PROGRESS_VISIBLE = 1;
    private static final int UX_STATE_NONE_VISIBLE = 2;
    private static final int UX_STATE_ANIMATING_HIDE = 3;
    private static final int UX_STATE_ANIMATING_SHOW = 4;
    private final Runnable showAllBarsRunnable = this::showAllBars;
    private final Runnable hideAllBarsRunnable = this::hideAllBars;
    private final Runnable hideProgressBarRunnable = this::hideProgressBar;
    private final Runnable hideMainBarsRunnable = this::hideMainBars;
    private final Runnable hideControllerRunnable = this::hideController;
    private final View.OnLayoutChangeListener onLayoutChangeListener = this::onLayoutChange;
    private final List<View> shownButtons = new ArrayList<View>();
    private int uxState = 0;
    private boolean initiallyHidden;
    private boolean isMinimalMode;
    private boolean needToShowBars;
    private boolean animationEnabled = true;
    @Nullable
    private StyledPlayerControlView styledPlayerControlView;
    @Nullable
    private ViewGroup embeddedTransportControls;
    @Nullable
    private ViewGroup bottomBar;
    @Nullable
    private ViewGroup minimalControls;
    @Nullable
    private ViewGroup basicControls;
    @Nullable
    private ViewGroup extraControls;
    @Nullable
    private ViewGroup extraControlsScrollView;
    @Nullable
    private ViewGroup timeView;
    @Nullable
    private View timeBar;
    @Nullable
    private View overflowShowButton;
    @Nullable
    private AnimatorSet hideMainBarsAnimator;
    @Nullable
    private AnimatorSet hideProgressBarAnimator;
    @Nullable
    private AnimatorSet hideAllBarsAnimator;
    @Nullable
    private AnimatorSet showMainBarsAnimator;
    @Nullable
    private AnimatorSet showAllBarsAnimator;
    @Nullable
    private ValueAnimator overflowShowAnimator;
    @Nullable
    private ValueAnimator overflowHideAnimator;

    public void show() {
        this.initiallyHidden = false;
        if (this.styledPlayerControlView == null) {
            return;
        }
        StyledPlayerControlView styledPlayerControlView = this.styledPlayerControlView;
        if (!styledPlayerControlView.isVisible()) {
            styledPlayerControlView.setVisibility(0);
            styledPlayerControlView.updateAll();
            styledPlayerControlView.requestPlayPauseFocus();
        }
        styledPlayerControlView.post(this.showAllBarsRunnable);
    }

    public void hide() {
        this.initiallyHidden = true;
        if (this.styledPlayerControlView == null || this.uxState == 3 || this.uxState == 2) {
            return;
        }
        this.removeHideCallbacks();
        if (!this.animationEnabled) {
            this.postDelayedRunnable(this.hideControllerRunnable, 0L);
        } else if (this.uxState == 1) {
            this.postDelayedRunnable(this.hideProgressBarRunnable, 0L);
        } else {
            this.postDelayedRunnable(this.hideAllBarsRunnable, 0L);
        }
    }

    public void setAnimationEnabled(boolean animationEnabled) {
        this.animationEnabled = animationEnabled;
    }

    public boolean isAnimationEnabled() {
        return this.animationEnabled;
    }

    public void resetHideCallbacks() {
        int showTimeoutMs;
        if (this.uxState == 3) {
            return;
        }
        this.removeHideCallbacks();
        int n = showTimeoutMs = this.styledPlayerControlView != null ? this.styledPlayerControlView.getShowTimeoutMs() : 0;
        if (showTimeoutMs > 0) {
            if (!this.animationEnabled) {
                this.postDelayedRunnable(this.hideControllerRunnable, showTimeoutMs);
            } else if (this.uxState == 1) {
                this.postDelayedRunnable(this.hideProgressBarRunnable, 2000L);
            } else {
                this.postDelayedRunnable(this.hideMainBarsRunnable, showTimeoutMs);
            }
        }
    }

    public void removeHideCallbacks() {
        if (this.styledPlayerControlView == null) {
            return;
        }
        this.styledPlayerControlView.removeCallbacks(this.hideControllerRunnable);
        this.styledPlayerControlView.removeCallbacks(this.hideAllBarsRunnable);
        this.styledPlayerControlView.removeCallbacks(this.hideMainBarsRunnable);
        this.styledPlayerControlView.removeCallbacks(this.hideProgressBarRunnable);
    }

    public void onViewAttached(StyledPlayerControlView v) {
        this.styledPlayerControlView = v;
        v.setVisibility(this.initiallyHidden ? 8 : 0);
        v.addOnLayoutChangeListener(this.onLayoutChangeListener);
        final ViewGroup centerView = (ViewGroup)v.findViewById(R.id.exo_center_view);
        this.embeddedTransportControls = (ViewGroup)v.findViewById(R.id.exo_embedded_transport_controls);
        this.minimalControls = (ViewGroup)v.findViewById(R.id.exo_minimal_controls);
        ViewGroup bottomBar = (ViewGroup)v.findViewById(R.id.exo_bottom_bar);
        this.timeView = (ViewGroup)v.findViewById(R.id.exo_time);
        final View timeBar = v.findViewById(R.id.exo_progress);
        this.basicControls = (ViewGroup)v.findViewById(R.id.exo_basic_controls);
        this.extraControls = (ViewGroup)v.findViewById(R.id.exo_extra_controls);
        this.extraControlsScrollView = (ViewGroup)v.findViewById(R.id.exo_extra_controls_scroll_view);
        this.overflowShowButton = v.findViewById(R.id.exo_overflow_show);
        View overflowHideButton = v.findViewById(R.id.exo_overflow_hide);
        if (this.overflowShowButton != null && overflowHideButton != null) {
            this.overflowShowButton.setOnClickListener(this::onOverflowButtonClick);
            overflowHideButton.setOnClickListener(this::onOverflowButtonClick);
        }
        this.bottomBar = bottomBar;
        this.timeBar = timeBar;
        Resources resources = v.getResources();
        float progressBarHeight = resources.getDimension(R.dimen.exo_custom_progress_thumb_size);
        float bottomBarHeight = resources.getDimension(R.dimen.exo_bottom_bar_height);
        ValueAnimator fadeOutAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        fadeOutAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        fadeOutAnimator.addUpdateListener(animation -> {
            float animatedValue = ((Float)animation.getAnimatedValue()).floatValue();
            if (centerView != null) {
                centerView.setAlpha(animatedValue);
            }
            if (this.minimalControls != null) {
                this.minimalControls.setAlpha(animatedValue);
            }
        });
        fadeOutAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                if (timeBar instanceof DefaultTimeBar && !StyledPlayerControlViewLayoutManager.this.isMinimalMode) {
                    ((DefaultTimeBar)timeBar).hideScrubber(250L);
                }
            }

            public void onAnimationEnd(Animator animation) {
                if (centerView != null) {
                    centerView.setVisibility(4);
                }
                if (StyledPlayerControlViewLayoutManager.this.minimalControls != null) {
                    StyledPlayerControlViewLayoutManager.this.minimalControls.setVisibility(4);
                }
            }
        });
        ValueAnimator fadeInAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        fadeInAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        fadeInAnimator.addUpdateListener(animation -> {
            float animatedValue = ((Float)animation.getAnimatedValue()).floatValue();
            if (centerView != null) {
                centerView.setAlpha(animatedValue);
            }
            if (this.minimalControls != null) {
                this.minimalControls.setAlpha(animatedValue);
            }
        });
        fadeInAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                if (centerView != null) {
                    centerView.setVisibility(0);
                }
                if (StyledPlayerControlViewLayoutManager.this.minimalControls != null) {
                    StyledPlayerControlViewLayoutManager.this.minimalControls.setVisibility(StyledPlayerControlViewLayoutManager.this.isMinimalMode ? 0 : 4);
                }
                if (timeBar instanceof DefaultTimeBar && !StyledPlayerControlViewLayoutManager.this.isMinimalMode) {
                    ((DefaultTimeBar)timeBar).showScrubber(250L);
                }
            }
        });
        this.hideMainBarsAnimator = new AnimatorSet();
        this.hideMainBarsAnimator.setDuration(250L);
        this.hideMainBarsAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                StyledPlayerControlViewLayoutManager.this.setUxState(3);
            }

            public void onAnimationEnd(Animator animation) {
                StyledPlayerControlViewLayoutManager.this.setUxState(1);
                if (StyledPlayerControlViewLayoutManager.this.needToShowBars) {
                    if (StyledPlayerControlViewLayoutManager.this.styledPlayerControlView != null) {
                        StyledPlayerControlViewLayoutManager.this.styledPlayerControlView.post(StyledPlayerControlViewLayoutManager.this.showAllBarsRunnable);
                    }
                    StyledPlayerControlViewLayoutManager.this.needToShowBars = false;
                }
            }
        });
        this.hideMainBarsAnimator.play((Animator)fadeOutAnimator).with((Animator)StyledPlayerControlViewLayoutManager.ofTranslationY(0.0f, bottomBarHeight, timeBar)).with((Animator)StyledPlayerControlViewLayoutManager.ofTranslationY(0.0f, bottomBarHeight, (View)bottomBar));
        this.hideProgressBarAnimator = new AnimatorSet();
        this.hideProgressBarAnimator.setDuration(250L);
        this.hideProgressBarAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                StyledPlayerControlViewLayoutManager.this.setUxState(3);
            }

            public void onAnimationEnd(Animator animation) {
                StyledPlayerControlViewLayoutManager.this.setUxState(2);
                if (StyledPlayerControlViewLayoutManager.this.needToShowBars) {
                    if (StyledPlayerControlViewLayoutManager.this.styledPlayerControlView != null) {
                        StyledPlayerControlViewLayoutManager.this.styledPlayerControlView.post(StyledPlayerControlViewLayoutManager.this.showAllBarsRunnable);
                    }
                    StyledPlayerControlViewLayoutManager.this.needToShowBars = false;
                }
            }
        });
        this.hideProgressBarAnimator.play((Animator)StyledPlayerControlViewLayoutManager.ofTranslationY(bottomBarHeight, bottomBarHeight + progressBarHeight, timeBar)).with((Animator)StyledPlayerControlViewLayoutManager.ofTranslationY(bottomBarHeight, bottomBarHeight + progressBarHeight, (View)bottomBar));
        this.hideAllBarsAnimator = new AnimatorSet();
        this.hideAllBarsAnimator.setDuration(250L);
        this.hideAllBarsAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                StyledPlayerControlViewLayoutManager.this.setUxState(3);
            }

            public void onAnimationEnd(Animator animation) {
                StyledPlayerControlViewLayoutManager.this.setUxState(2);
                if (StyledPlayerControlViewLayoutManager.this.needToShowBars) {
                    if (StyledPlayerControlViewLayoutManager.this.styledPlayerControlView != null) {
                        StyledPlayerControlViewLayoutManager.this.styledPlayerControlView.post(StyledPlayerControlViewLayoutManager.this.showAllBarsRunnable);
                    }
                    StyledPlayerControlViewLayoutManager.this.needToShowBars = false;
                }
            }
        });
        this.hideAllBarsAnimator.play((Animator)fadeOutAnimator).with((Animator)StyledPlayerControlViewLayoutManager.ofTranslationY(0.0f, bottomBarHeight + progressBarHeight, timeBar)).with((Animator)StyledPlayerControlViewLayoutManager.ofTranslationY(0.0f, bottomBarHeight + progressBarHeight, (View)bottomBar));
        this.showMainBarsAnimator = new AnimatorSet();
        this.showMainBarsAnimator.setDuration(250L);
        this.showMainBarsAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                StyledPlayerControlViewLayoutManager.this.setUxState(4);
            }

            public void onAnimationEnd(Animator animation) {
                StyledPlayerControlViewLayoutManager.this.setUxState(0);
            }
        });
        this.showMainBarsAnimator.play((Animator)fadeInAnimator).with((Animator)StyledPlayerControlViewLayoutManager.ofTranslationY(bottomBarHeight, 0.0f, timeBar)).with((Animator)StyledPlayerControlViewLayoutManager.ofTranslationY(bottomBarHeight, 0.0f, (View)bottomBar));
        this.showAllBarsAnimator = new AnimatorSet();
        this.showAllBarsAnimator.setDuration(250L);
        this.showAllBarsAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                StyledPlayerControlViewLayoutManager.this.setUxState(4);
            }

            public void onAnimationEnd(Animator animation) {
                StyledPlayerControlViewLayoutManager.this.setUxState(0);
            }
        });
        this.showAllBarsAnimator.play((Animator)fadeInAnimator).with((Animator)StyledPlayerControlViewLayoutManager.ofTranslationY(bottomBarHeight + progressBarHeight, 0.0f, timeBar)).with((Animator)StyledPlayerControlViewLayoutManager.ofTranslationY(bottomBarHeight + progressBarHeight, 0.0f, (View)bottomBar));
        this.overflowShowAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.overflowShowAnimator.setDuration(250L);
        this.overflowShowAnimator.addUpdateListener(animation -> this.animateOverflow(((Float)animation.getAnimatedValue()).floatValue()));
        this.overflowShowAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                if (StyledPlayerControlViewLayoutManager.this.extraControlsScrollView != null) {
                    StyledPlayerControlViewLayoutManager.this.extraControlsScrollView.setVisibility(0);
                    StyledPlayerControlViewLayoutManager.this.extraControlsScrollView.setTranslationX((float)StyledPlayerControlViewLayoutManager.this.extraControlsScrollView.getWidth());
                    StyledPlayerControlViewLayoutManager.this.extraControlsScrollView.scrollTo(StyledPlayerControlViewLayoutManager.this.extraControlsScrollView.getWidth(), 0);
                }
            }

            public void onAnimationEnd(Animator animation) {
                if (StyledPlayerControlViewLayoutManager.this.basicControls != null) {
                    StyledPlayerControlViewLayoutManager.this.basicControls.setVisibility(4);
                }
            }
        });
        this.overflowHideAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        this.overflowHideAnimator.setDuration(250L);
        this.overflowHideAnimator.addUpdateListener(animation -> this.animateOverflow(((Float)animation.getAnimatedValue()).floatValue()));
        this.overflowHideAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                if (StyledPlayerControlViewLayoutManager.this.basicControls != null) {
                    StyledPlayerControlViewLayoutManager.this.basicControls.setVisibility(0);
                }
            }

            public void onAnimationEnd(Animator animation) {
                if (StyledPlayerControlViewLayoutManager.this.extraControlsScrollView != null) {
                    StyledPlayerControlViewLayoutManager.this.extraControlsScrollView.setVisibility(4);
                }
            }
        });
    }

    public void onViewDetached(StyledPlayerControlView v) {
        v.removeOnLayoutChangeListener(this.onLayoutChangeListener);
    }

    public boolean isFullyVisible() {
        if (this.styledPlayerControlView == null) {
            return false;
        }
        return this.uxState == 0 && this.styledPlayerControlView.isVisible();
    }

    public void setShowButton(@Nullable View button, boolean showButton) {
        if (button == null) {
            return;
        }
        if (!showButton) {
            button.setVisibility(8);
            this.shownButtons.remove(button);
            return;
        }
        if (this.isMinimalMode && this.shouldHideInMinimalMode(button)) {
            button.setVisibility(4);
        } else {
            button.setVisibility(0);
        }
        this.shownButtons.add(button);
    }

    public boolean getShowButton(@Nullable View button) {
        return button != null && this.shownButtons.contains(button);
    }

    private void setUxState(int uxState) {
        int prevUxState = this.uxState;
        this.uxState = uxState;
        if (this.styledPlayerControlView != null) {
            StyledPlayerControlView styledPlayerControlView = this.styledPlayerControlView;
            if (uxState == 2) {
                styledPlayerControlView.setVisibility(8);
            } else if (prevUxState == 2) {
                styledPlayerControlView.setVisibility(0);
            }
            if (prevUxState != uxState) {
                styledPlayerControlView.notifyOnVisibilityChange();
            }
        }
    }

    private void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        boolean widthChanged;
        boolean shouldBeMinimalMode = this.shouldBeMinimalMode();
        if (this.isMinimalMode != shouldBeMinimalMode) {
            this.isMinimalMode = shouldBeMinimalMode;
            v.post(this::updateLayoutForSizeChange);
        }
        boolean bl = widthChanged = right - left != oldRight - oldLeft;
        if (!this.isMinimalMode && widthChanged) {
            v.post(this::onLayoutWidthChanged);
        }
    }

    private void onOverflowButtonClick(View v) {
        this.resetHideCallbacks();
        if (v.getId() == R.id.exo_overflow_show && this.overflowShowAnimator != null) {
            this.overflowShowAnimator.start();
        } else if (v.getId() == R.id.exo_overflow_hide && this.overflowHideAnimator != null) {
            this.overflowHideAnimator.start();
        }
    }

    private void showAllBars() {
        if (!this.animationEnabled) {
            this.setUxState(0);
            this.resetHideCallbacks();
            return;
        }
        switch (this.uxState) {
            case 2: {
                if (this.showAllBarsAnimator == null) break;
                this.showAllBarsAnimator.start();
                break;
            }
            case 1: {
                if (this.showMainBarsAnimator == null) break;
                this.showMainBarsAnimator.start();
                break;
            }
            case 3: {
                this.needToShowBars = true;
                break;
            }
            case 4: {
                return;
            }
        }
        this.resetHideCallbacks();
    }

    private void hideAllBars() {
        if (this.hideAllBarsAnimator == null) {
            return;
        }
        this.hideAllBarsAnimator.start();
    }

    private void hideProgressBar() {
        if (this.hideProgressBarAnimator == null) {
            return;
        }
        this.hideProgressBarAnimator.start();
    }

    private void hideMainBars() {
        if (this.hideMainBarsAnimator == null) {
            return;
        }
        this.hideMainBarsAnimator.start();
        this.postDelayedRunnable(this.hideProgressBarRunnable, 2000L);
    }

    private void hideController() {
        this.setUxState(2);
    }

    private static ObjectAnimator ofTranslationY(float startValue, float endValue, View target) {
        return ObjectAnimator.ofFloat((Object)target, (String)"translationY", (float[])new float[]{startValue, endValue});
    }

    private void postDelayedRunnable(Runnable runnable, long interval) {
        if (this.styledPlayerControlView != null && interval >= 0L) {
            this.styledPlayerControlView.postDelayed(runnable, interval);
        }
    }

    private void animateOverflow(float animatedValue) {
        if (this.extraControlsScrollView != null) {
            int extraControlTranslationX = (int)((float)this.extraControlsScrollView.getWidth() * (1.0f - animatedValue));
            this.extraControlsScrollView.setTranslationX((float)extraControlTranslationX);
        }
        if (this.timeView != null) {
            this.timeView.setAlpha(1.0f - animatedValue);
        }
        if (this.basicControls != null) {
            this.basicControls.setAlpha(1.0f - animatedValue);
        }
    }

    private boolean shouldBeMinimalMode() {
        if (this.styledPlayerControlView == null) {
            return this.isMinimalMode;
        }
        StyledPlayerControlView playerControlView = this.styledPlayerControlView;
        int width = playerControlView.getWidth() - playerControlView.getPaddingLeft() - playerControlView.getPaddingRight();
        int height = playerControlView.getHeight() - playerControlView.getPaddingBottom() - playerControlView.getPaddingTop();
        int defaultModeWidth = Math.max(StyledPlayerControlViewLayoutManager.getWidth((View)this.embeddedTransportControls), StyledPlayerControlViewLayoutManager.getWidth((View)this.timeView) + StyledPlayerControlViewLayoutManager.getWidth(this.overflowShowButton));
        int defaultModeHeight = StyledPlayerControlViewLayoutManager.getHeight((View)this.embeddedTransportControls) + StyledPlayerControlViewLayoutManager.getHeight(this.timeBar) + StyledPlayerControlViewLayoutManager.getHeight((View)this.bottomBar);
        return width <= defaultModeWidth || height <= defaultModeHeight;
    }

    private void updateLayoutForSizeChange() {
        View fullScreenButton;
        if (this.styledPlayerControlView == null) {
            return;
        }
        StyledPlayerControlView playerControlView = this.styledPlayerControlView;
        if (this.minimalControls != null) {
            this.minimalControls.setVisibility(this.isMinimalMode ? 0 : 4);
        }
        if ((fullScreenButton = playerControlView.findViewById(R.id.exo_fullscreen)) != null) {
            ViewGroup parent = (ViewGroup)fullScreenButton.getParent();
            parent.removeView(fullScreenButton);
            if (this.isMinimalMode && this.minimalControls != null) {
                this.minimalControls.addView(fullScreenButton);
            } else if (!this.isMinimalMode && this.basicControls != null) {
                int index = Math.max(0, this.basicControls.getChildCount() - 1);
                this.basicControls.addView(fullScreenButton, index);
            } else {
                parent.addView(fullScreenButton);
            }
        }
        if (this.timeBar != null) {
            View timeBar = this.timeBar;
            ViewGroup.MarginLayoutParams timeBarParams = (ViewGroup.MarginLayoutParams)timeBar.getLayoutParams();
            int timeBarMarginBottom = playerControlView.getResources().getDimensionPixelSize(R.dimen.exo_custom_progress_margin_bottom);
            timeBarParams.bottomMargin = this.isMinimalMode ? 0 : timeBarMarginBottom;
            timeBar.setLayoutParams((ViewGroup.LayoutParams)timeBarParams);
            if (timeBar instanceof DefaultTimeBar && this.uxState != 3 && this.uxState != 4) {
                if (this.isMinimalMode || this.uxState != 0) {
                    ((DefaultTimeBar)timeBar).hideScrubber();
                } else {
                    ((DefaultTimeBar)timeBar).showScrubber();
                }
            }
        }
        for (View v : this.shownButtons) {
            v.setVisibility(this.isMinimalMode && this.shouldHideInMinimalMode(v) ? 4 : 0);
        }
    }

    private boolean shouldHideInMinimalMode(View button) {
        int id2 = button.getId();
        return id2 == R.id.exo_bottom_bar || id2 == R.id.exo_prev || id2 == R.id.exo_next || id2 == R.id.exo_rew || id2 == R.id.exo_rew_with_amount || id2 == R.id.exo_ffwd || id2 == R.id.exo_ffwd_with_amount;
    }

    private void onLayoutWidthChanged() {
        block8: {
            int startIndex;
            View child3;
            int basicBottomBarWidth;
            int width;
            ViewGroup extraControls;
            ViewGroup basicControls;
            block7: {
                if (this.basicControls == null || this.extraControls == null) {
                    return;
                }
                basicControls = this.basicControls;
                extraControls = this.extraControls;
                width = this.styledPlayerControlView != null ? this.styledPlayerControlView.getWidth() - this.styledPlayerControlView.getPaddingLeft() - this.styledPlayerControlView.getPaddingRight() : 0;
                basicBottomBarWidth = StyledPlayerControlViewLayoutManager.getWidth((View)this.timeView);
                for (int i = 0; i < basicControls.getChildCount(); ++i) {
                    basicBottomBarWidth += basicControls.getChildAt(i).getWidth();
                }
                int minBasicControlsChildCount = 1;
                int minExtraControlsChildCount = 2;
                if (basicBottomBarWidth <= width) break block7;
                ArrayList<View> movingChildren = new ArrayList<View>();
                int movingWidth = 0;
                int endIndex = basicControls.getChildCount() - minBasicControlsChildCount;
                for (int index = 0; index < endIndex; ++index) {
                    View child2 = basicControls.getChildAt(index);
                    movingChildren.add(child2);
                    if (basicBottomBarWidth - (movingWidth += child2.getWidth()) <= width) break;
                }
                if (movingChildren.isEmpty()) break block8;
                basicControls.removeViews(0, movingChildren.size());
                for (View child2 : movingChildren) {
                    int index = extraControls.getChildCount() - minExtraControlsChildCount;
                    extraControls.addView(child2, index);
                }
                break block8;
            }
            ArrayList<View> movingChildren = new ArrayList<View>();
            int movingWidth = 0;
            for (int index = startIndex = extraControls.getChildCount() - minExtraControlsChildCount - 1; index >= 0 && basicBottomBarWidth + (movingWidth += (child3 = extraControls.getChildAt(index)).getWidth()) <= width; --index) {
                movingChildren.add(child3);
            }
            if (!movingChildren.isEmpty()) {
                extraControls.removeViews(startIndex - movingChildren.size() + 1, movingChildren.size());
                for (View child3 : movingChildren) {
                    basicControls.addView(child3, 0);
                }
            }
        }
    }

    private static int getWidth(@Nullable View v) {
        return v != null ? v.getWidth() : 0;
    }

    private static int getHeight(@Nullable View v) {
        return v != null ? v.getHeight() : 0;
    }
}

