/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.ui.R;
import com.google.android.exoplayer2.ui.TimeBar;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.util.Collections;
import java.util.Formatter;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArraySet;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class DefaultTimeBar
extends View
implements TimeBar {
    public static final int DEFAULT_BAR_HEIGHT_DP = 4;
    public static final int DEFAULT_TOUCH_TARGET_HEIGHT_DP = 26;
    public static final int DEFAULT_AD_MARKER_WIDTH_DP = 4;
    public static final int DEFAULT_SCRUBBER_ENABLED_SIZE_DP = 12;
    public static final int DEFAULT_SCRUBBER_DISABLED_SIZE_DP = 0;
    public static final int DEFAULT_SCRUBBER_DRAGGED_SIZE_DP = 16;
    public static final int DEFAULT_PLAYED_COLOR = -1;
    public static final int DEFAULT_UNPLAYED_COLOR = 0x33FFFFFF;
    public static final int DEFAULT_BUFFERED_COLOR = -855638017;
    public static final int DEFAULT_SCRUBBER_COLOR = -1;
    public static final int DEFAULT_AD_MARKER_COLOR = -1291845888;
    public static final int DEFAULT_PLAYED_AD_MARKER_COLOR = 0x33FFFF00;
    private static final int FINE_SCRUB_Y_THRESHOLD_DP = -50;
    private static final int FINE_SCRUB_RATIO = 3;
    private static final long STOP_SCRUBBING_TIMEOUT_MS = 1000L;
    private static final int DEFAULT_INCREMENT_COUNT = 20;
    private static final String ACCESSIBILITY_CLASS_NAME = "android.widget.SeekBar";
    private final Rect seekBounds = new Rect();
    private final Rect progressBar = new Rect();
    private final Rect bufferedBar = new Rect();
    private final Rect scrubberBar = new Rect();
    private final Paint playedPaint = new Paint();
    private final Paint bufferedPaint = new Paint();
    private final Paint unplayedPaint = new Paint();
    private final Paint adMarkerPaint = new Paint();
    private final Paint playedAdMarkerPaint = new Paint();
    private final Paint scrubberPaint = new Paint();
    @Nullable
    private final Drawable scrubberDrawable;
    private final int barHeight;
    private final int touchTargetHeight;
    private final int adMarkerWidth;
    private final int scrubberEnabledSize;
    private final int scrubberDisabledSize;
    private final int scrubberDraggedSize;
    private final int scrubberPadding;
    private final int fineScrubYThreshold;
    private final StringBuilder formatBuilder;
    private final Formatter formatter;
    private final Runnable stopScrubbingRunnable;
    private final CopyOnWriteArraySet<TimeBar.OnScrubListener> listeners;
    private final int[] locationOnScreen;
    private final Point touchPosition;
    private final float density;
    private int keyCountIncrement;
    private long keyTimeIncrement;
    private int lastCoarseScrubXPosition;
    private @MonotonicNonNull Rect lastExclusionRectangle;
    private boolean scrubbing;
    private long scrubPosition;
    private long duration;
    private long position;
    private long bufferedPosition;
    private int adGroupCount;
    @Nullable
    private long[] adGroupTimesMs;
    @Nullable
    private boolean[] playedAdGroups;

    public DefaultTimeBar(Context context) {
        this(context, null);
    }

    public DefaultTimeBar(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DefaultTimeBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultTimeBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr, @Nullable AttributeSet timebarAttrs) {
        super(context, attrs, defStyleAttr);
        this.scrubberPaint.setAntiAlias(true);
        this.listeners = new CopyOnWriteArraySet();
        this.locationOnScreen = new int[2];
        this.touchPosition = new Point();
        Resources res = context.getResources();
        DisplayMetrics displayMetrics = res.getDisplayMetrics();
        this.density = displayMetrics.density;
        this.fineScrubYThreshold = DefaultTimeBar.dpToPx(this.density, -50);
        int defaultBarHeight = DefaultTimeBar.dpToPx(this.density, 4);
        int defaultTouchTargetHeight = DefaultTimeBar.dpToPx(this.density, 26);
        int defaultAdMarkerWidth = DefaultTimeBar.dpToPx(this.density, 4);
        int defaultScrubberEnabledSize = DefaultTimeBar.dpToPx(this.density, 12);
        int defaultScrubberDisabledSize = DefaultTimeBar.dpToPx(this.density, 0);
        int defaultScrubberDraggedSize = DefaultTimeBar.dpToPx(this.density, 16);
        if (timebarAttrs != null) {
            TypedArray a = context.getTheme().obtainStyledAttributes(timebarAttrs, R.styleable.DefaultTimeBar, 0, 0);
            try {
                this.scrubberDrawable = a.getDrawable(R.styleable.DefaultTimeBar_scrubber_drawable);
                if (this.scrubberDrawable != null) {
                    this.setDrawableLayoutDirection(this.scrubberDrawable);
                    defaultTouchTargetHeight = Math.max(this.scrubberDrawable.getMinimumHeight(), defaultTouchTargetHeight);
                }
                this.barHeight = a.getDimensionPixelSize(R.styleable.DefaultTimeBar_bar_height, defaultBarHeight);
                this.touchTargetHeight = a.getDimensionPixelSize(R.styleable.DefaultTimeBar_touch_target_height, defaultTouchTargetHeight);
                this.adMarkerWidth = a.getDimensionPixelSize(R.styleable.DefaultTimeBar_ad_marker_width, defaultAdMarkerWidth);
                this.scrubberEnabledSize = a.getDimensionPixelSize(R.styleable.DefaultTimeBar_scrubber_enabled_size, defaultScrubberEnabledSize);
                this.scrubberDisabledSize = a.getDimensionPixelSize(R.styleable.DefaultTimeBar_scrubber_disabled_size, defaultScrubberDisabledSize);
                this.scrubberDraggedSize = a.getDimensionPixelSize(R.styleable.DefaultTimeBar_scrubber_dragged_size, defaultScrubberDraggedSize);
                int playedColor = a.getInt(R.styleable.DefaultTimeBar_played_color, -1);
                int scrubberColor = a.getInt(R.styleable.DefaultTimeBar_scrubber_color, -1);
                int bufferedColor = a.getInt(R.styleable.DefaultTimeBar_buffered_color, -855638017);
                int unplayedColor = a.getInt(R.styleable.DefaultTimeBar_unplayed_color, 0x33FFFFFF);
                int adMarkerColor = a.getInt(R.styleable.DefaultTimeBar_ad_marker_color, -1291845888);
                int playedAdMarkerColor = a.getInt(R.styleable.DefaultTimeBar_played_ad_marker_color, 0x33FFFF00);
                this.playedPaint.setColor(playedColor);
                this.scrubberPaint.setColor(scrubberColor);
                this.bufferedPaint.setColor(bufferedColor);
                this.unplayedPaint.setColor(unplayedColor);
                this.adMarkerPaint.setColor(adMarkerColor);
                this.playedAdMarkerPaint.setColor(playedAdMarkerColor);
            }
            finally {
                a.recycle();
            }
        } else {
            this.barHeight = defaultBarHeight;
            this.touchTargetHeight = defaultTouchTargetHeight;
            this.adMarkerWidth = defaultAdMarkerWidth;
            this.scrubberEnabledSize = defaultScrubberEnabledSize;
            this.scrubberDisabledSize = defaultScrubberDisabledSize;
            this.scrubberDraggedSize = defaultScrubberDraggedSize;
            this.playedPaint.setColor(-1);
            this.scrubberPaint.setColor(-1);
            this.bufferedPaint.setColor(-855638017);
            this.unplayedPaint.setColor(0x33FFFFFF);
            this.adMarkerPaint.setColor(-1291845888);
            this.playedAdMarkerPaint.setColor(0x33FFFF00);
            this.scrubberDrawable = null;
        }
        this.formatBuilder = new StringBuilder();
        this.formatter = new Formatter(this.formatBuilder, Locale.getDefault());
        this.stopScrubbingRunnable = () -> this.stopScrubbing(false);
        this.scrubberPadding = this.scrubberDrawable != null ? (this.scrubberDrawable.getMinimumWidth() + 1) / 2 : (Math.max(this.scrubberDisabledSize, Math.max(this.scrubberEnabledSize, this.scrubberDraggedSize)) + 1) / 2;
        this.duration = -9223372036854775807L;
        this.keyTimeIncrement = -9223372036854775807L;
        this.keyCountIncrement = 20;
        this.setFocusable(true);
        if (this.getImportantForAccessibility() == 0) {
            this.setImportantForAccessibility(1);
        }
    }

    public void setPlayedColor(@ColorInt int playedColor) {
        this.playedPaint.setColor(playedColor);
        this.invalidate(this.seekBounds);
    }

    public void setScrubberColor(@ColorInt int scrubberColor) {
        this.scrubberPaint.setColor(scrubberColor);
        this.invalidate(this.seekBounds);
    }

    public void setBufferedColor(@ColorInt int bufferedColor) {
        this.bufferedPaint.setColor(bufferedColor);
        this.invalidate(this.seekBounds);
    }

    public void setUnplayedColor(@ColorInt int unplayedColor) {
        this.unplayedPaint.setColor(unplayedColor);
        this.invalidate(this.seekBounds);
    }

    public void setAdMarkerColor(@ColorInt int adMarkerColor) {
        this.adMarkerPaint.setColor(adMarkerColor);
        this.invalidate(this.seekBounds);
    }

    public void setPlayedAdMarkerColor(@ColorInt int playedAdMarkerColor) {
        this.playedAdMarkerPaint.setColor(playedAdMarkerColor);
        this.invalidate(this.seekBounds);
    }

    @Override
    public void addListener(TimeBar.OnScrubListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(TimeBar.OnScrubListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setKeyTimeIncrement(long time) {
        Assertions.checkArgument((time > 0L ? 1 : 0) != 0);
        this.keyCountIncrement = -1;
        this.keyTimeIncrement = time;
    }

    @Override
    public void setKeyCountIncrement(int count) {
        Assertions.checkArgument((count > 0 ? 1 : 0) != 0);
        this.keyCountIncrement = count;
        this.keyTimeIncrement = -9223372036854775807L;
    }

    @Override
    public void setPosition(long position) {
        this.position = position;
        this.setContentDescription(this.getProgressText());
        this.update();
    }

    @Override
    public void setBufferedPosition(long bufferedPosition) {
        this.bufferedPosition = bufferedPosition;
        this.update();
    }

    @Override
    public void setDuration(long duration) {
        this.duration = duration;
        if (this.scrubbing && duration == -9223372036854775807L) {
            this.stopScrubbing(true);
        }
        this.update();
    }

    @Override
    public long getPreferredUpdateDelay() {
        int timeBarWidthDp = DefaultTimeBar.pxToDp(this.density, this.progressBar.width());
        return timeBarWidthDp == 0 || this.duration == 0L || this.duration == -9223372036854775807L ? Long.MAX_VALUE : this.duration / (long)timeBarWidthDp;
    }

    @Override
    public void setAdGroupTimesMs(@Nullable long[] adGroupTimesMs, @Nullable boolean[] playedAdGroups, int adGroupCount) {
        Assertions.checkArgument((adGroupCount == 0 || adGroupTimesMs != null && playedAdGroups != null ? 1 : 0) != 0);
        this.adGroupCount = adGroupCount;
        this.adGroupTimesMs = adGroupTimesMs;
        this.playedAdGroups = playedAdGroups;
        this.update();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.scrubbing && !enabled) {
            this.stopScrubbing(true);
        }
    }

    public void onDraw(Canvas canvas) {
        canvas.save();
        this.drawTimeBar(canvas);
        this.drawPlayhead(canvas);
        canvas.restore();
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled() || this.duration <= 0L) {
            return false;
        }
        Point touchPosition = this.resolveRelativeTouchPosition(event);
        int x = touchPosition.x;
        int y = touchPosition.y;
        switch (event.getAction()) {
            case 0: {
                if (!this.isInSeekBar(x, y)) break;
                this.positionScrubber(x);
                this.startScrubbing(this.getScrubberPosition());
                this.update();
                this.invalidate();
                return true;
            }
            case 2: {
                if (!this.scrubbing) break;
                if (y < this.fineScrubYThreshold) {
                    int relativeX = x - this.lastCoarseScrubXPosition;
                    this.positionScrubber(this.lastCoarseScrubXPosition + relativeX / 3);
                } else {
                    this.lastCoarseScrubXPosition = x;
                    this.positionScrubber(x);
                }
                this.updateScrubbing(this.getScrubberPosition());
                this.update();
                this.invalidate();
                return true;
            }
            case 1: 
            case 3: {
                if (!this.scrubbing) break;
                this.stopScrubbing(event.getAction() == 3);
                return true;
            }
        }
        return false;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.isEnabled()) {
            long positionIncrement = this.getPositionIncrement();
            switch (keyCode) {
                case 21: {
                    positionIncrement = -positionIncrement;
                }
                case 22: {
                    if (!this.scrubIncrementally(positionIncrement)) break;
                    this.removeCallbacks(this.stopScrubbingRunnable);
                    this.postDelayed(this.stopScrubbingRunnable, 1000L);
                    return true;
                }
                case 23: 
                case 66: {
                    if (!this.scrubbing) break;
                    this.stopScrubbing(false);
                    return true;
                }
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    protected void onFocusChanged(boolean gainFocus, int direction, @Nullable Rect previouslyFocusedRect) {
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        if (this.scrubbing && !gainFocus) {
            this.stopScrubbing(false);
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.updateDrawableState();
    }

    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.scrubberDrawable != null) {
            this.scrubberDrawable.jumpToCurrentState();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int height = heightMode == 0 ? this.touchTargetHeight : (heightMode == 0x40000000 ? heightSize : Math.min(this.touchTargetHeight, heightSize));
        this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), height);
        this.updateDrawableState();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int width = right - left;
        int height = bottom - top;
        int barY = (height - this.touchTargetHeight) / 2;
        int seekLeft = this.getPaddingLeft();
        int seekRight = width - this.getPaddingRight();
        int progressY = barY + (this.touchTargetHeight - this.barHeight) / 2;
        this.seekBounds.set(seekLeft, barY, seekRight, barY + this.touchTargetHeight);
        this.progressBar.set(this.seekBounds.left + this.scrubberPadding, progressY, this.seekBounds.right - this.scrubberPadding, progressY + this.barHeight);
        if (Util.SDK_INT >= 29) {
            this.setSystemGestureExclusionRectsV29(width, height);
        }
        this.update();
    }

    public void onRtlPropertiesChanged(int layoutDirection) {
        if (this.scrubberDrawable != null && DefaultTimeBar.setDrawableLayoutDirection(this.scrubberDrawable, layoutDirection)) {
            this.invalidate();
        }
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        if (event.getEventType() == 4) {
            event.getText().add(this.getProgressText());
        }
        event.setClassName((CharSequence)ACCESSIBILITY_CLASS_NAME);
    }

    @TargetApi(value=21)
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName((CharSequence)ACCESSIBILITY_CLASS_NAME);
        info.setContentDescription((CharSequence)this.getProgressText());
        if (this.duration <= 0L) {
            return;
        }
        if (Util.SDK_INT >= 21) {
            info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_FORWARD);
            info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_BACKWARD);
        } else {
            info.addAction(4096);
            info.addAction(8192);
        }
    }

    public boolean performAccessibilityAction(int action, @Nullable Bundle args) {
        if (super.performAccessibilityAction(action, args)) {
            return true;
        }
        if (this.duration <= 0L) {
            return false;
        }
        if (action == 8192) {
            if (this.scrubIncrementally(-this.getPositionIncrement())) {
                this.stopScrubbing(false);
            }
        } else if (action == 4096) {
            if (this.scrubIncrementally(this.getPositionIncrement())) {
                this.stopScrubbing(false);
            }
        } else {
            return false;
        }
        this.sendAccessibilityEvent(4);
        return true;
    }

    private void startScrubbing(long scrubPosition) {
        this.scrubPosition = scrubPosition;
        this.scrubbing = true;
        this.setPressed(true);
        ViewParent parent = this.getParent();
        if (parent != null) {
            parent.requestDisallowInterceptTouchEvent(true);
        }
        for (TimeBar.OnScrubListener listener : this.listeners) {
            listener.onScrubStart(this, scrubPosition);
        }
    }

    private void updateScrubbing(long scrubPosition) {
        if (this.scrubPosition == scrubPosition) {
            return;
        }
        this.scrubPosition = scrubPosition;
        for (TimeBar.OnScrubListener listener : this.listeners) {
            listener.onScrubMove(this, scrubPosition);
        }
    }

    private void stopScrubbing(boolean canceled) {
        this.removeCallbacks(this.stopScrubbingRunnable);
        this.scrubbing = false;
        this.setPressed(false);
        ViewParent parent = this.getParent();
        if (parent != null) {
            parent.requestDisallowInterceptTouchEvent(false);
        }
        this.invalidate();
        for (TimeBar.OnScrubListener listener : this.listeners) {
            listener.onScrubStop(this, this.scrubPosition, canceled);
        }
    }

    private boolean scrubIncrementally(long positionChange) {
        if (this.duration <= 0L) {
            return false;
        }
        long previousPosition = this.scrubbing ? this.scrubPosition : this.position;
        long scrubPosition = Util.constrainValue((long)(previousPosition + positionChange), (long)0L, (long)this.duration);
        if (scrubPosition == previousPosition) {
            return false;
        }
        if (!this.scrubbing) {
            this.startScrubbing(scrubPosition);
        } else {
            this.updateScrubbing(scrubPosition);
        }
        this.update();
        return true;
    }

    private void update() {
        long newScrubberTime;
        this.bufferedBar.set(this.progressBar);
        this.scrubberBar.set(this.progressBar);
        long l = newScrubberTime = this.scrubbing ? this.scrubPosition : this.position;
        if (this.duration > 0L) {
            int bufferedPixelWidth = (int)((long)this.progressBar.width() * this.bufferedPosition / this.duration);
            this.bufferedBar.right = Math.min(this.progressBar.left + bufferedPixelWidth, this.progressBar.right);
            int scrubberPixelPosition = (int)((long)this.progressBar.width() * newScrubberTime / this.duration);
            this.scrubberBar.right = Math.min(this.progressBar.left + scrubberPixelPosition, this.progressBar.right);
        } else {
            this.bufferedBar.right = this.progressBar.left;
            this.scrubberBar.right = this.progressBar.left;
        }
        this.invalidate(this.seekBounds);
    }

    private void positionScrubber(float xPosition) {
        this.scrubberBar.right = Util.constrainValue((int)((int)xPosition), (int)this.progressBar.left, (int)this.progressBar.right);
    }

    private Point resolveRelativeTouchPosition(MotionEvent motionEvent) {
        this.getLocationOnScreen(this.locationOnScreen);
        this.touchPosition.set((int)motionEvent.getRawX() - this.locationOnScreen[0], (int)motionEvent.getRawY() - this.locationOnScreen[1]);
        return this.touchPosition;
    }

    private long getScrubberPosition() {
        if (this.progressBar.width() <= 0 || this.duration == -9223372036854775807L) {
            return 0L;
        }
        return (long)this.scrubberBar.width() * this.duration / (long)this.progressBar.width();
    }

    private boolean isInSeekBar(float x, float y) {
        return this.seekBounds.contains((int)x, (int)y);
    }

    private void drawTimeBar(Canvas canvas) {
        int progressBarHeight = this.progressBar.height();
        int barTop = this.progressBar.centerY() - progressBarHeight / 2;
        int barBottom = barTop + progressBarHeight;
        if (this.duration <= 0L) {
            canvas.drawRect((float)this.progressBar.left, (float)barTop, (float)this.progressBar.right, (float)barBottom, this.unplayedPaint);
            return;
        }
        int bufferedLeft = this.bufferedBar.left;
        int bufferedRight = this.bufferedBar.right;
        int progressLeft = Math.max(Math.max(this.progressBar.left, bufferedRight), this.scrubberBar.right);
        if (progressLeft < this.progressBar.right) {
            canvas.drawRect((float)progressLeft, (float)barTop, (float)this.progressBar.right, (float)barBottom, this.unplayedPaint);
        }
        if (bufferedRight > (bufferedLeft = Math.max(bufferedLeft, this.scrubberBar.right))) {
            canvas.drawRect((float)bufferedLeft, (float)barTop, (float)bufferedRight, (float)barBottom, this.bufferedPaint);
        }
        if (this.scrubberBar.width() > 0) {
            canvas.drawRect((float)this.scrubberBar.left, (float)barTop, (float)this.scrubberBar.right, (float)barBottom, this.playedPaint);
        }
        if (this.adGroupCount == 0) {
            return;
        }
        long[] adGroupTimesMs = (long[])Assertions.checkNotNull((Object)this.adGroupTimesMs);
        boolean[] playedAdGroups = (boolean[])Assertions.checkNotNull((Object)this.playedAdGroups);
        int adMarkerOffset = this.adMarkerWidth / 2;
        for (int i = 0; i < this.adGroupCount; ++i) {
            long adGroupTimeMs = Util.constrainValue((long)adGroupTimesMs[i], (long)0L, (long)this.duration);
            int markerPositionOffset = (int)((long)this.progressBar.width() * adGroupTimeMs / this.duration) - adMarkerOffset;
            int markerLeft = this.progressBar.left + Math.min(this.progressBar.width() - this.adMarkerWidth, Math.max(0, markerPositionOffset));
            Paint paint = playedAdGroups[i] ? this.playedAdMarkerPaint : this.adMarkerPaint;
            canvas.drawRect((float)markerLeft, (float)barTop, (float)(markerLeft + this.adMarkerWidth), (float)barBottom, paint);
        }
    }

    private void drawPlayhead(Canvas canvas) {
        if (this.duration <= 0L) {
            return;
        }
        int playheadX = Util.constrainValue((int)this.scrubberBar.right, (int)this.scrubberBar.left, (int)this.progressBar.right);
        int playheadY = this.scrubberBar.centerY();
        if (this.scrubberDrawable == null) {
            int scrubberSize = this.scrubbing || this.isFocused() ? this.scrubberDraggedSize : (this.isEnabled() ? this.scrubberEnabledSize : this.scrubberDisabledSize);
            int playheadRadius = scrubberSize / 2;
            canvas.drawCircle((float)playheadX, (float)playheadY, (float)playheadRadius, this.scrubberPaint);
        } else {
            int scrubberDrawableWidth = this.scrubberDrawable.getIntrinsicWidth();
            int scrubberDrawableHeight = this.scrubberDrawable.getIntrinsicHeight();
            this.scrubberDrawable.setBounds(playheadX - scrubberDrawableWidth / 2, playheadY - scrubberDrawableHeight / 2, playheadX + scrubberDrawableWidth / 2, playheadY + scrubberDrawableHeight / 2);
            this.scrubberDrawable.draw(canvas);
        }
    }

    private void updateDrawableState() {
        if (this.scrubberDrawable != null && this.scrubberDrawable.isStateful() && this.scrubberDrawable.setState(this.getDrawableState())) {
            this.invalidate();
        }
    }

    @RequiresApi(value=29)
    private void setSystemGestureExclusionRectsV29(int width, int height) {
        if (this.lastExclusionRectangle != null && this.lastExclusionRectangle.width() == width && this.lastExclusionRectangle.height() == height) {
            return;
        }
        this.lastExclusionRectangle = new Rect(0, 0, width, height);
        this.setSystemGestureExclusionRects(Collections.singletonList(this.lastExclusionRectangle));
    }

    private String getProgressText() {
        return Util.getStringForTime((StringBuilder)this.formatBuilder, (Formatter)this.formatter, (long)this.position);
    }

    private long getPositionIncrement() {
        return this.keyTimeIncrement == -9223372036854775807L ? (this.duration == -9223372036854775807L ? 0L : this.duration / (long)this.keyCountIncrement) : this.keyTimeIncrement;
    }

    private boolean setDrawableLayoutDirection(Drawable drawable) {
        return Util.SDK_INT >= 23 && DefaultTimeBar.setDrawableLayoutDirection(drawable, this.getLayoutDirection());
    }

    private static boolean setDrawableLayoutDirection(Drawable drawable, int layoutDirection) {
        return Util.SDK_INT >= 23 && drawable.setLayoutDirection(layoutDirection);
    }

    private static int dpToPx(float density, int dps) {
        return (int)((float)dps * density + 0.5f);
    }

    private static int pxToDp(float density, int px) {
        return (int)((float)px / density);
    }
}

