/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.LayoutInflater;
import android.view.View;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.MappingTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelectionUtil;
import com.google.android.exoplayer2.ui.R;
import com.google.android.exoplayer2.ui.TrackNameProvider;
import com.google.android.exoplayer2.ui.TrackSelectionView;
import com.google.android.exoplayer2.util.Assertions;
import java.util.Collections;
import java.util.List;

public final class TrackSelectionDialogBuilder {
    private final Context context;
    private final CharSequence title;
    private final MappingTrackSelector.MappedTrackInfo mappedTrackInfo;
    private final int rendererIndex;
    private final DialogCallback callback;
    private boolean allowAdaptiveSelections;
    private boolean allowMultipleOverrides;
    private boolean showDisableOption;
    @Nullable
    private TrackNameProvider trackNameProvider;
    private boolean isDisabled;
    private List<DefaultTrackSelector.SelectionOverride> overrides;

    public TrackSelectionDialogBuilder(Context context, CharSequence title, MappingTrackSelector.MappedTrackInfo mappedTrackInfo, int rendererIndex, DialogCallback callback) {
        this.context = context;
        this.title = title;
        this.mappedTrackInfo = mappedTrackInfo;
        this.rendererIndex = rendererIndex;
        this.callback = callback;
        this.overrides = Collections.emptyList();
    }

    public TrackSelectionDialogBuilder(Context context, CharSequence title, DefaultTrackSelector trackSelector, int rendererIndex) {
        this.context = context;
        this.title = title;
        this.mappedTrackInfo = (MappingTrackSelector.MappedTrackInfo)Assertions.checkNotNull((Object)trackSelector.getCurrentMappedTrackInfo());
        this.rendererIndex = rendererIndex;
        TrackGroupArray rendererTrackGroups = this.mappedTrackInfo.getTrackGroups(rendererIndex);
        DefaultTrackSelector.Parameters selectionParameters = trackSelector.getParameters();
        this.isDisabled = selectionParameters.getRendererDisabled(rendererIndex);
        DefaultTrackSelector.SelectionOverride override = selectionParameters.getSelectionOverride(rendererIndex, rendererTrackGroups);
        this.overrides = override == null ? Collections.emptyList() : Collections.singletonList(override);
        this.callback = (newIsDisabled, newOverrides) -> trackSelector.setParameters(TrackSelectionUtil.updateParametersWithOverride((DefaultTrackSelector.Parameters)selectionParameters, (int)rendererIndex, (TrackGroupArray)rendererTrackGroups, (boolean)newIsDisabled, newOverrides.isEmpty() ? null : (DefaultTrackSelector.SelectionOverride)newOverrides.get(0)));
    }

    public TrackSelectionDialogBuilder setIsDisabled(boolean isDisabled) {
        this.isDisabled = isDisabled;
        return this;
    }

    public TrackSelectionDialogBuilder setOverride(@Nullable DefaultTrackSelector.SelectionOverride override) {
        return this.setOverrides(override == null ? Collections.emptyList() : Collections.singletonList(override));
    }

    public TrackSelectionDialogBuilder setOverrides(List<DefaultTrackSelector.SelectionOverride> overrides) {
        this.overrides = overrides;
        return this;
    }

    public TrackSelectionDialogBuilder setAllowAdaptiveSelections(boolean allowAdaptiveSelections) {
        this.allowAdaptiveSelections = allowAdaptiveSelections;
        return this;
    }

    public TrackSelectionDialogBuilder setAllowMultipleOverrides(boolean allowMultipleOverrides) {
        this.allowMultipleOverrides = allowMultipleOverrides;
        return this;
    }

    public TrackSelectionDialogBuilder setShowDisableOption(boolean showDisableOption) {
        this.showDisableOption = showDisableOption;
        return this;
    }

    public TrackSelectionDialogBuilder setTrackNameProvider(@Nullable TrackNameProvider trackNameProvider) {
        this.trackNameProvider = trackNameProvider;
        return this;
    }

    public AlertDialog build() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.context);
        LayoutInflater dialogInflater = LayoutInflater.from((Context)builder.getContext());
        View dialogView = dialogInflater.inflate(R.layout.exo_track_selection_dialog, null);
        TrackSelectionView selectionView = (TrackSelectionView)dialogView.findViewById(R.id.exo_track_selection_view);
        selectionView.setAllowMultipleOverrides(this.allowMultipleOverrides);
        selectionView.setAllowAdaptiveSelections(this.allowAdaptiveSelections);
        selectionView.setShowDisableOption(this.showDisableOption);
        if (this.trackNameProvider != null) {
            selectionView.setTrackNameProvider(this.trackNameProvider);
        }
        selectionView.init(this.mappedTrackInfo, this.rendererIndex, this.isDisabled, this.overrides, null);
        DialogInterface.OnClickListener okClickListener = (dialog, which) -> this.callback.onTracksSelected(selectionView.getIsDisabled(), selectionView.getOverrides());
        return builder.setTitle(this.title).setView(dialogView).setPositiveButton(17039370, okClickListener).setNegativeButton(0x1040000, null).create();
    }

    public static interface DialogCallback {
        public void onTracksSelected(boolean var1, List<DefaultTrackSelector.SelectionOverride> var2);
    }
}

