/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.annotation.SuppressLint;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.util.Assertions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Deprecated
public final class VideoEncoderSettings {
    public static final int NO_VALUE = -1;
    public static final float DEFAULT_I_FRAME_INTERVAL_SECONDS = 1.0f;
    public static final VideoEncoderSettings DEFAULT = new Builder().build();
    public final int bitrate;
    public final int bitrateMode;
    public final int profile;
    public final int level;
    public final float iFrameIntervalSeconds;
    public final int operatingRate;
    public final int priority;
    public final boolean enableHighQualityTargeting;

    private VideoEncoderSettings(int bitrate, int bitrateMode, int profile, int level, float iFrameIntervalSeconds, int operatingRate, int priority, boolean enableHighQualityTargeting) {
        this.bitrate = bitrate;
        this.bitrateMode = bitrateMode;
        this.profile = profile;
        this.level = level;
        this.iFrameIntervalSeconds = iFrameIntervalSeconds;
        this.operatingRate = operatingRate;
        this.priority = priority;
        this.enableHighQualityTargeting = enableHighQualityTargeting;
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VideoEncoderSettings)) {
            return false;
        }
        VideoEncoderSettings that = (VideoEncoderSettings)o;
        return this.bitrate == that.bitrate && this.bitrateMode == that.bitrateMode && this.profile == that.profile && this.level == that.level && this.iFrameIntervalSeconds == that.iFrameIntervalSeconds && this.operatingRate == that.operatingRate && this.priority == that.priority && this.enableHighQualityTargeting == that.enableHighQualityTargeting;
    }

    public int hashCode() {
        int result = 7;
        result = 31 * result + this.bitrate;
        result = 31 * result + this.bitrateMode;
        result = 31 * result + this.profile;
        result = 31 * result + this.level;
        result = 31 * result + Float.floatToIntBits(this.iFrameIntervalSeconds);
        result = 31 * result + this.operatingRate;
        result = 31 * result + this.priority;
        result = 31 * result + (this.enableHighQualityTargeting ? 1 : 0);
        return result;
    }

    public static final class Builder {
        private int bitrate;
        private int bitrateMode;
        private int profile;
        private int level;
        private float iFrameIntervalSeconds;
        private int operatingRate;
        private int priority;
        private boolean enableHighQualityTargeting;

        public Builder() {
            this.bitrate = -1;
            this.bitrateMode = 1;
            this.profile = -1;
            this.level = -1;
            this.iFrameIntervalSeconds = 1.0f;
            this.operatingRate = -1;
            this.priority = -1;
        }

        private Builder(VideoEncoderSettings videoEncoderSettings) {
            this.bitrate = videoEncoderSettings.bitrate;
            this.bitrateMode = videoEncoderSettings.bitrateMode;
            this.profile = videoEncoderSettings.profile;
            this.level = videoEncoderSettings.level;
            this.iFrameIntervalSeconds = videoEncoderSettings.iFrameIntervalSeconds;
            this.operatingRate = videoEncoderSettings.operatingRate;
            this.priority = videoEncoderSettings.priority;
            this.enableHighQualityTargeting = videoEncoderSettings.enableHighQualityTargeting;
        }

        @CanIgnoreReturnValue
        public Builder setBitrate(int bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setBitrateMode(int bitrateMode) {
            Assertions.checkArgument((bitrateMode == 1 || bitrateMode == 2 ? 1 : 0) != 0);
            this.bitrateMode = bitrateMode;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setEncodingProfileLevel(int encodingProfile, int encodingLevel) {
            this.profile = encodingProfile;
            this.level = encodingLevel;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setiFrameIntervalSeconds(float iFrameIntervalSeconds) {
            this.iFrameIntervalSeconds = iFrameIntervalSeconds;
            return this;
        }

        @CanIgnoreReturnValue
        @VisibleForTesting
        public Builder setEncoderPerformanceParameters(int operatingRate, int priority) {
            this.operatingRate = operatingRate;
            this.priority = priority;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder experimentalSetEnableHighQualityTargeting(boolean enableHighQualityTargeting) {
            this.enableHighQualityTargeting = enableHighQualityTargeting;
            return this;
        }

        public VideoEncoderSettings build() {
            Assertions.checkState((!this.enableHighQualityTargeting || this.bitrate == -1 ? 1 : 0) != 0, (Object)"Bitrate can not be set if enabling high quality targeting.");
            Assertions.checkState((!this.enableHighQualityTargeting || this.bitrateMode == 1 ? 1 : 0) != 0, (Object)"Bitrate mode must be VBR if enabling high quality targeting.");
            return new VideoEncoderSettings(this.bitrate, this.bitrateMode, this.profile, this.level, this.iFrameIntervalSeconds, this.operatingRate, this.priority, this.enableHighQualityTargeting);
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    @SuppressLint(value={"InlinedApi"})
    public static @interface BitrateMode {
    }
}

